/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.project;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceLevelQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.java.project.JavaTargetChooserPanelGUI;
import org.netbeans.modules.java.project.NewJavaFileWizardIterator;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class JavaTargetChooserPanel
implements WizardDescriptor.Panel<WizardDescriptor>,
ChangeListener {
    private static final String FOLDER_TO_DELETE = "folderToDelete";
    private final SpecificationVersion JDK_14 = new SpecificationVersion("1.4");
    private final List<ChangeListener> listeners = new ArrayList<ChangeListener>();
    private JavaTargetChooserPanelGUI gui;
    private WizardDescriptor.Panel<WizardDescriptor> bottomPanel;
    private WizardDescriptor wizard;
    private Project project;
    private SourceGroup[] folders;
    private final NewJavaFileWizardIterator.Type type;
    private boolean isValidPackageRequired;

    public JavaTargetChooserPanel(Project project, SourceGroup[] folders, WizardDescriptor.Panel<WizardDescriptor> bottomPanel, NewJavaFileWizardIterator.Type type, boolean isValidPackageRequired) {
        this.project = project;
        this.folders = folders;
        this.bottomPanel = bottomPanel;
        this.type = type;
        if (bottomPanel != null) {
            bottomPanel.addChangeListener((ChangeListener)this);
        }
        this.isValidPackageRequired = isValidPackageRequired;
    }

    public Component getComponent() {
        if (this.gui == null) {
            this.gui = new JavaTargetChooserPanelGUI(this.project, this.folders, this.bottomPanel == null ? null : this.bottomPanel.getComponent(), this.type);
            this.gui.addChangeListener(this);
        }
        return this.gui;
    }

    public HelpCtx getHelp() {
        HelpCtx bottomHelp;
        if (this.bottomPanel != null && (bottomHelp = this.bottomPanel.getHelp()) != null) {
            return bottomHelp;
        }
        return new HelpCtx(JavaTargetChooserPanel.class);
    }

    public boolean isValid() {
        if (this.gui == null) {
            this.setErrorMessage(null);
            return false;
        }
        if (this.type == NewJavaFileWizardIterator.Type.PACKAGE) {
            if (this.gui.getTargetName() == null) {
                this.setInfoMessage("INFO_JavaTargetChooser_ProvidePackageName");
                return false;
            }
            if (!JavaTargetChooserPanel.isValidPackageName(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            if (!JavaTargetChooserPanel.isValidPackage(this.gui.getRootFolder(), this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidFolder");
                return false;
            }
        } else if (this.type == NewJavaFileWizardIterator.Type.PKG_INFO) {
            if (this.gui.getTargetName() == null) {
                this.setInfoMessage("INFO_JavaTargetChooser_ProvideClassName");
                return false;
            }
            assert ("package-info".equals(this.gui.getTargetName()));
            if (!JavaTargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            if (!JavaTargetChooserPanel.isValidPackage(this.gui.getRootFolder(), this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidFolder");
                return false;
            }
        } else {
            if (this.gui.getTargetName() == null) {
                this.setInfoMessage("INFO_JavaTargetChooser_ProvideClassName");
                return false;
            }
            if (!JavaTargetChooserPanel.isValidTypeIdentifier(this.gui.getTargetName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidClass");
                return false;
            }
            if (!JavaTargetChooserPanel.isValidPackageName(this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidPackage");
                return false;
            }
            if (!JavaTargetChooserPanel.isValidPackage(this.gui.getRootFolder(), this.gui.getPackageName())) {
                this.setErrorMessage("ERR_JavaTargetChooser_InvalidFolder");
                return false;
            }
        }
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        boolean returnValue = true;
        FileObject rootFolder = this.gui.getRootFolder();
        SpecificationVersion specVersion = null;
        if (this.type != NewJavaFileWizardIterator.Type.PACKAGE) {
            String sl = SourceLevelQuery.getSourceLevel((FileObject)rootFolder);
            specVersion = sl != null ? new SpecificationVersion(sl) : null;
        }
        String errorMessage = JavaTargetChooserPanel.canUseFileName(rootFolder, this.gui.getPackageFileName(), this.gui.getTargetName(), template.getExt());
        if (this.gui != null) {
            this.wizard.getNotificationLineSupport().setErrorMessage(errorMessage);
        }
        if (errorMessage != null) {
            returnValue = false;
        }
        if (this.type != NewJavaFileWizardIterator.Type.PACKAGE && returnValue && this.gui.getPackageName().length() == 0 && specVersion != null && this.JDK_14.compareTo((Object)specVersion) <= 0) {
            if (this.isValidPackageRequired) {
                this.setInfoMessage("ERR_JavaTargetChooser_CantUseDefaultPackage");
                return false;
            }
            this.setErrorMessage("ERR_JavaTargetChooser_DefaultPackage");
        }
        String templateSrcLev = (String)template.getAttribute("javac.source");
        if (specVersion != null && templateSrcLev != null && specVersion.compareTo((Object)new SpecificationVersion(templateSrcLev)) < 0) {
            this.setErrorMessage("ERR_JavaTargetChooser_WrongPlatform");
        }
        if (returnValue && this.bottomPanel != null && !this.bottomPanel.isValid()) {
            return false;
        }
        return returnValue;
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(l);
    }

    private void fireChange() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator<ChangeListener> it = this.listeners.iterator();
        while (it.hasNext()) {
            it.next().stateChanged(e);
        }
    }

    public void readSettings(WizardDescriptor wizard) {
        Object substitute;
        this.wizard = wizard;
        if (this.gui != null) {
            FileObject preselectedFolder = Templates.getTargetFolder((WizardDescriptor)wizard);
            this.gui.initValues(Templates.getTemplate((WizardDescriptor)wizard), preselectedFolder);
        }
        if (this.bottomPanel != null) {
            this.bottomPanel.readSettings((Object)wizard);
        }
        if (this.gui != null && (substitute = this.gui.getClientProperty("NewFileWizard_Title")) != null) {
            wizard.putProperty("NewFileWizard_Title", substitute);
        }
    }

    public void storeSettings(WizardDescriptor wizard) {
        Object value = wizard.getValue();
        if (WizardDescriptor.PREVIOUS_OPTION.equals(value) || WizardDescriptor.CANCEL_OPTION.equals(value) || WizardDescriptor.CLOSED_OPTION.equals(value)) {
            return;
        }
        if (this.isValid()) {
            if (this.bottomPanel != null) {
                this.bottomPanel.storeSettings((Object)wizard);
            }
            Templates.setTargetFolder((WizardDescriptor)wizard, (FileObject)this.getTargetFolderFromGUI(wizard));
            Templates.setTargetName((WizardDescriptor)wizard, (String)this.gui.getTargetName());
        }
        wizard.putProperty("NewFileWizard_Title", null);
        if (WizardDescriptor.FINISH_OPTION.equals(value)) {
            wizard.putProperty(FOLDER_TO_DELETE, null);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.fireChange();
    }

    private void setErrorMessage(String key) {
        if (key == null) {
            this.wizard.getNotificationLineSupport().clearMessages();
        } else {
            this.wizard.getNotificationLineSupport().setErrorMessage(NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)key));
        }
    }

    private void setInfoMessage(String key) {
        if (key == null) {
            this.wizard.getNotificationLineSupport().clearMessages();
        } else {
            this.wizard.getNotificationLineSupport().setInformationMessage(NbBundle.getMessage(JavaTargetChooserPanelGUI.class, (String)key));
        }
    }

    private FileObject getTargetFolderFromGUI(WizardDescriptor wd) {
        assert (this.gui != null);
        FileObject rootFolder = this.gui.getRootFolder();
        FileObject folder = null;
        if (this.type != NewJavaFileWizardIterator.Type.PACKAGE) {
            String packageFileName = this.gui.getPackageFileName();
            folder = rootFolder.getFileObject(packageFileName);
            if (folder == null) {
                try {
                    FileObject fo;
                    folder = rootFolder;
                    StringTokenizer tk = new StringTokenizer(packageFileName, "/");
                    String name = null;
                    while (tk.hasMoreTokens() && (fo = folder.getFileObject(name = tk.nextToken(), "")) != null) {
                        folder = fo;
                    }
                    folder = folder.createFolder(name);
                    FileObject toDelete = (FileObject)wd.getProperty(FOLDER_TO_DELETE);
                    if (toDelete == null) {
                        wd.putProperty(FOLDER_TO_DELETE, (Object)folder);
                    } else if (!toDelete.equals(folder)) {
                        toDelete.delete();
                        wd.putProperty(FOLDER_TO_DELETE, (Object)folder);
                    }
                    while (tk.hasMoreTokens()) {
                        name = tk.nextToken();
                        folder = folder.createFolder(name);
                    }
                }
                catch (IOException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }
        } else {
            folder = rootFolder;
        }
        return folder;
    }

    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidPackage(FileObject root, String path) {
        if (root == null) {
            return false;
        }
        if (path == null) {
            return false;
        }
        StringTokenizer tk = new StringTokenizer(path, ".");
        while (tk.hasMoreTokens()) {
            if ((root = root.getFileObject(tk.nextToken())) == null) {
                return true;
            }
            if (!root.isData()) continue;
            return false;
        }
        return true;
    }

    static boolean isValidTypeIdentifier(String ident) {
        return ident != null && !"".equals(ident) && Utilities.isJavaIdentifier((String)ident);
    }

    public static final String canUseFileName(FileObject targetFolder, String folderName, String newObjectName, String extension) {
        File targetPackage;
        StringBuffer sb;
        String newObjectNameToDisplay = newObjectName;
        if (newObjectName != null) {
            newObjectName = newObjectName.replace('.', '/');
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuffer();
            sb.append(newObjectName);
            sb.append('.');
            sb.append(extension);
            newObjectName = sb.toString();
        }
        if (extension != null && extension.length() > 0) {
            sb = new StringBuffer();
            sb.append(newObjectNameToDisplay);
            sb.append('.');
            sb.append(extension);
            newObjectNameToDisplay = sb.toString();
        }
        String relFileName = folderName + "/" + newObjectName;
        if (targetFolder == null) {
            return NbBundle.getMessage(JavaTargetChooserPanel.class, (String)"MSG_fs_or_folder_does_not_exist");
        }
        File file = targetPackage = folderName != null ? new File(FileUtil.toFile((FileObject)targetFolder), folderName) : FileUtil.toFile((FileObject)targetFolder);
        if (targetPackage != null ? targetPackage.exists() && !targetPackage.canWrite() : !targetFolder.canWrite()) {
            return NbBundle.getMessage(JavaTargetChooserPanel.class, (String)"MSG_fs_is_readonly");
        }
        if (JavaTargetChooserPanel.existFileName(targetFolder, relFileName)) {
            return NbBundle.getMessage(JavaTargetChooserPanel.class, (String)"MSG_file_already_exist", (Object)newObjectNameToDisplay);
        }
        return null;
    }

    private static boolean existFileName(FileObject targetFolder, String relFileName) {
        boolean result = false;
        File fileForTargetFolder = FileUtil.toFile((FileObject)targetFolder);
        result = fileForTargetFolder.exists() ? new File(fileForTargetFolder, relFileName).exists() : targetFolder.getFileObject(relFileName) != null;
        return result;
    }
}

