/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.platform.platformdefinition;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.j2me.cdc.platform.CDCDevice;
import org.netbeans.modules.j2me.cdc.platform.CDCPlatform;
import org.netbeans.modules.j2me.cdc.platform.platformdefinition.CDCPlatformNode;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.cookies.InstanceCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.Environment;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.XMLDataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PlatformConvertor
implements Environment.Provider,
InstanceCookie.Of,
PropertyChangeListener,
Runnable,
InstanceContent.Convertor {
    private static final String PLATFORM_DTD_ID = "-//NetBeans//DTD CDC PlatformDefinition 1.0//EN";
    private static final String PLATFORM_DTD_ID_1_1 = "-//NetBeans//DTD CDC PlatformDefinition 1.1//EN";
    InstanceContent cookies = new InstanceContent();
    private XMLDataObject holder;
    private Lookup lookup;
    private RequestProcessor.Task saveTask;
    private Reference<CDCPlatform> refPlatform = new WeakReference<Object>(null);
    private LinkedList<PropertyChangeEvent> keepAlive = new LinkedList();
    static int DELAY = 2000;
    static final String ELEMENT_PROPERTIES = "properties";
    static final String ELEMENT_SYSPROPERTIES = "sysproperties";
    static final String ELEMENT_PROPERTY = "property";
    static final String ELEMENT_PLATFORM = "platform";
    static final String ELEMENT_JDKHOME = "jdkhome";
    static final String ELEMENT_SOURCEPATH = "sources";
    static final String ELEMENT_JAVADOC = "javadoc";
    static final String ELEMENT_RESOURCE = "resource";
    static final String ATTR_PLATFORM_NAME = "name";
    static final String ATTR_PLATFORM_ANT_NAME = "antname";
    static final String ATTR_PLATFORM_TYPE = "type";
    static final String ATTR_PLATFORM_DEFAULT = "default";
    static final String ATTR_PLATFORM_FATJAR = "fatjar";
    static final String ATTR_PROPERTY_NAME = "name";
    static final String ATTR_PROPERTY_VALUE = "value";
    static final String ELEMENT_PLATFORMHOME = "platformhome";
    static final String ELEMENT_DEVICE = "device";
    static final String ELEMENT_PROFILE = "profile";
    static final String ELEMENT_EXECUTION = "execution";
    static final String ELEMENT_SCREEN = "screen";
    static final String ATTR_PLATFORM_CLASSVERSION = "classversion";
    static final String ATTR_PLATFORM_DISPLAYNAME = "displayname";
    static final String ATTR_DEVICE_NAME = "name";
    static final String ATTR_DEVICE_DESCRIPTION = "description";
    static final String ATTR_PROFILE_NAME = "name";
    static final String ATTR_PROFILE_DESCRIPTION = "description";
    static final String ATTR_PROFILE_VERSION = "version";
    static final String ATTR_PROFILE_CLASSPATH = "classpath";
    static final String ATTR_PROFILE_RUNCLASSPATH = "runclasspath";
    static final String ATTR_PROFILE_DEFAULT = "isDefault";
    static final String ATTR_EXECUTION_TYPE = "type";
    static final String ATTR_EXECUTION_CLASS = "class";
    static final String ATTR_SCREEN_WIDTH = "width";
    static final String ATTR_SCREEN_HEIGHT = "height";
    static final String ATTR_SCREEN_BITDEPTH = "bitDepth";
    static final String ATTR_SCREEN_ISCOLOR = "isColor";
    static final String ATTR_SCREEN_ISTOUCH = "isTouch";
    static final String ATTR_SCREEN_ISMAIN = "isMain";

    private PlatformConvertor() {
    }

    public static PlatformConvertor createProvider(FileObject reg) {
        return new PlatformConvertor();
    }

    public Lookup getEnvironment(DataObject obj) {
        return new PlatformConvertor((XMLDataObject)obj).getLookup();
    }

    private PlatformConvertor(XMLDataObject object) {
        this.holder = object;
        this.holder.getPrimaryFile().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(final FileEvent fe) {
                try {
                    ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                        public Object run() throws IOException {
                            String systemName = fe.getFile().getName();
                            String propPrefix = "platforms." + systemName + ".";
                            boolean changed = false;
                            EditableProperties props = PropertyUtils.getGlobalProperties();
                            Iterator it = props.keySet().iterator();
                            while (it.hasNext()) {
                                String key = (String)it.next();
                                if (!key.startsWith(propPrefix)) continue;
                                it.remove();
                                changed = true;
                            }
                            if (changed) {
                                PropertyUtils.putGlobalProperties((EditableProperties)props);
                            }
                            return null;
                        }
                    });
                }
                catch (MutexException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        });
        this.cookies = new InstanceContent();
        this.cookies.add((Object)this);
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.cookies);
        this.cookies.add(Node.class, (InstanceContent.Convertor)this);
    }

    Lookup getLookup() {
        return this.lookup;
    }

    public Class instanceClass() {
        return JavaPlatform.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object instanceCreate() throws IOException {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            CDCPlatform o = this.refPlatform.get();
            if (o != null) {
                return o;
            }
            H handler = new H();
            try {
                XMLReader reader = XMLUtil.createXMLReader();
                InputSource is = new InputSource(this.holder.getPrimaryFile().getInputStream());
                is.setSystemId(this.holder.getPrimaryFile().getURL().toExternalForm());
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.setEntityResolver(handler);
                reader.parse(is);
            }
            catch (SAXException ex) {
                Exception x = ex.getException();
                ex.printStackTrace();
                if (x instanceof IOException) {
                    throw (IOException)x;
                }
                IOException ioe = new IOException(ex.getMessage());
                ioe.initCause(x);
                throw ioe;
            }
            CDCPlatform inst = this.createPlatform(handler);
            if (handler.dtdVersion == 0) {
                PropertyChangeEvent evt = new PropertyChangeEvent((Object)inst, null, null, null);
                this.propertyChange(evt);
            }
            this.refPlatform = new WeakReference<CDCPlatform>(inst);
            PlatformConvertor.updateBuildProperties(inst);
            return inst;
        }
    }

    CDCPlatform createPlatform(H handler) {
        CDCPlatform p = new CDCPlatform(handler.name, handler.antname, handler.type, handler.classVersion, handler.installFolders, handler.sources, handler.javadoc, handler.devices.toArray(new CDCDevice[handler.devices.size()]), handler.fatJar);
        p.addPropertyChangeListener(this);
        return p;
    }

    public String instanceName() {
        return this.holder.getName();
    }

    public boolean instanceOf(Class type) {
        return type.isAssignableFrom(CDCPlatform.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            if (this.saveTask == null) {
                this.saveTask = RequestProcessor.getDefault().create((Runnable)this);
            }
        }
        platformConvertor = this;
        synchronized (platformConvertor) {
            this.keepAlive.add(evt);
        }
        this.saveTask.schedule(DELAY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        PropertyChangeEvent e;
        PlatformConvertor platformConvertor = this;
        synchronized (platformConvertor) {
            e = this.keepAlive.removeFirst();
        }
        CDCPlatform plat = (CDCPlatform)((Object)e.getSource());
        try {
            this.holder.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)new W(plat, (MultiDataObject)this.holder));
        }
        catch (IOException ex) {
            ErrorManager.getDefault().notify(1, (Throwable)ex);
        }
    }

    public Object convert(Object obj) {
        if (obj == Node.class) {
            try {
                CDCPlatform p = (CDCPlatform)((Object)this.instanceCreate());
                return new CDCPlatformNode(p, (DataObject)this.holder);
            }
            catch (IOException ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
            catch (Exception ex) {
                ErrorManager.getDefault().notify((Throwable)ex);
            }
        }
        return null;
    }

    public String displayName(Object obj) {
        return ((Class)obj).getName();
    }

    public String id(Object obj) {
        return obj.toString();
    }

    public Class type(Object obj) {
        return (Class)obj;
    }

    public static DataObject create(CDCPlatform plat, DataFolder f, String idName) throws IOException {
        W w = new W(plat, f, idName);
        f.getPrimaryFile().getFileSystem().runAtomicAction((FileSystem.AtomicAction)w);
        return w.holder;
    }

    private static void updateBuildProperties(final CDCPlatform p) {
        final String name = p.getAntName();
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                try {
                    ProjectManager.mutex().writeAccess(new Mutex.ExceptionAction(){

                        public Object run() throws Exception {
                            EditableProperties props = PropertyUtils.getGlobalProperties();
                            Iterator it = props.entrySet().iterator();
                            String prefix = PlatformConvertor.createName(name, "");
                            while (it.hasNext()) {
                                if (!((String)((Map.Entry)it.next()).getKey()).startsWith(prefix)) continue;
                                it.remove();
                            }
                            String home = p.getHomePath();
                            if (home == null) {
                                return null;
                            }
                            props.setProperty(PlatformConvertor.createName(name, "home"), home);
                            props.setProperty(PlatformConvertor.createName(name, "type"), p.getType());
                            PropertyUtils.putGlobalProperties((EditableProperties)props);
                            return null;
                        }
                    });
                }
                catch (MutexException me) {
                    ErrorManager.getDefault().notify((Throwable)me.getException());
                }
            }
        });
    }

    protected static String createName(String propName, String propType) {
        return "platforms." + propName + "." + propType;
    }

    static class H
    extends DefaultHandler
    implements EntityResolver {
        String name;
        String antname;
        String type;
        String classVersion;
        String displayName;
        List<URL> sources;
        List<URL> javadoc;
        List<URL> installFolders;
        List<CDCDevice> devices;
        Map<String, String> properties;
        Map<String, String> sysProperties;
        private Map<String, String> propertyMap;
        private StringBuffer buffer;
        private List<URL> path;
        private String deviceName;
        private String deviceDescription;
        private List<CDCDevice.CDCProfile> profiles;
        private List<CDCDevice.Screen> screens;
        private Map<String, String> executionModes;
        private CDCDevice.CDCProfile profile;
        protected boolean fatJar;
        protected int dtdVersion;

        H() {
        }

        @Override
        public void startDocument() {
        }

        @Override
        public void endDocument() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (this.dtdVersion > 0) {
                if (PlatformConvertor.ELEMENT_PLATFORM.equals(qName)) {
                    this.name = this.getMandatoryValue(attrs, "name");
                    this.antname = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PLATFORM_ANT_NAME);
                    this.classVersion = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PLATFORM_CLASSVERSION);
                    this.displayName = this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PLATFORM_DISPLAYNAME);
                    this.type = this.getMandatoryValue(attrs, "type");
                    this.fatJar = Boolean.parseBoolean(this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PLATFORM_FATJAR));
                }
            } else if (PlatformConvertor.ELEMENT_PLATFORM.equals(qName)) {
                this.name = this.getMandatoryValue(attrs, "name");
                this.antname = this.name.replace(' ', '_');
                this.displayName = new String(this.name);
                String origType = this.getMandatoryValue(attrs, "type");
                if (origType.equals("0")) {
                    this.type = "semc";
                    this.classVersion = "1.2";
                } else if (origType.equals("1")) {
                    this.type = "nokiaS80";
                    this.classVersion = "1.4";
                } else {
                    throw new SAXException("Unrecognised platform type: " + origType);
                }
                this.fatJar = true;
            }
            if (PlatformConvertor.ELEMENT_PROPERTIES.equals(qName)) {
                if (this.properties == null) {
                    this.properties = new HashMap<String, String>(17);
                }
                this.propertyMap = this.properties;
            } else if (PlatformConvertor.ELEMENT_PLATFORMHOME.equals(qName) || PlatformConvertor.ELEMENT_JDKHOME.equals(qName)) {
                this.installFolders = new ArrayList<URL>();
                this.path = this.installFolders;
            } else if (PlatformConvertor.ELEMENT_SYSPROPERTIES.equals(qName)) {
                if (this.sysProperties == null) {
                    this.sysProperties = new HashMap<String, String>(17);
                }
                this.propertyMap = this.sysProperties;
            } else if (PlatformConvertor.ELEMENT_PROPERTY.equals(qName)) {
                if (this.propertyMap == null) {
                    throw new SAXException("property w/o properties or sysproperties");
                }
                String name = attrs.getValue("name");
                if (name == null || "".equals(name)) {
                    throw new SAXException("missing name");
                }
                String val = attrs.getValue(PlatformConvertor.ATTR_PROPERTY_VALUE);
                this.propertyMap.put(name, val);
            } else if (PlatformConvertor.ELEMENT_SOURCEPATH.equals(qName)) {
                this.sources = new ArrayList<URL>();
                this.path = this.sources;
            } else if (PlatformConvertor.ELEMENT_JAVADOC.equals(qName)) {
                this.javadoc = new ArrayList<URL>();
                this.path = this.javadoc;
            } else if (PlatformConvertor.ELEMENT_RESOURCE.equals(qName)) {
                this.buffer = new StringBuffer();
            } else if (PlatformConvertor.ELEMENT_DEVICE.equals(qName)) {
                this.deviceName = this.getMandatoryValue(attrs, "name");
                this.deviceDescription = attrs.getValue("description");
            } else if (PlatformConvertor.ELEMENT_PROFILE.equals(qName)) {
                boolean def = false;
                try {
                    def = Boolean.valueOf(attrs.getValue(PlatformConvertor.ATTR_PROFILE_DEFAULT));
                }
                catch (Exception ex) {
                    // empty catch block
                }
                this.profile = new CDCDevice.CDCProfile(this.getMandatoryValue(attrs, "name"), attrs.getValue("description"), this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROFILE_VERSION), null, this.getMandatoryValue(attrs, PlatformConvertor.ATTR_PROFILE_CLASSPATH), attrs.getValue(PlatformConvertor.ATTR_PROFILE_RUNCLASSPATH), def);
            } else if (PlatformConvertor.ELEMENT_EXECUTION.equals(qName)) {
                if (this.executionModes == null) {
                    this.executionModes = new HashMap<String, String>();
                }
                this.executionModes.put(attrs.getValue("type"), attrs.getValue(PlatformConvertor.ATTR_EXECUTION_CLASS));
            } else if (PlatformConvertor.ELEMENT_SCREEN.equals(qName)) {
                if (this.screens == null) {
                    this.screens = new ArrayList<CDCDevice.Screen>();
                }
                this.screens.add(new CDCDevice.Screen(attrs.getValue(PlatformConvertor.ATTR_SCREEN_WIDTH), attrs.getValue(PlatformConvertor.ATTR_SCREEN_HEIGHT), attrs.getValue(PlatformConvertor.ATTR_SCREEN_BITDEPTH), attrs.getValue(PlatformConvertor.ATTR_SCREEN_ISCOLOR), attrs.getValue(PlatformConvertor.ATTR_SCREEN_ISTOUCH), attrs.getValue(PlatformConvertor.ATTR_SCREEN_ISMAIN)));
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            if (PlatformConvertor.ELEMENT_PROPERTIES.equals(qName)) {
                this.propertyMap = null;
            } else if (PlatformConvertor.ELEMENT_SYSPROPERTIES.equals(qName)) {
                if (this.dtdVersion == 0) {
                    if (this.devices == null) {
                        this.devices = new ArrayList<CDCDevice>();
                    }
                    this.devices.add(new CDCDevice("Default", "Default device", new CDCDevice.CDCProfile[]{new CDCDevice.CDCProfile("PP-1.0", this.sysProperties.get("java.vm.name"), this.sysProperties.get("java.vm.version"), null, this.sysProperties.get("sun.boot.class.path"), null, true)}, null));
                }
                this.propertyMap = null;
            } else if (PlatformConvertor.ELEMENT_SOURCEPATH.equals(qName) || PlatformConvertor.ELEMENT_JAVADOC.equals(qName)) {
                this.path = null;
            } else if (PlatformConvertor.ELEMENT_RESOURCE.equals(qName)) {
                try {
                    URL url = new URL(this.buffer.toString());
                    try {
                        url.toURI();
                        this.path.add(url);
                    }
                    catch (URISyntaxException e) {
                        File f = new File(url.getPath());
                        this.path.add(f.toURI().toURL());
                    }
                }
                catch (MalformedURLException mue) {
                    ErrorManager.getDefault().notify((Throwable)mue);
                }
                this.buffer = null;
            } else if (PlatformConvertor.ELEMENT_DEVICE.equals(qName)) {
                if (this.devices == null) {
                    this.devices = new ArrayList<CDCDevice>();
                }
                this.devices.add(new CDCDevice(this.deviceName, this.deviceDescription, this.profiles.toArray(new CDCDevice.CDCProfile[this.profiles.size()]), this.screens != null ? this.screens.toArray(new CDCDevice.Screen[this.screens.size()]) : null));
                this.profiles = null;
                this.screens = null;
            } else if (PlatformConvertor.ELEMENT_PROFILE.equals(qName)) {
                if (this.profiles == null) {
                    this.profiles = new ArrayList<CDCDevice.CDCProfile>();
                }
                this.profile.setExecutionModes(this.executionModes);
                this.profiles.add(this.profile);
                this.profile = null;
                this.executionModes = null;
            }
        }

        @Override
        public void characters(char[] chars, int start, int length) {
            if (this.buffer != null) {
                this.buffer.append(chars, start, length);
            }
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if (PlatformConvertor.PLATFORM_DTD_ID.equals(publicId)) {
                this.dtdVersion = 0;
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            if (PlatformConvertor.PLATFORM_DTD_ID_1_1.equals(publicId)) {
                this.dtdVersion = 1;
                return new InputSource(new ByteArrayInputStream(new byte[0]));
            }
            return null;
        }

        private String getMandatoryValue(Attributes attrs, String name) throws SAXException {
            String val = attrs.getValue(name);
            if (val == null) {
                throw new SAXException("Missing " + name);
            }
            return val;
        }
    }

    static class W
    implements FileSystem.AtomicAction {
        CDCPlatform instance;
        MultiDataObject holder;
        String name;
        DataFolder f;

        W(CDCPlatform instance, MultiDataObject holder) {
            this.instance = instance;
            this.holder = holder;
        }

        W(CDCPlatform instance, DataFolder f, String n) {
            this.instance = instance;
            this.name = n;
            this.f = f;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() throws IOException {
            FileLock lck;
            FileObject data;
            if (this.holder != null) {
                data = this.holder.getPrimaryEntry().getFile();
                lck = this.holder.getPrimaryEntry().takeLock();
            } else {
                FileObject folder = this.f.getPrimaryFile();
                String fn = FileUtil.findFreeFileName((FileObject)folder, (String)this.name, (String)"xml");
                data = folder.createData(fn, "xml");
                lck = data.lock();
            }
            try {
                OutputStream ostm = data.getOutputStream(lck);
                PrintWriter writer = new PrintWriter(new OutputStreamWriter(ostm, "UTF8"));
                this.write(writer);
                writer.flush();
                writer.close();
                ostm.close();
            }
            finally {
                lck.releaseLock();
            }
            if (this.holder == null) {
                this.holder = (MultiDataObject)DataObject.find((FileObject)data);
            }
        }

        void write(PrintWriter pw) throws IOException {
            pw.println("<?xml version='1.0'?>");
            pw.println("<!DOCTYPE platform PUBLIC '-//NetBeans//DTD CDC PlatformDefinition 1.1//EN' 'http://www.netbeans.org/dtds/cdc-platformdefinition-1_1.dtd'>");
            pw.print("<platform name=\"" + XMLUtil.toAttributeValue((String)this.instance.getDisplayName()) + "\" antname=\"" + XMLUtil.toAttributeValue((String)this.instance.getAntName()) + "\" type=\"" + XMLUtil.toAttributeValue((String)this.instance.getType()) + "\" classversion=\"" + XMLUtil.toAttributeValue((String)this.instance.getClassVersion()) + "\" displayname=\"" + XMLUtil.toAttributeValue((String)this.instance.getDisplayName()) + "\" fatjar=\"" + this.instance.isFatJar());
            pw.println("\">");
            pw.println("  <platformhome>");
            Iterator<FileObject> it = this.instance.getInstallFolders().iterator();
            while (it.hasNext()) {
                URL url = it.next().getURL();
                pw.println("    <resource>" + url.toExternalForm() + "</resource>");
            }
            pw.println("  </platformhome>");
            List<URL> pl = this.instance.getSourceFolders().entries();
            if (pl.size() > 0) {
                pw.println("  <sources>");
                Iterator<URL> it2 = pl.iterator();
                while (it2.hasNext()) {
                    URL url = ((ClassPath.Entry)it2.next()).getURL();
                    pw.println("    <resource>" + url.toExternalForm() + "</resource>");
                }
                pw.println("  </sources>");
            }
            if ((pl = this.instance.getJavadocFolders()).size() > 0) {
                pw.println("  <javadoc>");
                for (URL url : pl) {
                    pw.println("<resource>" + url.toExternalForm() + "</resource>");
                }
                pw.println("  </javadoc>");
            }
            CDCDevice[] devices = this.instance.getDevices();
            for (int i = 0; i < devices.length; ++i) {
                CDCDevice d = devices[i];
                pw.print("  <device name=\"" + XMLUtil.toAttributeValue((String)d.getName()));
                if (d.getDescription() != null) {
                    pw.print("\" description=\"" + XMLUtil.toAttributeValue((String)d.getDescription()));
                }
                pw.println("\">");
                CDCDevice.CDCProfile[] profiles = d.getProfiles();
                for (int j = 0; j < profiles.length; ++j) {
                    CDCDevice.CDCProfile p = profiles[j];
                    pw.print("    <profile name=\"" + XMLUtil.toAttributeValue((String)p.getName()) + "\" description=\"" + XMLUtil.toAttributeValue((String)p.getDescription()) + "\" version=\"" + XMLUtil.toAttributeValue((String)p.getVersion().toString()) + "\" classpath=\"" + XMLUtil.toAttributeValue((String)p.getBootClassPath()));
                    if (p.getRunClassPath() != null) {
                        pw.print("\" runclasspath=\"" + XMLUtil.toAttributeValue((String)p.getRunClassPath()));
                    }
                    pw.print("\" isDefault=\"" + p.isDefault());
                    pw.println("\">");
                    Map<String, String> exec = p.getExecutionModes();
                    if (exec != null) {
                        for (Map.Entry<String, String> entry : exec.entrySet()) {
                            pw.print("      <execution type=\"" + entry.getKey() + "\" ");
                            if (entry.getValue() != null) {
                                pw.print("class=\"" + entry.getValue() + "\"");
                            }
                            pw.println("/>");
                        }
                    }
                    pw.println("    </profile>");
                }
                CDCDevice.Screen[] s = d.getScreens();
                for (int j = 0; s != null && j < s.length; ++j) {
                    if (s[j] == null) continue;
                    Integer sw = s[j].getWidth();
                    Integer sh = s[j].getHeight();
                    Integer sd = s[j].getBitDepth();
                    Boolean sc = s[j].getColor();
                    Boolean st = s[j].getTouch();
                    Boolean mn = s[j].istMain();
                    if (sw == null && sh == null && sd == null && sc == null && st == null) continue;
                    pw.print("    <screen");
                    if (sw != null) {
                        pw.print(" width=\"" + sw + "\"");
                    }
                    if (sh != null) {
                        pw.print(" height=\"" + sh + "\"");
                    }
                    if (sd != null) {
                        pw.print(" bitDepth=\"" + sd + "\"");
                    }
                    if (sc != null) {
                        pw.print(" isColor=\"" + sc + "\"");
                    }
                    if (st != null) {
                        pw.print(" isTouch=\"" + st + "\"");
                    }
                    if (mn != null) {
                        pw.print(" isMain=\"" + mn + "\"");
                    }
                    pw.println("/>");
                }
                pw.println("  </device>");
            }
            pw.println("</platform>");
        }

        void writeProperties(Map<String, String> props, PrintWriter pw) throws IOException {
            TreeSet<String> sortedProps = new TreeSet<String>(props.keySet());
            for (String n : sortedProps) {
                String val = props.get(n);
                String xmlName = XMLUtil.toAttributeValue((String)n);
                try {
                    String xmlValue = XMLUtil.toAttributeValue((String)val);
                    pw.println("    <property name='" + xmlName + "' value='" + xmlValue + "'/>");
                }
                catch (CharConversionException ce) {
                    ErrorManager.getDefault().log("PlatformConvertor: invalid property name=" + n + " value=" + val);
                }
            }
        }
    }
}

