/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.view.svg;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openide.util.NbBundle;

public abstract class SVGImagePanel
extends JPanel {
    public static final int CROSS_SIZE = 10;
    private final JComponent imagePanel;
    private AtomicBoolean canPaint;
    private JComponent myErrorComponent;

    public SVGImagePanel(JComponent imagePanel) {
        this.imagePanel = imagePanel;
        this.setLayout(new CenteredLayoutManager());
        this.add(imagePanel);
        this.setDoubleBuffered(true);
        this.canPaint = new AtomicBoolean(true);
        this.myErrorComponent = new JLabel(NbBundle.getMessage(SVGImagePanel.class, (String)"ERR_UnableRender"));
        this.myErrorComponent.validate();
    }

    public void setTryPaint() {
        if (!this.canPaint.getAndSet(true)) {
            System.gc();
            this.remove(this.myErrorComponent);
            this.setLayout(new CenteredLayoutManager());
            this.add(this.imagePanel);
        }
    }

    @Override
    protected void paintChildren(Graphics g) {
        if (this.canPaint.get()) {
            try {
                this.doPaintChildren(g);
            }
            catch (OutOfMemoryError e) {
                this.canPaint.set(false);
                this.remove(this.imagePanel);
                this.setLayout(new LabelLayout());
                this.add(this.myErrorComponent);
            }
        } else {
            super.paintChildren(g);
        }
    }

    private void doPaintChildren(Graphics g) {
        super.paintChildren(g);
        int xOff = this.imagePanel.getX();
        int yOff = this.imagePanel.getY();
        g.setColor(Color.BLACK);
        int w = this.imagePanel.getWidth();
        int h = this.imagePanel.getHeight();
        SVGImagePanel.drawCross(g, xOff - 1, yOff - 1);
        SVGImagePanel.drawCross(g, xOff - 1, yOff + h + 1);
        SVGImagePanel.drawCross(g, xOff + w + 1, yOff - 1);
        SVGImagePanel.drawCross(g, xOff + w + 1, yOff + h + 1);
        Rectangle2D clip = new Rectangle2D.Float(xOff, yOff, w, h);
        Rectangle visible = this.getVisibleRect();
        if (visible != null) {
            clip = visible.createIntersection(clip);
        }
        g.setClip(clip);
        this.paintPanel(g, xOff, yOff);
    }

    protected abstract void paintPanel(Graphics var1, int var2, int var3);

    private static void drawCross(Graphics g, int x, int y) {
        g.drawLine(x - 10, y, x + 10, y);
        g.drawLine(x, y - 10, x, y + 10);
    }

    private class LabelLayout
    extends FlowLayout {
        private static final long serialVersionUID = 842591224720135361L;

        private LabelLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            super.layoutContainer(parent);
            Point point = SVGImagePanel.this.myErrorComponent.getLocation();
            SVGImagePanel.this.myErrorComponent.setLocation(point.x, (int)((double)parent.getHeight() - SVGImagePanel.this.myErrorComponent.getPreferredSize().getHeight()) / 2);
        }
    }

    private class CenteredLayoutManager
    implements LayoutManager {
        private CenteredLayoutManager() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
            assert (SVGImagePanel.this.imagePanel.equals(comp));
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return SVGImagePanel.this.imagePanel.getSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return SVGImagePanel.this.imagePanel.getSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            SVGImagePanel.this.imagePanel.setLocation((parent.getWidth() - SVGImagePanel.this.imagePanel.getWidth()) / 2, (parent.getHeight() - SVGImagePanel.this.imagePanel.getHeight()) / 2);
        }

        @Override
        public void removeLayoutComponent(Component comp) {
            assert (SVGImagePanel.this.imagePanel.equals(comp));
        }
    }
}

