/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.deployment.common.api;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.util.Parameters;

public final class Version {
    private static final Pattern JSR277_PATTERN = Pattern.compile("(\\d+)(\\.(\\d+)(\\.(\\d+)(\\.(\\d+))?)?)?(-((\\w|-)+))?");
    private final String version;
    private final Integer majorNumber;
    private final Integer minorNumber;
    private final Integer microNumber;
    private final Integer updateNumber;
    private final String qualifier;

    private Version(String version, Integer majorNumber, Integer minorNumber, Integer microNumber, Integer updateNumber, String qualifier) {
        this.version = version;
        this.majorNumber = majorNumber;
        this.minorNumber = minorNumber;
        this.microNumber = microNumber;
        this.updateNumber = updateNumber;
        this.qualifier = qualifier;
    }

    @NonNull
    public static Version fromJsr277NotationWithFallback(@NonNull String version) {
        Parameters.notNull((CharSequence)"version", (Object)version);
        Matcher matcher = JSR277_PATTERN.matcher(version);
        if (matcher.matches()) {
            String fragment = matcher.group(1);
            Integer majorNumber = fragment != null ? Integer.valueOf(fragment) : null;
            fragment = matcher.group(3);
            Integer minorNumber = fragment != null ? Integer.valueOf(fragment) : null;
            fragment = matcher.group(5);
            Integer microNumber = fragment != null ? Integer.valueOf(fragment) : null;
            fragment = matcher.group(7);
            Integer updateNumber = fragment != null ? Integer.valueOf(fragment) : null;
            String qualifier = matcher.group(9);
            return new Version(version, majorNumber, minorNumber, microNumber, updateNumber, qualifier);
        }
        return new Version(version, null, null, null, null, null);
    }

    @CheckForNull
    public Integer getMajor() {
        return this.majorNumber;
    }

    @CheckForNull
    public Integer getMinor() {
        return this.minorNumber;
    }

    @CheckForNull
    public Integer getMicro() {
        return this.microNumber;
    }

    @CheckForNull
    public Integer getUpdate() {
        return this.updateNumber;
    }

    @CheckForNull
    public String getQualifier() {
        return this.qualifier;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Version other = (Version)obj;
        if (this.majorNumber == null && other.majorNumber != null || this.majorNumber != null && other.majorNumber == null) {
            return false;
        }
        if (this.majorNumber == null && other.majorNumber == null) {
            return this.version.equals(other.version);
        }
        if (!(this.majorNumber == other.majorNumber || this.majorNumber != null && this.majorNumber.equals(other.majorNumber))) {
            return false;
        }
        if (!(this.minorNumber == other.minorNumber || this.minorNumber != null && this.minorNumber.equals(other.minorNumber))) {
            return false;
        }
        if (!(this.microNumber == other.microNumber || this.microNumber != null && this.microNumber.equals(other.microNumber))) {
            return false;
        }
        if (!(this.updateNumber == other.updateNumber || this.updateNumber != null && this.updateNumber.equals(other.updateNumber))) {
            return false;
        }
        return !(this.qualifier == null ? other.qualifier != null : !this.qualifier.equals(other.qualifier));
    }

    public int hashCode() {
        if (this.majorNumber == null) {
            return this.version.hashCode();
        }
        int hash = 7;
        hash = 97 * hash + (this.majorNumber != null ? this.majorNumber.hashCode() : 0);
        hash = 97 * hash + (this.minorNumber != null ? this.minorNumber.hashCode() : 0);
        hash = 97 * hash + (this.microNumber != null ? this.microNumber.hashCode() : 0);
        hash = 97 * hash + (this.updateNumber != null ? this.updateNumber.hashCode() : 0);
        hash = 97 * hash + (this.qualifier != null ? this.qualifier.hashCode() : 0);
        return hash;
    }

    public boolean isAboveOrEqual(Version other) {
        if (this.majorNumber == null || other.majorNumber == null) {
            return this.equals(other);
        }
        return this.compareTo(other) >= 0;
    }

    public boolean isBelowOrEqual(Version other) {
        if (this.majorNumber == null || other.majorNumber == null) {
            return this.equals(other);
        }
        return this.compareTo(other) <= 0;
    }

    public String toString() {
        return this.version;
    }

    private int compareTo(Version o) {
        int comparison = Version.compare(this.majorNumber, o.majorNumber);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Version.compare(this.minorNumber, o.minorNumber);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Version.compare(this.microNumber, o.microNumber);
        if (comparison != 0) {
            return comparison;
        }
        comparison = Version.compare(this.updateNumber, o.updateNumber);
        if (comparison != 0) {
            return comparison;
        }
        return Version.compare(this.qualifier, o.qualifier);
    }

    private static int compare(Integer o1, Integer o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return Integer.valueOf(0).compareTo(o2);
        }
        if (o2 == null) {
            return o1.compareTo(0);
        }
        return o1.compareTo(o2);
    }

    private static int compare(String o1, String o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return "".compareTo(o2);
        }
        if (o2 == null) {
            return o1.compareTo("");
        }
        return o1.compareTo(o2);
    }
}

