/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.spi.collector;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.util.DLightExecutorService;

public final class DataCollectorListenersSupport {
    private final DataCollector<?> collector;
    private final CopyOnWriteArrayList<DataCollectorListener> listeners = new CopyOnWriteArrayList();
    private final Strategy strategy;

    public DataCollectorListenersSupport(DataCollector<?> collector) {
        this(collector, Strategy.SERIAL);
    }

    public DataCollectorListenersSupport(DataCollector<?> collector, Strategy notificationStrategy) {
        this.collector = collector;
        this.strategy = notificationStrategy;
    }

    public void addListener(DataCollectorListener listener) {
        if (listener != null) {
            this.listeners.addIfAbsent(listener);
        }
    }

    public void removeListener(DataCollectorListener listener) {
        if (listener != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyListeners(DataCollector.CollectorState state) {
        switch (this.strategy) {
            case SERIAL: {
                this.notifyListenersSerially(state);
                break;
            }
            case CONCURRENT: {
                this.notifyListenersConcurrently(state);
            }
        }
    }

    private synchronized void notifyListenersSerially(DataCollector.CollectorState state) {
        for (DataCollectorListener l : this.listeners) {
            l.collectorStateChanged(this.collector, state);
        }
    }

    private void notifyListenersConcurrently(final DataCollector.CollectorState state) {
        CopyOnWriteArrayList clone = (CopyOnWriteArrayList)this.listeners.clone();
        final CountDownLatch doneFlag = new CountDownLatch(clone.size());
        for (final DataCollectorListener l : clone) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        l.collectorStateChanged(DataCollectorListenersSupport.this.collector, state);
                    }
                    finally {
                        doneFlag.countDown();
                    }
                }
            }, (String)("Notifying " + l));
        }
        try {
            doneFlag.await();
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
    }

    public static enum Strategy {
        SERIAL,
        CONCURRENT;

    }
}

