/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.graph;

import java.util.List;
import java.util.Stack;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.netbeans.modules.maven.graph.ArtifactGraphNode;
import org.netbeans.modules.maven.graph.ArtifactWidget;
import org.netbeans.modules.maven.graph.DependencyGraphScene;

class ScopesVisitor
implements DependencyNodeVisitor {
    private DependencyGraphScene scene;
    private DependencyNode root;
    private Stack<DependencyNode> path;
    private List<String> scopes;

    ScopesVisitor(DependencyGraphScene scene, List<String> scopes) {
        this.scene = scene;
        this.path = new Stack();
        this.scopes = scopes;
    }

    public boolean visit(DependencyNode node) {
        if (this.root == null) {
            this.root = node;
        }
        if (node.getState() == 0) {
            ArtifactGraphNode grNode = this.scene.getGraphNodeRepresentant(node);
            ArtifactWidget aw = (ArtifactWidget)this.scene.findWidget(grNode);
            aw.hightlightScopes(this.scopes);
            this.path.push(node);
            return true;
        }
        return false;
    }

    public boolean endVisit(DependencyNode node) {
        if (node.getState() == 0) {
            this.path.pop();
        }
        return true;
    }
}

