/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.fileupload;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.FileItem;
import org.primefaces.component.fileupload.FileUpload;
import org.primefaces.event.FileUploadEvent;
import org.primefaces.model.DefaultUploadedFile;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;
import org.primefaces.webapp.MultipartRequest;

public class FileUploadRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        FileItem file;
        FileUpload fileUpload = (FileUpload)component;
        MultipartRequest multipartRequest = this.getMultiPartRequestInChain(facesContext);
        if (multipartRequest != null && (file = multipartRequest.getFileItem(fileUpload.getInputFileId(facesContext))) != null) {
            DefaultUploadedFile uploadedFile = new DefaultUploadedFile(file);
            fileUpload.queueEvent(new FileUploadEvent((UIComponent)fileUpload, uploadedFile));
        }
    }

    private MultipartRequest getMultiPartRequestInChain(FacesContext facesContext) {
        Object request = facesContext.getExternalContext().getRequest();
        while (request instanceof ServletRequestWrapper) {
            if (request instanceof MultipartRequest) {
                return (MultipartRequest)((Object)request);
            }
            request = ((ServletRequestWrapper)request).getRequest();
        }
        return null;
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        FileUpload fileUpload = (FileUpload)component;
        this.encodeMarkup(facesContext, fileUpload);
        this.encodeScript(facesContext, fileUpload);
    }

    protected void encodeScript(FacesContext context, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String clientId = fileUpload.getClientId(context);
        String inputFileId = fileUpload.getInputFileId(context);
        String actionURL = this.getActionURL(context);
        String cancelImg = fileUpload.getCancelImage() == null ? this.getResourceRequestPath(context, "fileupload/cancel.png") : this.getResourceURL(context, fileUpload.getCancelImage());
        UIComponent parentForm = ComponentUtils.findParentForm(context, (UIComponent)fileUpload);
        if (parentForm == null) {
            throw new FacesException("FileUpload component:" + clientId + " needs to be enclosed in a form");
        }
        String formClientId = parentForm.getClientId(context);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(fileUpload.resolveWidgetVar() + " = new PrimeFaces.widget.Uploader('" + clientId + "', {");
        writer.write("uploader:'" + this.getResourceRequestPath(context, "fileupload/uploadify.swf") + "'");
        writer.write(",script:'" + actionURL + "'");
        writer.write(",cancelImg:'" + cancelImg + "'");
        writer.write(",formId:'" + formClientId + "'");
        writer.write(",fileDataName:'" + inputFileId + "'");
        writer.write(",multi:" + fileUpload.isMultiple());
        writer.write(",auto:" + fileUpload.isAuto());
        writer.write(",inputFileId:'" + inputFileId + "'");
        writer.write(",jsessionid:'" + ((HttpSession)context.getExternalContext().getSession(true)).getId() + "'");
        if (fileUpload.getUpdate() != null) {
            writer.write(",update:'" + ComponentUtils.findClientIds(context, (UIComponent)fileUpload, fileUpload.getUpdate()) + "'");
        }
        if (fileUpload.getImage() != null) {
            writer.write(",buttonImg:'" + this.getResourceURL(context, fileUpload.getImage()) + "'");
        }
        if (fileUpload.getLabel() != null) {
            writer.write(",buttonText:'" + fileUpload.getLabel() + "'");
        }
        if (fileUpload.getWidth() != null) {
            writer.write(",width:'" + fileUpload.getWidth() + "'");
        }
        if (fileUpload.getHeight() != null) {
            writer.write(",height:'" + fileUpload.getWidth() + "'");
        }
        if (fileUpload.getAllowTypes() != null) {
            writer.write(",fileExt:'" + fileUpload.getAllowTypes() + "'");
        }
        if (fileUpload.getDescription() != null) {
            writer.write(",fileDesc:'" + fileUpload.getDescription() + "'");
        }
        if (fileUpload.getSizeLimit() != Long.MAX_VALUE) {
            writer.write(",sizeLimit:" + fileUpload.getSizeLimit());
        }
        if (fileUpload.getWmode() != null) {
            writer.write(",wmode:'" + fileUpload.getWmode() + "'");
        }
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, FileUpload fileUpload) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = fileUpload.getClientId(facesContext);
        String inputFileId = fileUpload.getInputFileId(facesContext);
        String widgetVar = fileUpload.resolveWidgetVar();
        writer.startElement("span", (UIComponent)fileUpload);
        writer.writeAttribute("id", (Object)clientId, "id");
        if (fileUpload.getStyle() != null) {
            writer.writeAttribute("style", (Object)fileUpload.getStyle(), "style");
        }
        if (fileUpload.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)fileUpload.getStyleClass(), "styleClass");
        }
        writer.startElement("input", null);
        writer.writeAttribute("type", (Object)"file", null);
        writer.writeAttribute("id", (Object)inputFileId, null);
        writer.writeAttribute("name", (Object)inputFileId, null);
        writer.endElement("input");
        if (!fileUpload.isCustomUI() && !fileUpload.isAuto()) {
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"javascript:void(0)", null);
            writer.writeAttribute("onclick", (Object)(widgetVar + ".upload()"), null);
            writer.write("Upload");
            writer.endElement("a");
            writer.write(" | ");
            writer.startElement("a", null);
            writer.writeAttribute("href", (Object)"javascript:void(0)", null);
            writer.writeAttribute("onclick", (Object)(widgetVar + ".clear()"), null);
            writer.write("Clear");
            writer.endElement("a");
        }
        writer.endElement("span");
    }
}

