/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.tooltip;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.tooltip.Tooltip;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class TooltipRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Tooltip tooltip = (Tooltip)component;
        this.encodeScript(facesContext, tooltip);
    }

    protected void encodeScript(FacesContext facesContext, Tooltip tooltip) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        boolean global = tooltip.isGlobal();
        String owner = this.getTarget(facesContext, tooltip);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(tooltip.resolveWidgetVar() + " = new PrimeFaces.widget.Tooltip({");
        writer.write("global:" + global);
        if (!global) {
            writer.write(",forComponent:'" + owner + "'");
            writer.write(",content:'");
            if (tooltip.getValue() == null) {
                this.renderChildren(facesContext, (UIComponent)tooltip);
            } else {
                writer.write(ComponentUtils.getStringValueToRender(facesContext, (UIComponent)tooltip).replaceAll("'", "\\\\'"));
            }
            writer.write("'");
        }
        writer.write(",show:{when:{event:'" + tooltip.getShowEvent() + "'}, delay:" + tooltip.getShowDelay() + ", effect:{length:" + tooltip.getShowEffectLength() + ", type: '" + tooltip.getShowEffect() + "'}}");
        writer.write(",hide:{when:{event:'" + tooltip.getHideEvent() + "'}, delay:" + tooltip.getHideDelay() + ", effect:{length:" + tooltip.getHideEffectLength() + ", type: '" + tooltip.getHideEffect() + "'}}");
        writer.write(",position: {");
        String container = owner == null ? "document.body" : "jQuery(PrimeFaces.escapeClientId('" + owner + "')).parent()";
        writer.write("container:" + container);
        writer.write(",corner:{");
        writer.write("target:'" + tooltip.getTargetPosition() + "'");
        writer.write(",tooltip:'" + tooltip.getPosition() + "'");
        writer.write("}}");
        writer.write("});");
        writer.write("});");
        writer.endElement("script");
    }

    protected String getTarget(FacesContext facesContext, Tooltip tooltip) {
        if (tooltip.isGlobal()) {
            return null;
        }
        String _for = tooltip.getFor();
        if (_for != null) {
            UIComponent forComponent = tooltip.findComponent(_for);
            if (forComponent == null) {
                throw new FacesException("Cannot find component \"" + _for + "\" in view.");
            }
            return forComponent.getClientId(facesContext);
        }
        if (tooltip.getForElement() != null) {
            return tooltip.getForElement();
        }
        return tooltip.getParent().getClientId(facesContext);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

