/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.util.WeakListeners;

final class BootClassPathImplementation
implements ClassPathImplementation {
    private static final Logger LOGGER = Logger.getLogger(BootClassPathImplementation.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private final ProjectConfigListener projectConfigListener = new ProjectConfigListener();
    private final GrailsProjectConfig config;
    private List<PathResourceImplementation> resourcesCache;
    private long eventId;

    private BootClassPathImplementation(GrailsProjectConfig config) {
        this.config = config;
    }

    public static BootClassPathImplementation forProject(Project project) {
        GrailsProjectConfig config = GrailsProjectConfig.forProject((Project)project);
        BootClassPathImplementation impl = new BootClassPathImplementation(config);
        config.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)impl.projectConfigListener, (Object)config));
        return impl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PathResourceImplementation> getResources() {
        GrailsPlatform gp;
        long currentId;
        BootClassPathImplementation bootClassPathImplementation = this;
        synchronized (bootClassPathImplementation) {
            if (this.resourcesCache != null) {
                return this.resourcesCache;
            }
            currentId = this.eventId;
        }
        JavaPlatform jp = this.config.getJavaPlatform();
        ArrayList<PathResourceImplementation> result = new ArrayList<PathResourceImplementation>();
        if (jp != null) {
            ClassPath cp = jp.getBootstrapLibraries();
            assert (cp != null) : jp;
            for (ClassPath.Entry entry : cp.entries()) {
                result.add(ClassPathSupport.createResource((URL)entry.getURL()));
            }
        }
        if ((gp = this.config.getGrailsPlatform()) != null) {
            ClassPath cp = gp.getClassPath();
            assert (cp != null) : gp;
            for (ClassPath.Entry entry : cp.entries()) {
                result.add(ClassPathSupport.createResource((URL)entry.getURL()));
            }
        }
        BootClassPathImplementation bootClassPathImplementation2 = this;
        synchronized (bootClassPathImplementation2) {
            if (currentId == this.eventId) {
                if (this.resourcesCache == null) {
                    this.resourcesCache = Collections.unmodifiableList(result);
                }
                return this.resourcesCache;
            }
            return Collections.unmodifiableList(result);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.support.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.support.removePropertyChangeListener(listener);
    }

    private class ProjectConfigListener
    implements PropertyChangeListener {
        private ProjectConfigListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("grails.java.platform".equals(evt.getPropertyName()) || "grails.platform".equals(evt.getPropertyName())) {
                LOGGER.log(Level.FINE, "Boot classpath changed due to change in {0}", evt.getPropertyName());
                BootClassPathImplementation bootClassPathImplementation = BootClassPathImplementation.this;
                synchronized (bootClassPathImplementation) {
                    BootClassPathImplementation.this.resourcesCache = null;
                    BootClassPathImplementation.this.eventId++;
                }
                BootClassPathImplementation.this.support.firePropertyChange("resources", null, null);
            }
        }
    }
}

