/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.ui.TreeRootNode;
import org.netbeans.modules.groovy.support.api.GroovySources;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ChangeSupport;

public class SourceNodeFactory
implements NodeFactory {
    public NodeList<?> createNodes(Project p) {
        GrailsProject project = (GrailsProject)p.getLookup().lookup(GrailsProject.class);
        assert (project != null);
        return new SourcesNodeList(project);
    }

    private static class SourceGroupKey
    implements Comparable<SourceGroupKey> {
        public final SourceGroup group;
        public final FileObject fileObject;
        public final FileObject projectDir;

        SourceGroupKey(SourceGroup group, FileObject projectDir) {
            this.group = group;
            this.fileObject = group.getRootFolder();
            this.projectDir = projectDir;
        }

        public int hashCode() {
            return this.fileObject.hashCode();
        }

        @Override
        public int compareTo(SourceGroupKey o) {
            String relativePath1 = FileUtil.getRelativePath((FileObject)this.projectDir, (FileObject)this.fileObject);
            String relativePath2 = FileUtil.getRelativePath((FileObject)this.projectDir, (FileObject)o.fileObject);
            return relativePath1.compareTo(relativePath2);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof SourceGroupKey)) {
                return false;
            }
            SourceGroupKey otherKey = (SourceGroupKey)obj;
            String thisDisplayName = this.group.getDisplayName();
            String otherDisplayName = otherKey.group.getDisplayName();
            return this.fileObject.equals(otherKey.fileObject) && thisDisplayName == null ? otherDisplayName == null : thisDisplayName.equals(otherDisplayName);
        }

        public String toString() {
            return this.group.toString();
        }
    }

    private static class SourcesNodeList
    implements NodeList<SourceGroupKey>,
    ChangeListener {
        private GrailsProject project;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

        public SourcesNodeList(GrailsProject proj) {
            this.project = proj;
        }

        public List<SourceGroupKey> keys() {
            FileObject projectDir = this.project.getProjectDirectory();
            if (projectDir == null || !projectDir.isValid()) {
                return Collections.emptyList();
            }
            Sources sources = this.getSources();
            List sourceGroups = GroovySources.getGroovySourceGroups((Sources)sources);
            ArrayList<SourceGroupKey> result = new ArrayList<SourceGroupKey>();
            for (SourceGroup sourceGroup : sourceGroups) {
                if (sourceGroup.getRootFolder() == null) continue;
                result.add(new SourceGroupKey(sourceGroup, projectDir));
            }
            Collections.sort(result);
            return result;
        }

        public void addChangeListener(ChangeListener l) {
            this.changeSupport.addChangeListener(l);
        }

        public void removeChangeListener(ChangeListener l) {
            this.changeSupport.removeChangeListener(l);
        }

        public Node node(SourceGroupKey key) {
            return new TreeRootNode(key.group, this.project);
        }

        public void addNotify() {
            this.getSources().addChangeListener((ChangeListener)this);
        }

        public void removeNotify() {
            this.getSources().removeChangeListener((ChangeListener)this);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SourcesNodeList.this.changeSupport.fireChange();
                }
            });
        }

        private Sources getSources() {
            return ProjectUtils.getSources((Project)this.project);
        }
    }
}

