/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.form.BeanSupport;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.RADProperty;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class ComponentChooserEditor
implements PropertyEditor,
FormAwareEditor,
XMLPropertyEditor,
NamedPropertyEditor {
    public static final int ALL_COMPONENTS = 0;
    public static final int NONVISUAL_COMPONENTS = 3;
    private static final String NULL_REF = "null";
    private static final String INVALID_REF = "default";
    private static String noneText = null;
    private static String invalidText = null;
    private static String defaultText = null;
    private FormModel formModel;
    private FormProperty property;
    private List<RADComponent> components;
    private Class[] beanTypes = null;
    private int componentCategory = 0;
    private Object defaultValue;
    private ComponentRef value;
    private PropertyChangeSupport changeSupport;
    private static final String XML_COMPONENT = "ComponentRef";
    private static final String ATTR_NAME = "name";

    public ComponentChooserEditor() {
    }

    public ComponentChooserEditor(Class[] componentTypes) {
        this.beanTypes = componentTypes;
    }

    @Override
    public void setValue(Object value) {
        this.defaultValue = null;
        if (value == null || value instanceof ComponentRef) {
            this.value = (ComponentRef)value;
        } else if (value instanceof RADComponent) {
            this.value = new ComponentRef((RADComponent)value);
        } else if (value instanceof String) {
            this.value = new ComponentRef((String)value);
        } else {
            this.value = null;
            this.defaultValue = value;
        }
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        if (this.value != null && INVALID_REF.equals(this.value.getDescription())) {
            return BeanSupport.NO_VALUE;
        }
        return this.isDefaultValue() ? this.defaultValue : this.value;
    }

    @Override
    public String[] getTags() {
        Object[] names;
        List compList = this.getComponents();
        int extraValues = 0;
        int count = 0;
        boolean includeNone = this.shouldIncludeNone();
        if (this.isDefaultValue()) {
            extraValues = includeNone ? 2 : 1;
            count = compList.size() + extraValues;
            names = new String[count];
            names[0] = this.defaultString();
        } else {
            extraValues = includeNone ? 1 : 0;
            count = compList.size() + extraValues;
            names = new String[count];
        }
        if (includeNone) {
            names[extraValues - 1] = this.noneString();
        }
        if (count > extraValues) {
            for (int i = extraValues; i < count; ++i) {
                names[i] = ((RADComponent)compList.get(i - extraValues)).getName();
            }
            Arrays.sort(names, 1, count);
        }
        return names;
    }

    private boolean shouldIncludeNone() {
        boolean include = true;
        if (this.property instanceof RADProperty) {
            RADProperty radProperty = (RADProperty)this.property;
            String propName = radProperty.getName();
            RADComponent metacomp = radProperty.getRADComponent();
            Object instance = metacomp.getBeanInstance();
            if (instance instanceof JTextComponent && ("caret".equals(propName) || "document".equals(propName))) {
                include = false;
            }
        }
        return include;
    }

    private boolean isDefaultValue() {
        return this.value == null && this.defaultValue != null;
    }

    @Override
    public String getAsText() {
        if (this.isDefaultValue()) {
            return this.defaultString();
        }
        if (this.value == null) {
            return this.noneString();
        }
        if (this.value.getComponent() == null) {
            return this.invalidString();
        }
        String str = this.value.getDescription();
        return NULL_REF.equals(str) ? this.noneString() : str;
    }

    @Override
    public void setAsText(String str) {
        if (str == null || str.equals("") || str.equals(this.noneString())) {
            this.setValue(null);
        } else if (this.defaultString().equals(str)) {
            this.setValue(this.defaultValue);
        } else {
            this.setValue(str);
        }
    }

    @Override
    public String getJavaInitializationString() {
        return this.value != null ? this.value.getJavaInitString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        ComponentChooserEditor componentChooserEditor = this;
        synchronized (componentChooserEditor) {
            if (this.changeSupport == null) {
                this.changeSupport = new PropertyChangeSupport(this);
            }
        }
        this.changeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(l);
        }
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics gfx, Rectangle box) {
    }

    @Override
    public Component getCustomEditor() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return false;
    }

    @Override
    public void setContext(FormModel model, FormProperty prop) {
        this.formModel = model;
        this.property = prop;
    }

    @Override
    public void updateFormVersionLevel() {
    }

    public FormModel getFormModel() {
        return this.formModel;
    }

    public void setBeanTypes(Class[] types) {
        this.beanTypes = types;
    }

    public Class[] getBeanTypes() {
        return this.beanTypes;
    }

    public void setComponentCategory(int cat) {
        this.componentCategory = cat;
    }

    public int getComponentCategory() {
        return this.componentCategory;
    }

    public Node storeToXML(Document doc) {
        String nameStr = this.value != null ? (this.value.getComponent() != null ? this.value.getDescription() : INVALID_REF) : NULL_REF;
        Element el = doc.createElement(XML_COMPONENT);
        el.setAttribute(ATTR_NAME, nameStr);
        return el;
    }

    public void readFromXML(Node element) throws IOException {
        String name;
        Node nameAttr;
        if (!XML_COMPONENT.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        if (attributes != null && (nameAttr = attributes.getNamedItem(ATTR_NAME)) != null && (name = nameAttr.getNodeValue()) != null) {
            this.value = NULL_REF.equals(name) ? null : new ComponentRef(name);
        }
    }

    protected List getComponents() {
        if (this.components == null) {
            this.components = new ArrayList<RADComponent>();
        } else {
            this.components.clear();
        }
        if (this.formModel != null) {
            Collection<RADComponent> comps = this.componentCategory == 3 ? this.formModel.getNonVisualComponents() : this.formModel.getAllComponents();
            for (RADComponent metacomp : comps) {
                if (!this.acceptBean(metacomp)) continue;
                this.components.add(metacomp);
            }
        }
        return this.components;
    }

    protected boolean acceptBean(RADComponent comp) {
        if (this.beanTypes == null) {
            return true;
        }
        boolean match = false;
        for (int i = 0; i < this.beanTypes.length && !match; ++i) {
            match = this.beanTypes[i].isAssignableFrom(comp.getBeanClass());
        }
        return match;
    }

    protected String noneString() {
        if (noneText == null) {
            noneText = FormUtils.getBundleString("CTL_NoComponent");
        }
        return noneText;
    }

    protected String defaultString() {
        if (defaultText == null) {
            defaultText = FormUtils.getBundleString("CTL_DefaultComponent");
        }
        return defaultText;
    }

    protected String invalidString() {
        if (invalidText == null) {
            invalidText = FormUtils.getBundleString("CTL_InvalidReference");
        }
        return invalidText;
    }

    protected final void firePropertyChange() {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(null, null, null);
        }
    }

    @Override
    public String getDisplayName() {
        return NbBundle.getBundle(this.getClass()).getString("CTL_ComponentChooserEditor_DisplayName");
    }

    private class ComponentRef
    extends FormDesignValueAdapter
    implements RADComponent.ComponentReference {
        private String componentName;
        private RADComponent component;

        ComponentRef(String name) {
            this.componentName = name;
        }

        ComponentRef(RADComponent metacomp) {
            this.componentName = metacomp.getName();
            this.component = metacomp;
        }

        public boolean equals(Object obj) {
            boolean equal;
            if (obj instanceof ComponentRef) {
                ComponentRef ref = (ComponentRef)obj;
                boolean bl = equal = ref.component == this.component;
                equal = this.componentName == null ? equal && ref.componentName == null : equal && this.componentName.equals(ref.componentName);
            } else {
                equal = obj instanceof RADComponent && obj == this.component;
            }
            return equal;
        }

        public int hashCode() {
            int hash = 5;
            hash = 89 * hash + (this.componentName != null ? this.componentName.hashCode() : 0);
            hash = 89 * hash + (this.component != null ? this.component.hashCode() : 0);
            return hash;
        }

        String getJavaInitString() {
            this.checkComponent();
            if (this.component != null) {
                if (this.component == this.component.getFormModel().getTopRADComponent()) {
                    return "this";
                }
            } else if (!ComponentChooserEditor.NULL_REF.equals(this.componentName)) {
                return null;
            }
            return this.componentName;
        }

        @Override
        public RADComponent getComponent() {
            this.checkComponent();
            return this.component;
        }

        @Override
        public String getDescription() {
            this.checkComponent();
            return this.componentName;
        }

        @Override
        public Object getDesignValue() {
            this.checkComponent();
            return this.component != null ? this.component.getBeanInstance() : IGNORED_VALUE;
        }

        private void checkComponent() {
            if (this.component == null && !ComponentChooserEditor.NULL_REF.equals(this.componentName) && !ComponentChooserEditor.INVALID_REF.equals(this.componentName)) {
                List compList = ComponentChooserEditor.this.getComponents();
                for (RADComponent comp : compList) {
                    if (!comp.getName().equals(this.componentName)) continue;
                    if (comp.isInModel()) {
                        this.component = comp;
                    }
                    break;
                }
            } else if (this.component != null) {
                if (!this.component.isInModel()) {
                    this.component = null;
                } else {
                    this.componentName = this.component.getName();
                }
            }
        }
    }
}

