/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.form.FormRefactoringUpdate;
import org.netbeans.modules.form.RefactoringInfo;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.MoveRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.api.SingleCopyRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.RefactoringPluginFactory;
import org.netbeans.modules.refactoring.spi.Transaction;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class RefactoringPluginFactoryImpl
implements RefactoringPluginFactory {
    public RefactoringPlugin createInstance(AbstractRefactoring refactoring) {
        Collection files;
        RefactoringInfo.ChangeType changeType = null;
        LinkedList<FileObject> fileList = new LinkedList<FileObject>();
        LinkedList<String> nameList = new LinkedList<String>();
        if (refactoring instanceof RenameRefactoring) {
            FileObject primaryFile = null;
            String oldName = null;
            Lookup sourceLookup = refactoring.getRefactoringSource();
            FileObject file = (FileObject)sourceLookup.lookup(FileObject.class);
            NonRecursiveFolder pkgFolder = (NonRecursiveFolder)sourceLookup.lookup(NonRecursiveFolder.class);
            final TreePathHandle tpHandle = (TreePathHandle)sourceLookup.lookup(TreePathHandle.class);
            if (file != null && RefactoringInfo.isJavaFile(file)) {
                if (RefactoringPluginFactoryImpl.isOnSourceClasspath(file)) {
                    changeType = RefactoringInfo.ChangeType.CLASS_RENAME;
                    primaryFile = file;
                    oldName = file.getName();
                }
            } else if (file == null && tpHandle != null) {
                primaryFile = tpHandle.getFileObject();
                if (RefactoringInfo.isJavaFileOfForm(primaryFile)) {
                    JavaSource source = JavaSource.forFileObject((FileObject)tpHandle.getFileObject());
                    final RefactoringInfo.ChangeType[] changeTypes = new RefactoringInfo.ChangeType[1];
                    final String[] oldNames = new String[1];
                    try {
                        source.runUserActionTask((Task)new CancellableTask<CompilationController>(){

                            public void cancel() {
                            }

                            public void run(CompilationController controller) throws Exception {
                                controller.toPhase(JavaSource.Phase.RESOLVED);
                                Element el = tpHandle.resolveElement((CompilationInfo)controller);
                                if (el != null) {
                                    switch (el.getKind()) {
                                        case FIELD: {
                                            changeTypes[0] = RefactoringInfo.ChangeType.VARIABLE_RENAME;
                                            break;
                                        }
                                        case LOCAL_VARIABLE: {
                                            Element parentEl = el.getEnclosingElement();
                                            if (parentEl.getKind() != ElementKind.METHOD || !"initComponents".equals(parentEl.getSimpleName().toString()) || !((ExecutableElement)parentEl).getParameters().isEmpty()) break;
                                            changeTypes[0] = RefactoringInfo.ChangeType.VARIABLE_RENAME;
                                        }
                                    }
                                    oldNames[0] = el.getSimpleName().toString();
                                }
                            }
                        }, true);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    changeType = changeTypes[0];
                    oldName = oldNames[0];
                }
            } else if (file != null && file.isFolder()) {
                if (RefactoringPluginFactoryImpl.isOnSourceClasspath(file)) {
                    changeType = RefactoringInfo.ChangeType.FOLDER_RENAME;
                    primaryFile = file;
                    oldName = file.getName();
                }
            } else if (pkgFolder != null && RefactoringPluginFactoryImpl.isOnSourceClasspath(pkgFolder.getFolder())) {
                changeType = RefactoringInfo.ChangeType.PACKAGE_RENAME;
                primaryFile = pkgFolder.getFolder();
                ClassPath cp = ClassPath.getClassPath((FileObject)primaryFile, (String)"classpath/source");
                oldName = cp.getResourceName(primaryFile, '.', false);
            }
            if (changeType != null) {
                fileList.add(primaryFile);
                nameList.add(oldName);
            }
        } else if (refactoring instanceof MoveRefactoring) {
            files = refactoring.getRefactoringSource().lookupAll(FileObject.class);
            for (FileObject file : files) {
                if (!RefactoringInfo.isJavaFile(file) || !RefactoringPluginFactoryImpl.isOnSourceClasspath(file)) continue;
                changeType = RefactoringInfo.ChangeType.CLASS_MOVE;
                fileList.add(file);
                ClassPath cp = ClassPath.getClassPath((FileObject)file, (String)"classpath/source");
                nameList.add(cp.getResourceName(file, '.', false));
            }
        } else if (refactoring instanceof SingleCopyRefactoring) {
            files = refactoring.getRefactoringSource().lookupAll(FileObject.class);
            for (FileObject file : files) {
                if (!RefactoringInfo.isJavaFileOfForm(file) || !RefactoringPluginFactoryImpl.isOnSourceClasspath(file)) continue;
                changeType = RefactoringInfo.ChangeType.CLASS_COPY;
                fileList.add(file);
                nameList.add(file.getName());
            }
        } else if (refactoring instanceof SafeDeleteRefactoring) {
            files = refactoring.getRefactoringSource().lookupAll(FileObject.class);
            for (FileObject file : files) {
                if (file == null || !RefactoringInfo.isJavaFileOfForm(file) || !RefactoringPluginFactoryImpl.isOnSourceClasspath(file)) continue;
                changeType = RefactoringInfo.ChangeType.CLASS_DELETE;
                fileList.add(file);
                nameList.add(null);
            }
        }
        if (changeType != null) {
            FileObject[] originalFiles = fileList.toArray(new FileObject[fileList.size()]);
            String[] oldNames = nameList.toArray(new String[nameList.size()]);
            RefactoringInfo refInfo = new RefactoringInfo(refactoring, changeType, originalFiles, oldNames);
            refactoring.getContext().add((Object)refInfo);
            return new RefactoringPluginImpl(refInfo);
        }
        return null;
    }

    private static boolean isOnSourceClasspath(FileObject fo) {
        return true;
    }

    private static class RefactoringPluginImpl
    implements RefactoringPlugin {
        private RefactoringInfo refInfo;

        RefactoringPluginImpl(RefactoringInfo refInfo) {
            this.refInfo = refInfo;
        }

        public Problem preCheck() {
            return null;
        }

        public Problem checkParameters() {
            return null;
        }

        public Problem fastCheckParameters() {
            return null;
        }

        public void cancelRequest() {
        }

        public Problem prepare(RefactoringElementsBag refactoringElements) {
            for (FileObject file : this.refInfo.getOriginalFiles()) {
                if (RefactoringInfo.isJavaFileOfForm(file)) {
                    FormRefactoringUpdate update = this.refInfo.getUpdateForFile(file);
                    switch (this.refInfo.getChangeType()) {
                        case CLASS_DELETE: {
                            refactoringElements.registerTransaction((Transaction)update);
                            return null;
                        }
                        case CLASS_RENAME: {
                            if (update.prepareForm(true)) break;
                            return new Problem(true, "Error loading form. Cannot update generated code.");
                        }
                    }
                    refactoringElements.add(this.refInfo.getRefactoring(), update.getPreviewElement());
                    refactoringElements.addFileChange(this.refInfo.getRefactoring(), (RefactoringElementImplementation)update);
                    continue;
                }
                if (this.refInfo.getChangeType() != RefactoringInfo.ChangeType.PACKAGE_RENAME && this.refInfo.getChangeType() != RefactoringInfo.ChangeType.FOLDER_RENAME) continue;
                boolean anyForm = false;
                for (FileObject fo : file.getChildren()) {
                    if (!RefactoringInfo.isJavaFileOfForm(fo)) continue;
                    anyForm = true;
                    FormRefactoringUpdate update = this.refInfo.getUpdateForFile(fo);
                    refactoringElements.addFileChange(this.refInfo.getRefactoring(), (RefactoringElementImplementation)update);
                }
                if (!anyForm) continue;
            }
            return null;
        }
    }
}

