/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.image.BufferedImage;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.form.FormAwareEditor;
import org.netbeans.modules.form.FormDesignValue;
import org.netbeans.modules.form.FormDesignValueAdapter;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormProperty;
import org.netbeans.modules.form.editors.CustomIconEditor;
import org.openide.ErrorManager;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IconEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
FormAwareEditor {
    public static final int TYPE_URL = 1;
    public static final int TYPE_FILE = 2;
    public static final int TYPE_CLASSPATH = 3;
    private static final String[] DEFAULT_DIRS = new String[]{"resources", "resource", "images"};
    private String currentPackage;
    private String[] currentFiles;
    private FileObject sourceFile;
    private boolean externalIconsAllowed = true;
    public static final String XML_IMAGE = "Image";
    public static final String ATTR_TYPE = "iconType";
    public static final String ATTR_NAME = "name";

    @Override
    public void setValue(Object value) {
        if (IconEditor.sameValue(value, this.getValue())) {
            return;
        }
        if (value instanceof NbImageIcon) {
            NbImageIcon nbIcon = (NbImageIcon)value;
            if (nbIcon.getType() == 3) {
                this.setCurrentPackage(this.getResourcePackage(nbIcon.getName()));
            }
        } else {
            Object nbIcon = null;
            if (value == null && this.currentPackage == null) {
                this.setCurrentPackage(this.getDefaultResourcePackage());
            }
        }
        super.setValue(value);
        this.currentFiles = null;
    }

    private static boolean sameValue(Object val1, Object val2) {
        if (val1 == null && val2 == null) {
            return true;
        }
        if (val1 instanceof NbImageIcon && val2 instanceof NbImageIcon) {
            return IconEditor.sameIcon((NbImageIcon)val1, (NbImageIcon)val2);
        }
        return false;
    }

    private static boolean sameIcon(NbImageIcon nbIcon1, NbImageIcon nbIcon2) {
        return nbIcon1.getType() == nbIcon2.getType() && nbIcon1.getName().equals(nbIcon2.getName());
    }

    @Override
    public String getAsText() {
        Object val = this.getValue();
        if (val instanceof NbImageIcon) {
            NbImageIcon nbIcon = (NbImageIcon)val;
            if (nbIcon.getType() == 3) {
                String resName = nbIcon.getName();
                if (this.currentPackage != null && resName.startsWith(this.currentPackage)) {
                    return resName.substring(this.currentPackage.length() + 1);
                }
                return resName;
            }
            return nbIcon.getName();
        }
        return "";
    }

    @Override
    public void setAsText(String string) throws IllegalArgumentException {
        this.setValue(this.createIconFromText(string));
    }

    @Override
    public String getJavaInitializationString() {
        if (this.getValue() instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)this.getValue();
            switch (ii.type) {
                case 1: {
                    return "new javax.swing.JLabel() {\n  public javax.swing.Icon getIcon() {\n    try {\n      return new javax.swing.ImageIcon(\n        new java.net.URL(\"" + IconEditor.convert(ii.name) + "\")\n" + "      );\n" + "    } catch (java.net.MalformedURLException e) {\n" + "    }\n" + "    return null;\n" + "  }\n" + "}.getIcon()";
                }
                case 2: {
                    return "*/\n\\1NOI18N*/\n\\0new javax.swing.ImageIcon(\"" + IconEditor.convert(ii.name) + "\")";
                }
                case 3: {
                    return "*/\n\\1NOI18N*/\n\\0new javax.swing.ImageIcon(getClass().getResource(\"/" + ii.name + "\"))";
                }
            }
        }
        return "null";
    }

    private static String convert(String s) {
        StringTokenizer st = new StringTokenizer(s, "\\");
        StringBuilder sb = new StringBuilder();
        if (st.hasMoreElements()) {
            sb.append(st.nextElement());
            while (st.hasMoreElements()) {
                sb.append("\\\\").append(st.nextElement());
            }
        }
        return sb.toString();
    }

    @Override
    public String[] getTags() {
        if (this.currentFiles == null) {
            this.currentFiles = this.getAvailableFileNames();
        }
        return this.currentFiles;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        CustomIconEditor customEditor = new CustomIconEditor(this);
        Object value = this.getValue();
        if (!(value instanceof NbImageIcon)) {
            value = null;
        }
        customEditor.setValue((NbImageIcon)value);
        this.currentFiles = null;
        return customEditor;
    }

    @Override
    public void setContext(FormModel model, FormProperty prop) {
        if (model != null) {
            this.sourceFile = FormEditor.getFormDataObject(model).getPrimaryFile();
        }
        if (prop != null) {
            prop.setValue("canEditAsText", true);
        }
        if (this.currentPackage == null && this.sourceFile != null) {
            this.setCurrentPackage(this.getDefaultResourcePackage());
        }
    }

    @Override
    public void updateFormVersionLevel() {
    }

    FileObject getSourceFile() {
        return this.sourceFile;
    }

    public void setSourceFile(FileObject sourceFile) {
        this.sourceFile = sourceFile;
    }

    public void setExternalIconsAllowed(boolean externalIconsAllowed) {
        this.externalIconsAllowed = externalIconsAllowed;
    }

    public boolean isExternalIconsAllowed() {
        return this.externalIconsAllowed;
    }

    public FileObject getCurrentFolder() {
        if (this.currentPackage != null) {
            FileObject srcFile = this.getSourceFile();
            FileObject folder = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source").findResource(this.currentPackage);
            if (folder == null) {
                folder = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute").findResource(this.currentPackage);
            }
            return folder;
        }
        return null;
    }

    public void setCurrentFolder(FileObject folder) {
        if (folder != null) {
            FileObject srcFile = this.getSourceFile();
            FileObject root = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source").findOwnerRoot(folder);
            if (root == null) {
                root = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute").findOwnerRoot(folder);
            }
            if (root != null) {
                this.setCurrentPackage(FileUtil.getRelativePath((FileObject)root, (FileObject)folder));
            }
        } else {
            this.setCurrentPackage(null);
        }
    }

    private void setCurrentPackage(String pkg) {
        this.currentPackage = pkg;
        this.currentFiles = null;
    }

    private String getResourcePackage(String resName) {
        int i = resName.lastIndexOf(47);
        if (i < 0) {
            return null;
        }
        return resName.substring(0, i);
    }

    FileObject getDefaultResourceFolder() {
        FileObject srcFile = this.getSourceFile();
        for (String dir : DEFAULT_DIRS) {
            FileObject folder = srcFile.getParent().getFileObject(dir);
            if (folder == null) continue;
            return folder;
        }
        return srcFile.getParent();
    }

    private String getDefaultResourcePackage() {
        FileObject folder = this.getDefaultResourceFolder();
        ClassPath cp = ClassPath.getClassPath((FileObject)folder, (String)"classpath/source");
        FileObject root = cp.findOwnerRoot(folder);
        return FileUtil.getRelativePath((FileObject)root, (FileObject)folder);
    }

    private String[] getAvailableFileNames() {
        FileObject folder = this.getCurrentFolder();
        if (folder != null) {
            LinkedList<String> list = new LinkedList<String>();
            for (FileObject fo : folder.getChildren()) {
                if (!IconEditor.isImageFile(fo)) continue;
                list.add(fo.getNameExt());
            }
            Object[] fileNames = new String[list.size()];
            list.toArray(fileNames);
            Arrays.sort(fileNames);
            return fileNames;
        }
        return null;
    }

    static boolean isImageFile(FileObject fo) {
        return fo.isFolder() ? false : IconEditor.isImageFileName(fo.getNameExt());
    }

    static boolean isImageFileName(String name) {
        return (name = name.toLowerCase()).endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".png") || name.endsWith(".jpeg") || name.endsWith(".jpe");
    }

    private NbImageIcon createIconFromText(String txt) {
        NbImageIcon nbIcon;
        if (txt == null || "".equals(txt.trim())) {
            return null;
        }
        if (!(txt.contains("/") || txt.contains("\\") || txt.contains(":"))) {
            String pkg = this.currentPackage != null ? this.currentPackage : this.getDefaultResourcePackage();
            txt = pkg + "/" + txt;
        }
        if ((nbIcon = this.iconFromResourceName(txt)) != null) {
            return nbIcon;
        }
        nbIcon = this.iconFromURL(txt, true);
        if (nbIcon != null) {
            return nbIcon;
        }
        return this.iconFromFileName(txt);
    }

    private NbImageIcon iconFromResourceName(String resName) {
        return IconEditor.iconFromResourceName(resName, this.getSourceFile());
    }

    private static NbImageIcon iconFromResourceName(String resName, FileObject srcFile) {
        ClassPath cp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/source");
        FileObject fo = cp.findResource(resName);
        if (fo == null) {
            cp = ClassPath.getClassPath((FileObject)srcFile, (String)"classpath/execute");
            fo = cp.findResource(resName);
        }
        if (fo != null) {
            try {
                try {
                    BufferedImage image = ImageIO.read(fo.getURL());
                    if (image != null) {
                        return new NbImageIcon(3, resName, new ImageIcon(image));
                    }
                }
                catch (IllegalArgumentException iaex) {
                    Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, iaex);
                    return new NbImageIcon(3, resName, new ImageIcon(fo.getURL()));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(IconEditor.class.getName()).log(Level.WARNING, null, ex);
            }
        }
        return null;
    }

    private NbImageIcon iconFromURL(String urlString, boolean forceURL) {
        block15: {
            try {
                URL url = new URL(urlString);
                if (!forceURL) {
                    try {
                        File f = new File(url.toURI());
                        if (f.exists()) {
                            String fileName = f.getAbsolutePath();
                            try {
                                BufferedImage image = ImageIO.read(new File(fileName));
                                if (image != null) {
                                    return new NbImageIcon(2, fileName, new ImageIcon(image));
                                }
                                return null;
                            }
                            catch (IOException ex) {
                                Logger.getLogger(IconEditor.class.getName()).log(Level.WARNING, null, ex);
                            }
                        }
                    }
                    catch (URISyntaxException ex) {
                    }
                    catch (IllegalArgumentException ex) {
                        // empty catch block
                    }
                }
                if (url == null) break block15;
                ImageIcon icon = null;
                try {
                    try {
                        BufferedImage image = ImageIO.read(url);
                        if (image != null) {
                            icon = new ImageIcon(image);
                        }
                    }
                    catch (IllegalArgumentException iaex) {
                        Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, iaex);
                        icon = new ImageIcon(url);
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
                return new NbImageIcon(1, urlString, icon);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private NbImageIcon iconFromFileName(String fileName) {
        File file = new File(fileName);
        if (file.exists()) {
            try {
                try {
                    BufferedImage image = ImageIO.read(file);
                    if (image != null) {
                        return new NbImageIcon(2, fileName, new ImageIcon(image));
                    }
                }
                catch (IllegalArgumentException iaex) {
                    Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, iaex);
                    return new NbImageIcon(2, fileName, new ImageIcon(fileName));
                }
            }
            catch (IOException ex) {
                Logger.getLogger(IconEditor.class.getName()).log(Level.INFO, null, ex);
            }
        }
        return null;
    }

    public void readFromXML(Node element) throws IOException {
        if (!XML_IMAGE.equals(element.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap attributes = element.getAttributes();
        try {
            int type = Integer.parseInt(attributes.getNamedItem(ATTR_TYPE).getNodeValue());
            String name = attributes.getNamedItem(ATTR_NAME).getNodeValue();
            switch (type) {
                case 0: {
                    this.setValue(null);
                    break;
                }
                case 1: {
                    this.setValue(this.iconFromURL(name, false));
                    break;
                }
                case 2: {
                    this.setValue(this.iconFromFileName(name));
                    break;
                }
                case 3: {
                    NbImageIcon iconValue;
                    if (name.startsWith("/")) {
                        name = name.substring(1);
                    }
                    if ((iconValue = this.iconFromResourceName(name)) == null && name.contains("/")) {
                        iconValue = new NbImageIcon(3, name, null);
                    }
                    this.setValue(iconValue);
                }
            }
        }
        catch (NullPointerException e) {
            IOException ioe = new IOException();
            ErrorManager.getDefault().annotate((Throwable)ioe, (Throwable)e);
            throw ioe;
        }
    }

    public Node storeToXML(Document doc) {
        Element el = doc.createElement(XML_IMAGE);
        Object value = this.getValue();
        if (value instanceof NbImageIcon) {
            NbImageIcon ii = (NbImageIcon)value;
            String name = ii.getName();
            if (ii.getType() == 3 && !name.startsWith("/")) {
                name = "/" + name;
            }
            el.setAttribute(ATTR_TYPE, Integer.toString(ii.type));
            el.setAttribute(ATTR_NAME, name);
        } else {
            el.setAttribute(ATTR_TYPE, "0");
            el.setAttribute(ATTR_NAME, "null");
        }
        return el;
    }

    public static class NbImageIcon
    extends FormDesignValueAdapter {
        private int type;
        private String name;
        private Icon icon;

        public NbImageIcon(int type, String name, Icon icon) {
            this.type = type;
            if (type == 3 && name.startsWith("/")) {
                name = name.substring(1);
            }
            this.name = name;
            this.icon = icon;
        }

        public int getType() {
            return this.type;
        }

        public String getName() {
            return this.name;
        }

        public Icon getIcon() {
            return this.icon;
        }

        @Override
        public Object getDesignValue() {
            return this.icon;
        }

        @Override
        public String getDescription() {
            return this.name;
        }

        @Override
        public FormDesignValue copy(FormProperty formProperty) {
            FormModel targetModel;
            if (this.type == 3 && (targetModel = formProperty.getPropertyContext().getFormModel()) != null) {
                FileObject sourceFile = FormEditor.getFormDataObject(targetModel).getPrimaryFile();
                return IconEditor.iconFromResourceName(this.name, sourceFile);
            }
            return new NbImageIcon(this.type, this.name, this.icon);
        }
    }
}

