/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.menu;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.modules.form.HandleLayer;
import org.netbeans.modules.form.RADComponent;
import org.netbeans.modules.form.menu.MenuEditLayer;
import org.openide.util.Utilities;

class DropTargetLayer
extends JComponent {
    private MenuEditLayer canvas;
    private Point currentTargetPoint;
    private DropTargetType currentTargetType;
    private JComponent currentTargetComponent;
    private JComponent selectedComponent;
    public static final BasicStroke DROP_TARGET_LINE_STROKE = new BasicStroke(3.0f, 1, 1, 1.0f, new float[]{6.0f, 6.0f}, 0.0f);
    public static final Color DROP_TARGET_COLOR;
    private static Color SELECTION_COLOR;
    private static BasicStroke SELECTION_STROKE;

    public DropTargetLayer(MenuEditLayer canvas) {
        this.canvas = canvas;
    }

    public void setSelectedComponent(JComponent selectedComponent) {
        this.selectedComponent = selectedComponent;
        this.repaint();
    }

    public void setDropTarget(JComponent comp, Point pt, DropTargetType type) {
        this.currentTargetComponent = comp;
        this.currentTargetPoint = pt;
        this.currentTargetType = type;
        this.repaint();
    }

    public void setDropTarget(RADComponent comp, Point pt) {
        this.currentTargetComponent = (JComponent)this.canvas.formDesigner.getComponent(comp);
        this.currentTargetPoint = pt;
        this.currentTargetType = DropTargetType.NONE;
        this.repaint();
    }

    public void setDropTarget(RADComponent comp, Point pt, DropTargetType type) {
        this.currentTargetComponent = (JComponent)this.canvas.formDesigner.getComponent(comp);
        this.currentTargetPoint = pt;
        this.currentTargetType = type;
        this.repaint();
    }

    public JComponent getDropTargetComponent() {
        return this.currentTargetComponent;
    }

    public void clearDropTarget() {
        this.currentTargetComponent = null;
        this.currentTargetType = DropTargetType.NONE;
        this.currentTargetPoint = null;
        this.repaint();
    }

    public static boolean isMenuRightEdge(Point pt, JComponent menu) {
        return pt.x > menu.getWidth() - 8;
    }

    public static boolean isMenuLeftEdge(Point pt, JComponent menu) {
        return pt.x < 8;
    }

    public static boolean isSubMenuRightEdge(Point pt, JComponent menu) {
        return pt.x > menu.getWidth() - 30;
    }

    public static boolean isBelowItem(Point pt, JComponent tcomp) {
        return pt.y > tcomp.getHeight() / 2;
    }

    @Override
    protected void paintComponent(Graphics g) {
        JComponent payload;
        RADComponent comp;
        Graphics2D g2 = (Graphics2D)g.create();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.currentTargetComponent != null && (comp = this.canvas.getFormMenuBar()) != null && this.canvas.formDesigner != null) {
            g2.setColor(DROP_TARGET_COLOR);
            g2.setStroke(DROP_TARGET_LINE_STROKE);
            if (this.canvas.formDesigner.getMetaComponent(this.currentTargetComponent) == comp) {
                this.drawOpenSpotAtEndOfMenuBar(g2, this.currentTargetComponent);
            } else if (this.currentTargetComponent.getParent() instanceof JMenuBar) {
                JComponent menu = this.currentTargetComponent;
                JComponent menubar = (JComponent)this.currentTargetComponent.getParent();
                Point mblocation = SwingUtilities.convertPoint(menu, new Point(0, 0), this);
                Point cursorLocation = SwingUtilities.convertPoint(this, this.currentTargetPoint, menu);
                g2.setColor(DROP_TARGET_COLOR);
                if (this.currentTargetType != DropTargetType.INTO_SUBMENU) {
                    if (DropTargetLayer.isMenuLeftEdge(cursorLocation, menu)) {
                        DropTargetLayer.drawVerticalTargetLine(g2, mblocation.x - 1, mblocation.y, 50);
                    } else if (DropTargetLayer.isMenuRightEdge(cursorLocation, menu)) {
                        if (this.isLastChild(menu, menubar)) {
                            this.drawOpenSpotAtEndOfMenuBar(g2, menubar);
                        } else {
                            DropTargetLayer.drawVerticalTargetLine(g2, mblocation.x + menu.getWidth(), mblocation.y, 50);
                        }
                    } else {
                        g2.drawRect(mblocation.x, mblocation.y, menu.getWidth(), menu.getHeight());
                    }
                }
            }
        }
        if ((payload = this.canvas.getDragOperation().getDragComponent()) instanceof JSeparator) {
            HandleLayer handleLayer = this.canvas.formDesigner.getHandleLayer();
            if (this.canvas.getDragOperation().getDeepestComponent(this.currentTargetPoint) != null) {
                g2.translate(payload.getX(), payload.getY());
                g2.setStroke(SELECTION_STROKE);
                g2.setColor(SELECTION_COLOR);
                g2.drawRect(0, -1, payload.getWidth(), payload.getHeight());
                g2.translate(-payload.getX(), -payload.getY());
                handleLayer.suspend();
                payload.setVisible(true);
            } else {
                handleLayer.resume();
                payload.setVisible(false);
            }
        }
        for (RADComponent rad : this.canvas.getSelectedRADComponents()) {
            if (rad == null) continue;
            Object o = this.canvas.formDesigner.getComponent(rad);
            JComponent selected = o instanceof JComponent ? (JComponent)o : null;
            this.drawSelectedComponent(g2, selected, rad);
        }
        this.drawDropTarget(g2);
        g2.dispose();
    }

    private boolean isLastChild(JComponent child, JComponent parent) {
        if (parent == null) {
            return false;
        }
        if (parent.getComponentCount() < 1) {
            return false;
        }
        return child == parent.getComponent(parent.getComponentCount() - 1);
    }

    private void drawOpenSpotAtEndOfMenuBar(Graphics2D g2, JComponent mb) {
        Point mblocation = SwingUtilities.convertPoint(mb, new Point(0, 0), this);
        if (mb.getComponentCount() > 0) {
            Component lastComp = mb.getComponent(mb.getComponentCount() - 1);
            mblocation.x += lastComp.getX() + lastComp.getWidth();
        }
        g2.drawRect(mblocation.x + 2, mblocation.y + 2, mb.getHeight() - 4, mb.getHeight() - 4);
    }

    private void drawSelectedComponent(Graphics2D g2, JComponent selected, RADComponent rad) {
        if (selected == null) {
            return;
        }
        if (selected.getParent() == null || !selected.getParent().isVisible()) {
            return;
        }
        if (selected instanceof JMenu && selected.getParent() instanceof JMenuBar) {
            JMenuItem menu = (JMenuItem)selected;
            Point location = SwingUtilities.convertPoint(menu, new Point(0, 0), this);
            g2.translate(location.x, location.y);
            g2.setStroke(SELECTION_STROKE);
            g2.setColor(SELECTION_COLOR);
            g2.drawRect(0, 0, menu.getWidth() - 1, menu.getHeight() - 1);
            g2.translate(-location.x, -location.y);
        }
        if (selected instanceof JMenuItem && !(selected.getParent() instanceof JMenuBar) && this.currentTargetComponent == null) {
            JMenuItem item = (JMenuItem)selected;
            this.drawSubselectedItem(g2, item);
        }
    }

    private void drawDropTarget(Graphics2D g2) {
        if (this.currentTargetComponent != null) {
            int y;
            int x;
            Point loc;
            Point cursorLocation = SwingUtilities.convertPoint(this, this.currentTargetPoint, this.currentTargetComponent);
            if (this.currentTargetType == DropTargetType.INTER_MENU) {
                loc = SwingUtilities.convertPoint(this.currentTargetComponent, new Point(0, 0), this);
                x = loc.x;
                y = loc.y;
                if (DropTargetLayer.isBelowItem(cursorLocation, this.currentTargetComponent)) {
                    y += this.currentTargetComponent.getHeight();
                }
                g2.translate(x, y);
                DropTargetLayer.drawHorizontalTargetLine(g2, -10, 0, this.currentTargetComponent.getWidth() + 20);
                g2.translate(-x, -y);
            }
            if (this.currentTargetType == DropTargetType.INTO_SUBMENU) {
                loc = SwingUtilities.convertPoint(this.currentTargetComponent, new Point(0, 0), this);
                x = loc.x;
                y = loc.y;
                int w = this.currentTargetComponent.getWidth();
                int h = this.currentTargetComponent.getHeight();
                g2.translate(x, y);
                g2.drawRect(0, 0, w, h);
                g2.translate(-x, -y);
            }
        }
    }

    private void drawSubselectedItem(Graphics2D g2, JMenuItem item) {
        Point location = SwingUtilities.convertPoint(item, new Point(0, 0), this);
        g2.translate(location.x, location.y);
        int iconGap = item.getIconTextGap();
        int iconLeft = DropTargetLayer.getIconLeft(item);
        int iconWidth = DropTargetLayer.getIconWidth(item);
        int iconHeight = DropTargetLayer.getIconHeight(item);
        int iconTop = (item.getHeight() - iconHeight) / 2;
        int accelWidth = DropTargetLayer.getAcceleratorWidth(item);
        int textWidth = item.getWidth() - iconLeft - iconWidth - iconGap - accelWidth;
        int accelLeft = item.getWidth() - accelWidth;
        g2.setColor(Color.LIGHT_GRAY);
        g2.setStroke(SELECTION_STROKE);
        g2.setColor(SELECTION_COLOR);
        switch (this.canvas.getCurrentSelectedPortion()) {
            case Icon: {
                if (item.getIcon() == null) break;
                g2.drawRect(iconLeft - 1, iconTop - 1, iconWidth + 1, iconHeight + 1);
                break;
            }
            case Text: {
                g2.drawRect(iconLeft + iconWidth + iconGap - 1, -1, textWidth + 1, item.getHeight() + 1);
                break;
            }
            case Accelerator: {
                if (item instanceof JMenu) break;
                g2.drawRect(accelLeft - 1, -1, accelWidth + 1, item.getHeight() + 1);
                break;
            }
            case All: {
                g2.drawRect(0, 0, item.getWidth() - 1, item.getHeight() - 1);
            }
        }
        g2.translate(-location.x, -location.y);
    }

    private static void drawHorizontalTargetLine(Graphics2D g, int x, int y, int len) {
        g.setColor(DROP_TARGET_COLOR);
        g.setStroke(DROP_TARGET_LINE_STROKE);
        g.drawLine(x, y - 1, x - 1 + len, y - 1);
    }

    private static void drawVerticalTargetLine(Graphics2D g, int x, int y, int len) {
        g.setColor(DROP_TARGET_COLOR);
        g.setStroke(DROP_TARGET_LINE_STROKE);
        g.drawLine(x - 1, y, x - 1, y + len);
    }

    private static int getAcceleratorWidth(JMenuItem item) {
        if (item instanceof JMenu) {
            return 0;
        }
        if (item.getAccelerator() != null) {
            return 50;
        }
        return 80;
    }

    private static int getAcceleratorLeft(JMenuItem item) {
        return item.getWidth() - DropTargetLayer.getAcceleratorWidth(item);
    }

    public static MenuEditLayer.SelectedPortion calculateSelectedPortion(JMenuItem item, Point localPt) {
        if (localPt.x <= DropTargetLayer.getIconRight(item)) {
            return MenuEditLayer.SelectedPortion.Icon;
        }
        if (localPt.x > DropTargetLayer.getAcceleratorLeft(item)) {
            return MenuEditLayer.SelectedPortion.Accelerator;
        }
        return MenuEditLayer.SelectedPortion.Text;
    }

    private static int getIconWidth(JMenuItem item) {
        int iconWidth = item.getIcon() != null ? item.getIcon().getIconWidth() : 0;
        return iconWidth;
    }

    private static int getIconHeight(JMenuItem item) {
        int iconHeight = item.getIcon() != null ? item.getIcon().getIconHeight() : 0;
        return iconHeight;
    }

    private static int getIconLeft(JMenuItem item) {
        if (Utilities.isWindows()) {
            if (DropTargetLayer.isVista()) {
                return 1;
            }
            if (DropTargetLayer.hasRadioOrCheckSibling(item)) {
                return 20;
            }
            return 20;
        }
        if (DropTargetLayer.isAqua()) {
            if (item instanceof JRadioButtonMenuItem) {
                return 11;
            }
            return 14;
        }
        if (DropTargetLayer.isRadioOrCheck(item)) {
            return 20;
        }
        return 10;
    }

    private static boolean isRadioOrCheck(JMenuItem item) {
        if (item instanceof JRadioButtonMenuItem) {
            return true;
        }
        return item instanceof JCheckBoxMenuItem;
    }

    private static boolean hasRadioOrCheckSibling(JMenuItem item) {
        if (item.getParent() == null) {
            return false;
        }
        for (Component c : item.getParent().getComponents()) {
            if (c instanceof JRadioButtonMenuItem) {
                return true;
            }
            if (!(c instanceof JCheckBoxMenuItem)) continue;
            return true;
        }
        return false;
    }

    private static int getIconRight(JMenuItem item) {
        return DropTargetLayer.getIconLeft(item) + DropTargetLayer.getIconWidth(item);
    }

    static boolean isMetal() {
        String laf = UIManager.getLookAndFeel().getName();
        if (laf == null) {
            return false;
        }
        return laf.startsWith("Metal");
    }

    static boolean isVista() {
        return System.getProperty("os.name").startsWith("Windows Vista");
    }

    static boolean isAqua() {
        String laf = UIManager.getLookAndFeel().getName();
        if (laf == null) {
            return false;
        }
        return laf.startsWith("Mac OS X");
    }

    public static boolean isMultiselectPressed(MouseEvent evt) {
        if (evt.isShiftDown()) {
            return true;
        }
        return !DropTargetLayer.isAqua() && evt.isControlDown();
    }

    static {
        SELECTION_COLOR = DROP_TARGET_COLOR = new Color(16753664);
        SELECTION_STROKE = new BasicStroke(1.0f);
    }

    public static enum DropTargetType {
        INTER_MENU,
        NONE,
        INTO_SUBMENU;

    }
}

