/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.screen.display;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.microedition.m2g.SVGImage;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.netbeans.modules.mobility.svgcore.util.Util;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfo;
import org.netbeans.modules.vmd.api.screen.display.ScreenDisplayPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenPropertyDescriptor;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGComponentCD;
import org.netbeans.modules.vmd.midpnb.components.svg.form.SVGFormSupport;
import org.netbeans.modules.vmd.midpnb.screen.display.SVGPlayerDisplayPresenter;
import org.openide.filesystems.FileObject;

public class SVGComponentDisplayPresenter
extends ScreenDisplayPresenter {
    private Rectangle myBoundsRect = null;
    private JPanel myView = null;

    public boolean isTopLevelDisplay() {
        return false;
    }

    public Collection<DesignComponent> getChildren() {
        return Collections.emptyList();
    }

    public JComponent getView() {
        if (this.myView == null) {
            this.myView = new JPanel();
            this.myView.setPreferredSize(new Dimension(0, 0));
        }
        return this.myView;
    }

    public void reload(ScreenDeviceInfo deviceInfo) {
        this.myBoundsRect = null;
        this.myView = null;
    }

    public Point getLocation() {
        Rectangle rect = this.getRectangle();
        return rect == null ? super.getLocation() : rect.getLocation();
    }

    public Shape getSelectionShape() {
        Rectangle rect = this.getRectangle();
        if (rect != null) {
            return new Rectangle((int)rect.getWidth(), (int)rect.getHeight());
        }
        return null;
    }

    public Collection<ScreenPropertyDescriptor> getPropertyDescriptors() {
        return Collections.emptyList();
    }

    protected DesignComponent getSvgComponent() {
        DesignComponent svgComponent = null;
        DescriptorRegistry registry = this.getComponent().getDocument().getDescriptorRegistry();
        if (registry.isInHierarchy(SVGComponentCD.TYPEID, this.getComponent().getType())) {
            return this.getComponent();
        }
        if (this.getComponent().getComponentDescriptor().getPropertyDescriptor("svgButton") == null) {
            return null;
        }
        PropertyValue value = this.getComponent().readProperty("svgButton");
        if (value != null && value.getComponent() != null) {
            svgComponent = value.getComponent();
        }
        return svgComponent;
    }

    protected String getSvgComponentId() {
        DesignComponent svgComponent = this.getSvgComponent();
        if (svgComponent == null) {
            return null;
        }
        return (String)svgComponent.readProperty("id").getPrimitiveValue();
    }

    protected SVGImage getSvgImage() {
        SVGImage svgImage = null;
        DesignComponent svgForm = this.getComponent().getParentComponent();
        if (svgForm == null) {
            return null;
        }
        SVGPlayerDisplayPresenter presenter = (SVGPlayerDisplayPresenter)svgForm.getPresenter(SVGPlayerDisplayPresenter.class);
        if (presenter != null) {
            svgImage = presenter.getSVGImage();
        }
        if (svgImage == null) {
            DesignComponent svgImageComponent = svgForm.readProperty("svgImage").getComponent();
            if (svgImageComponent == null) {
                return null;
            }
            FileObject file = SVGFormSupport.getSVGFile(svgImageComponent);
            if (file == null) {
                return null;
            }
            try {
                svgImage = Util.createSVGImage((FileObject)file, (boolean)true);
            }
            catch (IOException ex) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, null, ex);
            }
        }
        return svgImage;
    }

    private Rectangle doCalculateRectangle() {
        String id;
        float scaleX = 1.0f;
        float scaleY = 1.0f;
        int correctionX = 0;
        int correctionY = 0;
        DesignComponent svgForm = this.getComponent().getParentComponent();
        if (svgForm == null) {
            return null;
        }
        SVGPlayerDisplayPresenter presenter = (SVGPlayerDisplayPresenter)svgForm.getPresenter(SVGPlayerDisplayPresenter.class);
        if (presenter != null) {
            scaleX = presenter.getScaleX();
            scaleY = presenter.getScaleY();
            correctionX = presenter.getCorrectionX();
            correctionY = presenter.getCorrectionY();
        }
        if ((id = this.getSvgComponentId()) == null) {
            return null;
        }
        SVGImage svgImage = this.getSvgImage();
        if (svgImage == null) {
            return null;
        }
        Rectangle rect = Util.getElementRectangle((SVGImage)svgImage, (String)id);
        if (rect != null) {
            return new Rectangle((int)Math.round(rect.getX() * (double)scaleX) + correctionX, (int)Math.round(rect.getY() * (double)scaleY) + correctionY, (int)Math.round(rect.getWidth() * (double)scaleX) + 1, (int)Math.round(rect.getHeight() * (double)scaleY) + 1);
        }
        return null;
    }

    private Rectangle getRectangle() {
        if (this.myBoundsRect == null) {
            this.myBoundsRect = this.doCalculateRectangle();
        }
        return this.myBoundsRect;
    }
}

