/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.model;

import java.util.StringTokenizer;

public class TextDecorationData {
    private boolean noDecorationEnabled = false;
    private boolean underlineEnabled = false;
    private boolean overlineEnabled = false;
    private boolean lineThroughEnabled = false;
    private boolean blinkEnabled = false;

    public void setDecoration(String decorationStr) {
        StringTokenizer st = new StringTokenizer(decorationStr);
        this.enableUnderline(false);
        this.enableOverline(false);
        this.enableLineThrough(false);
        this.enableBlink(false);
        this.enableNoDecoration(false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.trim().equals("underline")) {
                this.enableUnderline(true);
            }
            if (token.trim().equals("overline")) {
                this.enableOverline(true);
            }
            if (token.trim().equals("line-through")) {
                this.enableLineThrough(true);
            }
            if (token.trim().equals("blink")) {
                this.enableBlink(true);
            }
            if (!token.trim().equals("none")) continue;
            this.enableNoDecoration(true);
        }
    }

    public boolean enableUnderline(boolean underlineEnabled) {
        boolean change = this.underlineEnabled() != underlineEnabled && !this.noDecorationEnabled();
        this.underlineEnabled = underlineEnabled;
        return change;
    }

    public boolean underlineEnabled() {
        return this.underlineEnabled;
    }

    public boolean enableOverline(boolean overlineEnabled) {
        boolean change = this.overlineEnabled() != overlineEnabled && !this.noDecorationEnabled();
        this.overlineEnabled = overlineEnabled;
        return change;
    }

    public boolean overlineEnabled() {
        return this.overlineEnabled;
    }

    public boolean enableLineThrough(boolean lineThroughEnabled) {
        boolean change = this.lineThroughEnabled() != lineThroughEnabled && !this.noDecorationEnabled();
        this.lineThroughEnabled = lineThroughEnabled;
        return change;
    }

    public boolean lineThroughEnabled() {
        return this.lineThroughEnabled;
    }

    public boolean enableBlink(boolean blinkEnabled) {
        boolean change = this.blinkEnabled() != blinkEnabled && !this.noDecorationEnabled();
        this.blinkEnabled = blinkEnabled;
        return change;
    }

    public boolean blinkEnabled() {
        return this.blinkEnabled;
    }

    public void enableNoDecoration(boolean noDecorationEnabled) {
        this.noDecorationEnabled = noDecorationEnabled;
        if (noDecorationEnabled) {
            this.enableUnderline(false);
            this.enableOverline(false);
            this.enableLineThrough(false);
            this.enableBlink(false);
        }
    }

    public boolean noDecorationEnabled() {
        return this.noDecorationEnabled;
    }

    public String toString() {
        String textDecoration = "";
        if (this.noDecorationEnabled) {
            return "none";
        }
        if (this.underlineEnabled) {
            textDecoration = textDecoration + " underline";
        }
        if (this.overlineEnabled) {
            textDecoration = textDecoration + " overline";
        }
        if (this.lineThroughEnabled) {
            textDecoration = textDecoration + " line-through";
        }
        if (this.blinkEnabled) {
            textDecoration = textDecoration + " blink";
        }
        return textDecoration;
    }
}

