/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.editor.ext.html.parser.spi.AstNodeVisitor;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsfapi.spi.LibraryUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class CompositeComponentModel
extends JsfPageModel {
    static final String LIBRARY_NAME_KEY = "library";
    static final String INTERFACE_ATTRIBUTES_KEY = "interface_attributes";
    static final String HAS_IMPLEMENTATION_KEY = "has_implementation";
    private static final String RESOURCES_FOLDER_NAME = "resources";
    private static final char VALUES_SEPARATOR = ',';
    private static final char ATTRIBUTES_SEPARATOR = ';';
    private static final char KEY_VALUE_SEPARATOR = '=';
    private static final Collection<String> COMPOSITE_ATTRIBUTE_TAG_ATTRIBUTES = Arrays.asList("name", "targets", "default", "displayName", "expert", "method-signature", "preferred", "required", "shortDescription", "type");
    protected Collection<Map<String, String>> attributes;
    protected boolean hasImplementation;
    protected FileObject sourceFile;
    protected String relativePath;

    public CompositeComponentModel(FileObject file, Collection<Map<String, String>> attributes, boolean hasImplementation) {
        this(file, null, attributes, hasImplementation);
    }

    public CompositeComponentModel(FileObject file, String relativePath, Collection<Map<String, String>> attributes, boolean hasImplementation) {
        this.attributes = attributes;
        this.hasImplementation = hasImplementation;
        this.sourceFile = file;
        this.relativePath = relativePath;
    }

    public String getComponentName() {
        return this.sourceFile.getName();
    }

    public FileObject getSourceFile() {
        return this.sourceFile;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public boolean isHasImplementation() {
        return this.hasImplementation;
    }

    public Collection<Map<String, String>> getExistingInterfaceAttributes() {
        return this.attributes;
    }

    public Collection<String> getPossibleAttributeTagAttributes() {
        return COMPOSITE_ATTRIBUTE_TAG_ATTRIBUTES;
    }

    @Override
    public String storeToIndex(IndexDocument document) {
        String libraryName = this.getLibraryPath();
        document.addPair(LIBRARY_NAME_KEY, libraryName, true, true);
        StringBuilder buf = new StringBuilder();
        Iterator<Map<String, String>> itr = this.attributes.iterator();
        while (itr.hasNext()) {
            Map<String, String> attrs = itr.next();
            Iterator<String> attrsKeysItr = attrs.keySet().iterator();
            while (attrsKeysItr.hasNext()) {
                String key = attrsKeysItr.next();
                String value = attrs.get(key);
                buf.append(key);
                buf.append('=');
                buf.append(CompositeComponentModel.encode(value));
                if (!attrsKeysItr.hasNext()) continue;
                buf.append(',');
            }
            if (!itr.hasNext()) continue;
            buf.append(';');
        }
        document.addPair(INTERFACE_ATTRIBUTES_KEY, buf.toString(), false, true);
        document.addPair(HAS_IMPLEMENTATION_KEY, Boolean.toString(this.hasImplementation), false, true);
        return LibraryUtils.getCompositeLibraryURL((String)libraryName);
    }

    private String getLibraryPath() {
        FileObject sourceFileFolder = this.sourceFile.getParent();
        FileObject resources = CompositeComponentModel.getResourcesDirectory(this.sourceFile);
        assert (resources != null);
        assert (!sourceFileFolder.equals(resources));
        return FileUtil.getRelativePath((FileObject)resources, (FileObject)sourceFileFolder);
    }

    private static boolean isCompositeLibraryMember(FileObject file) {
        FileObject resourcesFolder = CompositeComponentModel.getResourcesDirectory(file);
        return resourcesFolder != null && FileUtil.isParentOf((FileObject)resourcesFolder, (FileObject)file) && !file.getParent().equals(resourcesFolder);
    }

    private static FileObject getResourcesDirectory(FileObject file) {
        FileObject resourcesFolder;
        FileObject docRoot;
        WebModule wm = WebModule.getWebModule((FileObject)file);
        if (wm != null && (docRoot = wm.getDocumentBase()) != null && (resourcesFolder = CompositeComponentModel.getChild(docRoot, RESOURCES_FOLDER_NAME)) != null && FileUtil.isParentOf((FileObject)resourcesFolder, (FileObject)file)) {
            return resourcesFolder;
        }
        FileObject folder = file;
        do {
            FileObject parent;
            if (!folder.getName().equalsIgnoreCase(RESOURCES_FOLDER_NAME) || (parent = folder.getParent()) == null || !parent.getNameExt().startsWith("META-INF")) continue;
            return folder;
        } while ((folder = folder.getParent()) != null);
        return null;
    }

    private static FileObject getChild(FileObject parent, String name) {
        for (FileObject child : parent.getChildren()) {
            if (!child.getName().equals(name)) continue;
            return child;
        }
        return null;
    }

    static String encode(String attributeValue) {
        StringBuilder out = new StringBuilder();
        block5: for (int i = 0; i < attributeValue.length(); ++i) {
            char c = attributeValue.charAt(i);
            switch (c) {
                case ',': {
                    out.append("\\c");
                    continue block5;
                }
                case '=': {
                    out.append("\\e");
                    continue block5;
                }
                case '\\': {
                    out.append("\\s");
                    continue block5;
                }
                default: {
                    out.append(c);
                }
            }
        }
        return out.toString();
    }

    static String decode(String attributeValue) {
        StringBuilder out = new StringBuilder();
        boolean encodeChar = false;
        for (int i = 0; i < attributeValue.length(); ++i) {
            char c = attributeValue.charAt(i);
            if (encodeChar) {
                switch (c) {
                    case 'c': {
                        out.append(',');
                        break;
                    }
                    case 'e': {
                        out.append('=');
                        break;
                    }
                    case 's': {
                        out.append('\\');
                        break;
                    }
                    default: {
                        assert (false);
                        break;
                    }
                }
                encodeChar = false;
                continue;
            }
            if (c == '\\') {
                encodeChar = true;
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static class Factory
    extends JsfPageModelFactory {
        private static final String COMPOSITE_ATTRIBUTE_TAG_NAME = "attribute";
        private static final String INTERFACE_TAG_NAME = "interface";
        private static final String IMPLEMENTATION_TAG_NAME = "implementation";

        @Override
        public JsfPageModel getModel(HtmlParserResult result) {
            AstNode node = result.root("http://java.sun.com/jsf/composite");
            if (node == null) {
                return null;
            }
            FileObject file = result.getSnapshot().getSource().getFileObject();
            if (!CompositeComponentModel.isCompositeLibraryMember(file)) {
                return null;
            }
            final ArrayList<Map<String, String>> interfaceAttrs = new ArrayList<Map<String, String>>();
            final boolean[] hasInterface = new boolean[1];
            final boolean[] hasImplementation = new boolean[1];
            AstNodeUtils.visitChildren((AstNode)node, (AstNodeVisitor)new AstNodeVisitor(){

                public void visit(AstNode node) {
                    if (node.getNameWithoutPrefix().equals(Factory.INTERFACE_TAG_NAME)) {
                        hasInterface[0] = true;
                        for (AstNode child : node.children()) {
                            if (!child.getNameWithoutPrefix().equals(Factory.COMPOSITE_ATTRIBUTE_TAG_NAME)) continue;
                            HashMap<String, String> attrs = new HashMap<String, String>();
                            for (String attrKey : child.getAttributeKeys()) {
                                attrs.put(attrKey, child.getAttribute(attrKey).unquotedValue());
                            }
                            interfaceAttrs.add(attrs);
                        }
                    } else if (node.getNameWithoutPrefix().equals(Factory.IMPLEMENTATION_TAG_NAME)) {
                        hasImplementation[0] = true;
                    }
                }
            });
            return new CompositeComponentModel(file, interfaceAttrs, hasImplementation[0]);
        }

        @Override
        public JsfPageModel loadFromIndex(IndexResult result) {
            String attrs = result.getValue(CompositeComponentModel.INTERFACE_ATTRIBUTES_KEY);
            boolean hasImplementation = Boolean.parseBoolean(result.getValue(CompositeComponentModel.HAS_IMPLEMENTATION_KEY));
            ArrayList<Map<String, String>> parsedAttrs = new ArrayList<Map<String, String>>();
            StringTokenizer st = new StringTokenizer(attrs, Character.valueOf(';').toString());
            while (st.hasMoreTokens()) {
                String attrText = st.nextToken();
                HashMap<String, String> pairs = new HashMap<String, String>();
                StringTokenizer st2 = new StringTokenizer(attrText, Character.valueOf(',').toString());
                while (st2.hasMoreTokens()) {
                    String pair = st2.nextToken();
                    String key = pair.substring(0, pair.indexOf(61));
                    String value = CompositeComponentModel.decode(pair.substring(pair.indexOf(61) + 1));
                    pairs.put(key, value);
                }
                parsedAttrs.add(pairs);
            }
            return new CompositeComponentModel(result.getFile(), result.getRelativePath(), parsedAttrs, hasImplementation);
        }
    }
}

