/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.Configuration;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectImpl;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.AnalyzeFolder;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.BaseDwarfProvider;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.NbBundle;

public class AnalyzeExecutable
extends BaseDwarfProvider {
    private Map<String, ProviderProperty> myProperties = new LinkedHashMap<String, ProviderProperty>();
    public static final String EXECUTABLE_KEY = "executable";
    public static final String LIBRARIES_KEY = "libraries";

    public AnalyzeExecutable() {
        this.clean();
    }

    public final void clean() {
        this.myProperties.clear();
        this.myProperties.put(EXECUTABLE_KEY, new ProviderProperty(){
            private String myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Executable_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Executable_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFile;
            }
        });
        this.myProperties.put(LIBRARIES_KEY, new ProviderProperty(){
            private String[] myPath;

            public String getName() {
                return AnalyzeExecutable.i18n("Libraries_Files_Name");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("Libraries_Files_Description");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String[]) {
                    this.myPath = (String[])object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.BinaryFiles;
            }
        });
        this.myProperties.put("restrict_source_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecutable.i18n("RESTRICT_SOURCE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("RESTRICT_SOURCE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
        this.myProperties.put("restrict_compile_root", new ProviderProperty(){
            private String myPath = "";

            public String getName() {
                return AnalyzeExecutable.i18n("RESTRICT_COMPILE_ROOT");
            }

            public String getDescription() {
                return AnalyzeExecutable.i18n("RESTRICT_COMPILE_ROOT");
            }

            public Object getValue() {
                return this.myPath;
            }

            public void setValue(Object object) {
                if (object instanceof String) {
                    this.myPath = (String)object;
                }
            }

            public ProviderProperty.PropertyKind getKind() {
                return ProviderProperty.PropertyKind.String;
            }
        });
    }

    public String getID() {
        return "dwarf-executable";
    }

    public String getName() {
        return AnalyzeExecutable.i18n("Executable_Provider_Name");
    }

    public String getDescription() {
        return AnalyzeExecutable.i18n("Executable_Provider_Description");
    }

    public List<String> getPropertyKeys() {
        return new ArrayList<String>(this.myProperties.keySet());
    }

    public ProviderProperty getProperty(String string) {
        return this.myProperties.get(string);
    }

    public DiscoveryExtensionInterface.Applicable canAnalyze(ProjectProxy projectProxy) {
        String string = (String)this.getProperty(EXECUTABLE_KEY).getValue();
        if (string == null || string.length() == 0) {
            return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"NoExecutable")));
        }
        HashSet<String> hashSet = new HashSet<String>();
        ApplicableImpl applicableImpl = this.sizeComilationUnit(string, hashSet);
        if (applicableImpl.isApplicable()) {
            return new ApplicableImpl(true, applicableImpl.getErrors(), applicableImpl.getCompilerName(), 70, applicableImpl.isSunStudio(), applicableImpl.getDependencies(), applicableImpl.getSearchPaths(), applicableImpl.getSourceRoot(), applicableImpl.getMainFunction());
        }
        if (applicableImpl.getErrors().size() > 0) {
            return ApplicableImpl.getNotApplicable((List)applicableImpl.getErrors());
        }
        return ApplicableImpl.getNotApplicable(Collections.singletonList(NbBundle.getMessage(AnalyzeExecutable.class, (String)"CannotAnalyzeExecutable", (Object)string)));
    }

    public List<Configuration> analyze(ProjectProxy projectProxy, Progress progress) {
        this.isStoped.set(false);
        ArrayList<Configuration> arrayList = new ArrayList<Configuration>();
        this.setCommpilerSettings(projectProxy);
        if (!this.isStoped.get()) {
            Configuration configuration = new Configuration(){
                private List<SourceFileProperties> myFileProperties;
                private List<String> myIncludedFiles;
                private Set<String> myDependencies;

                public List<ProjectProperties> getProjectConfiguration() {
                    return ProjectImpl.divideByLanguage(this.getSourcesConfiguration());
                }

                public List<String> getDependencies() {
                    if (this.myDependencies == null) {
                        this.getSourcesConfiguration();
                    }
                    return new ArrayList<String>(this.myDependencies);
                }

                public List<SourceFileProperties> getSourcesConfiguration() {
                    if (this.myFileProperties == null) {
                        this.myDependencies = new HashSet<String>();
                        String string = (String)AnalyzeExecutable.this.getProperty(AnalyzeExecutable.EXECUTABLE_KEY).getValue();
                        if (string != null && string.length() > 0) {
                            String[] stringArray = (String[])AnalyzeExecutable.this.getProperty(AnalyzeExecutable.LIBRARIES_KEY).getValue();
                            if (stringArray == null || stringArray.length == 0) {
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(new String[]{string}, null, null, this.myDependencies);
                            } else {
                                String[] stringArray2 = new String[stringArray.length + 1];
                                stringArray2[0] = string;
                                System.arraycopy(stringArray, 0, stringArray2, 1, stringArray.length);
                                this.myFileProperties = AnalyzeExecutable.this.getSourceFileProperties(stringArray2, null, null, this.myDependencies);
                            }
                        }
                    }
                    return this.myFileProperties;
                }

                public List<String> getIncludedFiles() {
                    if (this.myIncludedFiles == null) {
                        HashSet<String> hashSet = new HashSet<String>();
                        for (SourceFileProperties object : this.getSourcesConfiguration()) {
                            if (AnalyzeExecutable.this.isStoped.get()) break;
                            if (!(object instanceof DwarfSource)) continue;
                            hashSet.addAll(((DwarfSource)object).getIncludedFiles());
                            hashSet.add(object.getItemPath());
                        }
                        HashSet hashSet2 = new HashSet();
                        for (String string : hashSet) {
                            if (AnalyzeExecutable.this.isStoped.get()) break;
                            File file = new File(string);
                            if (!CndFileUtils.exists((File)file)) continue;
                            hashSet2.add(CndFileUtils.normalizeFile((File)file).getAbsolutePath());
                        }
                        this.myIncludedFiles = new ArrayList<String>(hashSet2);
                    }
                    return this.myIncludedFiles;
                }
            };
            arrayList.add(configuration);
        }
        return arrayList;
    }

    private static String i18n(String string) {
        return NbBundle.getMessage(AnalyzeFolder.class, (String)string);
    }
}

