/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.discovery.api.ApplicableImpl;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.api.DiscoveryUtils;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.Progress;
import org.netbeans.modules.cnd.discovery.api.ProjectProxy;
import org.netbeans.modules.cnd.discovery.api.ProviderProperty;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.PathCache;
import org.netbeans.modules.cnd.dwarfdump.CompilationUnit;
import org.netbeans.modules.cnd.dwarfdump.Dwarf;
import org.netbeans.modules.cnd.dwarfdump.dwarf.DwarfEntry;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.LANG;
import org.netbeans.modules.cnd.dwarfdump.dwarfconsts.TAG;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public abstract class BaseDwarfProvider
implements DiscoveryProvider {
    private static final boolean TRACE_READ_EXCEPTIONS = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.errors");
    private static final boolean FULL_TRACE = Boolean.getBoolean("cnd.dwarfdiscovery.trace.read.source");
    public static final String RESTRICT_SOURCE_ROOT = "restrict_source_root";
    public static final String RESTRICT_COMPILE_ROOT = "restrict_compile_root";
    protected AtomicBoolean isStoped = new AtomicBoolean(false);
    private Map<String, GrepEntry> grepBase = new ConcurrentHashMap<String, GrepEntry>();
    private CompilerSettings myCommpilerSettings;

    public boolean isApplicable(ProjectProxy projectProxy) {
        return true;
    }

    public void stop() {
        this.isStoped.set(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String[] stringArray, Progress progress, ProjectProxy projectProxy, Set<String> set) {
        CountDownLatch countDownLatch = new CountDownLatch(stringArray.length);
        RequestProcessor requestProcessor = new RequestProcessor("Parallel analyzing", CndUtils.getNumberCndWorkerThreads());
        try {
            ConcurrentHashMap concurrentHashMap = new ConcurrentHashMap();
            for (String string : stringArray) {
                MyRunnable myRunnable = new MyRunnable(countDownLatch, string, concurrentHashMap, progress, projectProxy, set);
                requestProcessor.post((Runnable)myRunnable);
            }
            try {
                countDownLatch.await();
            }
            catch (InterruptedException interruptedException) {
                Exceptions.printStackTrace((Throwable)interruptedException);
            }
            ArrayList arrayList = new ArrayList();
            arrayList.addAll(concurrentHashMap.values());
            ArrayList arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            PathCache.dispose();
            this.grepBase.clear();
            this.grepBase = new ConcurrentHashMap<String, GrepEntry>();
            this.getCommpilerSettings().dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processObjectFile(String string, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy projectProxy, Set<String> set) {
        Object object;
        String string2;
        if (this.isStoped.get()) {
            return true;
        }
        String string3 = null;
        ProviderProperty providerProperty = this.getProperty(RESTRICT_SOURCE_ROOT);
        if (providerProperty != null && (string2 = (String)providerProperty.getValue()).length() > 0) {
            string3 = CndFileUtils.normalizeFile((File)new File(string2)).getAbsolutePath();
        }
        string2 = null;
        providerProperty = this.getProperty(RESTRICT_COMPILE_ROOT);
        if (providerProperty != null && ((String)(object = (String)providerProperty.getValue())).length() > 0) {
            string2 = CndFileUtils.normalizeFile((File)new File((String)object)).getAbsolutePath();
        }
        for (SourceFileProperties sourceFileProperties : this.getSourceFileProperties(string, map, projectProxy, set)) {
            String string4;
            if (this.isStoped.get()) break;
            String string5 = sourceFileProperties.getItemPath();
            if (string5 == null || string3 != null && !string5.startsWith(string3) || string2 != null && sourceFileProperties.getCompilePath() != null && !sourceFileProperties.getCompilePath().startsWith(string2)) continue;
            boolean bl = false;
            if (!new File(string5).exists()) {
                string4 = Dwarf.fileFinder((String)string, (String)string5);
                if (string4 != null && new File(string4).exists() && sourceFileProperties instanceof DwarfSource) {
                    ((DwarfSource)sourceFileProperties).resetItemPath(string4);
                    string5 = string4;
                    bl = true;
                }
            } else {
                bl = true;
            }
            if (bl) {
                string4 = map.get(string5);
                if (string4 == null) {
                    map.put(string5, sourceFileProperties);
                    continue;
                }
                if (string4.getUserInludePaths().size() >= sourceFileProperties.getUserInludePaths().size()) continue;
                map.put(string5, sourceFileProperties);
                continue;
            }
            if (!FULL_TRACE) continue;
            System.out.println("Not Exist " + string5);
        }
        if (progress != null) {
            object = progress;
            synchronized (object) {
                progress.increment(string);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected ApplicableImpl sizeComilationUnit(String string, Set<String> set) {
        void var15_32;
        String string22;
        ArrayList<String> arrayList;
        Object object2;
        HashMap<String, Object> hashMap;
        int n;
        TreeMap<String, AtomicInteger> treeMap;
        ArrayList arrayList2;
        ArrayList<String> arrayList3;
        MyPosition myPosition;
        int n2;
        int n3;
        block38: {
            n3 = 0;
            n2 = 0;
            Dwarf dwarf = null;
            myPosition = null;
            arrayList3 = new ArrayList<String>();
            arrayList2 = new ArrayList();
            treeMap = new TreeMap<String, AtomicInteger>();
            n = 0;
            hashMap = new HashMap<String, Object>();
            try {
                dwarf = new Dwarf(string);
                Iterator iterator = dwarf.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    String string3;
                    Object object;
                    Object object3;
                    void var15_24;
                    object2 = (CompilationUnit)iterator.next();
                    if (object2 == null || object2.getRoot() == null || object2.getSourceFileName() == null || (arrayList = object2.getSourceLanguage()) == null) continue;
                    ++n;
                    String string5 = object2.getSourceFileAbsolutePath();
                    string5 = DiscoveryUtils.normalizeAbsolutePath((String)string5);
                    if (!CndFileUtils.isExistingFile((String)string5)) {
                        string22 = Dwarf.fileFinder((String)string, (String)string5);
                        if (string22 == null || !CndFileUtils.isExistingFile((String)(string22 = DiscoveryUtils.normalizeAbsolutePath((String)string22)))) continue;
                        String string6 = string22;
                    }
                    string22 = null;
                    if (LANG.DW_LANG_C.toString().equals(arrayList) || LANG.DW_LANG_C89.toString().equals(arrayList) || LANG.DW_LANG_C99.toString().equals(arrayList)) {
                        string22 = ItemProperties.LanguageKind.C;
                        ++n3;
                    } else if (LANG.DW_LANG_C_plus_plus.toString().equals(arrayList)) {
                        string22 = ItemProperties.LanguageKind.CPP;
                        ++n3;
                    } else {
                        if (!LANG.DW_LANG_Fortran77.toString().equals(arrayList) && !LANG.DW_LANG_Fortran90.toString().equals(arrayList) && !LANG.DW_LANG_Fortran95.toString().equals(arrayList)) continue;
                        string22 = ItemProperties.LanguageKind.Fortran;
                        ++n3;
                    }
                    String string7 = var15_24.replace('\\', '/');
                    int n4 = string7.lastIndexOf(47);
                    if (n4 >= 0) {
                        object3 = string7.substring(0, n4);
                        object = treeMap.get(object3);
                        if (object == null) {
                            object = new AtomicInteger();
                            treeMap.put((String)object3, (AtomicInteger)object);
                        }
                        ((AtomicInteger)object).incrementAndGet();
                    }
                    if ((string3 = DwarfSource.extractCompilerName(object2, (ItemProperties.LanguageKind)string22)) != null) {
                        object3 = (AtomicInteger)hashMap.get(string3);
                        if (object3 == null) {
                            object3 = new AtomicInteger();
                            hashMap.put(string3, object3);
                        }
                        ((AtomicInteger)object3).incrementAndGet();
                    }
                    if (DwarfSource.isSunStudioCompiler(object2)) {
                        ++n2;
                    }
                    if (myPosition != null) continue;
                    object3 = object2.getTopLevelEntries();
                    object = object3.iterator();
                    while (object.hasNext()) {
                        DwarfEntry dwarfEntry = (DwarfEntry)object.next();
                        if (dwarfEntry.getKind() != TAG.DW_TAG_subprogram || !"main".equals(dwarfEntry.getName()) || !dwarfEntry.isExternal()) continue;
                        myPosition = new MyPosition(string7, dwarfEntry.getLine());
                    }
                }
                if (set == null) break block38;
                object2 = dwarf.readPubNames();
                arrayList = set;
                synchronized (arrayList) {
                    for (String string22 : object2.getDlls()) {
                        set.add(string22);
                    }
                    arrayList2.addAll(object2.getPaths());
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                arrayList3.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"FileNotFoundException", (Object)string));
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("File not found " + string + ": " + fileNotFoundException.getMessage());
                }
            }
            catch (WrongFileFormatException wrongFileFormatException) {
                arrayList3.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"WrongFileFormatException", (Object)string));
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("Unsuported format of file " + string + ": " + wrongFileFormatException.getMessage());
                }
            }
            catch (IOException iOException) {
                arrayList3.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"IOException", (Object)string, (Object)iOException.toString()));
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + string + ": " + iOException.getMessage());
                    iOException.printStackTrace(System.err);
                }
            }
            catch (Exception exception) {
                arrayList3.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"Exception", (Object)string, (Object)exception.toString()));
                System.err.println("Exception in file " + string + ": " + exception.getMessage());
                exception.printStackTrace(System.err);
            }
            finally {
                if (dwarf != null) {
                    dwarf.dispose();
                }
            }
        }
        int n5 = 0;
        object2 = "";
        for (Map.Entry entry : hashMap.entrySet()) {
            if (((AtomicInteger)entry.getValue()).get() <= n5) continue;
            n5 = ((AtomicInteger)entry.getValue()).get();
            object2 = (String)entry.getKey();
        }
        arrayList = null;
        if (set != null) {
            arrayList = new ArrayList<String>(set);
        }
        Object var15_30 = null;
        if (set != null) {
            ArrayList arrayList4 = new ArrayList(arrayList2);
        }
        string22 = this.getRoot(treeMap);
        if (n3 > 0) {
            return new ApplicableImpl(true, arrayList3, (String)object2, n3, n2 > n3 / 2, arrayList, (List)var15_32, string22, myPosition);
        }
        if (arrayList3.isEmpty()) {
            if (n > 0) {
                arrayList3.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"BadDebugInformation", (Object)string));
            } else {
                arrayList3.add(NbBundle.getMessage(BaseDwarfProvider.class, (String)"NotFoundDebugInformation", (Object)string));
            }
        }
        return new ApplicableImpl(false, arrayList3, (String)object2, n3, n2 > n3 / 2, arrayList, (List)var15_32, string22, myPosition);
    }

    private String getCommonPart(String string, String string2) {
        String[] stringArray = string.split("/");
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].isEmpty()) {
                arrayList.add(stringArray[i]);
                continue;
            }
            if (i != 0) continue;
            bl = true;
        }
        String[] stringArray2 = string2.split("/");
        ArrayList<String> arrayList2 = new ArrayList<String>();
        boolean bl2 = false;
        for (int i = 0; i < stringArray2.length; ++i) {
            if (!stringArray2[i].isEmpty()) {
                arrayList2.add(stringArray2[i]);
                continue;
            }
            if (i != 0) continue;
            bl2 = true;
        }
        if (bl != bl2) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (bl) {
            stringBuilder.append('/');
        }
        for (int i = 0; i < Math.min(arrayList.size(), arrayList2.size()) && ((String)arrayList.get(i)).equals(arrayList2.get(i)); ++i) {
            if (i > 0) {
                stringBuilder.append('/');
            }
            stringBuilder.append((String)arrayList.get(i));
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String getRoot(TreeMap<String, AtomicInteger> treeMap) {
        void var7_9;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<AtomicInteger> arrayList2 = new ArrayList<AtomicInteger>();
        String string = null;
        AtomicInteger atomicInteger = null;
        for (Map.Entry<String, AtomicInteger> object2 : treeMap.entrySet()) {
            int n;
            if (string == null) {
                string = object2.getKey();
                atomicInteger = new AtomicInteger(object2.getValue().get());
                continue;
            }
            String string2 = this.getCommonPart(object2.getKey(), string);
            String[] stringArray = string2.split("/");
            int n2 = n = stringArray.length > 0 && stringArray[0].isEmpty() ? stringArray.length - 1 : stringArray.length;
            if (n >= 2) {
                string = string2;
                atomicInteger.addAndGet(object2.getValue().get());
                continue;
            }
            arrayList.add(string);
            arrayList2.add(atomicInteger);
            string = object2.getKey();
            atomicInteger = new AtomicInteger(object2.getValue().get());
        }
        if (string != null) {
            arrayList.add(string);
            arrayList2.add(atomicInteger);
        }
        TreeMap treeMap2 = new TreeMap();
        Object var7_8 = null;
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            treeMap2.put(arrayList.get(i), arrayList2.get(i));
            if (var7_9 == null) {
                String string3 = (String)arrayList.get(i);
                n = ((AtomicInteger)arrayList2.get(i)).get();
                continue;
            }
            if (n >= ((AtomicInteger)arrayList2.get(i)).get()) continue;
            String string4 = (String)arrayList.get(i);
            n = ((AtomicInteger)arrayList2.get(i)).get();
        }
        return var7_9;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SourceFileProperties> getSourceFileProperties(String string, Map<String, SourceFileProperties> map, ProjectProxy projectProxy, Set<String> set) {
        ArrayList<SourceFileProperties> arrayList;
        block41: {
            arrayList = new ArrayList<SourceFileProperties>();
            Dwarf dwarf = null;
            try {
                Object object;
                CompilationUnit compilationUnit;
                if (FULL_TRACE) {
                    System.out.println("Process file " + string);
                }
                dwarf = new Dwarf(string);
                Iterator iterator = dwarf.iteratorCompilationUnits();
                while (iterator.hasNext()) {
                    compilationUnit = (CompilationUnit)iterator.next();
                    if (compilationUnit == null) continue;
                    if (this.isStoped.get()) break;
                    if (compilationUnit.getRoot() == null || compilationUnit.getSourceFileName() == null) {
                        if (!TRACE_READ_EXCEPTIONS) continue;
                        System.out.println("Compilation unit has broken name in file " + string);
                        continue;
                    }
                    object = compilationUnit.getSourceLanguage();
                    if (object == null) {
                        if (!TRACE_READ_EXCEPTIONS) continue;
                        System.out.println("Compilation unit has unresolved language in file " + string + "for " + compilationUnit.getSourceFileName());
                        continue;
                    }
                    Object object2 = null;
                    if (LANG.DW_LANG_C.toString().equals(object)) {
                        object2 = new DwarfSource(compilationUnit, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_C89.toString().equals(object)) {
                        object2 = new DwarfSource(compilationUnit, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C89, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_C99.toString().equals(object)) {
                        object2 = new DwarfSource(compilationUnit, ItemProperties.LanguageKind.C, ItemProperties.LanguageStandard.C99, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_C_plus_plus.toString().equals(object)) {
                        object2 = new DwarfSource(compilationUnit, ItemProperties.LanguageKind.CPP, ItemProperties.LanguageStandard.CPP, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_Fortran77.toString().equals(object)) {
                        object2 = new DwarfSource(compilationUnit, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F77, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_Fortran90.toString().equals(object)) {
                        object2 = new DwarfSource(compilationUnit, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F90, this.getCommpilerSettings(), this.grepBase);
                    } else if (LANG.DW_LANG_Fortran95.toString().equals(object)) {
                        object2 = new DwarfSource(compilationUnit, ItemProperties.LanguageKind.Fortran, ItemProperties.LanguageStandard.F95, this.getCommpilerSettings(), this.grepBase);
                    } else if (FULL_TRACE) {
                        System.out.println("Unknown language: " + (String)object);
                    }
                    if (object2 == null) continue;
                    if (((DwarfSource)object2).getCompilePath() == null) {
                        if (!TRACE_READ_EXCEPTIONS) continue;
                        System.out.println("Compilation unit has NULL compile path in file " + string);
                        continue;
                    }
                    String string2 = ((DwarfSource)object2).getItemPath();
                    SourceFileProperties sourceFileProperties = map.get(string2);
                    if (sourceFileProperties != null && sourceFileProperties.getUserInludePaths().size() > 0) {
                        if (!FULL_TRACE) continue;
                        System.out.println("Compilation unit already exist. Skip " + string2);
                        continue;
                    }
                    ((DwarfSource)object2).process(compilationUnit);
                    arrayList.add((SourceFileProperties)object2);
                }
                if (set == null) break block41;
                compilationUnit = dwarf.readPubNames();
                object = set;
                synchronized (object) {
                    for (String string2 : compilationUnit.getDlls()) {
                        set.add(string2);
                    }
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("File not found " + string + ": " + fileNotFoundException.getMessage());
                }
            }
            catch (WrongFileFormatException wrongFileFormatException) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.out.println("Unsuported format of file " + string + ": " + wrongFileFormatException.getMessage());
                }
            }
            catch (IOException iOException) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + string);
                    iOException.printStackTrace(System.err);
                }
            }
            catch (Exception exception) {
                if (TRACE_READ_EXCEPTIONS) {
                    System.err.println("Exception in file " + string);
                    exception.printStackTrace(System.err);
                }
            }
            finally {
                if (dwarf != null) {
                    dwarf.dispose();
                }
            }
        }
        return arrayList;
    }

    public CompilerSettings getCommpilerSettings() {
        return this.myCommpilerSettings;
    }

    public void setCommpilerSettings(ProjectProxy projectProxy) {
        this.myCommpilerSettings = new CompilerSettings(projectProxy);
    }

    private static class MyPosition
    implements DiscoveryExtensionInterface.Position {
        private final String path;
        private final int line;

        private MyPosition(String string, int n) {
            this.path = string;
            this.line = n;
        }

        public String getFilePath() {
            return this.path;
        }

        public int getLine() {
            return this.line;
        }

        public String toString() {
            return this.path + ":" + this.line;
        }
    }

    private class MyRunnable
    implements Runnable {
        private String file;
        private Map<String, SourceFileProperties> map;
        private Progress progress;
        private CountDownLatch countDownLatch;
        private ProjectProxy project;
        private Set<String> dlls;

        private MyRunnable(CountDownLatch countDownLatch, String string, Map<String, SourceFileProperties> map, Progress progress, ProjectProxy projectProxy, Set<String> set) {
            this.file = string;
            this.map = map;
            this.progress = progress;
            this.countDownLatch = countDownLatch;
            this.project = projectProxy;
            this.dlls = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (!BaseDwarfProvider.this.isStoped.get()) {
                    Thread.currentThread().setName("Parallel analyzing " + this.file);
                    BaseDwarfProvider.this.processObjectFile(this.file, this.map, this.progress, this.project, this.dlls);
                }
            }
            finally {
                this.countDownLatch.countDown();
            }
        }
    }

    public static class CompilerSettings {
        private final List<String> systemIncludePathsC;
        private final List<String> systemIncludePathsCpp;
        private final Map<String, String> systemMacroDefinitionsC;
        private final Map<String, String> systemMacroDefinitionsCpp;
        private Map<String, String> normalizedPaths = new ConcurrentHashMap<String, String>();
        private final CompilerFlavor compileFlavor;
        private final String cygwinDriveDirectory;
        private final boolean isWindows;

        public CompilerSettings(ProjectProxy projectProxy) {
            this.systemIncludePathsCpp = DiscoveryUtils.getSystemIncludePaths((ProjectProxy)projectProxy, (boolean)true);
            this.systemIncludePathsC = DiscoveryUtils.getSystemIncludePaths((ProjectProxy)projectProxy, (boolean)false);
            this.systemMacroDefinitionsCpp = DiscoveryUtils.getSystemMacroDefinitions((ProjectProxy)projectProxy, (boolean)true);
            this.systemMacroDefinitionsC = DiscoveryUtils.getSystemMacroDefinitions((ProjectProxy)projectProxy, (boolean)false);
            this.compileFlavor = DiscoveryUtils.getCompilerFlavor((ProjectProxy)projectProxy);
            this.isWindows = Utilities.isWindows();
            this.cygwinDriveDirectory = this.isWindows ? DiscoveryUtils.getCygwinDrive((ProjectProxy)projectProxy) : null;
        }

        public List<String> getSystemIncludePaths(ItemProperties.LanguageKind languageKind) {
            if (languageKind == ItemProperties.LanguageKind.CPP) {
                return this.systemIncludePathsCpp;
            }
            if (languageKind == ItemProperties.LanguageKind.C) {
                return this.systemIncludePathsC;
            }
            return Collections.emptyList();
        }

        public Map<String, String> getSystemMacroDefinitions(ItemProperties.LanguageKind languageKind) {
            if (languageKind == ItemProperties.LanguageKind.CPP) {
                return this.systemMacroDefinitionsCpp;
            }
            if (languageKind == ItemProperties.LanguageKind.C) {
                return this.systemMacroDefinitionsC;
            }
            return Collections.emptyMap();
        }

        public String getNormalizedPath(String string) {
            String string2 = this.normalizedPaths.get(string);
            if (string2 == null) {
                string2 = PathCache.getString(this.normalizePath(string));
                this.normalizedPaths.put(PathCache.getString(string), string2);
            }
            return string2;
        }

        protected String normalizePath(String string) {
            string = DiscoveryUtils.normalizeAbsolutePath((String)string);
            if (Utilities.isWindows()) {
                string = string.replace('\\', '/');
            }
            return string;
        }

        public CompilerFlavor getCompileFlavor() {
            return this.compileFlavor;
        }

        public String getCygwinDrive() {
            return this.cygwinDriveDirectory;
        }

        public boolean isWindows() {
            return this.isWindows;
        }

        private void dispose() {
            this.systemIncludePathsC.clear();
            this.systemIncludePathsCpp.clear();
            this.systemMacroDefinitionsC.clear();
            this.systemMacroDefinitionsCpp.clear();
            this.normalizedPaths.clear();
            this.normalizedPaths = new ConcurrentHashMap<String, String>();
        }
    }

    public static class GrepEntry {
        ArrayList<String> includes = new ArrayList();
        String firstMacro = null;
        int firstMacroLine = -1;
    }
}

