/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.macros;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.macros.storage.MacroDescription;
import org.netbeans.modules.editor.settings.storage.api.EditorSettingsStorage;
import org.netbeans.modules.editor.settings.storage.spi.StorageFilter;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;

public final class MacroShortcutsInjector
extends StorageFilter<Collection<KeyStroke>, MultiKeyBinding>
implements PropertyChangeListener {
    private static final Logger LOG = Logger.getLogger(MacroShortcutsInjector.class.getName());
    private EditorSettingsStorage<String, MacroDescription> storage = null;

    public static void refreshShortcuts() {
        Collection injectors = Lookup.getDefault().lookupAll(MacroShortcutsInjector.class);
        if (injectors.size() == 0) {
            LOG.warning("No MacroShortcutsInjector found in default Lookup");
            return;
        }
        if (injectors.size() > 1) {
            LOG.warning("Too many MacroShortcutsInjector instances found in default Lookup:");
            for (MacroShortcutsInjector msi : injectors) {
                LOG.warning("  " + msi);
            }
        }
        ((MacroShortcutsInjector)injectors.iterator().next()).notifyChanges();
    }

    public MacroShortcutsInjector() {
        super("Keybindings");
    }

    public void afterLoad(Map<Collection<KeyStroke>, MultiKeyBinding> map, MimePath mimePath, String profile, boolean defaults) {
        HashMap<String, MacroDescription> macros = new HashMap<String, MacroDescription>();
        this.collectMacroActions(mimePath, macros);
        for (MacroDescription macro : macros.values()) {
            List<? extends MultiKeyBinding> shortcuts = macro.getShortcuts();
            for (MultiKeyBinding multiKeyBinding : shortcuts) {
                List keys = multiKeyBinding.getKeyStrokeList();
                if (!map.containsKey(keys)) {
                    map.put(keys, multiKeyBinding);
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("afterLoad: injecting " + keys + " for macro '" + macro.getName() + "'; mimePath='" + mimePath.getPath() + "'");
                    continue;
                }
                LOG.warning("Shortcut " + keys + " is bound to '" + map.get(keys).getActionName() + "' for '" + mimePath.getPath() + "' and will not be assigned to '" + macro.getName() + "' macro!");
            }
        }
    }

    public void beforeSave(Map<Collection<KeyStroke>, MultiKeyBinding> map, MimePath mimePath, String profile, boolean defaults) {
        HashSet<Collection<KeyStroke>> keysToFilterOut = new HashSet<Collection<KeyStroke>>();
        for (Collection<KeyStroke> keys : map.keySet()) {
            MultiKeyBinding shortcut = map.get(keys);
            if (!shortcut.getActionName().equals("run-macro")) continue;
            keysToFilterOut.add(keys);
            if (!LOG.isLoggable(Level.FINE)) continue;
            LOG.fine("beforeSave: filtering out macro shortcut " + keys + "; mimePath='" + mimePath.getPath() + "'");
        }
        map.keySet().removeAll(keysToFilterOut);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null || "EditorSettingsStorage.PROP_DATA".equals(evt.getPropertyName())) {
            LOG.fine("Macros storage changed, notifying 'Keybindings' storage...");
            this.notifyChanges();
        }
    }

    private void collectMacroActions(MimePath mimePath, Map<String, MacroDescription> macros) {
        if (this.storage == null) {
            this.storage = EditorSettingsStorage.get((String)"Macros");
            this.storage.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, this.storage));
        }
        try {
            macros.putAll(this.storage.load(mimePath, null, false));
        }
        catch (IOException ioe) {
            LOG.log(Level.WARNING, null, ioe);
        }
    }
}

