/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.buildsupport;

import java.io.IOException;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildProjectActionHandler;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildTraceSupport;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandlerFactory;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Lookup;

public class BuildProjectActionHandlerFactory
implements ProjectActionHandlerFactory {
    public boolean canHandle(ProjectActionEvent.Type type, Configuration configuration) {
        if (type == ProjectActionEvent.PredefinedType.BUILD && configuration instanceof MakeConfiguration) {
            MakeConfiguration conf = (MakeConfiguration)configuration;
            ExecutionEnvironment executionEnvironment = conf.getDevelopmentHost().getExecutionEnvironment();
            if (conf.getConfigurationType().getValue() == 0 && BuildTraceSupport.useBuildTrace()) {
                try {
                    HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
                    switch (hostInfo.getOSFamily()) {
                        case SUNOS: 
                        case LINUX: {
                            return true;
                        }
                    }
                }
                catch (IOException ex) {
                }
                catch (CancellationException ex) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    public ProjectActionHandler createHandler() {
        return new BuildProjectActionHandler();
    }

    static ProjectActionHandler createDelegateHandler(ProjectActionEvent pae) {
        boolean selfFound = false;
        for (ProjectActionHandlerFactory factory : Lookup.getDefault().lookupAll(ProjectActionHandlerFactory.class)) {
            if (factory instanceof BuildProjectActionHandlerFactory) {
                selfFound = true;
                continue;
            }
            if (!selfFound || !factory.canHandle(pae)) continue;
            return factory.createHandler();
        }
        return null;
    }

    public boolean canHandle(ProjectActionEvent pae) {
        return this.canHandle(pae.getType(), (Configuration)pae.getConfiguration());
    }
}

