/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Future;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.discovery.api.DiscoveryProvider;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryExtension;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardAction;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardIterator;
import org.netbeans.modules.cnd.discovery.wizard.SimpleConfigurationWizard;
import org.netbeans.modules.cnd.makeproject.api.BuildActionsProvider;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class BuildActionsProviderImpl
extends BuildActionsProvider {
    public List<BuildActionsProvider.BuildAction> getActions(String ioTabName, ProjectActionEvent[] events) {
        ArrayList<BuildActionsProvider.BuildAction> res = new ArrayList<BuildActionsProvider.BuildAction>();
        if (events != null && events.length == 2 && events[0].getType() == ProjectActionEvent.PredefinedType.CLEAN && events[1].getType() == ProjectActionEvent.PredefinedType.BUILD && events[1].getConfiguration() != null && events[1].getConfiguration().getConfigurationType().getValue() == 0) {
            res.add(new ConfigureAction(ioTabName, events));
        }
        return res;
    }

    public static final class ConfigureAction
    extends AbstractAction
    implements BuildActionsProvider.BuildAction,
    BuildActionsProvider.OutputStreamHandler {
        private String ioTabName;
        private ProjectActionEvent[] events;
        private int step = -1;
        private BufferedWriter bw;
        private String name;
        private File execLog;

        public ConfigureAction(String ioTabName, ProjectActionEvent[] events) {
            this.ioTabName = ioTabName;
            this.events = events;
        }

        @Override
        public Object getValue(String key) {
            if (key.equals("SmallIcon")) {
                return new ImageIcon(BuildActionsProviderImpl.class.getResource("/org/netbeans/modules/cnd/discovery/wizard/resources/configure.png"));
            }
            if (key.equals("ShortDescription")) {
                return NbBundle.getBundle(BuildActionsProviderImpl.class).getString("OUTPUT_LOG_ACTION_TEXT");
            }
            return super.getValue(key);
        }

        public void executionStarted(int pid) {
            this.setEnabled(false);
            if (this.step == 1) {
                try {
                    File file = File.createTempFile("tmplog", ".log");
                    file.deleteOnExit();
                    this.name = file.getAbsolutePath();
                    this.bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
                }
                catch (IOException ex) {
                    this.name = null;
                    this.bw = null;
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }

        public void executionFinished(int rc) {
            if (this.step == 1 && rc == 0 && this.name != null) {
                this.setEnabled(true);
            }
        }

        public void setStep(int step) {
            this.step = step;
        }

        public void setExecLog(File execLog) {
            this.execLog = execLog;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.setEnabled(false);
            if (this.step >= 0 && this.step < this.events.length) {
                Project project = this.events[this.step].getProject();
                String fileName = this.name;
                if (fileName != null) {
                    this.name = null;
                    this.invokeWizard(project, fileName);
                }
            }
        }

        public void handleLine(String line) {
            if (this.bw != null) {
                try {
                    this.bw.write(line);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void flush() {
            if (this.bw != null) {
                try {
                    this.bw.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        public void close() {
            if (this.bw != null) {
                try {
                    this.bw.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void invokeWizard(Project project, String fileName) {
            boolean cancelled;
            DiscoveryProvider provider = null;
            if (this.execLog != null) {
                ExecutionEnvironment executionEnvironment = this.events[1].getConfiguration().getDevelopmentHost().getExecutionEnvironment();
                if (executionEnvironment.isRemote()) {
                    try {
                        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)executionEnvironment);
                        String remoteExecLog = hostInfo.getTempDir() + "/" + this.execLog.getName();
                        if (HostInfoUtils.fileExists((ExecutionEnvironment)executionEnvironment, (String)remoteExecLog)) {
                            Future task = CommonTasksSupport.downloadFile((String)remoteExecLog, (ExecutionEnvironment)executionEnvironment, (String)this.execLog.getAbsolutePath(), null);
                            task.get();
                            provider = DiscoveryExtension.findProvider("exec-log");
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                } else {
                    provider = DiscoveryExtension.findProvider("exec-log");
                }
            }
            if (provider == null) {
                provider = DiscoveryExtension.findProvider("make-log");
            }
            if (provider == null) {
                return;
            }
            if (DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)this.getString("OUTPUT_LOG_DILOG_COMTENT_TEXT"), this.getString("OUTPUT_LOG_DILOG_TITLE_TEXT"), 0)) != NotifyDescriptor.YES_OPTION) {
                return;
            }
            DiscoveryWizardDescriptor wizardDescriptor = new DiscoveryWizardDescriptor((WizardDescriptor.Iterator)this.getPanels());
            wizardDescriptor.setSimpleMode(true);
            wizardDescriptor.setProvider(provider);
            wizardDescriptor.setProject(project);
            wizardDescriptor.setRootFolder(DiscoveryWizardAction.findSourceRoot(project));
            if (this.execLog != null) {
                wizardDescriptor.setExecLog(this.execLog.getAbsolutePath());
            } else {
                wizardDescriptor.setBuildLog(fileName);
            }
            wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
            wizardDescriptor.setTitle(this.getString("WIZARD_TITLE_TXT"));
            Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)wizardDescriptor);
            dialog.setVisible(true);
            dialog.toFront();
            boolean bl = cancelled = wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
            if (!cancelled) {
                // empty if block
            }
            dialog.dispose();
        }

        private String getString(String key) {
            return NbBundle.getBundle(BuildActionsProviderImpl.class).getString(key);
        }

        private WizardDescriptor.InstantiatingIterator<WizardDescriptor> getPanels() {
            WizardDescriptor.Panel[] simple = new WizardDescriptor.Panel[]{new SimpleConfigurationWizard()};
            String[] steps = new String[simple.length];
            for (int i = 0; i < simple.length; ++i) {
                Component c = simple[i].getComponent();
                steps[i] = c.getName();
                DiscoveryWizardAction.setupComponent(steps, null, i, c);
            }
            return new DiscoveryWizardIterator(simple, simple);
        }
    }
}

