/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.api.support;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerFlavor;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.util.Utilities;

public class ProjectBridge {
    private String baseFolder;
    private final MakeConfigurationDescriptor makeConfigurationDescriptor;
    private Project project;
    private Set<Project> resultSet = new HashSet<Project>();
    private Map<String, Item> canonicalItems;
    private static final String PATTERN_1 = File.separator + "." + File.separator;
    private static final String PATTERN_2 = File.separator + ".";
    private static final String PATTERN_3 = File.separator + ".." + File.separator;
    private static final String PATTERN_4 = File.separator + "..";
    private Map<String, String> cache = new HashMap<String, String>();
    private List<String> systemIncludePathsC;
    private List<String> systemIncludePathsCpp;
    private static final String CYG_DRIVE_UNIX = "/cygdrive/";
    private Map<String, String> systemMacroDefinitionsC;
    private Map<String, String> systemMacroDefinitionsCpp;

    public ProjectBridge(Project project) {
        this.project = project;
        this.baseFolder = File.separator + project.getProjectDirectory().getPath();
        this.resultSet.add(project);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        this.makeConfigurationDescriptor = pdp != null ? pdp.getConfigurationDescriptor() : null;
    }

    public boolean isValid() {
        return this.makeConfigurationDescriptor != null;
    }

    public ProjectBridge(String baseFolder) throws IOException {
        this.baseFolder = baseFolder;
        MakeConfiguration extConf = new MakeConfiguration(baseFolder, "Default", 0, "localhost");
        String workingDir = baseFolder;
        String workingDirRel = CndPathUtilitities.toRelativePath((String)baseFolder, (String)CndPathUtilitities.naturalizeSlashes((String)workingDir));
        workingDirRel = CndPathUtilitities.normalizeSlashes((String)workingDirRel);
        extConf.getMakefileConfiguration().getBuildCommandWorkingDir().setValue(workingDirRel);
        String prjName = "DiscoveryProject";
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(prjName, baseFolder);
        prjParams.setOpenFlag(true).setConfiguration(extConf);
        this.project = ProjectGenerator.createBlankProject((ProjectGenerator.ProjectParameters)prjParams);
        this.resultSet.add(this.project);
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        this.makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
    }

    public Folder createFolder(Folder parent, String name) {
        return new Folder(this.makeConfigurationDescriptor, parent, name, name, true, null);
    }

    public void addSourceRoot(String path) {
        this.makeConfigurationDescriptor.addSourceRootRaw(path);
    }

    public Item createItem(String path) {
        return new Item(this.getRelativepath(path));
    }

    public Item getProjectItem(String path) {
        Item item = this.makeConfigurationDescriptor.findProjectItemByPath(path);
        if (item == null) {
            if (!CndPathUtilitities.isPathAbsolute((CharSequence)path)) {
                path = CndPathUtilitities.toAbsolutePath((String)this.baseFolder, (String)path);
            }
            item = this.findByCanonicalName(path);
        }
        return item;
    }

    public void checkForNewExtensions(Set<String> needAdd) {
        HashSet<String> extensions = new HashSet<String>();
        for (String name : needAdd) {
            String extension;
            int i = name.replace('\\', '/').lastIndexOf(47);
            if (i >= 0) {
                name = name.substring(i + 1);
            }
            if ((i = name.lastIndexOf(46)) <= 0 || (extension = name.substring(i + 1)).length() <= 0) continue;
            extensions.add(extension);
        }
        HashSet<Item> old = new HashSet<Item>();
        for (Item item : this.getAllSources()) {
            old.add(item);
        }
        if (this.makeConfigurationDescriptor.addAdditionalHeaderExtensions(extensions)) {
            for (Item item : this.getAllSources()) {
                if (old.contains(item)) continue;
                ProjectBridge.setExclude(item, true);
            }
        }
    }

    private Item findByCanonicalName(String path) {
        if (this.canonicalItems == null) {
            this.canonicalItems = new HashMap<String, Item>();
            for (Item item : this.makeConfigurationDescriptor.getProjectItems()) {
                this.canonicalItems.put(item.getCanonicalPath(), item);
            }
        }
        return this.canonicalItems.get(path);
    }

    public Object getAuxObject(Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        return itemConfiguration;
    }

    public void setAuxObject(Item item, Object pao) {
        if (pao instanceof ItemConfiguration) {
            ItemConfiguration conf = (ItemConfiguration)pao;
            MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
            ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
            switch (itemConfiguration.getTool()) {
                case CCCompiler: {
                    itemConfiguration.setCCCompilerConfiguration(conf.getCCCompilerConfiguration());
                    break;
                }
                case CCompiler: {
                    itemConfiguration.setCCompilerConfiguration(conf.getCCompilerConfiguration());
                    break;
                }
                case CustomTool: {
                    itemConfiguration.setCustomToolConfiguration(conf.getCustomToolConfiguration());
                }
            }
        }
    }

    public String getRelativepath(String path) {
        if (Utilities.isWindows()) {
            path = path.replace('/', File.separatorChar);
        }
        path = CndPathUtilitities.toRelativePath((String)this.makeConfigurationDescriptor.getBaseDir(), (String)path);
        path = this.cutLocalRelative(path);
        path = CndPathUtilitities.normalizeSlashes((String)path);
        return path;
    }

    private String cutLocalRelative(String path) {
        int i;
        String pattern = PATTERN_1;
        while ((i = path.indexOf(pattern)) >= 0) {
            path = path.substring(0, i + 1) + path.substring(i + pattern.length());
        }
        pattern = PATTERN_2;
        if (path.endsWith(pattern)) {
            path = path.substring(0, path.length() - pattern.length());
        }
        pattern = PATTERN_3;
        while ((i = path.indexOf(pattern)) >= 0) {
            int k = -1;
            for (int j = i - 1; j >= 0; --j) {
                if (path.charAt(j) != File.separatorChar) continue;
                k = j;
                break;
            }
            if (k < 0) break;
            path = path.substring(0, k + 1) + path.substring(i + pattern.length());
        }
        pattern = PATTERN_4;
        if (path.endsWith(pattern)) {
            int k = -1;
            for (int j = path.length() - pattern.length() - 1; j >= 0; --j) {
                if (path.charAt(j) != File.separatorChar) continue;
                k = j;
                break;
            }
            if (k > 0) {
                path = path.substring(0, k);
            }
        }
        return path;
    }

    public Item[] getAllSources() {
        return this.makeConfigurationDescriptor.getProjectItems();
    }

    public Folder getRoot() {
        Folder folder = this.makeConfigurationDescriptor.getLogicalFolders();
        List sources = folder.getFolders();
        for (Folder sub : sources) {
            if (!sub.isProjectFiles() || !"SourceFiles".equals(sub.getName())) continue;
            return sub;
        }
        return folder;
    }

    public Map<String, Folder> prefferedFolders() {
        String folder;
        HashMap<String, Folder> folders = new HashMap<String, Folder>();
        for (Item item : this.getAllSources()) {
            int i;
            String path = item.getAbsPath();
            if (Utilities.isWindows()) {
                path = path.replace('\\', '/');
            }
            if (path.indexOf("/../") >= 0 || path.indexOf("/./") >= 0) {
                path = CndFileUtils.normalizeFile((File)new File(path)).getAbsolutePath();
                if (Utilities.isWindows()) {
                    path = path.replace('\\', '/');
                }
            }
            if ((i = path.lastIndexOf(47)) < 0) continue;
            folder = path.substring(0, i);
            folders.put(folder, item.getFolder());
        }
        Folder root = this.makeConfigurationDescriptor.getLogicalFolders();
        HashSet<Folder> roots = new HashSet<Folder>(root.getFolders());
        roots.add(root);
        while (true) {
            HashMap<String, Folder> delta = new HashMap<String, Folder>();
            for (Map.Entry entry : folders.entrySet()) {
                String needCheck;
                String pathName;
                String path = (String)entry.getKey();
                folder = (Folder)entry.getValue();
                Folder parent = folder.getParent();
                if (parent == null || roots.contains(parent)) continue;
                String name = folder.getName();
                int i = path.lastIndexOf(47);
                if (i < 0 || !name.equals(pathName = path.substring(i + 1)) || folders.containsKey(needCheck = path.substring(0, i))) continue;
                delta.put(needCheck, parent);
            }
            if (delta.isEmpty()) break;
            folders.putAll(delta);
        }
        return folders;
    }

    public void save() {
        this.makeConfigurationDescriptor.save();
    }

    public Set<Project> getResult() {
        this.makeConfigurationDescriptor.checkForChangedItems(this.project, null, null);
        return this.resultSet;
    }

    public void setupProject(List<String> includes, List<String> macros, ItemProperties.LanguageKind lang) {
        MakeConfiguration extConf = this.makeConfigurationDescriptor.getActiveConfiguration();
        if (extConf != null) {
            int i;
            for (i = 0; i < includes.size(); ++i) {
                includes.set(i, this.getString(includes.get(i)));
            }
            for (i = 0; i < macros.size(); ++i) {
                macros.set(i, this.getString(macros.get(i)));
            }
            if (lang == ItemProperties.LanguageKind.CPP) {
                extConf.getCCCompilerConfiguration().getIncludeDirectories().setValue(includes);
                extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().setValue(macros);
                extConf.getCCCompilerConfiguration().getIncludeDirectories().setDirty(true);
                extConf.getCCCompilerConfiguration().getPreprocessorConfiguration().setDirty(true);
            } else if (lang == ItemProperties.LanguageKind.C) {
                extConf.getCCompilerConfiguration().getIncludeDirectories().setValue(includes);
                extConf.getCCompilerConfiguration().getPreprocessorConfiguration().setValue(macros);
                extConf.getCCompilerConfiguration().getIncludeDirectories().setDirty(true);
                extConf.getCCompilerConfiguration().getPreprocessorConfiguration().setDirty(true);
            } else if (lang == ItemProperties.LanguageKind.Fortran) {
                // empty if block
            }
        }
        this.makeConfigurationDescriptor.setModified();
    }

    public FolderConfiguration getFolderConfiguration(Folder folder) {
        MakeConfiguration makeConfiguration = folder.getConfigurationDescriptor().getActiveConfiguration();
        return folder.getFolderConfiguration((Configuration)makeConfiguration);
    }

    public CCCCompilerConfiguration getFolderConfiguration(ItemProperties.LanguageKind lang, Folder folder) {
        FolderConfiguration folderConfiguration = this.getFolderConfiguration(folder);
        if (folderConfiguration == null) {
            return null;
        }
        if (lang == ItemProperties.LanguageKind.CPP) {
            return folderConfiguration.getCCCompilerConfiguration();
        }
        if (lang == ItemProperties.LanguageKind.C) {
            return folderConfiguration.getCCompilerConfiguration();
        }
        return null;
    }

    public void setupFolder(List<String> includes, boolean inheriteIncludes, List<String> macros, boolean inheriteMacros, ItemProperties.LanguageKind lang, Folder folder) {
        int i;
        CCCCompilerConfiguration cccc = this.getFolderConfiguration(lang, folder);
        if (cccc == null) {
            return;
        }
        for (i = 0; i < includes.size(); ++i) {
            includes.set(i, this.getString(includes.get(i)));
        }
        for (i = 0; i < macros.size(); ++i) {
            macros.set(i, this.getString(macros.get(i)));
        }
        cccc.getIncludeDirectories().setValue(includes);
        cccc.getInheritIncludes().setValue(inheriteIncludes);
        cccc.getPreprocessorConfiguration().setValue(macros);
        cccc.getInheritPreprocessor().setValue(inheriteMacros);
    }

    public static void setExclude(Item item, boolean exclude) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        if (excl.getValue() ^ exclude) {
            excl.setValue(exclude);
        }
    }

    public static void setHeaderTool(Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return;
        }
        if (itemConfiguration.getTool() == PredefinedToolKind.CCCompiler || itemConfiguration.getTool() == PredefinedToolKind.CCompiler) {
            itemConfiguration.setTool(PredefinedToolKind.CustomTool);
        }
    }

    public void setSourceTool(Item item, ItemProperties.LanguageKind lang, ItemProperties.LanguageStandard languageStandard) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null) {
            return;
        }
        switch (lang) {
            case C: {
                if (itemConfiguration.getTool() != PredefinedToolKind.CCompiler) {
                    itemConfiguration.setTool(PredefinedToolKind.CCompiler);
                }
                if (languageStandard == ItemProperties.LanguageStandard.C) {
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.C);
                    break;
                }
                if (languageStandard == ItemProperties.LanguageStandard.C89) {
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.C89);
                    break;
                }
                if (languageStandard != ItemProperties.LanguageStandard.C99) break;
                itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.C99);
                break;
            }
            case CPP: {
                if (itemConfiguration.getTool() != PredefinedToolKind.CCCompiler) {
                    itemConfiguration.setTool(PredefinedToolKind.CCCompiler);
                }
                if (languageStandard != ItemProperties.LanguageStandard.CPP) break;
                itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.CPP);
                break;
            }
            case Fortran: {
                if (itemConfiguration.getTool() != PredefinedToolKind.FortranCompiler) {
                    itemConfiguration.setTool(PredefinedToolKind.FortranCompiler);
                }
                if (languageStandard == ItemProperties.LanguageStandard.F77) {
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.F77);
                    break;
                }
                if (languageStandard == ItemProperties.LanguageStandard.F90) {
                    itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.F90);
                    break;
                }
                if (languageStandard != ItemProperties.LanguageStandard.F95) break;
                itemConfiguration.setLanguageFlavor(NativeFileItem.LanguageFlavor.F95);
            }
        }
    }

    public CCCCompilerConfiguration getItemConfiguration(Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return null;
        }
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            return (CCCCompilerConfiguration)compilerConfiguration;
        }
        return null;
    }

    public void setupFile(String compilepath, List<String> includes, boolean inheriteIncludes, List<String> macros, boolean inheriteMacros, Item item) {
        int i;
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return;
        }
        BooleanConfiguration excl = itemConfiguration.getExcluded();
        if (excl.getValue()) {
            excl.setValue(false);
        }
        for (i = 0; i < includes.size(); ++i) {
            includes.set(i, this.getString(includes.get(i)));
        }
        for (i = 0; i < macros.size(); ++i) {
            macros.set(i, this.getString(macros.get(i)));
        }
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            cccCompilerConfiguration.getIncludeDirectories().setValue(includes);
            cccCompilerConfiguration.getInheritIncludes().setValue(inheriteIncludes);
            cccCompilerConfiguration.getPreprocessorConfiguration().setValue(macros);
            cccCompilerConfiguration.getInheritPreprocessor().setValue(inheriteMacros);
        }
    }

    public static void fixFileMacros(Map<String, String> macros, Item item) {
        MakeConfiguration makeConfiguration = item.getFolder().getConfigurationDescriptor().getActiveConfiguration();
        ItemConfiguration itemConfiguration = item.getItemConfiguration((Configuration)makeConfiguration);
        if (itemConfiguration == null || !itemConfiguration.isCompilerToolConfiguration()) {
            return;
        }
        BasicCompilerConfiguration compilerConfiguration = itemConfiguration.getCompilerConfiguration();
        if (compilerConfiguration instanceof CCCCompilerConfiguration) {
            HashSet set = new HashSet(item.getUserMacroDefinitions());
            CCCCompilerConfiguration cccCompilerConfiguration = (CCCCompilerConfiguration)compilerConfiguration;
            ArrayList<String> list = new ArrayList<String>(cccCompilerConfiguration.getPreprocessorConfiguration().getValue());
            for (Map.Entry<String, String> entry : macros.entrySet()) {
                String s = entry.getValue() != null ? entry.getKey() + "=" + entry.getValue() : entry.getKey();
                boolean find = set.contains(s);
                if (!(find || entry.getValue() != null && !"".equals(entry.getValue()) || (find = set.contains(s + "=1")))) {
                    find = set.contains(s + "=");
                }
                if (!find && ("1".equals(entry.getValue()) || "".equals(entry.getValue()))) {
                    find = set.contains(entry.getKey());
                }
                if (find) continue;
                list.add(s);
            }
            cccCompilerConfiguration.getPreprocessorConfiguration().setValue(list);
        }
    }

    private String getString(String s) {
        String res = this.cache.get(s);
        if (res == null) {
            this.cache.put(s, s);
            return s;
        }
        return res;
    }

    public void dispose() {
        this.cache.clear();
    }

    private CompilerSet getCompilerSet() {
        MakeConfiguration makeConfiguration = this.makeConfigurationDescriptor.getActiveConfiguration();
        return makeConfiguration.getCompilerSet().getCompilerSet();
    }

    public String getCygwinDrive() {
        String res = CompilerSetUtils.getCygwinBase();
        if (res != null && res.endsWith("/")) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public CompilerFlavor getCompilerFlavor() {
        return this.getCompilerSet().getCompilerFlavor();
    }

    public String getCompilerDirectory() {
        return this.getCompilerSet().getDirectory();
    }

    public List<String> getSystemIncludePaths(boolean isCPP) {
        List<String> systemIncludePaths = isCPP ? this.systemIncludePathsCpp : this.systemIncludePathsC;
        if (systemIncludePaths == null) {
            systemIncludePaths = new ArrayList<String>();
            CompilerSet compilerSet = this.getCompilerSet();
            AbstractCompiler compiler = isCPP ? (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler) : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            Iterator i$ = compiler.getSystemIncludeDirectories().iterator();
            while (i$.hasNext()) {
                String o;
                String path = o = (String)i$.next();
                systemIncludePaths.add(this.fixWindowsPath(path));
            }
            if (isCPP) {
                this.systemIncludePathsCpp = systemIncludePaths;
            } else {
                this.systemIncludePathsC = systemIncludePaths;
            }
        }
        return systemIncludePaths;
    }

    private String fixWindowsPath(String path) {
        int i;
        if (Utilities.isWindows() && (i = (path = path.replace('\\', '/')).indexOf(CYG_DRIVE_UNIX)) >= 0 && path.length() > i + CYG_DRIVE_UNIX.length() + 1) {
            path = Character.toUpperCase(path.charAt(i + CYG_DRIVE_UNIX.length())) + ":" + path.substring(i + CYG_DRIVE_UNIX.length() + 1);
        }
        return path;
    }

    public Map<String, String> getSystemMacroDefinitions(boolean isCPP) {
        Map<String, String> systemMacroDefinitions = isCPP ? this.systemMacroDefinitionsCpp : this.systemMacroDefinitionsC;
        if (systemMacroDefinitions == null) {
            systemMacroDefinitions = new HashMap<String, String>();
            CompilerSet compilerSet = this.getCompilerSet();
            AbstractCompiler compiler = isCPP ? (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler) : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCompiler);
            for (String o : compiler.getSystemPreprocessorSymbols()) {
                String macro = o;
                int i = macro.indexOf(61);
                if (i > 0) {
                    systemMacroDefinitions.put(macro.substring(0, i), macro.substring(i + 1).trim());
                    continue;
                }
                systemMacroDefinitions.put(macro, null);
            }
            if (isCPP) {
                this.systemMacroDefinitionsCpp = systemMacroDefinitions;
            } else {
                this.systemMacroDefinitionsC = systemMacroDefinitions;
            }
        }
        return systemMacroDefinitions;
    }
}

