/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationBase;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ItemXMLCodec;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class ItemConfiguration
implements ConfigurationAuxObject {
    private boolean needSave = false;
    private Configuration configuration;
    private Item item;
    private BooleanConfiguration excluded;
    private PredefinedToolKind tool = PredefinedToolKind.UnknownTool;
    private NativeFileItem.LanguageFlavor languageFlavor = NativeFileItem.LanguageFlavor.UNKNOWN;
    private ConfigurationBase lastConfiguration;
    private CustomToolConfiguration customToolConfiguration;
    private static ResourceBundle bundle = null;

    public ItemConfiguration(Configuration configuration, Item item) {
        this.configuration = configuration;
        this.setItem(item);
        this.excluded = new BooleanConfiguration(false);
        item.getFolder().getFolderConfiguration(configuration);
        this.clearChanged();
    }

    public ItemConfiguration(ItemConfiguration itemConfiguration) {
        this.configuration = itemConfiguration.configuration;
        this.item = itemConfiguration.item;
        this.excluded = itemConfiguration.excluded;
        this.needSave = itemConfiguration.needSave;
        this.tool = itemConfiguration.tool;
        this.languageFlavor = itemConfiguration.languageFlavor;
        this.lastConfiguration = itemConfiguration.lastConfiguration;
        this.customToolConfiguration = itemConfiguration.customToolConfiguration;
    }

    public boolean isDefaultConfiguration() {
        if (this.excluded.getValue()) {
            return false;
        }
        if (this.getTool() != this.item.getDefaultTool()) {
            return false;
        }
        if (this.lastConfiguration != null && this.lastConfiguration.getModified()) {
            return false;
        }
        return this.customToolConfiguration == null || !this.customToolConfiguration.getModified();
    }

    public boolean isCompilerToolConfiguration() {
        switch (this.getTool()) {
            case Assembler: 
            case CCCompiler: 
            case CCompiler: 
            case FortranCompiler: {
                return true;
            }
        }
        return false;
    }

    public BasicCompilerConfiguration getCompilerConfiguration() {
        switch (this.getTool()) {
            case Assembler: {
                return this.getAssemblerConfiguration();
            }
            case CCCompiler: {
                return this.getCCCompilerConfiguration();
            }
            case CCompiler: {
                return this.getCCompilerConfiguration();
            }
            case FortranCompiler: {
                return this.getFortranCompilerConfiguration();
            }
        }
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public Item getItem() {
        return this.item;
    }

    private void setItem(Item item) {
        if (this.item != item) {
            this.item = item;
            this.needSave = true;
        }
    }

    public BooleanConfiguration getExcluded() {
        return this.excluded;
    }

    public void setExcluded(BooleanConfiguration excluded) {
        this.excluded = excluded;
        this.needSave = true;
    }

    public void setTool(PredefinedToolKind tool) {
        if (this.tool != tool) {
            this.lastConfiguration = null;
        }
        this.tool = tool;
    }

    public PredefinedToolKind getTool() {
        if (this.tool == PredefinedToolKind.UnknownTool) {
            this.tool = this.item.getDefaultTool();
        }
        return this.tool;
    }

    public void setLanguageFlavor(NativeFileItem.LanguageFlavor flavor) {
        this.languageFlavor = flavor;
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor() {
        return this.languageFlavor;
    }

    protected String[] getToolNames() {
        return new String[]{PredefinedToolKind.CCompiler.getDisplayName(), PredefinedToolKind.CCCompiler.getDisplayName(), PredefinedToolKind.FortranCompiler.getDisplayName(), PredefinedToolKind.Assembler.getDisplayName(), PredefinedToolKind.CustomTool.getDisplayName()};
    }

    public void setCustomToolConfiguration(CustomToolConfiguration customToolConfiguration) {
        this.customToolConfiguration = customToolConfiguration;
    }

    public synchronized CustomToolConfiguration getCustomToolConfiguration() {
        if (this.getTool() == PredefinedToolKind.CustomTool || this.isProCFile()) {
            if (this.customToolConfiguration == null) {
                this.customToolConfiguration = new CustomToolConfiguration();
            }
            return this.customToolConfiguration;
        }
        return null;
    }

    public void setCCompilerConfiguration(CCompilerConfiguration cCompilerConfiguration) {
        this.lastConfiguration = cCompilerConfiguration;
    }

    public synchronized CCompilerConfiguration getCCompilerConfiguration() {
        if (this.getTool() == PredefinedToolKind.CCompiler) {
            if (this.lastConfiguration == null) {
                FolderConfiguration folderConfiguration = this.item.getFolder().getFolderConfiguration(this.configuration);
                this.lastConfiguration = folderConfiguration != null ? new CCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), folderConfiguration.getCCompilerConfiguration(), null) : new CCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), null, null);
            }
            assert (this.lastConfiguration instanceof CCompilerConfiguration);
            return (CCompilerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public void setCCCompilerConfiguration(CCCompilerConfiguration ccCompilerConfiguration) {
        this.lastConfiguration = ccCompilerConfiguration;
    }

    public synchronized CCCompilerConfiguration getCCCompilerConfiguration() {
        if (this.getTool() == PredefinedToolKind.CCCompiler) {
            if (this.lastConfiguration == null) {
                FolderConfiguration folderConfiguration = this.item.getFolder().getFolderConfiguration(this.configuration);
                this.lastConfiguration = folderConfiguration != null ? new CCCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), folderConfiguration.getCCCompilerConfiguration(), null) : new CCCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), null, null);
            }
            assert (this.lastConfiguration instanceof CCCompilerConfiguration);
            return (CCCompilerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public void setFortranCompilerConfiguration(FortranCompilerConfiguration fortranCompilerConfiguration) {
        this.lastConfiguration = fortranCompilerConfiguration;
    }

    public synchronized FortranCompilerConfiguration getFortranCompilerConfiguration() {
        if (this.getTool() == PredefinedToolKind.FortranCompiler) {
            if (this.lastConfiguration == null) {
                this.lastConfiguration = new FortranCompilerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), ((MakeConfiguration)this.configuration).getFortranCompilerConfiguration());
            }
            assert (this.lastConfiguration instanceof FortranCompilerConfiguration);
            return (FortranCompilerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    public void setAssemblerConfiguration(AssemblerConfiguration assemblerConfiguration) {
        this.lastConfiguration = assemblerConfiguration;
    }

    public synchronized AssemblerConfiguration getAssemblerConfiguration() {
        if (this.getTool() == PredefinedToolKind.Assembler) {
            if (this.lastConfiguration == null) {
                this.lastConfiguration = new AssemblerConfiguration(((MakeConfiguration)this.configuration).getBaseDir(), ((MakeConfiguration)this.configuration).getAssemblerConfiguration());
            }
            assert (this.lastConfiguration instanceof AssemblerConfiguration);
            return (AssemblerConfiguration)this.lastConfiguration;
        }
        return null;
    }

    @Override
    public boolean shared() {
        return true;
    }

    @Override
    public boolean hasChanged() {
        return this.needSave;
    }

    @Override
    public final void clearChanged() {
        this.needSave = false;
    }

    @Override
    public String getId() {
        return this.item.getId();
    }

    @Override
    public void assign(ConfigurationAuxObject profileAuxObject) {
        if (!(profileAuxObject instanceof ItemConfiguration)) {
            System.err.println("Item - assign: Profile object type expected - got " + profileAuxObject);
            return;
        }
        ItemConfiguration i = (ItemConfiguration)profileAuxObject;
        if (!this.getId().equals(i.getItem().getId())) {
            System.err.println("Item - assign: Item ID " + this.getId() + " expected - got " + i.getItem().getId());
            return;
        }
        this.setConfiguration(i.getConfiguration());
        this.setItem(i.getItem());
        this.getExcluded().assign(i.getExcluded());
        this.setTool(i.getTool());
        switch (this.getTool()) {
            case Assembler: {
                this.getAssemblerConfiguration().assign(i.getAssemblerConfiguration());
                break;
            }
            case CCCompiler: {
                this.getCCCompilerConfiguration().assign(i.getCCCompilerConfiguration());
                if (!this.isProCFile()) break;
                this.getCustomToolConfiguration().assign(i.getCustomToolConfiguration());
                break;
            }
            case CCompiler: {
                this.getCCompilerConfiguration().assign(i.getCCompilerConfiguration());
                if (!this.isProCFile()) break;
                this.getCustomToolConfiguration().assign(i.getCustomToolConfiguration());
                break;
            }
            case CustomTool: {
                this.getCustomToolConfiguration().assign(i.getCustomToolConfiguration());
                break;
            }
            case FortranCompiler: {
                this.getFortranCompilerConfiguration().assign(i.getFortranCompilerConfiguration());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public void assignValues(ConfigurationAuxObject profileAuxObject) {
        if (!(profileAuxObject instanceof ItemConfiguration)) {
            System.err.println("Item - assign: Profile object type expected - got " + profileAuxObject);
            return;
        }
        ItemConfiguration i = (ItemConfiguration)profileAuxObject;
        this.getExcluded().assign(i.getExcluded());
        this.setTool(i.getTool());
        switch (this.getTool()) {
            case Assembler: {
                this.getAssemblerConfiguration().assign(i.getAssemblerConfiguration());
                break;
            }
            case CCCompiler: {
                this.getCCCompilerConfiguration().assign(i.getCCCompilerConfiguration());
                if (!this.isProCFile()) break;
                this.getCustomToolConfiguration().assign(i.getCustomToolConfiguration());
                break;
            }
            case CCompiler: {
                this.getCCompilerConfiguration().assign(i.getCCompilerConfiguration());
                if (!this.isProCFile()) break;
                this.getCustomToolConfiguration().assign(i.getCustomToolConfiguration());
                break;
            }
            case CustomTool: {
                this.getCustomToolConfiguration().assign(i.getCustomToolConfiguration());
                break;
            }
            case FortranCompiler: {
                this.getFortranCompilerConfiguration().assign(i.getFortranCompilerConfiguration());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public ItemConfiguration copy(MakeConfiguration makeConfiguration) {
        ItemConfiguration copy = new ItemConfiguration(makeConfiguration, this.getItem());
        copy.assign(this);
        copy.setConfiguration(makeConfiguration);
        return copy;
    }

    @Override
    public ItemConfiguration clone(Configuration conf) {
        ItemConfiguration i = new ItemConfiguration(conf, this.getItem());
        i.setExcluded(this.getExcluded().clone());
        i.setTool(this.getTool());
        switch (this.getTool()) {
            case Assembler: {
                i.setAssemblerConfiguration(this.getAssemblerConfiguration().clone());
                break;
            }
            case CCCompiler: {
                i.setCCCompilerConfiguration(this.getCCCompilerConfiguration().clone());
                if (!this.isProCFile()) break;
                i.setCustomToolConfiguration(this.getCustomToolConfiguration().clone());
                break;
            }
            case CCompiler: {
                i.setCCompilerConfiguration(this.getCCompilerConfiguration().clone());
                if (!this.isProCFile()) break;
                i.setCustomToolConfiguration(this.getCustomToolConfiguration().clone());
                break;
            }
            case CustomTool: {
                i.setCustomToolConfiguration(this.getCustomToolConfiguration().clone());
                break;
            }
            case FortranCompiler: {
                i.setFortranCompilerConfiguration(this.getFortranCompilerConfiguration().clone());
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return i;
    }

    @Override
    public XMLDecoder getXMLDecoder() {
        return new ItemXMLCodec(this);
    }

    @Override
    public XMLEncoder getXMLEncoder() {
        return new ItemXMLCodec(this);
    }

    @Override
    public void initialize() {
    }

    public Sheet getGeneralSheet() {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("Item");
        set.setDisplayName(ItemConfiguration.getString("ItemTxt"));
        set.setShortDescription(ItemConfiguration.getString("ItemHint"));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("NameTxt"), CndPathUtilitities.getBaseName((String)this.item.getPath())));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("FilePathTxt"), this.item.getPath()));
        String fullPath = CndPathUtilitities.toAbsolutePath((String)((MakeConfiguration)this.configuration).getBaseDir(), (String)this.item.getPath());
        String mdate = "";
        File itemFile = new File(fullPath);
        if (itemFile.exists()) {
            mdate = DateFormat.getDateInstance().format(new Date(itemFile.lastModified()));
            mdate = mdate + " " + DateFormat.getTimeInstance().format(new Date(itemFile.lastModified()));
        }
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("FullFilePathTxt"), fullPath));
        set.put((Node.Property)new StringRONodeProp(ItemConfiguration.getString("LastModifiedTxt"), mdate));
        sheet.put(set);
        set = new Sheet.Set();
        set.setName("ItemConfiguration");
        set.setDisplayName(ItemConfiguration.getString("ItemConfigurationTxt"));
        set.setShortDescription(ItemConfiguration.getString("ItemConfigurationHint"));
        if (this.getConfiguration() instanceof MakeConfiguration && ((MakeConfiguration)this.getConfiguration()).isMakefileConfiguration()) {
            set.put((Node.Property)new BooleanNodeProp(this.getExcluded(), true, "ExcludedFromBuild", ItemConfiguration.getString("ExcludedFromCodeAssistanceTxt"), ItemConfiguration.getString("ExcludedFromCodeAssistanceHint")));
        } else {
            set.put((Node.Property)new BooleanNodeProp(this.getExcluded(), true, "ExcludedFromBuild", ItemConfiguration.getString("ExcludedFromBuildTxt"), ItemConfiguration.getString("ExcludedFromBuildHint")));
        }
        set.put((Node.Property)new ToolNodeProp());
        sheet.put(set);
        return sheet;
    }

    public boolean isProCFile() {
        return ItemConfiguration.isProCFile(this.item, this.tool);
    }

    public static boolean isProCFile(Item item, PredefinedToolKind tool) {
        FileObject fileObject;
        return (tool == PredefinedToolKind.CCompiler || tool == PredefinedToolKind.CCCompiler) && item != null && (fileObject = item.getFileObject()) != null && "pc".equalsIgnoreCase(fileObject.getExt());
    }

    public String toString() {
        return this.getItem().getPath();
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(ItemConfiguration.class);
        }
        return bundle.getString(s);
    }

    private static class StringRONodeProp
    extends PropertySupport<String> {
        private String value;

        public StringRONodeProp(String name, String value) {
            super(name, String.class, name, name, true, false);
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String v) {
        }
    }

    private class ToolEditor
    extends PropertyEditorSupport {
        private ToolEditor() {
        }

        @Override
        public String getJavaInitializationString() {
            return this.getAsText();
        }

        @Override
        public String getAsText() {
            ToolKind val = (ToolKind)this.getValue();
            return val.getDisplayName();
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            this.setValue(PredefinedToolKind.getTool((String)text));
        }

        @Override
        public String[] getTags() {
            return ItemConfiguration.this.getToolNames();
        }
    }

    private class ToolNodeProp
    extends Node.Property<PredefinedToolKind> {
        public ToolNodeProp() {
            super(PredefinedToolKind.class);
        }

        public String getName() {
            return ItemConfiguration.getString("ToolTxt1");
        }

        public PredefinedToolKind getValue() {
            return ItemConfiguration.this.getTool();
        }

        public void setValue(PredefinedToolKind v) {
            ItemConfiguration.this.setTool(v);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            return new ToolEditor();
        }
    }
}

