/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.StringTokenizer;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.OptionsConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsEditorPanel;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;

public class OptionsNodeProp
extends PropertySupport<String> {
    private OptionsConfiguration commandLineConfiguration;
    private BooleanConfiguration inheritValues;
    private AllOptionsProvider optionsProvider;
    private AbstractCompiler compiler;
    private String delimiter = "";
    private String[] texts;

    public OptionsNodeProp(OptionsConfiguration commandLineConfiguration, BooleanConfiguration inheritValues, AllOptionsProvider optionsProvider, AbstractCompiler compiler, String delimiter, String[] texts) {
        super("ID", String.class, texts[0], texts[1], true, true);
        this.commandLineConfiguration = commandLineConfiguration;
        this.inheritValues = inheritValues;
        this.optionsProvider = optionsProvider;
        this.compiler = compiler;
        if (delimiter != null) {
            this.delimiter = delimiter;
        }
        this.texts = texts;
    }

    public String getHtmlDisplayName() {
        if (this.commandLineConfiguration.getModified()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public String getValue() {
        return this.commandLineConfiguration.getValue();
    }

    public void setValue(String v) {
        String s = CppUtils.reformatWhitespaces(v);
        this.commandLineConfiguration.setValue(s);
    }

    public PropertyEditor getPropertyEditor() {
        return new CommandLinePropEditor();
    }

    public void restoreDefaultValue() {
        this.commandLineConfiguration.optionsReset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return !this.commandLineConfiguration.getModified();
    }

    private class CommandLinePropEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv env;

        private CommandLinePropEditor() {
        }

        @Override
        public void setAsText(String text) {
            StringBuilder newText = new StringBuilder();
            if (OptionsNodeProp.this.delimiter.length() > 0) {
                StringTokenizer st = new StringTokenizer(text, OptionsNodeProp.this.delimiter);
                while (st.hasMoreTokens()) {
                    newText.append(st.nextToken());
                }
            } else {
                newText.append(text);
            }
            super.setValue(newText.toString());
        }

        @Override
        public String getAsText() {
            String s = (String)super.getValue();
            return CppUtils.reformatWhitespaces(s, "", OptionsNodeProp.this.delimiter);
        }

        @Override
        public Component getCustomEditor() {
            OptionsEditorPanel commandLineEditorPanel = new OptionsEditorPanel(OptionsNodeProp.this.texts, OptionsNodeProp.this.inheritValues, this, this.env);
            commandLineEditorPanel.setAllOptions(OptionsNodeProp.this.optionsProvider.getAllOptions((Tool)OptionsNodeProp.this.compiler));
            commandLineEditorPanel.setAdditionalOptions((String)super.getValue());
            return commandLineEditorPanel;
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }
}

