/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CancellationException;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileView;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.RemoteProjectImportWizard;
import org.netbeans.modules.cnd.makeproject.ui.wizards.RemoteProjectImportWizardPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SettingsPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.remote.api.ui.FileChooserBuilder;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.WindowManager;

final class RemoteProjectImportVisual
extends SettingsPanel
implements DocumentListener,
HelpCtx.Provider {
    public static final String PROP_PROJECT_NAME = "projectName";
    private volatile boolean initialized = false;
    private final RemoteProjectImportWizardPanel controller;
    private volatile RemotePathCheckState currentState = new RemotePathCheckState(null, "");
    private ExecutionEnvironment remoteHost;
    private static Map<ExecutionEnvironment, String> lastUsedDirs = new HashMap<ExecutionEnvironment, String>();
    private JButton browseLocalButton;
    private JButton browseRemoteButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JPanel localProjectPanel;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JTextField remoteProjectFolder;
    private JLabel remoteProjectFolderLabel;

    public RemoteProjectImportVisual(RemoteProjectImportWizardPanel controller) {
        this.initComponents();
        this.controller = controller;
        this.projectNameTextField.getDocument().addDocumentListener(this);
        this.projectLocationTextField.getDocument().addDocumentListener(this);
        this.remoteProjectFolder.getDocument().addDocumentListener(new RemoteProjectListener());
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.title");
    }

    private void initComponents() {
        this.remoteProjectFolderLabel = new JLabel();
        this.remoteProjectFolder = new JTextField();
        this.browseRemoteButton = new JButton();
        this.localProjectPanel = new JPanel();
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.projectLocationTextField = new JTextField();
        this.browseLocalButton = new JButton();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.remoteProjectFolderLabel.setLabelFor(this.remoteProjectFolder);
        Mnemonics.setLocalizedText((JLabel)this.remoteProjectFolderLabel, (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.remoteProjectFolderLabel.text"));
        this.remoteProjectFolder.setColumns(20);
        this.remoteProjectFolder.setText(NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.remoteProjectFolder.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.browseRemoteButton, (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.browseRemoteButton.text"));
        this.browseRemoteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteProjectImportVisual.this.browseRemoteButtonActionPerformed(evt);
            }
        });
        this.localProjectPanel.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.localProjectPanel.border.title")));
        this.projectNameLabel.setLabelFor(this.projectNameTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.projectNameLabel.text"));
        this.projectNameTextField.setColumns(20);
        this.projectLocationLabel.setLabelFor(this.projectLocationTextField);
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.projectLocationLabel.text"));
        this.projectLocationTextField.setColumns(20);
        Mnemonics.setLocalizedText((AbstractButton)this.browseLocalButton, (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.browseLocalButton.text"));
        this.browseLocalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoteProjectImportVisual.this.browseLocalButtonbrowseLocationAction(evt);
            }
        });
        this.createdFolderLabel.setLabelFor(this.createdFolderTextField);
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.createdFolderLabel.text"));
        this.createdFolderTextField.setColumns(20);
        this.createdFolderTextField.setEditable(false);
        GroupLayout localProjectPanelLayout = new GroupLayout(this.localProjectPanel);
        this.localProjectPanel.setLayout(localProjectPanelLayout);
        localProjectPanelLayout.setHorizontalGroup(localProjectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(localProjectPanelLayout.createSequentialGroup().addContainerGap().addGroup(localProjectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.createdFolderLabel, -1, -1, Short.MAX_VALUE).addComponent(this.projectLocationLabel, -1, -1, Short.MAX_VALUE).addComponent(this.projectNameLabel, -1, 151, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(localProjectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.createdFolderTextField, GroupLayout.Alignment.TRAILING).addComponent(this.projectLocationTextField, GroupLayout.Alignment.TRAILING).addComponent(this.projectNameTextField)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseLocalButton).addContainerGap()));
        localProjectPanelLayout.setVerticalGroup(localProjectPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(localProjectPanelLayout.createSequentialGroup().addGroup(localProjectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameTextField, -2, -1, -2).addComponent(this.projectNameLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(localProjectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationTextField, -2, -1, -2).addComponent(this.projectLocationLabel).addComponent(this.browseLocalButton)).addGap(5, 5, 5).addGroup(localProjectPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderTextField, -2, -1, -2).addComponent(this.createdFolderLabel)).addContainerGap(-1, Short.MAX_VALUE)));
        localProjectPanelLayout.linkSize(1, this.createdFolderTextField, this.projectLocationTextField, this.projectNameTextField);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.remoteProjectFolderLabel, -2, 178, -2).addGap(3, 3, 3).addComponent(this.remoteProjectFolder, -1, 222, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseRemoteButton).addGap(30, 30, 30)).addGroup(layout.createSequentialGroup().addComponent(this.localProjectPanel, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteProjectFolderLabel).addComponent(this.remoteProjectFolder, -2, -1, -2).addComponent(this.browseRemoteButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localProjectPanel, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void browseLocalButtonbrowseLocationAction(ActionEvent evt) {
        String path = this.projectLocationTextField.getText();
        FileChooser chooser = new FileChooser(NbBundle.getMessage(PanelProjectLocationVisual.class, (String)"LBL_NWP1_SelectProjectLocation"), null, 1, null, path, true);
        if (0 == chooser.showOpenDialog((Component)this)) {
            File projectDir = chooser.getSelectedFile();
            this.projectLocationTextField.setText(projectDir.getAbsolutePath());
        }
        this.controller.fireChangeEvent();
    }

    private void browseRemoteButtonActionPerformed(ActionEvent evt) {
        if (this.remoteHost != null) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private volatile String homeDir;

                public void doWork() {
                    if (ConnectionManager.getInstance().isConnectedTo(RemoteProjectImportVisual.this.remoteHost)) {
                        this.homeDir = (String)lastUsedDirs.get(RemoteProjectImportVisual.this.remoteHost);
                        if (this.homeDir == null) {
                            this.homeDir = RemoteProjectImportVisual.getRemoteProjectDir(RemoteProjectImportVisual.this.remoteHost);
                        }
                    }
                }

                public void doPostRunInEDT() {
                    String chooseRemoteFolder;
                    if (ConnectionManager.getInstance().isConnectedTo(RemoteProjectImportVisual.this.remoteHost) && (chooseRemoteFolder = RemoteProjectImportVisual.this.chooseRemoteFolder(this.homeDir)) != null) {
                        RemoteProjectImportVisual.this.remoteProjectFolder.setText(chooseRemoteFolder);
                        return;
                    }
                    RemoteProjectImportVisual.this.controller.fireChangeEvent();
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.comment.title");
            String msg = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.comment.message", (Object)this.remoteHost.getDisplayName());
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        }
        this.controller.fireChangeEvent();
    }

    private String chooseRemoteFolder(String homeDir) {
        Frame mainWindow = WindowManager.getDefault().getMainWindow();
        FileChooserBuilder.JFileChooserEx fileChooser = (FileChooserBuilder.JFileChooserEx)RemoteFileUtil.createFileChooser((ExecutionEnvironment)this.remoteHost, (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.title"), (String)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.open"), (int)1, null, (String)homeDir, (boolean)true);
        fileChooser.setFileView((FileView)new MyFileView((JFileChooser)fileChooser));
        int ret = fileChooser.showOpenDialog((Component)mainWindow);
        if (ret == 1) {
            return null;
        }
        FileObject remoteProjectFO = fileChooser.getSelectedFileObject();
        if (remoteProjectFO == null) {
            return null;
        }
        lastUsedDirs.put(this.remoteHost, remoteProjectFO.getParent().getPath());
        return remoteProjectFO.getPath();
    }

    private static String getRemoteProjectDir(ExecutionEnvironment env) {
        try {
            return HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getUserDir() + "/" + NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"DefaultProjectFolder");
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
        }
        catch (CancellationException ex) {
            ex.printStackTrace(System.err);
        }
        return null;
    }

    @Override
    void store(WizardDescriptor settings) {
        String projectName = this.projectNameTextField.getText().trim();
        String folder = this.createdFolderTextField.getText().trim();
        if (CndPathUtilitities.isPathAbsolute((CharSequence)folder)) {
            String localFolder = FileUtil.normalizePath((String)folder);
            settings.putProperty("projdir", (Object)CndFileUtils.createLocalFile((String)localFolder));
            RemoteProjectImportWizard.ImportedProject importProject = new RemoteProjectImportWizard.ImportedProject(this.remoteHost, this.remoteProjectFolder.getText().trim(), localFolder);
            settings.putProperty("RemoteImportedProjects", Collections.singleton(importProject));
        }
        settings.putProperty("name", (Object)projectName);
    }

    @Override
    void read(WizardDescriptor settings) {
        this.initialized = false;
        String hostUID = (String)settings.getProperty("hostUID");
        this.remoteHost = hostUID == null ? null : ExecutionEnvironmentFactory.fromUniqueID((String)hostUID);
        File projectLocation = (File)settings.getProperty("projdir");
        String projectName = null;
        if (projectLocation == null) {
            projectLocation = ProjectChooser.getProjectsFolder();
        } else {
            projectName = projectLocation.getName();
            projectLocation = projectLocation.getParentFile();
        }
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        this.initialized = true;
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        if (!this.initialized) {
            return false;
        }
        RemotePathCheckState curState = this.currentState;
        if (curState.checkingRemote == Boolean.TRUE) {
            settings.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"MSG_CheckingRemoteProject"));
            return false;
        }
        String errorMessage = null;
        if (this.remoteHost == null || !ConnectionManager.getInstance().isConnectedTo(this.remoteHost)) {
            errorMessage = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"MSG_RemoteHostIsNotConnected");
        } else if (this.remoteProjectFolder.getText().trim().isEmpty()) {
            errorMessage = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"MSG_EmptyRemoteProjectName");
        } else if (curState.checkingRemote == Boolean.FALSE) {
            errorMessage = curState.remoteCheckError;
        }
        if (errorMessage != null) {
            settings.putProperty("WizardPanel_errorMessage", (Object)errorMessage);
            return false;
        }
        if (!PanelProjectLocationVisual.isValidLocalProjectNameAndLocation(settings, this.projectNameTextField.getText(), this.projectLocationTextField.getText(), this.createdFolderTextField.getText())) {
            return false;
        }
        File destFolder = PanelProjectLocationVisual.getCanonicalFile(CndFileUtils.createLocalFile((String)this.createdFolderTextField.getText()).getAbsoluteFile());
        if (destFolder.exists()) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"MSG_LocalProjectAlreadyExists", (Object)this.createdFolderTextField.getText().trim()));
            return false;
        }
        return true;
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.update(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.update(e);
    }

    private void update(DocumentEvent e) {
        this.updateTexts(e);
        if (this.projectNameTextField.getDocument() == e.getDocument()) {
            this.firePropertyChange(PROP_PROJECT_NAME, null, this.projectNameTextField.getText());
        }
    }

    private void updateTexts(DocumentEvent e) {
        Document doc = e.getDocument();
        if (doc == this.projectNameTextField.getDocument() || doc == this.projectLocationTextField.getDocument()) {
            String projectName = this.projectNameTextField.getText().trim();
            String projectFolder = this.projectLocationTextField.getText().trim();
            while (projectFolder.endsWith("/")) {
                projectFolder = projectFolder.substring(0, projectFolder.length() - 1);
            }
            this.createdFolderTextField.setText(projectFolder + File.separatorChar + projectName);
        }
        this.controller.fireChangeEvent();
    }

    public HelpCtx getHelpCtx() {
        return RemoteProjectImportVisual.getHelpCtxImpl();
    }

    static HelpCtx getHelpCtxImpl() {
        return new HelpCtx("ImportRemoteProjectWizard");
    }

    private static final class MyFileView
    extends FileView
    implements Runnable {
        private final JFileChooser chooser;
        private final Map<File, Icon> knownProjectIcons = new HashMap<File, Icon>();
        private final RequestProcessor.Task task = new RequestProcessor("ProjectIconFileView").create((Runnable)this);
        private File lookingForIcon;

        public MyFileView(JFileChooser chooser) {
            this.chooser = chooser;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Icon getIcon(File f) {
            if (f.isDirectory() && !f.toString().matches("/[^/]+") && f.getParentFile() != null) {
                MyFileView myFileView = this;
                synchronized (myFileView) {
                    Icon icon = this.knownProjectIcons.get(f);
                    if (icon != null) {
                        return icon;
                    }
                    if (this.lookingForIcon == null) {
                        this.lookingForIcon = f;
                        this.task.schedule(20);
                    }
                }
            }
            return this.chooser.getFileSystemView().getSystemIcon(f);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String path = this.lookingForIcon.getAbsolutePath();
            String project = path + "/nbproject";
            File projectDir = this.chooser.getFileSystemView().createFileObject(project);
            Icon icon = this.chooser.getFileSystemView().getSystemIcon(this.lookingForIcon);
            if (projectDir.exists() && projectDir.isDirectory() && projectDir.canRead()) {
                String projectXml = path + "/nbproject/project.xml";
                File projectFile = this.chooser.getFileSystemView().createFileObject(projectXml);
                if (projectFile.exists()) {
                    String conf = path + "/nbproject/configurations.xml";
                    File configuration = this.chooser.getFileSystemView().createFileObject(conf);
                    if (configuration.exists()) {
                        icon = ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/makeproject/ui/resources/makeProject.gif", (boolean)true);
                    }
                }
            }
            MyFileView myFileView = this;
            synchronized (myFileView) {
                this.knownProjectIcons.put(this.lookingForIcon, icon);
                this.lookingForIcon = null;
            }
            this.chooser.repaint();
        }
    }

    private class RemoteProjectListener
    implements DocumentListener,
    Runnable {
        private final RequestProcessor.Task task = new RequestProcessor("Checking remote project folder", 1).create((Runnable)this);
        private RemotePathCheckState lastCheck = null;
        private String remotePath = "";
        private Color defColor = RemoteProjectImportVisual.access$800(RemoteProjectImportVisual.this).getForeground();

        private RemoteProjectListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        private void update() {
            String baseName;
            if (RemoteProjectImportVisual.this.remoteHost != null) {
                RemoteProjectImportVisual.this.currentState = new RemotePathCheckState(Boolean.TRUE, "");
                this.remotePath = RemoteProjectImportVisual.this.remoteProjectFolder.getText().trim();
                RemoteProjectImportVisual.this.remoteProjectFolder.setForeground(Color.red);
                this.task.schedule(10);
            }
            if ((baseName = CndPathUtilitities.getBaseName((String)this.remotePath)) != null && !baseName.isEmpty() && !baseName.endsWith("/")) {
                String prjName;
                String projectFolder = RemoteProjectImportVisual.this.projectLocationTextField.getText().trim();
                while (projectFolder.endsWith("/")) {
                    projectFolder = projectFolder.substring(0, projectFolder.length() - 1);
                }
                int index = 0;
                while (CndFileUtils.exists((File)new File(projectFolder, prjName = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.shadowName", (Object)baseName, (Object)(index++ == 0 ? "" : Integer.valueOf(index)))))) {
                }
                RemoteProjectImportVisual.this.projectNameTextField.setText(prjName);
            }
            RemoteProjectImportVisual.this.controller.fireChangeEvent();
        }

        @Override
        public void run() {
            if (SwingUtilities.isEventDispatchThread()) {
                RemotePathCheckState curStatus = this.lastCheck;
                if (curStatus.checkingRemote == null) {
                    RemoteProjectImportVisual.this.remoteProjectFolder.setForeground(this.defColor);
                }
                RemoteProjectImportVisual.this.currentState = curStatus;
                RemoteProjectImportVisual.this.controller.fireChangeEvent();
            } else {
                String msgError;
                String curRemotePath = this.remotePath;
                String prjDirName = CndPathUtilitities.getBaseName((String)curRemotePath);
                String dir = CndPathUtilitities.getDirName((String)curRemotePath);
                if (dir == null) {
                    prjDirName = "";
                }
                Boolean exists = null;
                try {
                    assert (RemoteProjectImportVisual.this.remoteHost != null);
                    ConnectionManager.getInstance().connectTo(RemoteProjectImportVisual.this.remoteHost);
                    if (HostInfoUtils.fileExists((ExecutionEnvironment)RemoteProjectImportVisual.this.remoteHost, (String)curRemotePath)) {
                        String conf = curRemotePath + "/nbproject/configurations.xml";
                        String projectXml = curRemotePath + "/nbproject/project.xml";
                        if (!HostInfoUtils.fileExists((ExecutionEnvironment)RemoteProjectImportVisual.this.remoteHost, (String)conf) || !HostInfoUtils.fileExists((ExecutionEnvironment)RemoteProjectImportVisual.this.remoteHost, (String)projectXml)) {
                            msgError = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.remotePathNotProject", (Object)prjDirName);
                            exists = Boolean.FALSE;
                        } else {
                            msgError = "";
                            exists = null;
                        }
                    } else {
                        msgError = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.remotePathNotExists", (Object)prjDirName);
                        exists = Boolean.FALSE;
                    }
                }
                catch (Throwable ex) {
                    exists = Boolean.FALSE;
                    msgError = NbBundle.getMessage(RemoteProjectImportVisual.class, (String)"RemoteProjectImportVisual.remotePathNotExistsError", (Object)prjDirName, (Object)ex.getMessage());
                }
                this.lastCheck = new RemotePathCheckState(exists, msgError);
                SwingUtilities.invokeLater(this);
            }
        }
    }

    private static final class RemotePathCheckState {
        private final Boolean checkingRemote;
        private final String remoteCheckError;

        private RemotePathCheckState(Boolean checking, String error) {
            this.checkingRemote = checking;
            this.remoteCheckError = error;
        }
    }
}

