/*
 * Decompiled with CFR 0.152.
 */
package ricoh.util.dom;

import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import ricoh.util.dom.DOMHandler;

public class DalpDOMHandler
extends DOMHandler {
    public static final String DEFAULT_DALP_VERSION_STR = "0.10";
    public static final String DEFAULT_BASEPATH = "current";
    public static final String DEFAULT_LOCATION = "jar";
    public static final String DSDK_VERSION_STR = "1.0";
    public static final String APP_VISIBLE_STR = "true";
    public static final String INSTALL_MODE = "manual";
    public static final String INSTALL_DEST = "hdd";
    public static final int DIGITS_IN_UID = 8;
    private String appName = null;
    private String appVersion = null;
    private String email = null;
    private String description = null;
    private String detailDescription = null;
    private String fax = null;
    private String iconPath = null;
    private String mainClass = null;
    private String phone = null;
    private String targetJar = null;
    private String uid = null;
    private String vendor = null;
    private String dalpSpecVer = null;
    private String seperator;

    public DalpDOMHandler() {
        this.setCompression(false);
    }

    public void setDalpSpecVersion(String ver) {
        this.dalpSpecVer = ver;
    }

    public String getDalpSpecVersion() {
        return this.dalpSpecVer;
    }

    public void setAppID(String uid) {
        this.uid = uid;
    }

    public String getAppID() {
        return this.uid;
    }

    public void setXletClass(String mainClass) {
        this.mainClass = mainClass;
    }

    public String getXletClass() {
        return this.mainClass;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public String getEmail() {
        return this.email;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public String getFax() {
        return this.fax;
    }

    public void setTelephone(String number) {
        this.phone = number;
    }

    public String getTelephone() {
        return this.phone;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String newName) {
        this.appName = newName;
    }

    public void setAppVersion(String newVer) {
        this.appVersion = newVer;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public void setIconPath(String iconPath) {
        this.iconPath = iconPath;
        this.seperator = iconPath.indexOf("/") == -1 ? "\\" : "/";
    }

    public void setTargetJar(String target) {
        this.targetJar = target;
    }

    public String getTargetJar() {
        return this.targetJar;
    }

    public boolean failRequiredInfo() {
        return !DalpDOMHandler.isValidUid(this.uid);
    }

    public static boolean isValidUid(String num) {
        if (num == null) {
            return false;
        }
        try {
            if (Integer.parseInt(num) < 0) {
                return false;
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    @Override
    public Document loadDocument(File xmlFile) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(xmlFile);
            return document;
        }
        catch (Exception pce) {
            pce.printStackTrace();
            return null;
        }
    }

    @Override
    public Document makeDocument() {
        if (this.failRequiredInfo()) {
            return null;
        }
        Element root = this.document.createElement("dalp");
        root.setAttribute("dsdk", "");
        root.setAttribute("version", DEFAULT_DALP_VERSION_STR);
        this.document.appendChild(root);
        Element informationTag = this.document.createElement("information");
        root.appendChild(informationTag);
        Element productId = this.document.createElement("product-id");
        productId.setTextContent(this.uid);
        informationTag.appendChild(productId);
        Element title = this.document.createElement("title");
        informationTag.appendChild(title);
        title.setTextContent(this.appName);
        Element vendorTag = this.document.createElement("vendor");
        informationTag.appendChild(vendorTag);
        vendorTag.setTextContent(this.vendor);
        if (this.iconPath != null && !this.iconPath.trim().equals("")) {
            Element iconTag = this.document.createElement("icon");
            informationTag.appendChild(iconTag);
            iconTag.setAttribute("href", "./" + this.targetJar + ".jar");
            iconTag.setAttribute("basepath", DEFAULT_BASEPATH);
            iconTag.setAttribute("location", DEFAULT_LOCATION);
            iconTag.setTextContent(this.iconPath.substring(this.iconPath.lastIndexOf(this.seperator) + 1));
        }
        Element descriptionTagA = this.document.createElement("description");
        Element descriptionTagB = this.document.createElement("description");
        informationTag.appendChild(descriptionTagA);
        informationTag.appendChild(descriptionTagB);
        descriptionTagA.setTextContent(this.description);
        descriptionTagB.setAttribute("type", "detail");
        descriptionTagB.setTextContent(this.detailDescription);
        Element telephoneTag = this.document.createElement("telephone");
        Element faxTag = this.document.createElement("fax");
        Element emailTag = this.document.createElement("e-mail");
        telephoneTag.setTextContent(this.phone);
        faxTag.setTextContent(this.fax);
        emailTag.setTextContent(this.email);
        informationTag.appendChild(telephoneTag);
        informationTag.appendChild(faxTag);
        informationTag.appendChild(emailTag);
        Element appVersionTag = this.document.createElement("application-ver");
        appVersionTag.setTextContent(this.appVersion);
        informationTag.appendChild(appVersionTag);
        Element allowOfflineTag = this.document.createElement("offline-allowed");
        informationTag.appendChild(allowOfflineTag);
        Element securityTag = this.document.createElement("security");
        root.appendChild(securityTag);
        Element allPermissions = this.document.createElement("all-permissions");
        securityTag.appendChild(allPermissions);
        Element resourcesTag = this.document.createElement("resources");
        root.appendChild(resourcesTag);
        Element dsdkTag = this.document.createElement("dsdk");
        dsdkTag.setAttribute("version", DSDK_VERSION_STR);
        resourcesTag.appendChild(dsdkTag);
        Element jarTag = this.document.createElement(DEFAULT_LOCATION);
        jarTag.setAttribute("href", "./" + this.targetJar + ".jar");
        jarTag.setAttribute("version", this.appVersion);
        jarTag.setAttribute("basepath", DEFAULT_BASEPATH);
        resourcesTag.appendChild(jarTag);
        Element encodeFileTag = this.document.createElement("encode-file");
        if (this.targetJar.contains(".jar")) {
            encodeFileTag.setTextContent(this.targetJar.substring(0, this.targetJar.indexOf(".jar")).toLowerCase());
        } else {
            encodeFileTag.setTextContent(this.targetJar.toLowerCase());
        }
        resourcesTag.appendChild(encodeFileTag);
        Element appDescTag = this.document.createElement("application-desc");
        appDescTag.setAttribute("main-class", this.mainClass);
        appDescTag.setAttribute("visible", APP_VISIBLE_STR);
        root.appendChild(appDescTag);
        Element installTag = this.document.createElement("install");
        installTag.setAttribute("mode", INSTALL_MODE);
        installTag.setAttribute("destination", INSTALL_DEST);
        root.appendChild(installTag);
        return this.document;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDetailDescription() {
        return this.detailDescription;
    }

    public void setDetailDescription(String detailDescription) {
        this.detailDescription = detailDescription;
    }
}

