/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.nodes;

import java.awt.Image;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.websvc.rest.model.api.HttpMethod;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.netbeans.modules.websvc.rest.model.api.RestServicesMetadata;
import org.netbeans.modules.websvc.rest.nodes.OpenCookieFactory;
import org.netbeans.modules.websvc.rest.nodes.ResourceUriProvider;
import org.netbeans.modules.websvc.rest.nodes.TestResourceUriAction;
import org.netbeans.modules.websvc.rest.support.Utils;
import org.openide.actions.OpenAction;
import org.openide.actions.PropertiesAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class HttpMethodNode
extends AbstractNode {
    private String methodName;
    private String produceMime;
    private String consumeMime;
    private String returnType;
    private MetadataModel<RestServicesMetadata> model;
    private static final Image METHOD_BADGE = ImageUtilities.loadImage((String)"org/netbeans/modules/websvc/rest/nodes/resources/method.png");

    public HttpMethodNode(Project project, RestServiceDescription restServiceDescription, HttpMethod httpMethod) {
        this(project, restServiceDescription, httpMethod, new InstanceContent());
    }

    private HttpMethodNode(Project project, RestServiceDescription restServiceDescription, HttpMethod httpMethod, InstanceContent instanceContent) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)instanceContent));
        this.methodName = httpMethod.getName();
        this.produceMime = httpMethod.getProduceMime();
        this.consumeMime = httpMethod.getConsumeMime();
        this.returnType = httpMethod.getReturnType();
        instanceContent.add((Object)this);
        if ("GET".equals(httpMethod.getType())) {
            instanceContent.add((Object)new MethodUriProvider(restServiceDescription.getUriTemplate(), httpMethod.getPath()));
        }
        instanceContent.add((Object)project);
        instanceContent.add((Object)OpenCookieFactory.create(project, restServiceDescription.getClassName(), this.methodName));
    }

    public String getDisplayName() {
        return this.methodName + "() : " + Utils.stripPackageName(this.returnType);
    }

    public String getShortDescription() {
        String string = "";
        if (this.consumeMime.length() > 0) {
            string = string + "@ConsumeMime(\"" + this.consumeMime + "\") ";
        }
        if (this.produceMime.length() > 0) {
            string = string + "@ProduceMime(\"" + this.produceMime + "\") ";
        }
        return string;
    }

    public String getKey() {
        return this.methodName + ":" + this.returnType + ":" + this.consumeMime + ":" + this.produceMime;
    }

    public Image getIcon(int n) {
        return METHOD_BADGE;
    }

    void changeIcon() {
        this.fireIconChange();
    }

    public Image getOpenedIcon(int n) {
        return this.getIcon(n);
    }

    public Action getPreferredAction() {
        return SystemAction.get(OpenAction.class);
    }

    public Action[] getActions(boolean bl) {
        return new SystemAction[]{SystemAction.get(OpenAction.class), SystemAction.get(TestResourceUriAction.class), null, SystemAction.get(PropertiesAction.class)};
    }

    private class MethodUriProvider
    implements ResourceUriProvider {
        private String resourcePath;
        private String methodPath;

        private MethodUriProvider(String string, String string2) {
            this.resourcePath = string;
            this.methodPath = string2;
        }

        @Override
        public String getResourceUri() {
            if (this.methodPath == null || this.methodPath.length() == 0) {
                return this.resourcePath;
            }
            if (this.methodPath.startsWith("/")) {
                return this.resourcePath + this.methodPath;
            }
            return this.resourcePath + "/" + this.methodPath;
        }
    }
}

