/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.groups;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.groups.AdHocGroup;
import org.netbeans.modules.project.ui.groups.DirectoryGroup;
import org.netbeans.modules.project.ui.groups.Group;
import org.netbeans.modules.project.ui.groups.SubprojectsGroup;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class NewGroupPanel
extends JPanel {
    public static final String PROP_READY = "ready";
    private NotificationLineSupport notificationLineSupport;
    private JLabel adHocKindLabel;
    private JRadioButton adHocKindRadio;
    private JCheckBox autoSynchCheckbox;
    private JButton directoryButton;
    private JTextField directoryField;
    private JLabel directoryKindLabel;
    private JRadioButton directoryKindRadio;
    private JLabel directoryLabel;
    private ButtonGroup kindButtonGroup;
    private JButton masterProjectButton;
    private JTextField masterProjectField;
    private JLabel masterProjectLabel;
    private JTextField nameField;
    private JLabel nameLabel;
    private JLabel subprojectsKindLabel;
    private JRadioButton subprojectsKindRadio;
    private JCheckBox useOpenCheckbox;

    public NewGroupPanel() {
        this.initComponents();
        DocumentListener l = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                NewGroupPanel.this.firePropertyChange(NewGroupPanel.PROP_READY, null, null);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                NewGroupPanel.this.firePropertyChange(NewGroupPanel.PROP_READY, null, null);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        this.directoryField.getDocument().addDocumentListener(l);
        this.nameField.getDocument().addDocumentListener(l);
        this.updateNameField();
    }

    public boolean isReady() {
        if (this.adHocKindRadio.isSelected()) {
            return this.nameField.getText() != null && this.nameField.getText().trim().length() > 0;
        }
        if (this.subprojectsKindRadio.isSelected()) {
            File f;
            FileObject fo;
            String s = this.masterProjectField.getText();
            if (s != null && s.length() > 0 && (fo = FileUtil.toFileObject((File)(f = new File(s)))) != null && fo.isFolder()) {
                try {
                    return ProjectManager.getDefault().findProject(fo) != null;
                }
                catch (IOException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
            return false;
        }
        assert (this.directoryKindRadio.isSelected());
        if (this.nameField.getText() == null || this.nameField.getText().trim().length() == 0) {
            return false;
        }
        String s = this.directoryField.getText();
        if (s != null) {
            return new File(s.trim()).isDirectory();
        }
        return false;
    }

    private void updateNameField() {
        String s;
        if (this.adHocKindRadio.isSelected() && this.useOpenCheckbox.isSelected()) {
            Project p = OpenProjects.getDefault().getMainProject();
            if (p != null && this.nameField.getText().length() == 0) {
                this.nameField.setText(ProjectUtils.getInformation((Project)p).getDisplayName());
            }
        } else if (this.subprojectsKindRadio.isSelected()) {
            File f;
            FileObject fo;
            String s2 = this.masterProjectField.getText();
            if (s2 != null && s2.length() > 0 && (fo = FileUtil.toFileObject((File)(f = new File(s2)))) != null && fo.isFolder()) {
                try {
                    Project p = ProjectManager.getDefault().findProject(fo);
                    if (p != null && this.nameField.getText().length() == 0) {
                        this.nameField.setText(ProjectUtils.getInformation((Project)p).getDisplayName());
                    }
                }
                catch (IOException x) {
                    Exceptions.printStackTrace((Throwable)x);
                }
            }
        } else if (this.directoryKindRadio.isSelected() && (s = this.directoryField.getText()) != null && s.length() > 0 && this.nameField.getText().length() == 0) {
            File f = new File(s);
            this.nameField.setText(f.getName());
        }
    }

    public Group create() {
        assert (this.isReady());
        if (this.adHocKindRadio.isSelected()) {
            AdHocGroup g = AdHocGroup.create(this.nameField.getText().trim(), this.autoSynchCheckbox.isSelected());
            if (this.useOpenCheckbox.isSelected()) {
                g.setProjects(new HashSet<Project>(Arrays.asList(OpenProjects.getDefault().getOpenProjects())));
                g.setMainProject(OpenProjects.getDefault().getMainProject());
            }
            return g;
        }
        if (this.subprojectsKindRadio.isSelected()) {
            FileObject fo = FileUtil.toFileObject((File)new File(this.masterProjectField.getText()));
            try {
                return SubprojectsGroup.create(this.nameField.getText().trim(), ProjectManager.getDefault().findProject(fo));
            }
            catch (IOException x) {
                throw new AssertionError((Object)x);
            }
        }
        assert (this.directoryKindRadio.isSelected());
        FileObject f = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(this.directoryField.getText().trim())));
        try {
            return DirectoryGroup.create(this.nameField.getText().trim(), f);
        }
        catch (FileStateInvalidException x) {
            throw new AssertionError((Object)x);
        }
    }

    private void initComponents() {
        this.kindButtonGroup = new ButtonGroup();
        this.adHocKindRadio = new JRadioButton();
        this.adHocKindLabel = new JLabel();
        this.useOpenCheckbox = new JCheckBox();
        this.autoSynchCheckbox = new JCheckBox();
        this.subprojectsKindRadio = new JRadioButton();
        this.subprojectsKindLabel = new JLabel();
        this.masterProjectLabel = new JLabel();
        this.masterProjectField = new JTextField();
        this.masterProjectButton = new JButton();
        this.directoryKindRadio = new JRadioButton();
        this.directoryKindLabel = new JLabel();
        this.directoryLabel = new JLabel();
        this.directoryField = new JTextField();
        this.directoryButton = new JButton();
        this.nameLabel = new JLabel();
        this.nameField = new JTextField();
        this.kindButtonGroup.add(this.adHocKindRadio);
        this.adHocKindRadio.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.adHocKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindRadio.text"));
        this.adHocKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.adHocKindRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.adHocKindRadioActionPerformed(evt);
            }
        });
        this.adHocKindLabel.setLabelFor(this.adHocKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.adHocKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindLabel.text"));
        this.useOpenCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.useOpenCheckbox, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.useOpenCheckbox.text"));
        this.useOpenCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.useOpenCheckboxActionPerformed(evt);
            }
        });
        this.autoSynchCheckbox.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.autoSynchCheckbox, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.autoSynchCheckbox.text"));
        this.kindButtonGroup.add(this.subprojectsKindRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.subprojectsKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindRadio.text"));
        this.subprojectsKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.subprojectsKindRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.subprojectsKindRadioActionPerformed(evt);
            }
        });
        this.subprojectsKindLabel.setLabelFor(this.subprojectsKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.subprojectsKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindLabel.text"));
        this.subprojectsKindLabel.setEnabled(false);
        this.masterProjectLabel.setLabelFor(this.masterProjectField);
        Mnemonics.setLocalizedText((JLabel)this.masterProjectLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectLabel.text"));
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEditable(false);
        this.masterProjectField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.masterProjectButton, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectButton.text"));
        this.masterProjectButton.setEnabled(false);
        this.masterProjectButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.masterProjectButtonActionPerformed(evt);
            }
        });
        this.kindButtonGroup.add(this.directoryKindRadio);
        Mnemonics.setLocalizedText((AbstractButton)this.directoryKindRadio, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindRadio.text"));
        this.directoryKindRadio.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.directoryKindRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.directoryKindRadioActionPerformed(evt);
            }
        });
        this.directoryKindLabel.setLabelFor(this.directoryKindRadio);
        Mnemonics.setLocalizedText((JLabel)this.directoryKindLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindLabel.text"));
        this.directoryKindLabel.setEnabled(false);
        this.directoryLabel.setLabelFor(this.directoryField);
        Mnemonics.setLocalizedText((JLabel)this.directoryLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryLabel.text"));
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        Mnemonics.setLocalizedText((AbstractButton)this.directoryButton, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryButton.text"));
        this.directoryButton.setEnabled(false);
        this.directoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewGroupPanel.this.directoryButtonActionPerformed(evt);
            }
        });
        this.nameLabel.setLabelFor(this.nameField);
        Mnemonics.setLocalizedText((JLabel)this.nameLabel, (String)NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.nameLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.nameLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nameField, -1, 684, Short.MAX_VALUE)).addComponent(this.directoryKindRadio).addComponent(this.adHocKindRadio).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.directoryLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryField, -1, 554, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryButton)).addComponent(this.directoryKindLabel))).addComponent(this.subprojectsKindRadio).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.masterProjectLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.masterProjectField, -1, 495, Short.MAX_VALUE)).addComponent(this.subprojectsKindLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.masterProjectButton)).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addComponent(this.adHocKindLabel)).addGroup(layout.createSequentialGroup().addGap(17, 17, 17).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.autoSynchCheckbox).addComponent(this.useOpenCheckbox)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameLabel).addComponent(this.nameField, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.adHocKindRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.adHocKindLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.useOpenCheckbox, -2, 23, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.autoSynchCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subprojectsKindRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subprojectsKindLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.masterProjectLabel).addComponent(this.masterProjectButton).addComponent(this.masterProjectField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryKindRadio).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.directoryKindLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.directoryLabel).addComponent(this.directoryField, -2, -1, -2).addComponent(this.directoryButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.adHocKindRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindRadio.AccessibleContext.accessibleDescription"));
        this.adHocKindLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.adHocKindLabel.AccessibleContext.accessibleDescription"));
        this.useOpenCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.useOpenCheckbox.AccessibleContext.accessibleDescription"));
        this.autoSynchCheckbox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.autoSynchCheckbox.AccessibleContext.accessibleDescription"));
        this.subprojectsKindRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindRadio.AccessibleContext.accessibleDescription"));
        this.subprojectsKindLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.subprojectsKindLabel.AccessibleContext.accessibleDescription"));
        this.masterProjectLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectLabel.AccessibleContext.accessibleDescription"));
        this.masterProjectField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectField.AccessibleContext.accessibleName"));
        this.masterProjectField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectField.AccessibleContext.accessibleDescription"));
        this.masterProjectButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.masterProjectButton.AccessibleContext.accessibleDescription"));
        this.directoryKindRadio.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindRadio.AccessibleContext.accessibleDescription"));
        this.directoryKindLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryKindLabel.AccessibleContext.accessibleDescription"));
        this.directoryLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryLabel.AccessibleContext.accessibleDescription"));
        this.directoryField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryField.AccessibleContext.accessibleName"));
        this.directoryField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryField.AccessibleContext.accessibleDescription"));
        this.directoryButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.directoryButton.AccessibleContext.accessibleDescription"));
        this.nameLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.nameLabel.AccessibleContext.accessibleDescription"));
        this.nameField.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.nameField.AccessibleContext.accessibleName"));
        this.nameField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.nameField.AccessibleContext.accessibleDescription"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.AccessibleContext.accessibleName"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.AccessibleContext.accessibleDescription"));
    }

    private void directoryButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        chooser.setMultiSelectionEnabled(false);
        File start = ProjectChooser.getProjectsFolder();
        if (this.directoryField.getText() != null && this.directoryField.getText().trim().length() > 0) {
            start = new File(this.directoryField.getText().trim());
        }
        FileUtil.preventFileChooserSymlinkTraversal((JFileChooser)chooser, (File)start);
        if (chooser.showOpenDialog(this) == 0 && (f = chooser.getSelectedFile()) != null) {
            this.directoryField.setText(f.getAbsolutePath());
            this.updateNameField();
        }
    }

    private void masterProjectButtonActionPerformed(ActionEvent evt) {
        File f;
        JFileChooser chooser = ProjectChooser.projectChooser();
        if (chooser.showOpenDialog(this) == 0 && (f = chooser.getSelectedFile()) != null) {
            this.masterProjectField.setText(f.getAbsolutePath());
            this.updateNameField();
            this.firePropertyChange(PROP_READY, null, null);
        }
    }

    private void directoryKindRadioActionPerformed(ActionEvent evt) {
        this.adHocKindLabel.setEnabled(false);
        this.useOpenCheckbox.setEnabled(false);
        this.autoSynchCheckbox.setEnabled(false);
        this.subprojectsKindLabel.setEnabled(false);
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEnabled(false);
        this.masterProjectButton.setEnabled(false);
        this.directoryKindLabel.setEnabled(true);
        this.directoryLabel.setEnabled(true);
        this.directoryField.setEnabled(true);
        this.directoryButton.setEnabled(true);
        this.updateNameField();
        this.firePropertyChange(PROP_READY, null, null);
        this.updateExistingProjectListWarning();
    }

    private void subprojectsKindRadioActionPerformed(ActionEvent evt) {
        this.adHocKindLabel.setEnabled(false);
        this.useOpenCheckbox.setEnabled(false);
        this.autoSynchCheckbox.setEnabled(false);
        this.subprojectsKindLabel.setEnabled(true);
        this.masterProjectLabel.setEnabled(true);
        this.masterProjectField.setEnabled(true);
        this.masterProjectButton.setEnabled(true);
        this.directoryKindLabel.setEnabled(false);
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        this.directoryButton.setEnabled(false);
        this.updateNameField();
        this.firePropertyChange(PROP_READY, null, null);
        this.updateExistingProjectListWarning();
    }

    private void adHocKindRadioActionPerformed(ActionEvent evt) {
        this.adHocKindLabel.setEnabled(true);
        this.useOpenCheckbox.setEnabled(true);
        this.autoSynchCheckbox.setEnabled(true);
        this.subprojectsKindLabel.setEnabled(false);
        this.masterProjectLabel.setEnabled(false);
        this.masterProjectField.setEnabled(false);
        this.masterProjectButton.setEnabled(false);
        this.directoryKindLabel.setEnabled(false);
        this.directoryLabel.setEnabled(false);
        this.directoryField.setEnabled(false);
        this.directoryButton.setEnabled(false);
        this.updateNameField();
        this.firePropertyChange(PROP_READY, null, null);
        this.updateExistingProjectListWarning();
    }

    private void useOpenCheckboxActionPerformed(ActionEvent evt) {
        this.updateExistingProjectListWarning();
    }

    void setNotificationLineSupport(NotificationLineSupport notificationLineSupport) {
        this.notificationLineSupport = notificationLineSupport;
    }

    private void updateExistingProjectListWarning() {
        if (this.adHocKindRadio.isSelected() && this.useOpenCheckbox.isSelected() || OpenProjects.getDefault().getOpenProjects().length == 0) {
            this.notificationLineSupport.clearMessages();
        } else {
            this.notificationLineSupport.setWarningMessage(NbBundle.getMessage(NewGroupPanel.class, (String)"NewGroupPanel.open_project_warning"));
        }
    }
}

