/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.util;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.websvc.saas.model.SaasServicesModel;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlData;
import org.netbeans.modules.websvc.saas.spi.websvcmgr.WsdlDataManager;
import org.netbeans.modules.websvc.saas.util.SaasUtil;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class WsdlUtil {
    private static final String IMPORTED_MARK = ".imported";

    private static WsdlDataManager getWsdlDataManager() {
        WsdlDataManager wsdlDataManager = null;
        int precedence = 0;
        boolean first = true;
        Collection mgrs = Lookup.getDefault().lookupAll(WsdlDataManager.class);
        for (WsdlDataManager mgr : mgrs) {
            if (first) {
                first = false;
                precedence = mgr.getPrecedence();
                wsdlDataManager = mgr;
                continue;
            }
            int newPrecedence = mgr.getPrecedence();
            if (newPrecedence >= precedence) continue;
            wsdlDataManager = mgr;
            precedence = newPrecedence;
        }
        return wsdlDataManager;
    }

    public static boolean hasWsdlSupport() {
        return WsdlUtil.getWsdlDataManager() != null;
    }

    public static WsdlData findWsdlData(String url, String serviceName) {
        WsdlDataManager manager = WsdlUtil.getWsdlDataManager();
        if (manager != null) {
            return manager.findWsdlData(url, serviceName);
        }
        return null;
    }

    public static WsdlData addWsdlData(String url, String packageName) {
        WsdlDataManager manager = WsdlUtil.getWsdlDataManager();
        if (manager != null) {
            return manager.addWsdlData(url, packageName);
        }
        return null;
    }

    public static WsdlData getWsdlData(String url, String serviceName, boolean synchronous) {
        WsdlDataManager manager = WsdlUtil.getWsdlDataManager();
        if (manager != null) {
            return manager.getWsdlData(url, serviceName, synchronous);
        }
        return null;
    }

    public static void removeWsdlData(WsdlData data) {
        WsdlDataManager manager = WsdlUtil.getWsdlDataManager();
        if (manager != null) {
            manager.removeWsdlData(data.getOriginalWsdlUrl(), data.getName());
        }
    }

    public static void removeWsdlData(String url) {
        WsdlDataManager manager = WsdlUtil.getWsdlDataManager();
        if (manager != null) {
            manager.removeWsdlData(url, null);
        }
    }

    public static void refreshWsdlData(WsdlData data) {
        WsdlDataManager manager = WsdlUtil.getWsdlDataManager();
        if (manager != null) {
            manager.refresh(data);
        }
    }

    public static boolean isJAXRPCAvailable() {
        return WsdlUtil.getWebServiceSupportLibDef(false) != null;
    }

    public static Library getWebServiceSupportLibDef(boolean isJ2EE_15) {
        String libraryName = isJ2EE_15 ? "jaxws21" : "jaxrpc16";
        Library libDef = LibraryManager.getDefault().getLibrary(libraryName);
        return libDef;
    }

    public static String getCatalogForWsdl(String wsdlUrl) {
        String serviceDir = WsdlUtil.getServiceDirName(wsdlUrl);
        return "/" + serviceDir + "/catalog/catalog.xml";
    }

    public static String getServiceDirName(String wsdlUrl) {
        try {
            int start;
            URL url = new URL(wsdlUrl);
            String urlPath = url.getPath();
            if (url.getProtocol().toLowerCase().startsWith("file")) {
                start = urlPath.lastIndexOf(System.getProperty("path.separator"));
                start = start < 0 ? urlPath.lastIndexOf("/") : start;
            } else {
                if (urlPath.endsWith("/")) {
                    urlPath = urlPath.substring(0, urlPath.length() - 1);
                }
                start = urlPath.lastIndexOf("/");
            }
            return urlPath.substring(++start).replace('.', '-');
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return SaasUtil.ensureUniqueServiceDirName("Service");
        }
    }

    public static boolean hasProcessedImport() {
        return SaasServicesModel.getWebServiceHome().getFileObject(IMPORTED_MARK) != null;
    }

    public static void markImportProcessed() {
        if (!WsdlUtil.hasProcessedImport()) {
            try {
                SaasServicesModel.getWebServiceHome().createData(IMPORTED_MARK);
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public static void ensureImportExisting60Services() {
        if (!WsdlUtil.hasProcessedImport()) {
            WsdlUtil.findWsdlData("/foo", "bar");
        }
    }
}

