/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.CancellationException;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettings;
import org.netbeans.modules.cnd.debugger.common2.debugger.DebuggerSettingsBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebuggerInfo;
import org.netbeans.modules.cnd.debugger.common2.debugger.debugtarget.DebugTarget;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.DbgProfile;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Pathmap;
import org.netbeans.modules.cnd.debugger.common2.debugger.options.Signals;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerImpl;
import org.netbeans.modules.cnd.debugger.gdb2.GdbDebuggerSettings;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;

public final class GdbDebuggerSettingsBridge
extends DebuggerSettingsBridge {
    private final GdbDebuggerImpl gdbDebugger;
    private Pathmap.Item[] shadowPathmap = null;

    public GdbDebuggerSettingsBridge(NativeDebugger debugger) {
        super(debugger, (DebuggerSettings)new GdbDebuggerSettings());
        this.gdbDebugger = (GdbDebuggerImpl)debugger;
    }

    protected DebuggerSettings createSettingsFromTarget(DebugTarget dt) {
        RunProfile newRunProfile = dt.getRunProfile();
        DbgProfile newDbgProfile = dt.getDbgProfile();
        return GdbDebuggerSettings.create(newRunProfile, newDbgProfile);
    }

    protected void setTentativeSettings(NativeDebuggerInfo info) {
        RunProfile newRunProfile = info.getProfile();
        DbgProfile newDbgProfile = info.getDbgProfile();
        assert (newRunProfile != null);
        String exename = info.getTarget();
        this.assignTentativeSettings(GdbDebuggerSettings.create(newRunProfile, newDbgProfile), exename);
    }

    protected void applyPathmap(Pathmap o, Pathmap n) {
        if (o == null) {
            this.shadowPathmap = new Pathmap.Item[0];
            this.applyPathmap(this.shadowPathmap, n.getPathmap());
        } else {
            this.applyPathmap(o.getPathmap(), n.getPathmap());
        }
    }

    private void applyPathmap(Pathmap.Item[] oldMap, Pathmap.Item[] newMap) {
        int i;
        if (oldMap != null) {
            for (i = 0; i < oldMap.length; ++i) {
                if (newMap != null) {
                    int j;
                    for (j = 0; !(j >= newMap.length || newMap[j].from().equals(oldMap[i].from()) && IpeUtils.sameString((String)newMap[j].to(), (String)oldMap[i].to())); ++j) {
                    }
                    if (j < newMap.length) continue;
                }
                this.gdbDebugger.pathmap("unset substitute-path " + oldMap[i].from());
            }
        }
        if (newMap != null) {
            for (i = 0; i < newMap.length; ++i) {
                if (oldMap != null) {
                    int j;
                    for (j = 0; !(j >= oldMap.length || newMap[i].from().equals(oldMap[j].from()) && IpeUtils.sameString((String)newMap[i].to(), (String)oldMap[j].to())); ++j) {
                    }
                    if (j < oldMap.length) continue;
                }
                String pathmap = null;
                pathmap = "set substitute-path " + newMap[i].from();
                if (newMap[i].to() != null) {
                    pathmap = pathmap + " " + newMap[i].to();
                }
                this.gdbDebugger.pathmap(pathmap);
            }
        }
    }

    protected void applyRunargs() {
        String runargs = this.getArgsFlatEx();
        if (runargs == null) {
            runargs = "";
        }
        this.gdbDebugger.runArgs(runargs + this.ioRedirect());
    }

    protected void applyRunDirectory() {
        RunProfile mainRunProfile = this.getMainSettings().runProfile();
        if (mainRunProfile.getRunDirectory() != null) {
            this.gdbDebugger.runDir(mainRunProfile.getRunDirectory());
        }
    }

    protected void applyClasspath() {
    }

    protected void applyEnvvars() {
        MacroMap macroMap = MacroMap.createEmpty((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment());
        RunProfile mainRunProfile = this.getMainSettings().runProfile();
        macroMap.putAll(mainRunProfile.getEnvironment().getenvAsMap());
        this.gdbDebugger.getIOPack().updateEnv(macroMap);
        for (Map.Entry entry : macroMap.entrySet()) {
            this.gdbDebugger.setEnv((String)entry.getKey() + '=' + (String)entry.getValue());
        }
    }

    protected void applySignals(Signals o, Signals n) {
    }

    protected void applyInterceptList() {
    }

    private String ioRedirect() {
        String shell;
        String[] files = this.gdbDebugger.getIOPack().getIOFiles();
        if (files == null) {
            return "";
        }
        HostInfo.OSFamily osFamily = HostInfo.OSFamily.UNKNOWN;
        try {
            HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment());
            osFamily = hostInfo.getOSFamily();
        }
        catch (CancellationException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        String inRedir = "";
        String inFile = files[0];
        String outFile = files[1];
        if (osFamily == HostInfo.OSFamily.WINDOWS) {
            inFile = this.gdbDebugger.fmap().worldToEngine(inFile);
            outFile = this.gdbDebugger.fmap().worldToEngine(outFile);
        }
        inRedir = osFamily == HostInfo.OSFamily.MACOSX ? " < " + inFile + " > " + outFile + " 2> " + outFile : ((shell = (String)HostInfoProvider.getEnv((ExecutionEnvironment)this.gdbDebugger.getExecutionEnvironment()).get("SHELL")) != null && shell.endsWith("csh") ? " < " + inFile + " >& " + outFile : " < " + inFile + " > " + outFile + " 2>&1");
        return inRedir;
    }
}

