/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.xref.impl;

import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunctionDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceKind;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.xref.impl.ObjectReferenceImpl;

public class ReferenceSupportImpl {
    public CsmReference createObjectReference(CsmOffsetable obj) {
        return this.createObjectReference((CsmObject)obj, obj);
    }

    public CsmReference createObjectReference(CsmObject target, CsmOffsetable owner) {
        int start = this.getStartRefenceOffset(owner);
        int end = this.getEndReferenceOffset(owner);
        CsmUID<CsmObject> targetUID = target != null ? this.getUID(target) : null;
        CsmUID<CsmOffsetable> ownerUID = this.getUID(owner);
        CsmUID<CsmFile> fileUID = this.getUID(owner.getContainingFile());
        CsmReferenceKind kind = this.getObjectKind(target, (CsmObject)owner);
        CsmObject top = CsmBaseUtilities.findClosestTopLevelObject((CsmObject)owner);
        CsmUID<CsmObject> topUID = this.getUID(top);
        return new ObjectReferenceImpl(targetUID, ownerUID, topUID, fileUID, kind, start, end);
    }

    private CsmReferenceKind getObjectKind(CsmObject target, CsmObject owner) {
        CsmReferenceKind kind = CsmReferenceKind.UNKNOWN;
        if (target == null && CsmKindUtilities.isInclude((CsmObject)owner)) {
            kind = CsmReferenceKind.DIRECT_USAGE;
        } else if (CsmKindUtilities.isFile((CsmObject)target)) {
            kind = CsmReferenceKind.DIRECT_USAGE;
        } else if (target != null) {
            if (owner != null && !owner.equals(target)) {
                CsmObject[] decDef = CsmBaseUtilities.getDefinitionDeclaration((CsmObject)target, (boolean)true);
                CsmObject targetDecl = decDef[0];
                CsmObject targetDef = decDef[1];
                kind = CsmReferenceKind.DIRECT_USAGE;
                if (owner.equals(targetDef)) {
                    kind = CsmReferenceKind.DEFINITION;
                } else if (CsmReferenceSupport.sameDeclaration(owner, targetDecl)) {
                    kind = CsmReferenceKind.DECLARATION;
                }
            } else {
                kind = CsmReferenceKind.DECLARATION;
                if (CsmKindUtilities.isFunctionDefinition((CsmObject)target) || CsmKindUtilities.isVariableDefinition((CsmObject)target)) {
                    kind = CsmReferenceKind.DEFINITION;
                }
            }
        }
        return kind;
    }

    private int getStartRefenceOffset(CsmOffsetable obj) {
        return obj.getStartOffset();
    }

    private int getEndReferenceOffset(CsmOffsetable obj) {
        int end = obj.getEndOffset();
        if (CsmKindUtilities.isClass((CsmObject)obj)) {
            end = ((CsmClass)obj).getLeftBracketOffset();
        } else if (CsmKindUtilities.isFunctionDefinition((CsmObject)obj) && ((CsmFunctionDefinition)obj).getBody() != null) {
            end = ((CsmFunctionDefinition)obj).getBody().getStartOffset();
        }
        return end;
    }

    public <T extends CsmObject> CsmUID<T> getUID(T element) {
        return UIDs.get(element);
    }
}

