/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassForwardDeclaration;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriendClass;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.modelimpl.csm.AstRendererException;
import org.netbeans.modules.cnd.modelimpl.csm.ClassForwardDeclarationImpl;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.TemplateUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableDeclarationBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.openide.util.CharSequences;

public final class FriendClassImpl
extends OffsetableDeclarationBase<CsmFriendClass>
implements CsmFriendClass,
CsmTemplate {
    private final CharSequence name;
    private final CharSequence[] nameParts;
    private final CsmUID<CsmClass> parentUID;
    private final CsmUID<CsmClassForwardDeclaration> classForwardUID;
    private CsmUID<CsmClass> friendUID;
    private TemplateDescriptor templateDescriptor = null;
    private int lastParseCount = -1;
    private int lastFileID = -1;

    private FriendClassImpl(AST aST, AST aST2, CsmClassForwardDeclaration csmClassForwardDeclaration, FileImpl fileImpl, CsmClass csmClass, boolean bl) throws AstRendererException {
        super(aST, fileImpl);
        this.parentUID = UIDs.get((Object)csmClass);
        AST aST3 = aST2 = aST2 != null ? aST2 : AstUtil.findSiblingOfType(aST, 503);
        if (aST2 == null) {
            throw new AstRendererException(fileImpl, this.getStartOffset(), "Invalid friend class declaration.");
        }
        this.name = QualifiedNameCache.getManager().getString(AstRenderer.getQualifiedName(aST2));
        this.nameParts = this.initNameParts(aST2);
        this.classForwardUID = UIDCsmConverter.declarationToUID(csmClassForwardDeclaration);
        AST aST4 = AstUtil.findSiblingOfType(aST, 115);
        if (aST4 != null) {
            List<CsmTemplateParameter> list = TemplateUtils.getTemplateParameters(aST4, fileImpl, (CsmScope)csmClass, bl);
            String string = TemplateUtils.getClassSpecializationSuffix(aST4, null);
            String string2 = "<" + string + ">";
            this.setTemplateDescriptor(list, string2, !string.isEmpty(), bl);
        }
    }

    public static FriendClassImpl create(AST aST, AST aST2, CsmClassForwardDeclaration csmClassForwardDeclaration, FileImpl fileImpl, CsmClass csmClass, boolean bl) throws AstRendererException {
        FriendClassImpl friendClassImpl = new FriendClassImpl(aST, aST2, csmClassForwardDeclaration, fileImpl, csmClass, bl);
        FriendClassImpl.postObjectCreateRegistration(bl, friendClassImpl);
        return friendClassImpl;
    }

    @Override
    protected boolean registerInProject() {
        CsmProject csmProject = this.getContainingFile().getProject();
        if (csmProject instanceof ProjectBase) {
            return ((ProjectBase)csmProject).registerDeclaration(this);
        }
        return false;
    }

    public CsmClass getContainingClass() {
        return (CsmClass)this.parentUID.getObject();
    }

    public CsmScope getScope() {
        return this.getContainingClass();
    }

    public CharSequence getName() {
        return this.name;
    }

    public CharSequence getQualifiedName() {
        CsmClass csmClass = this.getContainingClass();
        CharSequence charSequence = csmClass.getQualifiedName();
        if (charSequence != null && charSequence.length() > 0) {
            return CharSequences.create((CharSequence)(((Object)charSequence).toString() + "::" + this.getQualifiedNamePostfix()));
        }
        return this.getName();
    }

    public CsmDeclaration.Kind getKind() {
        return CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION;
    }

    private boolean needRecount(int n, Resolver resolver) {
        int n2;
        if (this.lastParseCount != n) {
            return true;
        }
        CsmFile csmFile = null;
        if (resolver != null) {
            csmFile = resolver.getStartFile();
        }
        if (csmFile == null) {
            csmFile = this.getContainingFile();
        }
        return this.lastFileID != (n2 = UIDUtilities.getFileID(UIDs.get((Object)csmFile)));
    }

    private void updateCache(int n, Resolver resolver) {
        int n2;
        this.lastParseCount = n;
        CsmFile csmFile = null;
        if (resolver != null) {
            csmFile = resolver.getStartFile();
        }
        if (csmFile == null) {
            csmFile = this.getContainingFile();
        }
        this.lastFileID = n2 = UIDUtilities.getFileID(UIDs.get((Object)csmFile));
    }

    public CsmClass getReferencedClass() {
        Resolver resolver;
        CsmClass csmClass = UIDCsmConverter.UIDtoClass(this.friendUID);
        int n = FileImpl.getParseCount();
        if (this.needRecount(n, resolver = ResolverFactory.getCurrentResolver())) {
            CsmClassForwardDeclaration csmClassForwardDeclaration;
            if (!CsmBaseUtilities.isValid((CsmObject)csmClass) || ForwardClass.isForwardClass((CsmDeclaration)csmClass)) {
                csmClass = null;
                csmClassForwardDeclaration = UIDCsmConverter.UIDtoCsmObject(this.classForwardUID);
                if (CsmBaseUtilities.isValid((CsmObject)csmClassForwardDeclaration)) {
                    csmClass = csmClassForwardDeclaration.getCsmClass();
                }
                this.friendUID = UIDCsmConverter.declarationToUID(csmClass);
            }
            if ((!CsmBaseUtilities.isValid((CsmObject)csmClass) || ForwardClass.isForwardClass((CsmDeclaration)csmClass)) && CsmKindUtilities.isClass((CsmObject)(csmClassForwardDeclaration = this.resolve()))) {
                csmClass = (CsmClass)csmClassForwardDeclaration;
                this.friendUID = UIDCsmConverter.objectToUID(csmClass);
            }
            this.updateCache(n, resolver);
        }
        return csmClass;
    }

    private CharSequence[] initNameParts(AST aST) {
        if (aST != null) {
            return AstRenderer.getNameTokens(aST);
        }
        return new CharSequence[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CsmObject resolve() {
        CsmObject csmObject = null;
        Resolver resolver = ResolverFactory.createResolver(this);
        try {
            csmObject = resolver.resolve(this.nameParts, 4);
        }
        finally {
            ResolverFactory.releaseResolver(resolver);
        }
        if (csmObject == null) {
            csmObject = ((ProjectBase)this.getContainingFile().getProject()).getDummyForUnresolved(this.nameParts, this.getContainingFile(), this.getStartOffset());
        }
        return csmObject;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.unregisterInProject();
    }

    private void unregisterInProject() {
        CsmClassForwardDeclaration csmClassForwardDeclaration = UIDCsmConverter.UIDtoCsmObject(this.classForwardUID);
        if (csmClassForwardDeclaration instanceof ClassForwardDeclarationImpl) {
            ((ClassForwardDeclarationImpl)csmClassForwardDeclaration).dispose();
        }
        ((ProjectBase)this.getContainingFile().getProject()).unregisterDeclaration(this);
        this.cleanUID();
    }

    private void setTemplateDescriptor(List<CsmTemplateParameter> list, String string, boolean bl, boolean bl2) {
        this.templateDescriptor = new TemplateDescriptor(list, string, bl, bl2);
    }

    public boolean isTemplate() {
        return this.templateDescriptor != null;
    }

    public boolean isSpecialization() {
        return false;
    }

    public boolean isExplicitSpecialization() {
        return false;
    }

    public List<CsmTemplateParameter> getTemplateParameters() {
        return this.templateDescriptor != null ? this.templateDescriptor.getTemplateParameters() : Collections.emptyList();
    }

    public CharSequence getDisplayName() {
        return this.templateDescriptor != null ? CharSequences.create((CharSequence)(((Object)this.getName()).toString() + this.templateDescriptor.getTemplateSuffix())) : this.getName();
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        PersistentUtils.writeStrings(this.nameParts, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.parentUID, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.friendUID, dataOutput);
        PersistentUtils.writeTemplateDescriptor(this.templateDescriptor, dataOutput);
        UIDObjectFactory.getDefaultFactory().writeUID(this.classForwardUID, dataOutput);
    }

    public FriendClassImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.name = PersistentUtils.readUTF(dataInput, QualifiedNameCache.getManager());
        assert (this.name != null);
        this.nameParts = PersistentUtils.readStrings(dataInput, NameCache.getManager());
        this.parentUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.friendUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
        this.templateDescriptor = PersistentUtils.readTemplateDescriptor(dataInput);
        this.classForwardUID = UIDObjectFactory.getDefaultFactory().readUID(dataInput);
    }
}

