/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.repository.FileInstantiationsKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;

public class FileComponentInstantiations
extends FileComponent
implements Persistent,
SelfPersistent {
    private Set<CsmUID<CsmInstantiation>> instantiations = this.createInstantiations();
    private final ReadWriteLock instantiationsLock = new ReentrantReadWriteLock();
    private static final FileComponentInstantiations EMPTY = new FileComponentInstantiations(){

        @Override
        public void put() {
        }
    };

    public static FileComponentInstantiations empty() {
        return EMPTY;
    }

    public FileComponentInstantiations(FileImpl fileImpl) {
        super(new FileInstantiationsKey(fileImpl));
        this.put();
    }

    public FileComponentInstantiations(DataInput dataInput) throws IOException {
        super(dataInput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        uIDObjectFactory.readUIDCollection(this.instantiations, dataInput);
    }

    private FileComponentInstantiations() {
        super((Key)null);
    }

    void clean() {
        this._clearInstantiations();
        this.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearInstantiations() {
        try {
            this.instantiationsLock.writeLock().lock();
            RepositoryUtils.remove(this.instantiations);
            this.instantiations = this.createInstantiations();
        }
        finally {
            this.instantiationsLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addInstantiation(CsmInstantiation csmInstantiation) {
        CsmUID<CsmInstantiation> csmUID = RepositoryUtils.put(csmInstantiation);
        assert (csmUID != null);
        try {
            this.instantiationsLock.writeLock().lock();
            this.instantiations.add(csmUID);
        }
        finally {
            this.instantiationsLock.writeLock().unlock();
        }
        this.put();
    }

    private Set<CsmUID<CsmInstantiation>> createInstantiations() {
        return new HashSet<CsmUID<CsmInstantiation>>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        try {
            this.instantiationsLock.readLock().lock();
            uIDObjectFactory.writeUIDCollection(this.instantiations, dataOutput, false);
        }
        finally {
            this.instantiationsLock.readLock().unlock();
        }
    }
}

