/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFriend;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.project.NativeProjectItemsListener;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheEntry;
import org.netbeans.modules.cnd.apt.support.APTFileSearch;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.APTIncludeHandler;
import org.netbeans.modules.cnd.apt.support.APTIncludePathStorage;
import org.netbeans.modules.cnd.apt.support.APTMacroMap;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.APTSystemStorage;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;
import org.netbeans.modules.cnd.apt.support.StartEntry;
import org.netbeans.modules.cnd.debug.DebugUtils;
import org.netbeans.modules.cnd.modelimpl.csm.ClassEnumBase;
import org.netbeans.modules.cnd.modelimpl.csm.ForwardClass;
import org.netbeans.modules.cnd.modelimpl.csm.FunctionImplEx;
import org.netbeans.modules.cnd.modelimpl.csm.NamespaceImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ClassifierContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.CreateFilesWorker;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeclarationContainerProject;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FakeRegistrationWorker;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileModel;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.csm.core.GraphContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeProjectListenerImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseFinishNotificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParseStatistics;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.PreprocessorStatePair;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProgressSupport;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectComponent;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectSettingsValidator;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Unresolved;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.Terminator;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.impl.services.FileInfoQueryImpl;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTRestorePreprocStateWalker;
import org.netbeans.modules.cnd.modelimpl.platform.ModelSupport;
import org.netbeans.modules.cnd.modelimpl.repository.ClassifierContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.FileContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.GraphContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.KeyUtilities;
import org.netbeans.modules.cnd.modelimpl.repository.PersistentUtils;
import org.netbeans.modules.cnd.modelimpl.repository.ProjectDeclarationContainerKey;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.ProjectNameCache;
import org.netbeans.modules.cnd.modelimpl.textcache.QualifiedNameCache;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;
import org.netbeans.modules.cnd.modelimpl.uid.LazyCsmCollection;
import org.netbeans.modules.cnd.modelimpl.uid.UIDCsmConverter;
import org.netbeans.modules.cnd.modelimpl.uid.UIDManager;
import org.netbeans.modules.cnd.modelimpl.uid.UIDObjectFactory;
import org.netbeans.modules.cnd.modelimpl.uid.UIDUtilities;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.support.SelfPersistent;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Cancellable;
import org.openide.util.CharSequences;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;

public abstract class ProjectBase
implements CsmProject,
Persistent,
SelfPersistent,
CsmIdentifiable {
    private static final boolean TRACE_FILE = TraceFlags.TRACE_FILE_NAME != null;
    private int preventMultiplyDiagnosticExceptionsGlobalNamespace = 0;
    private CsmUID<CsmProject> uid = null;
    private final Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> fakeASTs = new WeakHashMap();
    private volatile int hash = 0;
    private volatile Status status;
    private Cancellable initializationTask;
    private final Object initializationTaskLock = new InitializationTaskLock();
    private final Object waitParseLock = new WaitParseLock();
    private final Object classifierReplaceLock = new ClassifierReplaceLock();
    private ModelImpl model;
    private Unresolved unresolved;
    private CharSequence name;
    private CsmUID<CsmNamespace> globalNamespaceUID;
    private NamespaceImpl FAKE_GLOBAL_NAMESPACE;
    private Object platformProject;
    private final FileSystem fileSystem;
    private final AtomicBoolean disposing = new AtomicBoolean(false);
    private final ReadWriteLock disposeLock = new ReentrantReadWriteLock();
    private final CharSequence uniqueName;
    private final Map<CharSequence, CsmUID<CsmNamespace>> namespaces;
    private final Key classifierStorageKey;
    private final APTSystemStorage sysAPTData;
    private final APTIncludePathStorage userPathStorage;
    private final Object namespaceLock = new NamespaceLock();
    private final Key declarationsSorageKey;
    private final Key fileContainerKey;
    private final Object fileContainerLock = new FileContainerLock();
    private final Key graphStorageKey;
    private NativeProjectListenerImpl projectListener;
    private static final boolean TRACE_PP_STATE_OUT = DebugUtils.getBoolean((String)"cnd.dump.preproc.state", (boolean)false);
    private static final boolean REMEMBER_RESTORED = TraceFlags.CLEAN_MACROS_AFTER_PARSE && (DebugUtils.getBoolean((String)"cnd.remember.restored", (boolean)false) || TRACE_PP_STATE_OUT);
    public static final int GATHERING_MACROS = 0;
    public static final int GATHERING_TOKENS = 1;
    private static volatile List<String> testRestoredFiles = null;
    private final WeakContainer<DeclarationContainerProject> weakDeclarationContainer;
    private final WeakContainer<FileContainer> weakFileContainer;
    private final WeakContainer<GraphContainer> weakGraphContainer;
    private final WeakContainer<ClassifierContainer> weakClassifierContainer;

    protected ProjectBase(ModelImpl modelImpl, FileSystem fileSystem, Object object, String string) {
        this.namespaces = new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>();
        this.uniqueName = ProjectBase.getUniqueName(fileSystem, object);
        RepositoryUtils.openUnit(ProjectBase.createProjectKey(fileSystem, object));
        this.setStatus(Status.Initial);
        this.name = ProjectNameCache.getManager().getString((CharSequence)string);
        this.fileSystem = fileSystem;
        this.init(modelImpl, object);
        this.sysAPTData = APTSystemStorage.getInstance();
        this.userPathStorage = new APTIncludePathStorage();
        this.declarationsSorageKey = new ProjectDeclarationContainerKey(this.getUniqueName());
        this.weakDeclarationContainer = new WeakContainer(this, this.declarationsSorageKey);
        this.classifierStorageKey = new ClassifierContainerKey(this.getUniqueName());
        this.weakClassifierContainer = new WeakContainer(this, this.classifierStorageKey);
        this.fileContainerKey = new FileContainerKey(this.getUniqueName());
        this.weakFileContainer = new WeakContainer(this, this.fileContainerKey);
        this.graphStorageKey = new GraphContainerKey(this.getUniqueName());
        this.weakGraphContainer = new WeakContainer(this, this.graphStorageKey);
        this.initFields();
    }

    final void initFields() {
        NamespaceImpl namespaceImpl = NamespaceImpl.create(this, false);
        assert (namespaceImpl != null);
        this.globalNamespaceUID = UIDCsmConverter.namespaceToUID(namespaceImpl);
        DeclarationContainerProject declarationContainerProject = new DeclarationContainerProject(this);
        CndUtils.assertTrue((boolean)this.declarationsSorageKey.equals(declarationContainerProject.getKey()));
        this.weakDeclarationContainer.clear();
        ClassifierContainer classifierContainer = new ClassifierContainer(this);
        CndUtils.assertTrue((boolean)this.classifierStorageKey.equals(classifierContainer.getKey()));
        this.weakClassifierContainer.clear();
        FileContainer fileContainer = new FileContainer(this);
        CndUtils.assertTrue((boolean)this.fileContainerKey.equals(fileContainer.getKey()));
        this.weakFileContainer.clear();
        GraphContainer graphContainer = new GraphContainer(this);
        CndUtils.assertTrue((boolean)this.graphStorageKey.equals(graphContainer.getKey()));
        this.weakGraphContainer.clear();
        this.FAKE_GLOBAL_NAMESPACE = NamespaceImpl.create(this, true);
    }

    private void init(ModelImpl modelImpl, Object object) {
        this.model = modelImpl;
        this.platformProject = object;
        RepositoryUtils.hang(this);
        if (TraceFlags.CLOSE_AFTER_PARSE) {
            Terminator.create(this);
        }
    }

    private boolean checkConsistency() {
        long l;
        long l2 = l = TraceFlags.TIMING ? System.currentTimeMillis() : 0L;
        if (this.getFileContainer() == FileContainer.empty()) {
            return false;
        }
        if (this.getDeclarationsSorage() == DeclarationContainerProject.empty()) {
            return false;
        }
        if (this.getGraph() == GraphContainer.empty()) {
            return false;
        }
        if (this.getGlobalNamespace() == this.FAKE_GLOBAL_NAMESPACE) {
            return false;
        }
        if (TraceFlags.TIMING) {
            System.err.printf("Consistency check took %d ms\n", System.currentTimeMillis() - l);
        }
        return true;
    }

    private void setStatus(Status status) {
        this.status = status;
    }

    protected static void cleanRepository(FileSystem fileSystem, Object object, boolean bl) {
        Key key = ProjectBase.createProjectKey(fileSystem, object);
        RepositoryUtils.closeUnit(key, null, true);
    }

    private static Key createProjectKey(FileSystem fileSystem, Object object) {
        return KeyUtilities.createProjectKey(ProjectBase.getUniqueName(fileSystem, object));
    }

    protected static ProjectBase readInstance(ModelImpl modelImpl, FileSystem fileSystem, Object object, String string) {
        long l = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("Project %s: instantiating...\n", string);
            l = System.currentTimeMillis();
        }
        assert (TraceFlags.PERSISTENT_REPOSITORY);
        Key key = ProjectBase.createProjectKey(fileSystem, object);
        RepositoryUtils.openUnit(key);
        Persistent persistent = RepositoryUtils.get(key);
        if (persistent != null) {
            assert (persistent instanceof ProjectBase);
            ProjectBase projectBase = (ProjectBase)persistent;
            CharSequence charSequence = ProjectNameCache.getManager().getString((CharSequence)string);
            if (!projectBase.name.equals(charSequence)) {
                projectBase.setName(charSequence);
            }
            projectBase.init(modelImpl, object);
            if (TraceFlags.TIMING) {
                l = System.currentTimeMillis() - l;
                System.err.printf("Project %s: loaded. %d ms\n", string, l);
            }
            UIDManager.instance().clearProjectCache(key);
            if (projectBase.checkConsistency()) {
                return projectBase;
            }
        }
        return null;
    }

    public final CsmNamespace getGlobalNamespace() {
        return this._getGlobalNamespace();
    }

    public final CharSequence getName() {
        return this.name;
    }

    protected final void setName(CharSequence charSequence) {
        this.name = charSequence;
    }

    public final CharSequence getUniqueName() {
        return this.uniqueName;
    }

    public static CharSequence getUniqueName(NativeProject nativeProject) {
        return ProjectBase.getUniqueName(nativeProject.getFileSystem(), nativeProject);
    }

    public String getDisplayName() {
        if (CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem)) {
            return ((Object)this.name).toString();
        }
        return NbBundle.getMessage(this.getClass(), (String)"ProjectDisplayName", (Object)this.name, (Object)this.fileSystem.getDisplayName());
    }

    public String getHtmlDisplayName() {
        if (CndFileUtils.isLocalFileSystem((FileSystem)this.fileSystem)) {
            return ((Object)this.name).toString();
        }
        return NbBundle.getMessage(this.getClass(), (String)"ProjectHtmlDisplayName", (Object)this.name, (Object)this.fileSystem.getDisplayName());
    }

    public static CharSequence getUniqueName(FileSystem fileSystem, Object object) {
        String string;
        String string2;
        Parameters.notNull((CharSequence)"FileSystem", (Object)fileSystem);
        String string3 = string2 = CndFileUtils.isLocalFileSystem((FileSystem)fileSystem) ? "" : fileSystem.getDisplayName();
        if (object instanceof NativeProject) {
            string = ((NativeProject)object).getProjectRoot() + 'N' + string2;
        } else if (object instanceof CharSequence) {
            string = ((Object)((CharSequence)object)).toString() + 'L' + string2;
        } else {
            if (object == null) {
                throw new IllegalArgumentException("Incorrect platform project: null");
            }
            throw new IllegalArgumentException("Incorrect platform project class: " + object.getClass());
        }
        return ProjectNameCache.getManager().getString((CharSequence)string);
    }

    public final Object getPlatformProject() {
        return this.platformProject;
    }

    protected final void setPlatformProject(Object object) {
        CndUtils.assertTrue((this.platformProject == null ? 1 : 0) != 0);
        this.platformProject = object;
        CndUtils.assertTrue((boolean)this.uniqueName.equals(ProjectBase.getUniqueName(this.fileSystem, object)));
    }

    public final CsmNamespace findNamespace(CharSequence charSequence, boolean bl) {
        CsmNamespace csmNamespace;
        block1: {
            CsmProject csmProject;
            csmNamespace = this.findNamespace(charSequence);
            if (csmNamespace != null || !bl) break block1;
            Iterator iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && (csmNamespace = (csmProject = (CsmProject)iterator.next()).findNamespace(charSequence)) == null) {
            }
        }
        return csmNamespace;
    }

    public final CsmNamespace findNamespace(CharSequence charSequence) {
        NamespaceImpl namespaceImpl = this._getNamespace(charSequence);
        return namespaceImpl;
    }

    private static String getNestedNamespaceQualifiedName(CharSequence charSequence, NamespaceImpl namespaceImpl, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder(charSequence);
        if (namespaceImpl != null) {
            if (charSequence.length() == 0 && bl) {
                stringBuilder.append(namespaceImpl.getNameForUnnamedElement());
            }
            if (!namespaceImpl.isGlobal()) {
                stringBuilder.insert(0, "::");
                stringBuilder.insert(0, namespaceImpl.getQualifiedName());
            }
        }
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final NamespaceImpl findNamespaceCreateIfNeeded(NamespaceImpl namespaceImpl, CharSequence charSequence) {
        Object object = this.namespaceLock;
        synchronized (object) {
            String string = ProjectBase.getNestedNamespaceQualifiedName(charSequence, namespaceImpl, true);
            NamespaceImpl namespaceImpl2 = this._getNamespace(string);
            if (namespaceImpl2 == null) {
                namespaceImpl2 = NamespaceImpl.create(this, namespaceImpl, ((Object)charSequence).toString(), string);
            }
            return namespaceImpl2;
        }
    }

    public final void registerNamespace(NamespaceImpl namespaceImpl) {
        this._registerNamespace(namespaceImpl);
    }

    public final void unregisterNamesace(NamespaceImpl namespaceImpl) {
        this._unregisterNamespace(namespaceImpl);
    }

    public final CsmClassifier findClassifier(CharSequence charSequence, boolean bl) {
        CsmClassifier csmClassifier;
        block1: {
            CsmProject csmProject;
            csmClassifier = this.findClassifier(charSequence);
            if (csmClassifier != null || !bl) break block1;
            Iterator iterator = this.getLibraries().iterator();
            while (iterator.hasNext() && (csmClassifier = (csmProject = (CsmProject)iterator.next()).findClassifier(charSequence)) == null) {
            }
        }
        return csmClassifier;
    }

    public final CsmClassifier findClassifier(CharSequence charSequence) {
        CsmClassifier csmClassifier = this.getClassifierSorage().getClassifier(charSequence);
        return csmClassifier;
    }

    public final Collection<CsmClassifier> findClassifiers(CharSequence charSequence) {
        CsmClassifier csmClassifier = this.getClassifierSorage().getClassifier(charSequence);
        ArrayList<CsmClassifier> arrayList = new ArrayList<CsmClassifier>();
        if (csmClassifier != null) {
            if (CsmKindUtilities.isBuiltIn((CsmObject)csmClassifier)) {
                return Collections.singletonList(csmClassifier);
            }
            CharSequence[] charSequenceArray = Utils.getAllClassifiersUniqueNames(csmClassifier.getUniqueName());
            ArrayList<CsmClassifier> arrayList2 = new ArrayList<CsmClassifier>(1);
            for (CharSequence charSequence2 : charSequenceArray) {
                Collection<CsmOffsetableDeclaration> collection;
                Collection<CsmOffsetableDeclaration> collection2 = collection = this.findDeclarations(charSequence2);
                for (CsmClassifier csmClassifier2 : collection2) {
                    if (ForwardClass.isForwardClass((CsmDeclaration)csmClassifier2)) {
                        arrayList2.add(csmClassifier2);
                        continue;
                    }
                    arrayList.add(csmClassifier2);
                }
            }
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public final Collection<CsmInheritance> findInheritances(CharSequence charSequence) {
        return this.getClassifierSorage().getInheritances(charSequence);
    }

    public final CsmDeclaration findDeclaration(CharSequence charSequence) {
        return this.getDeclarationsSorage().getDeclaration(charSequence);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarations(CharSequence charSequence) {
        return this.getDeclarationsSorage().findDeclarations(charSequence);
    }

    public final Collection<CsmOffsetableDeclaration> findDeclarationsByPrefix(String string) {
        char c = '\u00ff';
        return this.getDeclarationsSorage().getDeclarationsRange((CharSequence)string, string + c);
    }

    public final Collection<CsmFriend> findFriendDeclarations(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        return this.getDeclarationsSorage().findFriends(csmOffsetableDeclaration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean registerDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (!Utils.canRegisterDeclaration((CsmDeclaration)csmOffsetableDeclaration)) {
            if (TraceFlags.TRACE_REGISTRATION) {
                ProjectBase.traceRegistration("not registered decl " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
            }
            return false;
        }
        if (CsmKindUtilities.isClass((CsmObject)csmOffsetableDeclaration) || CsmKindUtilities.isEnum((CsmObject)csmOffsetableDeclaration)) {
            ClassEnumBase classEnumBase = (ClassEnumBase)csmOffsetableDeclaration;
            CharSequence charSequence = classEnumBase.getQualifiedName();
            Object object = this.classifierReplaceLock;
            synchronized (object) {
                CsmClassifier csmClassifier = this.getClassifierSorage().getClassifier(charSequence);
                if (csmClassifier != null) {
                    if (classEnumBase.shouldBeReplaced(csmClassifier)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            ProjectBase.traceRegistration("not registered decl " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
                        }
                        return false;
                    }
                    if (csmClassifier instanceof ClassEnumBase && ((ClassEnumBase)csmClassifier).shouldBeReplaced((CsmClassifier)classEnumBase)) {
                        if (TraceFlags.TRACE_REGISTRATION) {
                            System.err.println("disposing old decl " + csmClassifier + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
                        }
                        ((ClassEnumBase)csmClassifier).dispose();
                    }
                }
                this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
                this.getClassifierSorage().putClassifier((CsmClassifier)csmOffsetableDeclaration);
            }
        } else if (CsmKindUtilities.isTypedef((CsmObject)csmOffsetableDeclaration)) {
            this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
            this.getClassifierSorage().putClassifier((CsmClassifier)csmOffsetableDeclaration);
        } else {
            this.getDeclarationsSorage().putDeclaration(csmOffsetableDeclaration);
        }
        if (TraceFlags.TRACE_REGISTRATION) {
            System.err.println("registered " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
        }
        return true;
    }

    public final void unregisterDeclaration(CsmOffsetableDeclaration csmOffsetableDeclaration) {
        if (TraceFlags.TRACE_REGISTRATION) {
            ProjectBase.traceRegistration("unregistered " + csmOffsetableDeclaration + " UID " + UIDs.get((Object)csmOffsetableDeclaration));
        }
        if (csmOffsetableDeclaration instanceof CsmClassifier) {
            this.getClassifierSorage().removeClassifier((CsmDeclaration)csmOffsetableDeclaration);
        }
        this.getDeclarationsSorage().removeDeclaration(csmOffsetableDeclaration);
    }

    private static void traceRegistration(String string) {
        assert (TraceFlags.TRACE_REGISTRATION) : "TraceFlags.TRACE_REGISTRATION should be checked *before* call !";
        System.err.printf("registration: %s\n", string);
    }

    public final void waitParse() {
        boolean bl = ParserThreadManager.instance().isParserThread();
        if (bl) {
            new Throwable("project.waitParse should NEVER be called in parser thread !!!").printStackTrace(System.err);
        }
        if (bl) {
            return;
        }
        this.ensureFilesCreated();
        this.ensureChangedFilesEnqueued();
        this.waitParseImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitParseImpl() {
        Object object = this.waitParseLock;
        synchronized (object) {
            while (ParserQueue.instance().hasPendingProjectRelatedWork(this, null)) {
                try {
                    this.waitParseLock.wait(10000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    protected void ensureChangedFilesEnqueued() {
    }

    protected boolean hasChangedFiles(CsmFile csmFile) {
        return false;
    }

    protected boolean hasEditedFiles() {
        return false;
    }

    protected final synchronized void registerProjectListeners() {
        if (this.platformProject instanceof NativeProject) {
            if (this.projectListener == null) {
                this.projectListener = new NativeProjectListenerImpl(this.getModel(), (NativeProject)this.platformProject, this);
            }
            ((NativeProject)this.platformProject).addProjectItemsListener((NativeProjectItemsListener)this.projectListener);
        }
    }

    public final synchronized void enableProjectListeners(boolean bl) {
        if (this.projectListener != null) {
            this.projectListener.enableListening(bl);
        }
    }

    protected final synchronized void unregisterProjectListeners() {
        if (this.projectListener != null && this.platformProject instanceof NativeProject) {
            ((NativeProject)this.platformProject).removeProjectItemsListener((NativeProjectItemsListener)this.projectListener);
        }
    }

    final void scheduleReparse() {
        this.ensureFilesCreated();
        DeepReparsingUtils.reparseOnEdit(this.getAllFileImpls(), this, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void ensureFilesCreated() {
        if (this.status == Status.Ready) {
            return;
        }
        boolean bl = false;
        ProjectBase projectBase = this;
        synchronized (projectBase) {
            if (this.status == Status.Initial || this.status == Status.Restored) {
                try {
                    this.setStatus(this.status == Status.Initial ? Status.AddingFiles : Status.Validating);
                    long l = 0L;
                    if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                        System.err.println("suspend queue");
                        ParserQueue.instance().suspend();
                        if (TraceFlags.TIMING) {
                            l = System.currentTimeMillis();
                        }
                    }
                    ParserQueue.instance().onStartAddingProjectFiles(this);
                    this.registerProjectListeners();
                    NativeProject nativeProject = ModelSupport.getNativeProject(this.platformProject);
                    if (nativeProject != null) {
                        try {
                            ParserQueue.instance().suspend();
                            this.createProjectFilesIfNeed(nativeProject);
                        }
                        finally {
                            ParserQueue.instance().resume();
                        }
                    }
                    if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                        if (TraceFlags.TIMING) {
                            l = System.currentTimeMillis() - l;
                            System.err.println("getting files from project system + put in queue took " + l + "ms");
                        }
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before resuming queue");
                        this.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                        ParserQueue.instance().resume();
                    }
                    bl = true;
                }
                finally {
                    this.setStatus(Status.Ready);
                }
            }
        }
        if (bl) {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    private void sleep(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void createProjectFilesIfNeed(NativeProject var1_1) {
        block30: {
            block31: {
                if (TraceFlags.TIMING) {
                    System.err.printf("\n\nGetting files from project system for %s...\n", new Object[]{this.getName()});
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec before getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException var2_2) {
                        // empty catch block
                    }
                }
                var2_3 = System.currentTimeMillis();
                var4_4 = Collections.synchronizedSet(new HashSet<E>());
                var5_5 = new NativeProjectItemsListener(){

                    public void fileAdded(NativeFileItem nativeFileItem) {
                    }

                    public void filesAdded(List<NativeFileItem> list) {
                    }

                    public void fileRemoved(NativeFileItem nativeFileItem) {
                        var4_4.add(nativeFileItem);
                    }

                    public void filesRemoved(List<NativeFileItem> list) {
                        var4_4.addAll(list);
                    }

                    public void fileRenamed(String string, NativeFileItem nativeFileItem) {
                    }

                    public void filePropertiesChanged(NativeFileItem nativeFileItem) {
                    }

                    public void filesPropertiesChanged(List<NativeFileItem> list) {
                    }

                    public void filesPropertiesChanged() {
                    }

                    public void projectDeleted(NativeProject nativeProject) {
                    }
                };
                var1_1.addProjectItemsListener(var5_5);
                var6_6 = new ArrayList<NativeFileItem>();
                var7_7 = new ArrayList<NativeFileItem>();
                var8_8 = new ArrayList<NativeFileItem>();
                block14: for (Object var10_11 : var1_1.getAllFiles()) {
                    if (!var10_11.isExcluded()) {
                        switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[var10_11.getLanguage().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                var6_6.add((NativeFileItem)var10_11);
                                continue block14;
                            }
                            case 4: {
                                var7_7.add((NativeFileItem)var10_11);
                                continue block14;
                            }
                        }
                        continue;
                    }
                    switch (3.$SwitchMap$org$netbeans$modules$cnd$api$project$NativeFileItem$Language[var10_11.getLanguage().ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            var8_8.add((NativeFileItem)var10_11);
                            break;
                        }
                    }
                }
                if (TraceFlags.TIMING) {
                    var2_3 = System.currentTimeMillis() - var2_3;
                    System.err.printf("Getting files from project system took  %d ms for %s\n", new Object[]{var2_3, this.getName()});
                    System.err.printf("FILES COUNT for %s:\nSource files:\t%d\nHeader files:\t%d\nTotal files:\t%d\n", new Object[]{this.getName(), var6_6.size(), var7_7.size(), var6_6.size() + var7_7.size()});
                    var2_3 = System.currentTimeMillis();
                }
                if (TraceFlags.SUSPEND_PARSE_TIME != 0) {
                    try {
                        System.err.println("sleep for " + TraceFlags.SUSPEND_PARSE_TIME + "sec after getting files from project");
                        Thread.sleep(TraceFlags.SUSPEND_PARSE_TIME * 1000);
                        System.err.println("woke up after sleep");
                    }
                    catch (InterruptedException var9_10) {
                        // empty catch block
                    }
                }
                if (TraceFlags.DUMP_PROJECT_ON_OPEN) {
                    ModelSupport.dumpNativeProject(var1_1);
                }
                this.disposeLock.readLock().lock();
                if (TraceFlags.TIMING) {
                    var2_3 = System.currentTimeMillis() - var2_3;
                    System.err.printf("Waited on disposeLock: %d ms for %s\n", new Object[]{var2_3, this.getName()});
                    var2_3 = System.currentTimeMillis();
                }
                if (!this.isDisposing()) break block30;
                if (TraceFlags.TRACE_MODEL_STATE) {
                    System.err.printf("filling parser queue interrupted for %s\n", new Object[]{this.getName()});
                }
                this.disposeLock.readLock().unlock();
                if (!TraceFlags.TIMING) break block31;
                var2_3 = System.currentTimeMillis() - var2_3;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
            }
            return;
        }
        try {
            var9_9 = null;
            if (this.status == Status.Validating) {
                var9_9 = new ProjectSettingsValidator(this);
                var9_9.restoreSettings();
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                var9_9 = null;
                this.reopenUnit();
            }
            this.getProjectRoots().fixFolder(var1_1.getProjectRoot());
            for (String var11_12 : var1_1.getSourceRoots()) {
                this.getProjectRoots().fixFolder(var11_12);
            }
            this.getProjectRoots().addSources(var6_6);
            this.getProjectRoots().addSources(var7_7);
            this.getProjectRoots().addSources(var8_8);
            var10_11 = new CreateFilesWorker(this);
            var10_11.createProjectFilesIfNeed(var6_6, true, var4_4, (ProjectSettingsValidator)var9_9);
            if (this.status != Status.Validating || RepositoryUtils.getRepositoryErrorCount(this) == 0) {
                var10_11.createProjectFilesIfNeed(var7_7, false, var4_4, (ProjectSettingsValidator)var9_9);
            }
            if (this.status == Status.Validating && RepositoryUtils.getRepositoryErrorCount(this) > 0) {
                System.err.println("Clean index for project \"" + this.getUniqueName() + "\" because index was corrupted (was " + RepositoryUtils.getRepositoryErrorCount(this) + " errors).");
                var9_9 = null;
                this.reopenUnit();
                var10_11.createProjectFilesIfNeed(var6_6, true, var4_4, (ProjectSettingsValidator)var9_9);
                var10_11.createProjectFilesIfNeed(var7_7, false, var4_4, (ProjectSettingsValidator)var9_9);
            }
            this.disposeLock.readLock().unlock();
            ** if (!TraceFlags.TIMING) goto lbl-1000
        }
        catch (Throwable var12_13) {
            this.disposeLock.readLock().unlock();
            if (TraceFlags.TIMING) {
                var2_3 = System.currentTimeMillis() - var2_3;
                System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
            }
            throw var12_13;
        }
lbl-1000:
        // 1 sources

        {
            var2_3 = System.currentTimeMillis() - var2_3;
            System.err.printf("FILLING PARSER QUEUE took %d ms for %s\n", new Object[]{var2_3, this.getName()});
        }
lbl-1000:
        // 2 sources

        {
        }
        var1_1.removeProjectItemsListener(var5_5);
    }

    private void reopenUnit() {
        this.setStatus(Status.Initial);
        ParserQueue.instance().clean(this);
        RepositoryUtils.closeUnit(this.getUniqueName(), null, true);
        RepositoryUtils.openUnit(this);
        RepositoryUtils.hang(this);
        this.initFields();
    }

    protected final void createIfNeed(NativeFileItem nativeFileItem, boolean bl) {
        FileAndHandler fileAndHandler = this.preCreateIfNeed(nativeFileItem, bl);
        if (fileAndHandler == null) {
            return;
        }
        ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
    }

    private FileAndHandler preCreateIfNeed(NativeFileItem nativeFileItem, boolean bl) {
        assert (nativeFileItem != null && nativeFileItem.getFileObject() != null);
        if (!Utils.acceptNativeItem(nativeFileItem)) {
            return null;
        }
        CsmFile.FileType fileType = bl ? Utils.getFileType(nativeFileItem) : CsmFile.FileType.HEADER_FILE;
        FileAndHandler fileAndHandler = this.createOrFindFileImpl(ModelSupport.createFileBuffer(nativeFileItem.getFileObject()), nativeFileItem, fileType);
        if (fileAndHandler.preprocHandler == null) {
            fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFileItem);
        }
        return fileAndHandler;
    }

    final void createIfNeed(NativeFileItem nativeFileItem, boolean bl, FileModel fileModel, ProjectSettingsValidator projectSettingsValidator, List<FileImpl> list, List<NativeFileItem> list2) {
        FileAndHandler fileAndHandler = this.preCreateIfNeed(nativeFileItem, bl);
        if (fileAndHandler == null) {
            return;
        }
        if (projectSettingsValidator != null) {
            if (fileAndHandler.fileImpl.validate()) {
                if (fileAndHandler.fileImpl.isParsed()) {
                    if (projectSettingsValidator.arePropertiesChanged(nativeFileItem)) {
                        if (TraceFlags.TRACE_VALIDATION) {
                            System.err.printf("Validation: %s properties are changed \n", nativeFileItem.getAbsolutePath());
                        }
                        list2.add(nativeFileItem);
                    }
                } else if (projectSettingsValidator.arePropertiesChanged(nativeFileItem)) {
                    if (fileAndHandler.fileImpl.getState() == FileImpl.State.INITIAL) {
                        fileAndHandler.preprocHandler = this.createPreprocHandler(nativeFileItem);
                        ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
                    } else {
                        if (TraceFlags.TRACE_VALIDATION) {
                            System.err.printf("Validation: %s properties are changed \n", nativeFileItem.getAbsolutePath());
                        }
                        list2.add(nativeFileItem);
                    }
                } else {
                    ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
                }
            } else {
                if (TraceFlags.TRACE_VALIDATION) {
                    System.err.printf("Validation: file %s is changed\n", nativeFileItem.getAbsolutePath());
                }
                if (projectSettingsValidator.arePropertiesChanged(nativeFileItem)) {
                    list2.add(nativeFileItem);
                } else {
                    list.add(fileAndHandler.fileImpl);
                }
            }
        } else if (fileModel == null || !fileModel.fill(fileAndHandler.fileImpl)) {
            ParserQueue.instance().add(fileAndHandler.fileImpl, fileAndHandler.preprocHandler.getState(), ParserQueue.Position.TAIL);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAddedToModel() {
        boolean bl;
        boolean bl2 = bl = this.status == Status.Restored;
        if (this.status == Status.Initial || this.status == Status.Restored) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    ProjectBase.this.onAddedToModelImpl(bl);
                    Object object = ProjectBase.this.initializationTaskLock;
                    synchronized (object) {
                        ProjectBase.this.initializationTask = null;
                    }
                }
            };
            String string = this.status == Status.Initial ? "Filling parser queue for " : "Validating files for ";
            Object object = this.initializationTaskLock;
            synchronized (object) {
                this.initializationTask = ModelImpl.instance().enqueueModelTask(runnable, string + this.getName());
            }
        }
    }

    protected final Status getStatus() {
        return this.status;
    }

    boolean isValidating() {
        return this.status == Status.Validating;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAddedToModelImpl(boolean bl) {
        if (TraceFlags.TRACE_182342_BUG) {
            new Exception("Restored: " + bl + " disposing: " + this.isDisposing()).printStackTrace(System.err);
        }
        if (this.isDisposing()) {
            return;
        }
        try {
            this.disposeLock.readLock().lock();
            if (this.isDisposing()) {
                return;
            }
            this.ensureFilesCreated();
            if (this.isDisposing()) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
        if (bl) {
            ProgressSupport.instance().fireProjectLoaded(this);
        }
        try {
            this.disposeLock.readLock().lock();
            if (bl && !this.isDisposing()) {
                try {
                    this.waitParseImpl();
                    this.checkForRemoved();
                }
                catch (Exception exception) {
                    DiagnosticExceptoins.register(exception);
                }
            }
            if (this.isDisposing()) {
                return;
            }
            Notificator.instance().flush();
        }
        finally {
            this.disposeLock.readLock().unlock();
        }
    }

    private void checkForRemoved() {
        Object object2;
        NativeFileItem nativeFileItem22;
        NativeProject nativeProject = this.platformProject instanceof NativeProject ? (NativeProject)this.platformProject : null;
        HashSet<String> hashSet = null;
        if (nativeProject != null) {
            hashSet = new HashSet<String>();
            for (NativeFileItem nativeFileItem22 : nativeProject.getAllFiles()) {
                if (nativeFileItem22.isExcluded()) continue;
                switch (nativeFileItem22.getLanguage()) {
                    case C: 
                    case CPP: 
                    case FORTRAN: 
                    case C_HEADER: {
                        hashSet.add(nativeFileItem22.getAbsolutePath());
                        break;
                    }
                }
            }
        }
        HashSet hashSet2 = new HashSet();
        nativeFileItem22 = new HashSet();
        for (FileImpl object22 : this.getAllFileImpls()) {
            object2 = object22.getFileObject();
            if (object2 == null || !object2.isValid()) {
                nativeFileItem22.add(object22);
                continue;
            }
            if (hashSet == null || hashSet.contains(((Object)object22.getAbsolutePath()).toString())) continue;
            hashSet2.add(object22);
        }
        ArrayList arrayList = new ArrayList(nativeFileItem22);
        if (TraceFlags.TRACE_VALIDATION) {
            for (Object object2 : nativeFileItem22) {
                System.err.printf("Validation: removing (physically deleted) %s\n", ((FileImpl)object2).getAbsolutePath());
            }
        }
        Iterator iterator = hashSet2.iterator();
        while (iterator.hasNext()) {
            object2 = (FileImpl)iterator.next();
            boolean bl = true;
            Set<CsmFile> set = this.getGraphStorage().getParentFiles((CsmFile)object2);
            for (CsmFile csmFile : set) {
                if (hashSet2.contains((FileImpl)csmFile)) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (TraceFlags.TRACE_VALIDATION) {
                System.err.printf("Validation: removing (removed from project) %s\n", ((FileImpl)object2).getAbsolutePath());
            }
            arrayList.add(object2);
        }
        this.onFileImplRemoved(arrayList);
    }

    protected final APTPreprocHandler createEmptyPreprocHandler(CharSequence charSequence) {
        StartEntry startEntry = new StartEntry(this.getFileSystem(), ((Object)FileContainer.getFileKey(charSequence, true)).toString(), RepositoryUtils.UIDtoKey(this.getUID()));
        return APTHandlersSupport.createEmptyPreprocHandler((StartEntry)startEntry);
    }

    protected final APTPreprocHandler createPreprocHandler(NativeFileItem nativeFileItem) {
        assert (nativeFileItem != null);
        APTMacroMap aPTMacroMap = this.getMacroMap(nativeFileItem);
        APTIncludeHandler aPTIncludeHandler = this.getIncludeHandler(nativeFileItem);
        APTPreprocHandler aPTPreprocHandler = APTHandlersSupport.createPreprocHandler((APTMacroMap)aPTMacroMap, (APTIncludeHandler)aPTIncludeHandler, (boolean)this.isSourceFile(nativeFileItem));
        return aPTPreprocHandler;
    }

    private APTIncludeHandler getIncludeHandler(NativeFileItem nativeFileItem) {
        FileSystem fileSystem;
        FileSystem fileSystem2;
        List list3;
        if (!this.isSourceFile(nativeFileItem)) {
            nativeFileItem = DefaultFileItem.toDefault(nativeFileItem);
        }
        List list2 = nativeFileItem.getUserIncludePaths();
        if (TraceFlags.DUMP_NATIVE_FILE_ITEM_USER_INCLUDE_PATHS) {
            System.err.println("Item " + nativeFileItem.getAbsolutePath());
            for (List list3 : list2) {
                System.err.println("\tPath " + list3.getPath());
            }
        }
        List list4 = nativeFileItem.getSystemIncludePaths();
        list3 = this.userPathStorage.get((CharSequence)list2.toString(), list2);
        List list5 = this.sysAPTData.getIncludes((CharSequence)list4.toString(), list4);
        String string = ((Object)FileContainer.getFileKey(nativeFileItem.getAbsolutePath(), true)).toString();
        if (CndUtils.isDebugMode()) {
            fileSystem2 = this.getFileSystem();
            fileSystem = nativeFileItem.getNativeProject().getFileSystem();
            CndUtils.assertTrue((boolean)fileSystem.equals(fileSystem2), (String)("File systems differ: incoming=" + fileSystem + ";cur=" + fileSystem2));
        }
        fileSystem2 = new StartEntry(this.getFileSystem(), string, RepositoryUtils.UIDtoKey(this.getUID()));
        fileSystem = null;
        Object object = this.getPlatformProject();
        if (object != null) {
            fileSystem = APTFileSearch.get((Key)KeyUtilities.createProjectKey(ProjectBase.getUniqueName(this.fileSystem, object)));
        }
        return APTHandlersSupport.createIncludeHandler((StartEntry)fileSystem2, (List)list5, (List)list3, (APTFileSearch)fileSystem);
    }

    private APTMacroMap getMacroMap(NativeFileItem nativeFileItem) {
        if (!this.isSourceFile(nativeFileItem)) {
            nativeFileItem = DefaultFileItem.toDefault(nativeFileItem);
        }
        List list = nativeFileItem.getUserMacroDefinitions();
        List list2 = nativeFileItem.getSystemMacroDefinitions();
        APTMacroMap aPTMacroMap = APTHandlersSupport.createMacroMap((APTMacroMap)this.getSysMacroMap(list2), (List)list);
        return aPTMacroMap;
    }

    protected final boolean isSourceFile(NativeFileItem nativeFileItem) {
        CsmFile.FileType fileType = Utils.getFileType(nativeFileItem);
        return FileImpl.isSourceFileType(fileType);
    }

    private APTMacroMap getSysMacroMap(List<String> list) {
        APTMacroMap aPTMacroMap = this.sysAPTData.getMacroMap(list.toString(), list);
        return aPTMacroMap;
    }

    public final APTPreprocHandler getPreprocHandler(CharSequence charSequence) {
        Collection<APTPreprocHandler.State> collection = this.getFileContainer().getPreprocStates(charSequence);
        APTPreprocHandler.State state = collection.isEmpty() ? null : collection.iterator().next();
        return this.createPreprocHandlerFromState(charSequence, state);
    }

    final APTPreprocHandler getPreprocHandler(CharSequence charSequence, PreprocessorStatePair preprocessorStatePair) {
        assert (preprocessorStatePair != null);
        return this.createPreprocHandlerFromState(charSequence, preprocessorStatePair.state);
    }

    final APTPreprocHandler createPreprocHandlerFromState(CharSequence charSequence, APTPreprocHandler.State state) {
        APTPreprocHandler aPTPreprocHandler = this.createEmptyPreprocHandler(charSequence);
        if (state != null) {
            if (state.isCleaned()) {
                return this.restorePreprocHandler(charSequence, aPTPreprocHandler, state);
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.println("copying state for " + charSequence);
            }
            aPTPreprocHandler.setState(state);
            return aPTPreprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.printf("null state for %s, returning default one", charSequence);
        }
        return aPTPreprocHandler;
    }

    final Collection<PreprocessorStatePair> getPreprocessorStatePairs(CharSequence charSequence) {
        return this.getFileContainer().getStatePairs(charSequence);
    }

    public final Collection<APTPreprocHandler> getPreprocHandlers(CharSequence charSequence) {
        Collection<APTPreprocHandler.State> collection = this.getFileContainer().getPreprocStates(charSequence);
        ArrayList<APTPreprocHandler> arrayList = new ArrayList<APTPreprocHandler>(collection.size());
        for (APTPreprocHandler.State state : collection) {
            APTPreprocHandler aPTPreprocHandler = this.createEmptyPreprocHandler(charSequence);
            if (state != null) {
                if (state.isCleaned()) {
                    aPTPreprocHandler = this.restorePreprocHandler(charSequence, aPTPreprocHandler, state);
                } else {
                    if (TRACE_PP_STATE_OUT) {
                        System.err.println("copying state for " + charSequence);
                    }
                    aPTPreprocHandler.setState(state);
                }
            }
            if (TRACE_PP_STATE_OUT) {
                System.err.printf("null state for %s, returning default one", charSequence);
            }
            arrayList.add(aPTPreprocHandler);
        }
        return arrayList;
    }

    public final Collection<APTPreprocHandler.State> getPreprocStates(FileImpl fileImpl) {
        FileContainer fileContainer = this.getFileContainer();
        return fileContainer.getPreprocStates(fileImpl.getAbsolutePath());
    }

    public final CsmFile testAPTParseFile(NativeFileItem nativeFileItem) {
        APTPreprocHandler aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
        return this.findFile(nativeFileItem.getAbsolutePath(), false, Utils.getFileType(nativeFileItem), aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final APTPreprocHandler.State setChangedFileState(NativeFileItem nativeFileItem) {
        APTPreprocHandler.State state = this.createPreprocHandler(nativeFileItem).getState();
        FileContainer fileContainer = this.getFileContainer();
        FileContainer.FileEntry fileEntry = fileContainer.getEntry(nativeFileItem.getAbsolutePath());
        Object object = fileEntry.getLock();
        synchronized (object) {
            fileEntry.invalidateStates();
            fileEntry.setState(state, FilePreprocessorConditionState.PARSING);
        }
        fileContainer.put();
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void invalidatePreprocState(CharSequence charSequence) {
        Object object;
        FileContainer fileContainer = this.getFileContainer();
        Object object2 = object = fileContainer.getLock(charSequence);
        synchronized (object2) {
            fileContainer.invalidatePreprocState(charSequence);
        }
        fileContainer.put();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void markAsParsingPreprocStates(CharSequence charSequence) {
        Object object;
        FileContainer fileContainer = this.getFileContainer();
        Object object2 = object = fileContainer.getLock(charSequence);
        synchronized (object2) {
            fileContainer.markAsParsingPreprocStates(charSequence);
        }
    }

    public final void debugInvalidateFiles() {
        this.getFileContainer().debugClearState();
        for (ProjectBase projectBase : this.getLibraries()) {
            projectBase.debugInvalidateFiles();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final FileImpl onFileIncluded(ProjectBase var1_1, CharSequence var2_2, APTPreprocHandler var3_3, PostIncludeData var4_4, int var5_5, boolean var6_6) throws IOException {
        if (!ProjectBase.$assertionsDisabled && var3_3 == null) {
            throw new AssertionError((Object)("null preprocHandler for " + var2_2));
        }
        var7_7 = null;
        if (this.isDisposing()) {
            return null;
        }
        var7_7 = this.findFile(var2_2, true, CsmFile.FileType.HEADER_FILE, var3_3, false, null, null);
        if (this.isDisposing()) {
            return var7_7;
        }
        var8_8 = var3_3.getState();
        var9_9 = null;
        var10_10 = null;
        var11_11 = null;
        var12_12 = false;
        if (var4_4 != null && var4_4.hasDeadBlocks()) {
            if (!ProjectBase.$assertionsDisabled && !var4_4.hasPostIncludeMacroState()) {
                throw new AssertionError((Object)("how could it be? " + var2_2));
            }
            var11_11 = FilePreprocessorConditionState.Builder.build(var2_2, var4_4.getDeadBlocks());
            var3_3.getMacroMap().setState(var4_4.getPostIncludeMacroState());
            var12_12 = true;
        }
        v0 = var13_13 = var5_5 == 1 && APTHandlersSupport.getIncludeStackDepth((APTPreprocHandler.State)var8_8) != 0;
        if (!var12_12 && var13_13 && (var9_9 = var7_7.getCachedVisitedState(var8_8)) != null) {
            var3_3.getMacroMap().setState(APTHandlersSupport.extractMacroMapState((APTPreprocHandler.State)var9_9.state));
            var11_11 = var9_9.pcState;
            var12_12 = true;
        }
        if (!var12_12) {
            var14_14 = this.getAPTLight(var7_7);
            if (var14_14 == null) {
                Utils.LOG.log(Level.INFO, "Can not find or build APT for file {0}", var2_2);
                return var7_7;
            }
            var15_16 = new FilePreprocessorConditionState.Builder(var7_7.getAbsolutePath());
            var10_10 = var7_7.getAPTCacheEntry(var3_3, Boolean.TRUE);
            var16_17 /* !! */  = new APTParseFileWalker(var1_1, var14_14, var7_7, var3_3, var6_6, (APTParseFileWalker.EvalCallback)var15_16, var10_10);
            var16_17 /* !! */ .visit();
            var11_11 = var15_16.build();
        }
        if (var4_4 != null && !var4_4.hasDeadBlocks()) {
            var4_4.setDeadBlocks(FilePreprocessorConditionState.Builder.getDeadBlocks(var11_11));
        }
        if (var9_9 == null && var13_13) {
            var7_7.cacheVisitedState(var8_8, var3_3, var11_11);
        }
        var14_15 = false;
        if (this.isDisposing()) {
            var15_16 = var7_7;
            if (var14_15 == false) return var15_16;
        }
        ** GOTO lbl-1000
        this.getFileContainer().put();
        return var15_16;
lbl-1000:
        // 1 sources

        {
            if (var6_6 == false) return var7_7;
            var15_16 = this.getFileContainer().getEntry(var7_7.getAbsolutePath());
            if (var15_16 != null) ** GOTO lbl-1000
            this.entryNotFoundMessage(var2_2);
            var16_17 /* !! */  = var7_7;
            if (var14_15 == false) return var16_17 /* !! */ ;
        }
        this.getFileContainer().put();
        return var16_17 /* !! */ ;
lbl-1000:
        // 1 sources

        {
            var16_17 /* !! */  = var15_16.getLock();
            synchronized (var16_17 /* !! */ ) {
                var17_18 = new ArrayList<PreprocessorStatePair>(4);
                var18_19 = new AtomicBoolean();
                var19_20 = var15_16.getStatePairs();
                var20_21 = this.fillStatesToKeepBasedOnPPState(var8_8, var19_20, var17_18, var18_19);
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(var2_2)) {
                    ProjectBase.traceIncludeStates("comparison 2 " + (Object)var20_21, var7_7, var8_8, var11_11, var18_19.get(), null, var17_18);
                }
                if (var20_21 != ComparisonResult.WORSE) ** break block42
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(var2_2)) {
                    ProjectBase.traceIncludeStates("worse 2", var7_7, var8_8, var11_11, false, null, var17_18);
                }
                var21_22 = var7_7;
            }
            if (var14_15 == false) return var21_22;
        }
        this.getFileContainer().put();
        return var21_22;
        {
            if (var20_21 == ComparisonResult.SAME && var18_19.get()) {
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(var2_2)) {
                    ProjectBase.traceIncludeStates("state is already here ", var7_7, var8_8, var11_11, false, null, var17_18);
                }
                var21_23 = var7_7;
                // MONITOREXIT @DISABLED, blocks:[25, 9] lbl78 : MonitorExitStatement: MONITOREXIT : var16_17 /* !! */ 
                if (var14_15 == false) return var21_23;
                this.getFileContainer().put();
                return var21_23;
            }
            if (!ProjectBase.$assertionsDisabled && var20_21 == ComparisonResult.WORSE) {
                throw new AssertionError();
            }
            var22_25 = new ArrayList<APTPreprocHandler.State>(4);
            var22_25.add(var8_8);
            if (var20_21 == ComparisonResult.BETTER) {
                var21_24 = true;
                CndUtils.assertTrueInConsole((boolean)var17_18.isEmpty(), (String)"states to keep must be empty 2");
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(var2_2)) {
                    ProjectBase.traceIncludeStates("best state", var7_7, var8_8, var11_11, var21_24, var22_25, var17_18);
                }
            } else {
                var21_24 = false;
                var20_21 = this.fillStatesToKeepBasedOnPCState(var11_11, new ArrayList<PreprocessorStatePair>(var17_18), var17_18);
                if (ProjectBase.TRACE_FILE && FileImpl.traceFile(var2_2)) {
                    ProjectBase.traceIncludeStates("pc state comparison " + (Object)var20_21, var7_7, var8_8, var11_11, var21_24, var22_25, var17_18);
                }
                switch (3.$SwitchMap$org$netbeans$modules$cnd$modelimpl$csm$core$ProjectBase$ComparisonResult[var20_21.ordinal()]) {
                    case 1: {
                        CndUtils.assertTrueInConsole((boolean)var17_18.isEmpty(), (String)"states to keep must be empty 3");
                        var21_24 = true;
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        var23_26 = var7_7;
                        // MONITOREXIT @DISABLED, blocks:[39, 9, 10, 13] lbl107 : MonitorExitStatement: MONITOREXIT : var16_17 /* !! */ 
                        if (var14_15 == false) return var23_26;
                        this.getFileContainer().put();
                        return var23_26;
                    }
                    default: {
                        if (!ProjectBase.$assertionsDisabled) {
                            throw new AssertionError((Object)("unexpected comparison result: " + (Object)var20_21));
                        }
                        var23_27 = var7_7;
                        // MONITOREXIT @DISABLED, blocks:[39, 9, 10, 14] lbl115 : MonitorExitStatement: MONITOREXIT : var16_17 /* !! */ 
                        if (var14_15 == false) return var23_27;
                        this.getFileContainer().put();
                        return var23_27;
                    }
                }
            }
            ** try [egrp 7[TRYBLOCK] [12 : 1001->1210)] { 
lbl119:
            // 1 sources

            if (this.isDisposing() != false) return var7_7;
            if (var1_1.isDisposing() != false) return var7_7;
            if (var21_24) {
                for (PreprocessorStatePair var24_29 : var17_18) {
                    if (var24_29.pcState == FilePreprocessorConditionState.PARSING) continue;
                    var22_25.add(var24_29.state);
                }
            }
            var7_7.setAPTCacheEntry(var3_3, var10_10, var21_24);
            var15_16.setStates(var17_18, new PreprocessorStatePair(var8_8, var11_11));
            ParserQueue.instance().add(var7_7, var22_25, ParserQueue.Position.HEAD, var21_24, var21_24 != false ? ParserQueue.FileAction.MARK_REPARSE : ParserQueue.FileAction.MARK_MORE_PARSE);
            var7_7.setAPTCacheEntry(var3_3, var10_10, var21_24);
            if (ProjectBase.TRACE_FILE && FileImpl.traceFile(var2_2) && (TraceFlags.TRACE_PC_STATE || TraceFlags.TRACE_PC_STATE_COMPARISION)) {
                ProjectBase.traceIncludeStates("scheduling", var7_7, var8_8, var11_11, var21_24, var22_25, var17_18);
            }
            var14_15 = true;
            return var7_7;
lbl136:
            // 1 sources

            finally {
                if (var14_15) {
                    this.getFileContainer().put();
                }
            }
        }
    }

    private void entryNotFoundMessage(CharSequence charSequence) {
        if (Utils.LOG.isLoggable(Level.INFO)) {
            Status status;
            StringBuilder stringBuilder = new StringBuilder("File container does not have file ");
            stringBuilder.append("[").append(charSequence).append("]");
            if (this.getFileContainer() == FileContainer.empty()) {
                stringBuilder.append(" because file container is EMPTY.");
            } else {
                stringBuilder.append(".");
            }
            if (this.isDisposing()) {
                stringBuilder.append("\n\tIt is very strange but project is disposing.");
            }
            if (!this.isValid()) {
                stringBuilder.append("\n\tIt is very strange but project is invalid.");
            }
            if ((status = this.getStatus()) != null) {
                stringBuilder.append("\n\tProject ").append(this.toString()).append(" has status ").append((Object)status).append(".");
            }
            Utils.LOG.info(stringBuilder.toString());
        }
    }

    private static void traceIncludeStates(CharSequence charSequence, FileImpl fileImpl, APTPreprocHandler.State state, FilePreprocessorConditionState filePreprocessorConditionState, boolean bl, Collection<APTPreprocHandler.State> collection, Collection<PreprocessorStatePair> collection2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (PreprocessorStatePair object : collection2) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object.pcState);
        }
        APTPreprocHandler aPTPreprocHandler = fileImpl.getProjectImpl(true).createEmptyPreprocHandler(fileImpl.getAbsolutePath());
        aPTPreprocHandler.setState(state);
        System.err.printf("%s %s (1) %s\n\tfrom %s \n\t%s %s \n\t%s keeping [%s]\n", charSequence, bl ? "reparse" : "  parse", fileImpl.getAbsolutePath(), APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state).getStartFile(), TraceUtils.getPreprocStateString(aPTPreprocHandler.getState()), TraceUtils.getMacroString(aPTPreprocHandler, TraceFlags.logMacros), filePreprocessorConditionState, stringBuilder);
        if (collection != null) {
            for (APTPreprocHandler.State state2 : collection) {
                if (state.equals(state2)) continue;
                FilePreprocessorConditionState filePreprocessorConditionState2 = null;
                for (PreprocessorStatePair preprocessorStatePair : collection2) {
                    if (!state.equals(preprocessorStatePair.state)) continue;
                    filePreprocessorConditionState2 = preprocessorStatePair.pcState;
                    break;
                }
                System.err.printf("%s %s (2) %s \n\tfrom %s\n\t valid %b context %b %s\n", charSequence, "  parse", fileImpl.getAbsolutePath(), APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state2).getStartFile(), state2.isValid(), state2.isCompileContext(), filePreprocessorConditionState2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean setParsedPCState(FileImpl fileImpl, APTPreprocHandler.State state, FilePreprocessorConditionState filePreprocessorConditionState) {
        boolean bl;
        FileContainer.FileEntry fileEntry = this.getFileContainer().getEntry(fileImpl.getAbsolutePath());
        if (fileEntry == null) {
            this.entryNotFoundMessage(fileImpl.getAbsolutePath());
            return false;
        }
        Object object = fileEntry.getLock();
        synchronized (object) {
            ArrayList<PreprocessorStatePair> arrayList = new ArrayList<PreprocessorStatePair>(4);
            Collection<PreprocessorStatePair> collection = fileEntry.getStatePairs();
            if (TraceFlags.TRACE_182342_BUG) {
                System.err.printf("setParsedPCState: original states for file: %s \n with new state: %s\n and pcState: %s\n", fileImpl, state, filePreprocessorConditionState);
                if (collection.isEmpty()) {
                    System.err.println("NO ORIGINAL STATES");
                } else {
                    int n = 0;
                    for (PreprocessorStatePair object2 : collection) {
                        System.err.printf("setParsedPCState: State %d from original %s\n", n++, object2);
                    }
                }
            }
            ArrayList<PreprocessorStatePair> arrayList2 = new ArrayList<PreprocessorStatePair>();
            bl = false;
            for (PreprocessorStatePair preprocessorStatePair : collection) {
                assert (preprocessorStatePair != null) : "can not be null element in " + collection;
                assert (preprocessorStatePair.state != null) : "state can not be null in pair " + preprocessorStatePair + " for file " + fileImpl;
                if (preprocessorStatePair.pcState == FilePreprocessorConditionState.PARSING && APTHandlersSupport.equalsIgnoreInvalid((APTPreprocHandler.State)preprocessorStatePair.state, (APTPreprocHandler.State)state)) {
                    assert (!bl);
                    bl = true;
                    continue;
                }
                arrayList2.add(preprocessorStatePair);
            }
            if (TraceFlags.TRACE_182342_BUG) {
                System.err.printf("setParsedPCState: %s found PARSING entry for file: %s \n", bl ? "" : "NOT", fileImpl);
                if (arrayList2.isEmpty()) {
                    System.err.println("NO KEPT STATES");
                } else {
                    int n = 0;
                    for (PreprocessorStatePair preprocessorStatePair : arrayList2) {
                        System.err.printf("setParsedPCState: State %d from copy %s\n", n++, preprocessorStatePair);
                    }
                }
            }
            if (bl) {
                ComparisonResult comparisonResult = this.fillStatesToKeepBasedOnPCState(filePreprocessorConditionState, arrayList2, arrayList);
                switch (comparisonResult) {
                    case BETTER: {
                        CndUtils.assertTrueInConsole((boolean)arrayList.isEmpty(), (String)"states to keep must be empty 3");
                        fileEntry.setStates(arrayList, new PreprocessorStatePair(state, filePreprocessorConditionState));
                        break;
                    }
                    case SAME: {
                        assert (!arrayList.isEmpty());
                        fileEntry.setStates(arrayList, new PreprocessorStatePair(state, filePreprocessorConditionState));
                        break;
                    }
                    case WORSE: {
                        assert (!arrayList2.isEmpty());
                        fileEntry.setStates(arrayList2, null);
                        break;
                    }
                    default: {
                        assert (false) : "unexpected comparison result: " + (Object)((Object)comparisonResult);
                        break;
                    }
                }
            }
        }
        if (bl) {
            object = this.getFileContainer();
            ((ProjectComponent)object).put();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyOnWaitParseLock() {
        Object object = this.waitParseLock;
        synchronized (object) {
            this.waitParseLock.notifyAll();
        }
    }

    public Iterator<CsmUID<CsmFile>> getFilteredFileUIDs(CsmSelect.NameAcceptor nameAcceptor) {
        FileContainer fileContainer = this.getFileContainer();
        Collection<CsmUID<CsmFile>> collection = fileContainer.getFilesUID();
        ArrayList<CsmUID<CsmFile>> arrayList = new ArrayList<CsmUID<CsmFile>>(collection.size());
        for (CsmUID<CsmFile> csmUID : collection) {
            CharSequence charSequence = FileInfoQueryImpl.getFileName(csmUID);
            if (!nameAcceptor.accept(charSequence)) continue;
            arrayList.add(csmUID);
        }
        return arrayList.iterator();
    }

    protected abstract SourceRootContainer getProjectRoots();

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    private ComparisonResult fillStatesToKeepBasedOnPPState(APTPreprocHandler.State state, Collection<PreprocessorStatePair> collection, Collection<PreprocessorStatePair> collection2, AtomicBoolean atomicBoolean) {
        if (state == null || !state.isValid()) {
            return ComparisonResult.WORSE;
        }
        collection2.clear();
        atomicBoolean.set(false);
        ComparisonResult comparisonResult = ComparisonResult.SAME;
        for (PreprocessorStatePair preprocessorStatePair : collection) {
            if (state.equals(preprocessorStatePair.state)) {
                assert (!atomicBoolean.get());
                atomicBoolean.set(true);
                continue;
            }
            boolean bl = false;
            if (preprocessorStatePair.state != null && preprocessorStatePair.state.isValid()) {
                if (preprocessorStatePair.state.isCompileContext()) {
                    bl = true;
                    if (!state.isCompileContext()) {
                        return ComparisonResult.WORSE;
                    }
                } else {
                    boolean bl2 = bl = !state.isCompileContext();
                }
            }
            if (bl) {
                if (!preprocessorStatePair.state.isCleaned()) {
                    preprocessorStatePair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), preprocessorStatePair.pcState);
                }
                collection2.add(preprocessorStatePair);
                continue;
            }
            comparisonResult = ComparisonResult.BETTER;
        }
        if (comparisonResult == ComparisonResult.BETTER) {
            CndUtils.assertTrueInConsole((boolean)collection2.isEmpty(), (String)"states to keep must be empty ");
        }
        return comparisonResult;
    }

    private ComparisonResult fillStatesToKeepBasedOnPCState(FilePreprocessorConditionState filePreprocessorConditionState, List<PreprocessorStatePair> list, List<PreprocessorStatePair> list2) {
        boolean bl = true;
        list2.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            PreprocessorStatePair preprocessorStatePair = list.get(i);
            if (preprocessorStatePair.pcState == FilePreprocessorConditionState.PARSING) {
                bl = false;
                if (!preprocessorStatePair.state.isCleaned()) {
                    preprocessorStatePair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), preprocessorStatePair.pcState);
                }
                list2.add(preprocessorStatePair);
                continue;
            }
            if (preprocessorStatePair.pcState.isBetterOrEqual(filePreprocessorConditionState)) {
                return ComparisonResult.WORSE;
            }
            if (filePreprocessorConditionState.isBetterOrEqual(preprocessorStatePair.pcState)) continue;
            bl = false;
            if (!preprocessorStatePair.state.isCleaned()) {
                preprocessorStatePair = new PreprocessorStatePair(APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)preprocessorStatePair.state), preprocessorStatePair.pcState);
            }
            list2.add(preprocessorStatePair);
        }
        if (bl) {
            assert (list2.isEmpty()) : "should be empty, but it is: " + Arrays.toString(list2.toArray());
            return ComparisonResult.BETTER;
        }
        return ComparisonResult.SAME;
    }

    public ProjectBase findFileProject(CharSequence charSequence, boolean bl) {
        if (bl) {
            this.ensureFilesCreated();
        }
        if (this.getFileUID(charSequence, false) != null) {
            return this;
        }
        for (CsmProject csmProject : this.getLibraries()) {
            if (bl) {
                ((ProjectBase)csmProject).ensureFilesCreated();
            }
            if (((ProjectBase)csmProject).getFileUID(charSequence, false) == null) continue;
            return (ProjectBase)csmProject;
        }
        return null;
    }

    public final boolean isMySource(String string) {
        return this.getProjectRoots().isMySource(string);
    }

    public abstract void onFileAdded(NativeFileItem var1);

    public abstract void onFileAdded(List<NativeFileItem> var1);

    public abstract void onFileImplRemoved(Collection<FileImpl> var1);

    public abstract void onFileRemoved(List<NativeFileItem> var1);

    public abstract void onFilePropertyChanged(NativeFileItem var1);

    public abstract void onFilePropertyChanged(List<NativeFileItem> var1);

    protected abstract ParserQueue.Position getIncludedFileParserQueuePosition();

    public abstract NativeFileItem getNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void putNativeFileItem(CsmUID<CsmFile> var1, NativeFileItem var2);

    protected abstract NativeFileItem removeNativeFileItem(CsmUID<CsmFile> var1);

    protected abstract void clearNativeFileContainer();

    public final void onFileRemoved(CharSequence charSequence) {
        this.onFileImplRemoved(Collections.singletonList(this.getFile(charSequence, false)));
    }

    public final void onFileExternalCreate(FileObject fileObject) {
        CndFileUtils.clearFileExistenceCache();
        DeepReparsingUtils.reparseOnAdded(fileObject, this);
    }

    public final void onFileExternalChange(FileImpl fileImpl) {
        DeepReparsingUtils.reparseOnChangedFile(fileImpl, this);
    }

    public final CsmFile findFile(Object object, boolean bl, boolean bl2) {
        CsmFile csmFile = null;
        if (object instanceof CharSequence) {
            csmFile = this.findFileByPath((CharSequence)object, bl);
        } else if (object instanceof NativeFileItem) {
            csmFile = this.findFileByItem((NativeFileItem)object, bl);
        }
        if (bl2 && csmFile instanceof FileImpl) {
            csmFile = ((FileImpl)csmFile).getSnapshot();
        }
        return csmFile;
    }

    final int getFileContainerSize() {
        return this.getFileContainer().getSize();
    }

    private CsmFile findFileByPath(CharSequence charSequence, boolean bl) {
        APTPreprocHandler aPTPreprocHandler = null;
        if (this.getFileContainer().getEntry(charSequence) == null) {
            NativeProject nativeProject;
            if (!bl) {
                return null;
            }
            NativeFileItem nativeFileItem = null;
            if (this.getPlatformProject() instanceof NativeProject && (nativeProject = (NativeProject)this.getPlatformProject()) != null) {
                FileObject fileObject = CndFileUtils.toFileObject((FileSystem)nativeProject.getFileSystem(), (CharSequence)((Object)charSequence).toString());
                if (fileObject != null) {
                    nativeFileItem = nativeProject.findFileItem(fileObject);
                }
                if (nativeFileItem == null) {
                    return null;
                }
                if (!Utils.acceptNativeItem(nativeFileItem)) {
                    return null;
                }
                aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
            }
            if (aPTPreprocHandler != null) {
                return this.findFile(charSequence, false, CsmFile.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
            }
        }
        return this.findFile(charSequence, false, CsmFile.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, null, null);
    }

    private CsmFile findFileByItem(NativeFileItem nativeFileItem, boolean bl) {
        String string = nativeFileItem.getAbsolutePath();
        APTPreprocHandler aPTPreprocHandler = null;
        if (this.getFileContainer().getEntry(string) == null) {
            NativeProject nativeProject;
            if (!bl || !Utils.acceptNativeItem(nativeFileItem)) {
                return null;
            }
            if (this.getPlatformProject() instanceof NativeProject && (nativeProject = nativeFileItem.getNativeProject()) != null && nativeFileItem.getFileObject() != null && nativeFileItem.getFileObject().isValid()) {
                aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
            }
            if (aPTPreprocHandler != null) {
                return this.findFile(string, false, CsmFile.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, aPTPreprocHandler.getState(), nativeFileItem);
            }
        }
        return this.findFile(string, false, CsmFile.FileType.UNDEFINED_FILE, aPTPreprocHandler, true, null, null);
    }

    protected final FileImpl findFile(CharSequence charSequence, boolean bl, CsmFile.FileType fileType, APTPreprocHandler aPTPreprocHandler, boolean bl2, APTPreprocHandler.State state, NativeFileItem nativeFileItem) {
        FileImpl fileImpl = this.getFile(charSequence, bl);
        if (fileImpl == null) {
            CndUtils.assertTrueInConsole((aPTPreprocHandler != null ? 1 : 0) != 0, (String)"null preprocHandler");
            if (aPTPreprocHandler == null) {
                Collection<APTPreprocHandler.State> collection = this.getFileContainer().getPreprocStates(charSequence);
                APTPreprocHandler.State state2 = collection.isEmpty() ? null : collection.iterator().next();
                aPTPreprocHandler = this.createPreprocHandlerFromState(charSequence, state2);
            }
            fileImpl = this.findFileImpl(charSequence, bl, fileType, aPTPreprocHandler, bl2, state, nativeFileItem);
        }
        return fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileImpl findFileImpl(CharSequence charSequence, boolean bl, CsmFile.FileType fileType, APTPreprocHandler aPTPreprocHandler, boolean bl2, APTPreprocHandler.State state, NativeFileItem nativeFileItem) {
        FileImpl fileImpl = null;
        boolean bl3 = false;
        Object object = this.fileContainerLock;
        synchronized (object) {
            fileImpl = this.getFile(charSequence, bl);
            if (fileImpl == null) {
                bl3 = true;
            }
        }
        if (bl3) {
            assert (aPTPreprocHandler != null) : "null preprocHandler for " + charSequence;
            object = CndFileUtils.toFileObject((FileSystem)this.fileSystem, (CharSequence)charSequence);
            CndUtils.assertTrueInConsole((object != null ? 1 : 0) != 0, (String)("file object not found " + charSequence + " in fs=" + this.fileSystem));
            FileBuffer fileBuffer = ModelSupport.createFileBuffer((FileObject)object);
            Object object2 = this.fileContainerLock;
            synchronized (object2) {
                fileImpl = this.getFile(charSequence, bl);
                if (fileImpl == null) {
                    fileImpl = new FileImpl(fileBuffer, this, fileType, nativeFileItem);
                    if (nativeFileItem != null) {
                        this.putNativeFileItem(fileImpl.getUID(), nativeFileItem);
                    }
                    this.putFile(fileImpl, state);
                    if (bl2) {
                        APTPreprocHandler.State state2 = aPTPreprocHandler.getState();
                        ParserQueue.instance().add(fileImpl, state2, ParserQueue.Position.TAIL);
                    }
                }
            }
        }
        if (fileType == CsmFile.FileType.SOURCE_FILE && !fileImpl.isSourceFile()) {
            fileImpl.setSourceFile();
        } else if (fileType == CsmFile.FileType.HEADER_FILE && !fileImpl.isHeaderFile()) {
            fileImpl.setHeaderFile();
        }
        return fileImpl;
    }

    protected final FileImpl createOrFindFileImpl(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        return this.createOrFindFileImpl(fileBuffer, nativeFileItem, Utils.getFileType(nativeFileItem)).fileImpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAndHandler createOrFindFileImpl(FileBuffer fileBuffer, NativeFileItem nativeFileItem, CsmFile.FileType fileType) {
        APTPreprocHandler aPTPreprocHandler = null;
        CharSequence charSequence = fileBuffer.getAbsolutePath();
        FileImpl fileImpl = this.getFile(charSequence, true);
        CsmUID<CsmFile> csmUID = null;
        if (fileImpl == null) {
            aPTPreprocHandler = this.createPreprocHandler(nativeFileItem);
            Object object = this.fileContainerLock;
            synchronized (object) {
                fileImpl = this.getFile(charSequence, true);
                if (fileImpl == null) {
                    assert (aPTPreprocHandler != null);
                    fileImpl = new FileImpl(fileBuffer, this, fileType, nativeFileItem);
                    this.putFile(fileImpl, aPTPreprocHandler.getState());
                } else {
                    csmUID = fileImpl.getUID();
                }
            }
        } else {
            csmUID = fileImpl.getUID();
        }
        if (csmUID != null) {
            this.putNativeFileItem(csmUID, nativeFileItem);
        }
        return new FileAndHandler(fileImpl, aPTPreprocHandler);
    }

    public final FileImpl getFile(CharSequence charSequence, boolean bl) {
        return this.getFileContainer().getFile(charSequence, bl);
    }

    public final CsmUID<CsmFile> getFileUID(CharSequence charSequence, boolean bl) {
        return this.getFileContainer().getFileUID(charSequence, bl);
    }

    protected final void removeFile(CharSequence charSequence) {
        this.getFileContainer().removeFile(charSequence);
    }

    protected final void putFile(FileImpl fileImpl, APTPreprocHandler.State state) {
        if (state != null && !state.isCleaned()) {
            state = APTHandlersSupport.createCleanPreprocState((APTPreprocHandler.State)state);
        }
        this.getFileContainer().putFile(fileImpl, state);
    }

    protected Collection<Key> getLibrariesKeys() {
        ArrayList<Key> arrayList = new ArrayList<Key>();
        if (this.platformProject instanceof NativeProject) {
            for (NativeProject nativeProject : ((NativeProject)this.platformProject).getDependences()) {
                Key key = ProjectBase.createProjectKey(nativeProject.getFileSystem(), nativeProject);
                if (key == null) continue;
                arrayList.add(key);
            }
        }
        if (!this.isArtificial()) {
            for (CsmUID csmUID : LibraryManager.getInstance().getLirariesKeys(this.getUID())) {
                arrayList.add(RepositoryUtils.UIDtoKey(csmUID));
            }
        }
        return arrayList;
    }

    public List<CsmProject> getLibraries() {
        int n;
        int n2;
        List<LibProjectImpl> list;
        ArrayList<CsmProject> arrayList = new ArrayList<CsmProject>();
        if (this.platformProject instanceof NativeProject) {
            list = ((NativeProject)this.platformProject).getDependences();
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                NativeProject nativeProject = (NativeProject)list.get(n);
                CsmProject csmProject = this.model.findProject(nativeProject);
                if (csmProject == null) continue;
                arrayList.add(csmProject);
            }
        }
        if (!this.isArtificial()) {
            list = LibraryManager.getInstance().getLibraries((ProjectImpl)this);
            n2 = list.size();
            for (n = 0; n < n2; ++n) {
                arrayList.add(list.get(n));
            }
        }
        return arrayList;
    }

    public final List<ProjectBase> getDependentProjects() {
        ArrayList<ProjectBase> arrayList = new ArrayList<ProjectBase>();
        for (CsmProject csmProject : this.model.projects()) {
            if (!(csmProject instanceof ProjectBase) || !csmProject.getLibraries().contains(this)) continue;
            arrayList.add((ProjectBase)csmProject);
        }
        return arrayList;
    }

    public final CsmClass getDummyForUnresolved(CharSequence[] charSequenceArray, CsmFile csmFile, int n) {
        if (Diagnostic.needStatistics()) {
            Diagnostic.onUnresolvedError(charSequenceArray, csmFile, n);
        }
        return this.getUnresolved().getDummyForUnresolved(charSequenceArray);
    }

    public final CsmClass getDummyForUnresolved(CharSequence charSequence) {
        return this.getUnresolved().getDummyForUnresolved(charSequence);
    }

    public final CsmNamespace getUnresolvedNamespace() {
        return this.getUnresolved().getUnresolvedNamespace();
    }

    public final CsmFile getUnresolvedFile() {
        return this.getUnresolved().getUnresolvedFile();
    }

    private synchronized Unresolved getUnresolved() {
        if (this.unresolved == null) {
            this.unresolved = new Unresolved(this);
        }
        return this.unresolved;
    }

    public final boolean isValid() {
        return this.platformProject != null && !this.isDisposing();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDisposed() {
        this.disposing.set(true);
        Object object = this.initializationTaskLock;
        synchronized (object) {
            if (this.initializationTask != null) {
                this.initializationTask.cancel();
                this.initializationTask = null;
            }
        }
        this.unregisterProjectListeners();
        ParserQueue.instance().removeAll(this);
    }

    public final boolean isDisposing() {
        return this.disposing.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose(boolean bl) {
        long l = 0L;
        if (TraceFlags.TIMING) {
            System.err.printf("\n\nProject %s: disposing...\n", this.name);
            l = System.currentTimeMillis();
        }
        this.setDisposed();
        try {
            this.disposeLock.writeLock().lock();
            ProjectSettingsValidator projectSettingsValidator = new ProjectSettingsValidator(this);
            projectSettingsValidator.storeSettings();
            this.getUnresolved().dispose();
            RepositoryUtils.closeUnit(this.getUID(), this.getRequiredUnits(), bl);
            this.platformProject = null;
            this.unresolved = null;
            this.uid = null;
        }
        finally {
            this.disposeLock.writeLock().unlock();
        }
        if (TraceFlags.TIMING) {
            l = System.currentTimeMillis() - l;
            System.err.printf("Project %s: disposing took %d ms\n", this.name, l);
        }
    }

    protected final Set<CharSequence> getRequiredUnits() {
        HashSet<CharSequence> hashSet = new HashSet<CharSequence>();
        for (Key key : this.getLibrariesKeys()) {
            hashSet.add(key.getUnit());
        }
        return hashSet;
    }

    private NamespaceImpl _getGlobalNamespace() {
        NamespaceImpl namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(this.globalNamespaceUID);
        if (namespaceImpl == null && this.preventMultiplyDiagnosticExceptionsGlobalNamespace < 5) {
            DiagnosticExceptoins.register(new IllegalStateException("Failed to get global namespace by key " + this.globalNamespaceUID));
            ++this.preventMultiplyDiagnosticExceptionsGlobalNamespace;
        }
        return namespaceImpl != null ? namespaceImpl : this.FAKE_GLOBAL_NAMESPACE;
    }

    private NamespaceImpl _getNamespace(CharSequence charSequence) {
        charSequence = CharSequences.create((CharSequence)charSequence);
        CsmUID<CsmNamespace> csmUID = this.namespaces.get(charSequence);
        NamespaceImpl namespaceImpl = (NamespaceImpl)UIDCsmConverter.UIDtoNamespace(csmUID);
        return namespaceImpl;
    }

    private void _registerNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        CharSequence charSequence = namespaceImpl.getQualifiedName();
        assert (CharSequences.isCompact((CharSequence)charSequence));
        CsmUID<NamespaceImpl> csmUID = RepositoryUtils.put(namespaceImpl);
        assert (csmUID != null);
        this.namespaces.put(charSequence, csmUID);
    }

    private void _unregisterNamespace(NamespaceImpl namespaceImpl) {
        assert (namespaceImpl != null);
        assert (!namespaceImpl.isGlobal());
        CharSequence charSequence = namespaceImpl.getQualifiedName();
        assert (CharSequences.isCompact((CharSequence)charSequence));
        CsmUID<CsmNamespace> csmUID = this.namespaces.remove(charSequence);
        assert (csmUID != null);
        RepositoryUtils.remove(csmUID, namespaceImpl);
    }

    protected final ModelImpl getModel() {
        return this.model;
    }

    public void onFileEditStart(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
    }

    public void onFileEditEnd(FileBuffer fileBuffer, NativeFileItem nativeFileItem, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final CsmUID<CsmProject> getUID() {
        CsmUID<CsmProject> csmUID = this.uid;
        if (csmUID == null) {
            ProjectBase projectBase = this;
            synchronized (projectBase) {
                if (this.uid == null) {
                    this.uid = csmUID = UIDUtilities.createProjectUID(this);
                }
            }
        }
        return this.uid;
    }

    public boolean isStable(CsmFile csmFile) {
        if (this.status == Status.Ready && !this.isDisposing()) {
            return !ParserQueue.instance().hasPendingProjectRelatedWork(this, (FileImpl)csmFile);
        }
        return false;
    }

    public final void onParseFinish() {
        this.onParseFinishImpl(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onParseFinishImpl(boolean bl) {
        Object object = this.waitParseLock;
        synchronized (object) {
            this.waitParseLock.notifyAll();
        }
        try {
            this.disposeLock.readLock().lock();
            if (!this.isDisposing() && !this.hasEditedFiles()) {
                new FakeRegistrationWorker(this, this.disposing).fixFakeRegistration(bl);
            }
        }
        catch (Exception exception) {
            DiagnosticExceptoins.register(exception);
        }
        finally {
            this.disposeLock.readLock().unlock();
            ProjectComponent.setStable(this.declarationsSorageKey);
            ProjectComponent.setStable(this.fileContainerKey);
            ProjectComponent.setStable(this.graphStorageKey);
            ProjectComponent.setStable(this.classifierStorageKey);
            ProjectBase.checkStates(this, bl);
            if (!bl) {
                ParseFinishNotificator.onParseFinish(this);
            }
        }
        if (TraceFlags.PARSE_STATISTICS) {
            ParseStatistics.getInstance().printResults(this);
            ParseStatistics.getInstance().clear(this);
        }
    }

    private static void checkStates(ProjectBase projectBase, boolean bl) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void trackFakeFunctionAST(CsmUID<CsmFile> csmUID, CsmUID<FunctionImplEx<?>> csmUID2, AST aST) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            Map<CsmUID<FunctionImplEx<?>>, AST> map2 = this.fakeASTs.get(csmUID);
            if (map2 == null) {
                map2 = new HashMap();
                if (aST != null) {
                    this.fakeASTs.put(csmUID, map2);
                }
            }
            if (aST == null) {
                map2.remove(csmUID2);
            } else {
                map2.put(csmUID2, aST);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanAllFakeFunctionAST(CsmUID<CsmFile> csmUID) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            this.fakeASTs.remove(csmUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void cleanAllFakeFunctionAST() {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            this.fakeASTs.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AST getFakeFunctionAST(CsmUID<CsmFile> csmUID, CsmUID<FunctionImplEx<?>> csmUID2) {
        Map<CsmUID<CsmFile>, Map<CsmUID<FunctionImplEx<?>>, AST>> map = this.fakeASTs;
        synchronized (map) {
            Map<CsmUID<FunctionImplEx<?>>, AST> map2 = this.fakeASTs.get(csmUID);
            return map2 == null ? null : map2.get(csmUID2);
        }
    }

    final void onLibParseFinish() {
        this.onParseFinishImpl(true);
    }

    public final Collection<CsmFile> getAllFiles() {
        return this.getFileContainer().getFiles();
    }

    public final Collection<CsmUID<CsmFile>> getAllFilesUID() {
        return this.getFileContainer().getFilesUID();
    }

    public final Collection<FileImpl> getAllFileImpls() {
        return this.getFileContainer().getFileImpls();
    }

    public final Collection<CsmFile> getSourceFiles() {
        ArrayList arrayList = new ArrayList();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (!fileImpl.isSourceFile()) continue;
            arrayList.add(fileImpl.getUID());
        }
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public final Collection<CsmFile> getHeaderFiles() {
        ArrayList arrayList = new ArrayList();
        for (FileImpl fileImpl : this.getAllFileImpls()) {
            if (fileImpl.isSourceFile()) continue;
            arrayList.add(fileImpl.getUID());
        }
        return new LazyCsmCollection(arrayList, TraceFlags.SAFE_UID_ACCESS);
    }

    public final long getMemoryUsageEstimation() {
        return this.getFileContainer().getSize();
    }

    public final String toString() {
        return ((Object)this.getName()).toString() + ' ' + this.getClass().getName() + " @" + this.hashCode() + ":" + System.identityHashCode(this);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = super.hashCode();
        }
        return this.hash;
    }

    public boolean equals(Object object) {
        return object == this;
    }

    private StartEntryInfo getStartEntryInfo(APTPreprocHandler aPTPreprocHandler, APTPreprocHandler.State state) {
        NativeFileItem nativeFileItem;
        FileImpl fileImpl;
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((APTPreprocHandler.State)state);
        ProjectBase projectBase = Utils.getStartProject(startEntry);
        FileImpl fileImpl2 = fileImpl = projectBase == null ? null : projectBase.getFile(startEntry.getStartFile(), false);
        if (fileImpl != null && (nativeFileItem = fileImpl.getNativeFileItem()) != null && nativeFileItem.getFileObject() != null && nativeFileItem.getFileObject().isValid()) {
            aPTPreprocHandler = projectBase.createPreprocHandler(nativeFileItem);
        }
        return new StartEntryInfo(aPTPreprocHandler, projectBase, fileImpl);
    }

    private APTPreprocHandler restorePreprocHandler(CharSequence charSequence, APTPreprocHandler aPTPreprocHandler, APTPreprocHandler.State state) {
        assert (state != null);
        assert (state.isCleaned());
        LinkedList linkedList = APTHandlersSupport.extractIncludeStack((APTPreprocHandler.State)state);
        assert (linkedList != null);
        if (linkedList.isEmpty()) {
            if (TRACE_PP_STATE_OUT) {
                System.err.println("stack is empty; return default for " + charSequence);
            }
            return this.getStartEntryInfo(aPTPreprocHandler, state).preprocHandler;
        }
        if (TRACE_PP_STATE_OUT) {
            System.err.println("restoring for " + charSequence);
        }
        return this.restorePreprocHandlerFromIncludeStack(linkedList, charSequence, aPTPreprocHandler, state);
    }

    protected final APTPreprocHandler restorePreprocHandlerFromIncludeStack(LinkedList<APTIncludeHandler.IncludeInfo> linkedList, CharSequence charSequence, APTPreprocHandler aPTPreprocHandler, APTPreprocHandler.State state) {
        assert (!linkedList.isEmpty()) : "state of stack is " + linkedList;
        LinkedList<APTIncludeHandler.IncludeInfo> linkedList2 = Utils.reverse(linkedList);
        StartEntryInfo startEntryInfo = this.getStartEntryInfo(aPTPreprocHandler, state);
        FileImpl fileImpl = startEntryInfo.csmFile;
        ProjectBase projectBase = startEntryInfo.startProject;
        aPTPreprocHandler = startEntryInfo.preprocHandler;
        APTFile aPTFile = null;
        try {
            aPTFile = fileImpl == null ? null : this.getAPTLight(fileImpl);
        }
        catch (IOException iOException) {
            System.err.println("can't restore preprocessor state for " + charSequence + "\nreason: " + iOException.getMessage());
            DiagnosticExceptoins.register(iOException);
        }
        boolean bl = false;
        if (aPTFile != null) {
            long l = REMEMBER_RESTORED ? System.currentTimeMillis() : 0L;
            int n = linkedList2.size();
            APTFileCacheEntry aPTFileCacheEntry = fileImpl.getAPTCacheEntry(aPTPreprocHandler, Boolean.FALSE);
            APTRestorePreprocStateWalker aPTRestorePreprocStateWalker = new APTRestorePreprocStateWalker(projectBase, aPTFile, fileImpl, aPTPreprocHandler, linkedList2, ((Object)FileContainer.getFileKey(charSequence, false)).toString(), aPTFileCacheEntry);
            aPTRestorePreprocStateWalker.visit();
            if (aPTPreprocHandler.isValid()) {
                if (REMEMBER_RESTORED) {
                    if (testRestoredFiles == null) {
                        testRestoredFiles = new ArrayList<String>();
                    }
                    FileImpl fileImpl2 = this.getFile(charSequence, false);
                    assert (fileImpl2 != null);
                    String string = charSequence + " [" + (fileImpl2.isHeaderFile() ? "H" : (fileImpl2.isSourceFile() ? "S" : "U")) + "]";
                    l = System.currentTimeMillis() - l;
                    string = string + " within " + l + "ms" + " stack " + n + " elems";
                    System.err.println("#" + testRestoredFiles.size() + " restored: " + string);
                    testRestoredFiles.add(string);
                }
                if (TRACE_PP_STATE_OUT) {
                    System.err.println("after restoring " + aPTPreprocHandler);
                }
                bl = true;
            }
        }
        if (!bl) {
            if (projectBase == null) {
                projectBase = this;
            }
            aPTPreprocHandler = projectBase.createDefaultPreprocHandler(charSequence);
        }
        return aPTPreprocHandler;
    }

    private NativeProject findNativeProjectHolder(Set<ProjectBase> set) {
        NativeProject nativeProject;
        block1: {
            set.add(this);
            nativeProject = ModelSupport.getNativeProject(this.getPlatformProject());
            if (nativeProject != null) break block1;
            List<ProjectBase> list = this.getDependentProjects();
            for (ProjectBase projectBase : list) {
                if (!set.contains(projectBase) && (nativeProject = projectBase.findNativeProjectHolder(set)) != null) break;
            }
        }
        return nativeProject;
    }

    private APTPreprocHandler createDefaultPreprocHandler(CharSequence charSequence) {
        NativeProject nativeProject = this.findNativeProjectHolder(new HashSet<ProjectBase>(10));
        APTPreprocHandler aPTPreprocHandler = null;
        if (nativeProject != null) {
            DefaultFileItem defaultFileItem = new DefaultFileItem(nativeProject, ((Object)charSequence).toString());
            aPTPreprocHandler = this.createPreprocHandler(defaultFileItem);
        } else {
            aPTPreprocHandler = this.createEmptyPreprocHandler(charSequence);
        }
        assert (aPTPreprocHandler != null) : "failed creating default ppState for " + charSequence;
        return aPTPreprocHandler;
    }

    public final APTFile getAPTLight(CsmFile csmFile) throws IOException {
        APTFile aPTFile = null;
        aPTFile = APTDriver.findAPTLight((APTFileBuffer)((FileImpl)csmFile).getBuffer());
        return aPTFile;
    }

    public final GraphContainer getGraph() {
        return this.getGraphStorage();
    }

    public static List<String> testGetRestoredFiles() {
        return testRestoredFiles;
    }

    public void write(DataOutput dataOutput) throws IOException {
        assert (dataOutput != null);
        PersistentUtils.writeFileSystem(this.fileSystem, dataOutput);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null);
        assert (this.name != null);
        PersistentUtils.writeUTF(this.name, dataOutput);
        uIDObjectFactory.writeUID(this.globalNamespaceUID, dataOutput);
        uIDObjectFactory.writeStringToUIDMap(this.namespaces, dataOutput, false);
        ProjectComponent.writeKey(this.fileContainerKey, dataOutput);
        ProjectComponent.writeKey(this.declarationsSorageKey, dataOutput);
        ProjectComponent.writeKey(this.graphStorageKey, dataOutput);
        ProjectComponent.writeKey(this.classifierStorageKey, dataOutput);
        PersistentUtils.writeUTF(this.uniqueName, dataOutput);
    }

    protected ProjectBase(DataInput dataInput) throws IOException {
        this.fileSystem = PersistentUtils.readFileSystem(dataInput);
        this.sysAPTData = APTSystemStorage.getInstance();
        this.userPathStorage = new APTIncludePathStorage();
        this.setStatus(Status.Restored);
        assert (dataInput != null);
        UIDObjectFactory uIDObjectFactory = UIDObjectFactory.getDefaultFactory();
        assert (uIDObjectFactory != null) : "default UID factory can not be bull";
        this.name = PersistentUtils.readUTF(dataInput, ProjectNameCache.getManager());
        assert (this.name != null) : "project name can not be null";
        this.globalNamespaceUID = uIDObjectFactory.readUID(dataInput);
        assert (this.globalNamespaceUID != null) : "globalNamespaceUID can not be null";
        int n = dataInput.readInt();
        this.namespaces = n <= 0 ? new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(0) : new ConcurrentHashMap<CharSequence, CsmUID<CsmNamespace>>(n);
        uIDObjectFactory.readStringToUIDMap(this.namespaces, dataInput, QualifiedNameCache.getManager(), n);
        this.fileContainerKey = ProjectComponent.readKey(dataInput);
        assert (this.fileContainerKey != null) : "fileContainerKey can not be null";
        this.weakFileContainer = new WeakContainer(this, this.fileContainerKey);
        this.declarationsSorageKey = ProjectComponent.readKey(dataInput);
        assert (this.declarationsSorageKey != null) : "declarationsSorageKey can not be null";
        this.weakDeclarationContainer = new WeakContainer(this, this.declarationsSorageKey);
        this.graphStorageKey = ProjectComponent.readKey(dataInput);
        assert (this.graphStorageKey != null) : "graphStorageKey can not be null";
        this.weakGraphContainer = new WeakContainer(this, this.graphStorageKey);
        this.classifierStorageKey = ProjectComponent.readKey(dataInput);
        assert (this.classifierStorageKey != null) : "classifierStorageKey can not be null";
        this.weakClassifierContainer = new WeakContainer(this, this.classifierStorageKey);
        this.uniqueName = PersistentUtils.readUTF(dataInput, ProjectNameCache.getManager());
        assert (this.uniqueName != null) : "uniqueName can not be null";
        this.model = (ModelImpl)CsmModelAccessor.getModel();
        this.FAKE_GLOBAL_NAMESPACE = NamespaceImpl.create(this, true);
    }

    DeclarationContainerProject getDeclarationsSorage() {
        DeclarationContainerProject declarationContainerProject = this.weakDeclarationContainer.getContainer();
        return declarationContainerProject != null ? declarationContainerProject : DeclarationContainerProject.empty();
    }

    FileContainer getFileContainer() {
        FileContainer fileContainer = this.weakFileContainer.getContainer();
        return fileContainer != null ? fileContainer : FileContainer.empty();
    }

    public void traceFileContainer(PrintWriter printWriter) {
        FileContainer fileContainer = this.getFileContainer();
        Set<Map.Entry<CharSequence, FileContainer.FileEntry>> set = fileContainer.getFileStorage().entrySet();
        printWriter.printf("FileContainer (%d) for project %s\n", set.size(), this.toString());
        for (Map.Entry<CharSequence, FileContainer.FileEntry> entry : set) {
            printWriter.println("\tEntry " + entry.getKey());
            if (entry.getValue().getStatePairs().isEmpty()) {
                printWriter.println("\t\tState EMPTY");
                continue;
            }
            block1: for (PreprocessorStatePair preprocessorStatePair : entry.getValue().getStatePairs()) {
                printWriter.println("\t\tState");
                String string = preprocessorStatePair.toString();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if ("Snapshot".equals(string2)) {
                        printWriter.println("\t\t\t" + string2 + "{...}");
                        continue block1;
                    }
                    printWriter.println("\t\t\t" + string2);
                }
            }
        }
    }

    public final GraphContainer getGraphStorage() {
        GraphContainer graphContainer = this.weakGraphContainer.getContainer();
        return graphContainer != null ? graphContainer : GraphContainer.empty();
    }

    final ClassifierContainer getClassifierSorage() {
        ClassifierContainer classifierContainer = this.weakClassifierContainer.getContainer();
        return classifierContainer != null ? classifierContainer : ClassifierContainer.empty();
    }

    public void traceProjectContainers(PrintStream printStream) {
        ProjectBase.dumpProjectContainers(this.getClassifierSorage(), printStream);
        ProjectBase.dumpProjectContainers(this.getDeclarationsSorage(), printStream);
    }

    private static void dumpProjectContainers(ClassifierContainer classifierContainer, PrintStream printStream) {
        printStream.println("\n========== Dumping Dump Project Classifiers");
        for (Map.Entry<CharSequence, CsmClassifier> entry : classifierContainer.getClassifiers().entrySet()) {
            printStream.print("\t" + ((Object)entry.getKey()).toString() + " ");
            if (entry.getValue() == null) {
                printStream.println("null");
                continue;
            }
            printStream.println(entry.getValue().getUniqueName());
        }
        printStream.println("\n========== Dumping Dump Project Typedefs");
        for (Map.Entry<CharSequence, CsmClassifier> entry : classifierContainer.getTypedefs().entrySet()) {
            printStream.print("\t" + ((Object)entry.getKey()).toString() + " ");
            if (entry.getValue() == null) {
                printStream.println("null");
                continue;
            }
            printStream.println(entry.getValue().getUniqueName());
        }
    }

    private static void dumpProjectContainers(DeclarationContainerProject declarationContainerProject, PrintStream printStream) {
        TreeMap<CharSequence, Object> treeMap;
        printStream.println("\n========== Dumping Project declarations");
        for (Map.Entry<CharSequence, Object> entry : declarationContainerProject.testDeclarations().entrySet()) {
            printStream.println("\t" + ((Object)entry.getKey()).toString());
            treeMap = new TreeMap<CharSequence, Object>();
            Iterator<Object> iterator = entry.getValue();
            if (iterator instanceof CsmUID[]) {
                CsmUID[] csmUIDArray = (CsmUID[])iterator;
                for (CsmUID csmUID : csmUIDArray) {
                    treeMap.put(((CsmOffsetableDeclaration)csmUID.getObject()).getContainingFile().getAbsolutePath(), csmUID.getObject());
                }
            } else if (iterator instanceof CsmUID) {
                CsmUID csmUID = (CsmUID)iterator;
                treeMap.put(((CsmOffsetableDeclaration)csmUID.getObject()).getContainingFile().getAbsolutePath(), csmUID.getObject());
            }
            for (CsmFriend csmFriend : treeMap.entrySet()) {
                printStream.println("\t\t" + csmFriend.getValue() + " from " + csmFriend.getKey());
            }
        }
        printStream.println("\n========== Dumping Project friends");
        for (Map.Entry<CharSequence, Object> entry : declarationContainerProject.testFriends().entrySet()) {
            printStream.println("\t" + ((Object)entry.getKey()).toString());
            treeMap = new TreeMap();
            for (CsmUID csmUID : (Set)entry.getValue()) {
                CsmFriend csmFriend;
                csmFriend = (CsmFriend)csmUID.getObject();
                treeMap.put(csmFriend.getQualifiedName(), csmFriend);
            }
            for (Map.Entry entry2 : treeMap.entrySet()) {
                printStream.println("\t\t" + entry2.getKey() + " " + entry2.getValue());
            }
        }
    }

    public static final class WeakContainer<T> {
        private WeakReference<T> weakContainer = TraceFlags.USE_WEAK_MEMORY_CACHE ? new WeakReference<Object>(null) : null;
        private int preventMultiplyDiagnosticExceptionsSorage = 0;
        private final ProjectBase project;
        private final Key sorageKey;

        public WeakContainer(ProjectBase projectBase, Key key) {
            this.project = projectBase;
            this.sorageKey = key;
        }

        synchronized void clear() {
            if (TraceFlags.USE_WEAK_MEMORY_CACHE) {
                this.weakContainer.clear();
            }
        }

        synchronized T getContainer() {
            Object object = null;
            WeakReference<T> weakReference = null;
            if (TraceFlags.USE_WEAK_MEMORY_CACHE && this.project.isValid() && (weakReference = this.weakContainer) != null && (object = weakReference.get()) != null) {
                return (T)object;
            }
            object = RepositoryUtils.get(this.sorageKey);
            if (object == null && this.project.isValid() && this.preventMultiplyDiagnosticExceptionsSorage < 3) {
                DiagnosticExceptoins.register(new IllegalStateException("Failed to get container sorage by key " + this.sorageKey));
                ++this.preventMultiplyDiagnosticExceptionsSorage;
            }
            if (TraceFlags.USE_WEAK_MEMORY_CACHE && object != null && this.weakContainer != null) {
                this.weakContainer = new WeakReference<Persistent>((Persistent)object);
            }
            return (T)object;
        }
    }

    private static final class FileContainerLock {
        private FileContainerLock() {
        }
    }

    private static final class NamespaceLock {
        private NamespaceLock() {
        }
    }

    private static final class ClassifierReplaceLock {
        private ClassifierReplaceLock() {
        }
    }

    private static final class WaitParseLock {
        private WaitParseLock() {
        }
    }

    private static final class InitializationTaskLock {
        private InitializationTaskLock() {
        }
    }

    protected static enum Status {
        Initial,
        Restored,
        AddingFiles,
        Validating,
        Ready;

    }

    private static final class DefaultFileItem
    implements NativeFileItem {
        private final NativeProject project;
        private final String normalizedAbsPath;

        public DefaultFileItem(NativeProject nativeProject, String string) {
            Parameters.notNull((CharSequence)"project", (Object)nativeProject);
            Parameters.notNull((CharSequence)"absolutePath", (Object)string);
            this.project = nativeProject;
            this.normalizedAbsPath = CndFileUtils.normalizeAbsolutePath((FileSystem)nativeProject.getFileSystem(), (String)string);
        }

        public DefaultFileItem(NativeFileItem nativeFileItem) {
            Parameters.notNull((CharSequence)"nativeFile", (Object)nativeFileItem);
            this.project = nativeFileItem.getNativeProject();
            this.normalizedAbsPath = nativeFileItem.getAbsolutePath();
            CndUtils.assertNormalized((FileSystem)this.project.getFileSystem(), (CharSequence)this.normalizedAbsPath);
            Parameters.notNull((CharSequence)"nativeFile.getAbsolutePath()", (Object)this.normalizedAbsPath);
        }

        public static NativeFileItem toDefault(NativeFileItem nativeFileItem) {
            if (!(nativeFileItem instanceof DefaultFileItem)) {
                nativeFileItem = new DefaultFileItem(nativeFileItem);
            }
            return nativeFileItem;
        }

        public List<String> getUserMacroDefinitions() {
            if (this.project != null) {
                return this.project.getUserMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<FSPath> getUserIncludePaths() {
            if (this.project != null) {
                return this.project.getUserIncludePaths();
            }
            return Collections.emptyList();
        }

        public List<String> getSystemMacroDefinitions() {
            if (this.project != null) {
                return this.project.getSystemMacroDefinitions();
            }
            return Collections.emptyList();
        }

        public List<FSPath> getSystemIncludePaths() {
            if (this.project != null) {
                return this.project.getSystemIncludePaths();
            }
            return Collections.emptyList();
        }

        public NativeProject getNativeProject() {
            return this.project;
        }

        public FileObject getFileObject() {
            return CndFileUtils.toFileObject((FileSystem)this.project.getFileSystem(), (CharSequence)this.normalizedAbsPath);
        }

        public String getAbsolutePath() {
            return this.normalizedAbsPath;
        }

        public String getName() {
            return CndPathUtilitities.getBaseName((String)this.normalizedAbsPath);
        }

        public NativeFileItem.Language getLanguage() {
            return NativeFileItem.Language.C_HEADER;
        }

        public NativeFileItem.LanguageFlavor getLanguageFlavor() {
            return NativeFileItem.LanguageFlavor.UNKNOWN;
        }

        public boolean isExcluded() {
            return false;
        }

        public String toString() {
            return this.normalizedAbsPath + ' ' + this.project.getFileSystem().getDisplayName();
        }
    }

    private static class StartEntryInfo {
        private final APTPreprocHandler preprocHandler;
        private final ProjectBase startProject;
        private final FileImpl csmFile;

        public StartEntryInfo(APTPreprocHandler aPTPreprocHandler, ProjectBase projectBase, FileImpl fileImpl) {
            this.preprocHandler = aPTPreprocHandler;
            this.startProject = projectBase;
            this.csmFile = fileImpl;
        }
    }

    private static class FileAndHandler {
        private final FileImpl fileImpl;
        private APTPreprocHandler preprocHandler;

        public FileAndHandler(FileImpl fileImpl, APTPreprocHandler aPTPreprocHandler) {
            this.fileImpl = fileImpl;
            this.preprocHandler = aPTPreprocHandler;
        }
    }

    private static enum ComparisonResult {
        BETTER,
        SAME,
        WORSE;

    }
}

