/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.apt.support.APTDriver;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCacheManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.DeepReparsingUtils;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileBuffer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.LibraryManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.NativeFileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Notificator;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserQueue;
import org.netbeans.modules.cnd.modelimpl.csm.core.ParserThreadManager;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.SourceRootContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.debug.Diagnostic;
import org.netbeans.modules.cnd.modelimpl.debug.DiagnosticExceptoins;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelutil.NamedEntity;
import org.netbeans.modules.cnd.modelutil.NamedEntityOptions;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileSystem;
import org.openide.util.RequestProcessor;

public final class ProjectImpl
extends ProjectBase {
    private final Map<CsmFile, EditingTask> editedFiles = new HashMap<CsmFile, EditingTask>();
    private final NativeFileContainer nativeFiles = new NativeFileContainer();
    private final SourceRootContainer projectRoots = new SourceRootContainer(false);
    private static final RequestProcessor RP = new RequestProcessor("ProjectImpl RP", 50);

    private ProjectImpl(ModelImpl modelImpl, FileSystem fileSystem, Object object, String string) {
        super(modelImpl, fileSystem, object, string);
    }

    public static ProjectImpl createInstance(ModelImpl modelImpl, NativeProject nativeProject, String string) {
        return ProjectImpl.createInstance(modelImpl, nativeProject.getFileSystem(), nativeProject, string);
    }

    private static ProjectImpl createInstance(ModelImpl modelImpl, FileSystem fileSystem, Object object, String string) {
        ProjectBase projectBase = null;
        if (TraceFlags.PERSISTENT_REPOSITORY) {
            try {
                projectBase = ProjectImpl.readInstance(modelImpl, fileSystem, object, string);
            }
            catch (Exception exception) {
                ProjectImpl.cleanRepository(fileSystem, object, false);
                DiagnosticExceptoins.register(exception);
            }
        }
        if (projectBase == null) {
            projectBase = new ProjectImpl(modelImpl, fileSystem, object, string);
        }
        CndUtils.assertTrue((projectBase.getFileSystem() == fileSystem ? 1 : 0) != 0);
        return (ProjectImpl)projectBase;
    }

    @Override
    protected final ParserQueue.Position getIncludedFileParserQueuePosition() {
        return ParserQueue.Position.HEAD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditStart(FileBuffer fileBuffer, NativeFileItem nativeFileItem) {
        FileImpl fileImpl;
        if (!Utils.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditSTART " + fileBuffer.getUrl());
        }
        if ((fileImpl = this.createOrFindFileImpl(fileBuffer, nativeFileItem)) != null) {
            APTDriver.invalidateAPT((APTFileBuffer)fileBuffer);
            APTFileCacheManager.getInstance((FileSystem)fileBuffer.getFileSystem()).invalidate(fileBuffer.getAbsolutePath());
            ChangeListener changeListener = new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent changeEvent) {
                    ProjectImpl.this.scheduleParseOnEditing(fileImpl);
                }
            };
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("onFileEditStart: edited file " + csmFile);
                    }
                    System.err.println("onFileEditStart: current file " + fileImpl);
                }
                fileImpl.setBuffer(fileBuffer);
                if (!this.editedFiles.containsKey(fileImpl)) {
                    this.editedFiles.put(fileImpl, new EditingTask(fileBuffer, changeListener));
                }
                this.scheduleParseOnEditing(fileImpl);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileEditEnd(FileBuffer fileBuffer, NativeFileItem nativeFileItem, boolean bl) {
        FileImpl fileImpl;
        if (!Utils.acceptNativeItem(nativeFileItem)) {
            return;
        }
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFileEditEND " + fileBuffer.getUrl());
        }
        if ((fileImpl = this.getFile(fileBuffer.getAbsolutePath(), false)) != null) {
            Map<CsmFile, EditingTask> map = this.editedFiles;
            synchronized (map) {
                Object object;
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    object = this.editedFiles.keySet().iterator();
                    while (object.hasNext()) {
                        CsmFile csmFile = (CsmFile)object.next();
                        System.err.println("onFileEditEnd: edited file " + csmFile);
                    }
                    System.err.println("onFileEditEnd: " + (bl ? "undo" : "save") + " current file " + fileImpl);
                }
                if ((object = this.editedFiles.remove(fileImpl)) == null) {
                    return;
                }
                ((EditingTask)object).cancelTask();
                fileImpl.setBuffer(fileBuffer);
            }
            if (bl) {
                DeepReparsingUtils.reparseOnEditingFile(this, fileImpl);
            }
        }
    }

    @Override
    public void onFilePropertyChanged(NativeFileItem nativeFileItem) {
        if (TraceFlags.DEBUG) {
            Diagnostic.trace("------------------------- onFilePropertyChanged " + nativeFileItem.getName());
        }
        DeepReparsingUtils.reparseOnPropertyChanged(Collections.singletonList(nativeFileItem), this);
    }

    @Override
    public void onFilePropertyChanged(List<NativeFileItem> list) {
        if (list.size() > 0) {
            DeepReparsingUtils.reparseOnPropertyChanged(list, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileImplRemoved(Collection<FileImpl> collection) {
        try {
            EditingTask editingTask;
            Object object = this.editedFiles;
            synchronized (object) {
                for (FileImpl fileImpl : collection) {
                    editingTask = this.editedFiles.remove(fileImpl);
                    if (editingTask == null) continue;
                    editingTask.cancelTask();
                }
            }
            object = new LinkedList();
            for (FileImpl fileImpl : collection) {
                if (fileImpl == null || (editingTask = this.removeNativeFileItem(fileImpl.getUID())) == null) continue;
                ((LinkedList)object).addLast(fileImpl);
                fileImpl.dispose();
                this.removeFile(fileImpl.getAbsolutePath());
                FileBuffer fileBuffer = fileImpl.getBuffer();
                APTDriver.invalidateAPT((APTFileBuffer)fileBuffer);
                APTFileCacheManager.getInstance((FileSystem)fileBuffer.getFileSystem()).invalidate(fileBuffer.getAbsolutePath());
                ParserQueue.instance().remove(fileImpl);
            }
            DeepReparsingUtils.reparseOnRemoved((Collection<FileImpl>)object, this);
        }
        finally {
            Notificator.instance().flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileRemoved(List<NativeFileItem> list) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<FileImpl> arrayList = new ArrayList<FileImpl>();
            for (NativeFileItem nativeFileItem : list) {
                FileImpl fileImpl = this.getFile(nativeFileItem.getAbsolutePath(), false);
                if (fileImpl == null) continue;
                arrayList.add(fileImpl);
            }
            this.onFileImplRemoved(arrayList);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    @Override
    public void onFileAdded(NativeFileItem nativeFileItem) {
        this.onFileAddedImpl(nativeFileItem, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeFileItem onFileAddedImpl(NativeFileItem nativeFileItem, boolean bl) {
        if (Utils.acceptNativeItem(nativeFileItem)) {
            CndFileUtils.clearFileExistenceCache();
            try {
                this.createIfNeed(nativeFileItem, this.isSourceFile(nativeFileItem));
                NativeFileItem nativeFileItem2 = nativeFileItem;
                return nativeFileItem2;
            }
            finally {
                Notificator.instance().flush();
                if (bl) {
                    DeepReparsingUtils.reparseOnAdded(Collections.singletonList(nativeFileItem), (ProjectBase)this);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFileAdded(List<NativeFileItem> list) {
        try {
            ParserQueue.instance().onStartAddingProjectFiles(this);
            ArrayList<NativeFileItem> arrayList = new ArrayList<NativeFileItem>();
            for (NativeFileItem nativeFileItem : list) {
                NativeFileItem nativeFileItem2 = this.onFileAddedImpl(nativeFileItem, false);
                if (nativeFileItem2 == null) continue;
                arrayList.add(nativeFileItem2);
            }
            DeepReparsingUtils.reparseOnAdded(arrayList, (ProjectBase)this);
        }
        finally {
            ParserQueue.instance().onEndAddingProjectFiles(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void ensureChangedFilesEnqueued() {
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            super.ensureChangedFilesEnqueued();
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (fileImpl.isParsingOrParsed()) continue;
                ParserQueue.instance().add(fileImpl, this.getPreprocHandler(fileImpl.getAbsolutePath()).getState(), ParserQueue.Position.TAIL);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasChangedFiles(CsmFile csmFile) {
        if (csmFile == null) {
            return false;
        }
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (FileImpl fileImpl : this.editedFiles.keySet()) {
                if (csmFile == fileImpl || fileImpl.isParsingOrParsed()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean hasEditedFiles() {
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            return !this.editedFiles.isEmpty();
        }
    }

    @Override
    public ProjectBase findFileProject(CharSequence charSequence, boolean bl) {
        ProjectBase projectBase = super.findFileProject(charSequence, bl);
        if (projectBase == null && ParserThreadManager.instance().isStandalone()) {
            projectBase = ((Object)charSequence).toString().startsWith("/usr") ? projectBase : this;
        }
        return projectBase;
    }

    public boolean isArtificial() {
        return false;
    }

    @Override
    public NativeFileItem getNativeFileItem(CsmUID<CsmFile> csmUID) {
        return this.nativeFiles.getNativeFileItem(csmUID);
    }

    @Override
    protected void putNativeFileItem(CsmUID<CsmFile> csmUID, NativeFileItem nativeFileItem) {
        this.nativeFiles.putNativeFileItem(csmUID, nativeFileItem);
    }

    @Override
    protected NativeFileItem removeNativeFileItem(CsmUID<CsmFile> csmUID) {
        return this.nativeFiles.removeNativeFileItem(csmUID);
    }

    @Override
    protected void clearNativeFileContainer() {
        this.nativeFiles.clear();
    }

    @Override
    protected SourceRootContainer getProjectRoots() {
        return this.projectRoots;
    }

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        LibraryManager.getInstance().writeProjectLibraries(this.getUID(), dataOutput);
    }

    public ProjectImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        LibraryManager.getInstance().readProjectLibraries(this.getUID(), dataInput);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleParseOnEditing(final FileImpl fileImpl) {
        int n;
        RequestProcessor.Task task;
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            EditingTask editingTask;
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                new Exception("scheduleParseOnEditing " + fileImpl).printStackTrace(System.err);
            }
            if ((editingTask = this.editedFiles.get(fileImpl)) == null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.println("scheduleParseOnEditing: file was removed " + fileImpl);
                }
                return;
            }
            if (!editingTask.updateLastModified()) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    System.err.println("scheduleParseOnEditing: no updates " + fileImpl + " : " + editingTask.lastModified);
                }
                return;
            }
            task = editingTask.getTask();
            if (task == null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    for (CsmFile csmFile : this.editedFiles.keySet()) {
                        System.err.println("scheduleParseOnEditing: edited file " + csmFile);
                    }
                    System.err.println("scheduleParseOnEditing: current file " + fileImpl);
                }
                task = RP.create(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                                System.err.printf("scheduleParseOnEditing: RUN scheduleParseOnEditing task for %s\n", fileImpl);
                            }
                            if (ProjectImpl.this.isDisposing()) {
                                return;
                            }
                            DeepReparsingUtils.reparseOnEditingFile(ProjectImpl.this, fileImpl);
                        }
                        catch (AssertionError assertionError) {
                            DiagnosticExceptoins.register((Throwable)((Object)assertionError));
                        }
                        catch (Exception exception) {
                            DiagnosticExceptoins.register(exception);
                        }
                    }
                }, true);
                task.setPriority(1);
                editingTask.setTask(task);
            } else if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                for (CsmFile csmFile : this.editedFiles.keySet()) {
                    System.err.println("reschedule in scheduleParseOnEditing: edited file " + csmFile);
                }
                System.err.println("reschedule in scheduleParseOnEditing: current file " + fileImpl);
            }
            n = TraceFlags.REPARSE_DELAY;
            boolean bl = NamedEntityOptions.instance().isEnabled(new NamedEntity(){

                public String getName() {
                    return "reparse-on-document-changed";
                }

                public boolean isEnabledByDefault() {
                    return true;
                }
            });
            if (bl) {
                if (fileImpl.getLastParseTime() / (n + 1) > 2) {
                    n = Math.max(n, fileImpl.getLastParseTime() + 2000);
                }
            } else {
                n = Integer.MAX_VALUE;
            }
        }
        task.schedule(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setDisposed() {
        super.setDisposed();
        Map<CsmFile, EditingTask> map = this.editedFiles;
        synchronized (map) {
            for (EditingTask editingTask : this.editedFiles.values()) {
                editingTask.cancelTask();
            }
            this.editedFiles.clear();
        }
    }

    private static final class EditingTask {
        private RequestProcessor.Task task;
        private final ChangeListener bufListener;
        private final FileBuffer buf;
        private long lastModified = -1L;

        public EditingTask(FileBuffer fileBuffer, ChangeListener changeListener) {
            assert (changeListener != null);
            this.bufListener = changeListener;
            assert (fileBuffer != null);
            this.buf = fileBuffer;
            this.buf.addChangeListener(changeListener);
        }

        public boolean updateLastModified() {
            long l = this.buf.lastModified();
            if (this.lastModified == l) {
                return false;
            }
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("EditingTask.updateLastModified: set lastModified from %d to %d\n", this.lastModified, l);
            }
            this.lastModified = l;
            return true;
        }

        public void setTask(RequestProcessor.Task task) {
            if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                System.err.printf("EditingTask.setTask: set new EditingTask %d for %s\n", task.hashCode(), this.buf.getUrl());
            }
            this.task = task;
        }

        public void cancelTask() {
            if (this.task != null) {
                if (TraceFlags.TRACE_182342_BUG || TraceFlags.TRACE_191307_BUG) {
                    if (!this.task.isFinished()) {
                        new Exception("EditingTask.cancelTask: cancelling previous EditingTask " + this.task.hashCode()).printStackTrace(System.err);
                    } else {
                        new Exception("EditingTask.cancelTask: cancelTask where EditingTask was finished " + this.task.hashCode()).printStackTrace(System.err);
                    }
                }
                try {
                    this.task.cancel();
                }
                catch (Throwable throwable) {
                    System.err.println("EditingTask.cancelTask: cancelled with exception:");
                    throwable.printStackTrace(System.err);
                }
            }
            this.buf.removeChangeListener(this.bufListener);
        }

        private RequestProcessor.Task getTask() {
            return this.task;
        }
    }
}

