/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.deep;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.antlr.TokenStream;
import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.deep.CsmStatement;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Utils;
import org.netbeans.modules.cnd.modelimpl.csm.deep.StatementBase;
import org.netbeans.modules.cnd.modelimpl.parser.spi.CsmParserProvider;
import org.netbeans.modules.cnd.utils.CndUtils;

public abstract class LazyStatementImpl
extends StatementBase
implements CsmScope {
    private volatile SoftReference<List<CsmStatement>> statements = null;

    protected LazyStatementImpl(CsmFile csmFile, int n, int n2, CsmFunction csmFunction) {
        super(csmFile, n, n2, (CsmScope)csmFunction);
    }

    public CsmStatement.Kind getKind() {
        return CsmStatement.Kind.COMPOUND;
    }

    public List<CsmStatement> getStatements() {
        if (this.statements == null) {
            return this.createStatements();
        }
        List<CsmStatement> list = this.statements.get();
        return list == null ? this.createStatements() : list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<CsmStatement> createStatements() {
        List<CsmStatement> list;
        List<CsmStatement> list2 = list = this.statements == null ? null : this.statements.get();
        if (list == null) {
            list = new ArrayList<CsmStatement>();
            CndUtils.assertTrueInConsole((!SwingUtilities.isEventDispatchThread() || CndUtils.isCodeCompletionUnitTestMode() ? 1 : 0) != 0, (String)"Calling Parser in UI Thread");
            LazyStatementImpl lazyStatementImpl = this;
            synchronized (lazyStatementImpl) {
                List<CsmStatement> list3;
                if (this.statements != null && (list3 = this.statements.get()) != null) {
                    return list3;
                }
                if (this.renderStatements(list)) {
                    this.statements = new SoftReference<List<CsmStatement>>(list);
                    return list;
                }
                return Collections.emptyList();
            }
        }
        return list;
    }

    private boolean renderStatements(List<CsmStatement> list) {
        FileImpl fileImpl = (FileImpl)this.getContainingFile();
        TokenStream tokenStream = fileImpl.getTokenStream(this.getStartOffset(), this.getEndOffset(), this.getFirstTokenID(), true);
        if (tokenStream == null) {
            Utils.LOG.log(Level.SEVERE, "Can't create compound statement: can't create token stream for file {0}", fileImpl.getAbsolutePath());
            return false;
        }
        CsmParserProvider.CsmParserResult csmParserResult = this.resolveLazyStatement(tokenStream);
        if (csmParserResult != null) {
            csmParserResult.render(list);
        }
        return true;
    }

    public void renderStatements(AST aST, List<CsmStatement> list) {
        AST aST2 = aST = aST == null ? null : aST.getFirstChild();
        while (aST != null) {
            StatementBase statementBase = AstRenderer.renderStatement(aST, this.getContainingFile(), this);
            if (statementBase != null) {
                list.add(statementBase);
            }
            aST = aST.getNextSibling();
        }
    }

    public Collection<CsmScopeElement> getScopeElements() {
        List<CsmStatement> list = this.getStatements();
        return list;
    }

    protected abstract CsmParserProvider.CsmParserResult resolveLazyStatement(TokenStream var1);

    protected abstract int getFirstTokenID();

    @Override
    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
    }

    public LazyStatementImpl(DataInput dataInput) throws IOException {
        super(dataInput);
        this.statements = null;
    }
}

