/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.j2d;

import org.w3c.dom.svg.SVGRect;

public class Box
implements SVGRect {
    public float x;
    public float y;
    public float width;
    public float height;

    public Box(float x, float y, float w, float h) {
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
    }

    public Box(Box b) {
        this(b.x, b.y, b.width, b.height);
    }

    public void setX(float value) {
        this.x = value;
    }

    public void setY(float value) {
        this.y = value;
    }

    public void setWidth(float value) {
        this.width = value;
    }

    public void setHeight(float value) {
        this.height = value;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public void snap() {
        float fmaxX = this.x + this.width;
        float fmaxY = this.y + this.height;
        int x = (int)this.x;
        if (this.x < 0.0f && this.x - (float)x != 0.0f) {
            --x;
        }
        int y = (int)this.y;
        if (this.y < 0.0f && this.y - (float)y != 0.0f) {
            --y;
        }
        int maxX = (int)fmaxX;
        if (fmaxX > 0.0f && fmaxX - (float)maxX != 0.0f) {
            ++maxX;
        }
        int maxY = (int)fmaxY;
        if (fmaxY > 0.0f && fmaxY - (float)maxY != 0.0f) {
            ++maxY;
        }
        this.x = x;
        this.y = y;
        this.width = maxX - x;
        this.height = maxY - y;
    }

    public boolean equals(Object cmp) {
        if (cmp == this) {
            return true;
        }
        if (cmp == null) {
            return false;
        }
        if (cmp instanceof Box) {
            Box b = (Box)cmp;
            return b.x == this.x && b.y == this.y && b.width == this.width && b.height == this.height;
        }
        return false;
    }

    public String toString() {
        return "Box(" + this.x + ", " + this.y + ", " + this.width + ", " + this.height + ")";
    }
}

