/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.Transform;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.ModelNode;

public class ElementNodeProxy
extends ModelNode {
    protected ElementNode proxied;
    protected boolean expanded;
    protected ElementNodeProxy nextProxy;
    protected ElementNodeProxy prevProxy;
    protected ModelNode firstExpandedChild;
    protected ModelNode lastExpandedChild;

    protected ElementNodeProxy(ElementNode proxiedNode) {
        this.proxied = proxiedNode;
        proxiedNode.addProxy(this);
        this.ownerDocument = proxiedNode.ownerDocument;
    }

    final void onHookedInDocumentTree() {
        super.onHookedInDocumentTree();
        ModelNode c = this.firstExpandedChild;
        while (c != null) {
            c.onHookedInDocumentTree();
            c = c.nextSibling;
        }
    }

    protected void clearLayouts() {
        this.clearLayouts(this.firstExpandedChild);
    }

    public ModelNode getFirstChildNode() {
        return null;
    }

    public ModelNode getLastChildNode() {
        return null;
    }

    protected void unhookChildrenQuiet() {
    }

    public ModelNode getFirstExpandedChild() {
        this.expand();
        return this.firstExpandedChild;
    }

    public ModelNode getFirstComputedExpandedChild() {
        return this.firstExpandedChild;
    }

    public ModelNode getLastExpandedChild() {
        this.expand();
        return this.lastExpandedChild;
    }

    protected void unhookExpandedQuiet() {
        this.unhookQuiet(this.firstExpandedChild);
        this.firstExpandedChild = null;
        this.lastExpandedChild = null;
        this.expanded = false;
    }

    public boolean hasDescendants() {
        if (super.hasDescendants()) {
            return true;
        }
        this.expand();
        return this.firstExpandedChild != null;
    }

    public ModelNode nodeHitAt(float[] pt) {
        return this.proxied.proxyNodeHitAt(pt, this);
    }

    protected Transform appendTransform(Transform tx, Transform workTx) {
        if (this.proxied != null) {
            return this.proxied.appendTransform(tx, workTx);
        }
        return tx;
    }

    public ElementNode getProxied() {
        return this.proxied;
    }

    protected void setProxied(ElementNode newProxied) {
        if (this.proxied == newProxied) {
            return;
        }
        this.modifyingNode();
        if (this.proxied != null) {
            this.proxied.removeProxy(this);
        }
        this.unhookQuiet(this.firstExpandedChild);
        this.proxied = newProxied;
        this.firstExpandedChild = null;
        this.lastExpandedChild = null;
        this.expanded = false;
        if (newProxied != null) {
            newProxied.addProxy(this);
        }
        int oldCanRenderState = this.canRenderState;
        this.canRenderState &= 0xFFFFFFFD;
        this.canRenderState &= 0xFFFFFFFB;
        this.canRenderState &= 0xFFFFFFF7;
        if (newProxied != null) {
            this.canRenderState |= newProxied.canRenderState & 2;
            this.canRenderState |= newProxied.canRenderState & 4;
            this.canRenderState |= newProxied.canRenderState & 8;
        }
        this.propagateCanRenderState(oldCanRenderState, this.canRenderState);
        this.modifiedNode();
    }

    protected void expand() {
        if (this.expanded) {
            return;
        }
        if (this.proxied != null) {
            this.firstExpandedChild = this.computeProxiesChain((ElementNode)this.proxied.getFirstChildNode());
            if (this.firstExpandedChild != null) {
                this.lastExpandedChild = this.firstExpandedChild.prevSibling;
                this.firstExpandedChild.prevSibling = null;
            } else {
                this.firstExpandedChild = null;
            }
        }
        this.expanded = true;
    }

    public void modifyingProxied() {
        this.modifyingNode();
    }

    public void modifiedProxied() {
        this.modifiedNode();
    }

    public void proxiedChildAdded(ElementNode child) {
        if (!this.expanded) {
            this.expand();
        } else {
            ElementNodeProxy newChildProxy = child.buildProxy();
            if (this.firstExpandedChild == null) {
                this.firstExpandedChild = newChildProxy;
                this.lastExpandedChild = newChildProxy;
                newChildProxy.nextSibling = null;
                newChildProxy.prevSibling = null;
            } else {
                this.lastExpandedChild.nextSibling = newChildProxy;
                newChildProxy.nextSibling = null;
                newChildProxy.prevSibling = this.lastExpandedChild;
                this.lastExpandedChild = newChildProxy;
            }
            newChildProxy.setParentQuiet(this);
            newChildProxy.expand();
            ElementNodeProxy.nodeInserted(newChildProxy);
        }
    }

    protected ElementNodeProxy computeProxiesChain(ElementNode proxiedChild) {
        ElementNodeProxy firstProxy = null;
        ElementNodeProxy proxy = null;
        ElementNodeProxy previousProxy = null;
        while (proxiedChild != null) {
            proxy = proxiedChild.buildProxy();
            proxy.setParentQuiet(this);
            proxy.expand();
            if (previousProxy == null) {
                firstProxy = proxy;
            } else {
                previousProxy.nextSibling = proxy;
                proxy.prevSibling = previousProxy;
            }
            firstProxy.prevSibling = proxy;
            previousProxy = proxy;
            proxiedChild = (ElementNode)proxiedChild.nextSibling;
        }
        return firstProxy;
    }
}

