/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.Time;
import com.sun.perseus.model.TimeCondition;
import com.sun.perseus.model.TimedElementNode;
import org.w3c.dom.DOMException;

public class TimeAttributesNode
extends TimedElementNode {
    public TimeAttributesNode(DocumentNode ownerDocument) {
        super(ownerDocument);
        if (!ownerDocument.loaded) {
            ownerDocument.timedElementNodes.addElement(this);
        }
    }

    public TimeAttributesNode(DocumentNode ownerDocument, String localName) {
        super(ownerDocument, localName);
        if (!ownerDocument.loaded) {
            ownerDocument.timedElementNodes.addElement(this);
        }
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new TimeAttributesNode(doc, this.localName);
    }

    boolean supportsTrait(String traitName) {
        if ("begin" == traitName || "end" == traitName || "dur" == traitName || "min" == traitName || "max" == traitName || "restart" == traitName || "repeatCount" == traitName || "repeatDur" == traitName || "fill" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("begin" == name) {
            if (this.timedElementSupport.beginConditions.size() == 0) {
                return "0s";
            }
            return TimeCondition.toStringTrait(this.timedElementSupport.beginConditions);
        }
        if ("end" == name) {
            if (this.timedElementSupport.endConditions.size() == 0) {
                return "indefinite";
            }
            return TimeCondition.toStringTrait(this.timedElementSupport.endConditions);
        }
        if ("dur" == name) {
            return Time.toStringTrait(this.timedElementSupport.dur);
        }
        if ("min" == name) {
            return Time.toStringTrait(this.timedElementSupport.min);
        }
        if ("max" == name) {
            return Time.toStringTrait(this.timedElementSupport.max);
        }
        if ("restart" == name) {
            switch (this.timedElementSupport.restart) {
                case 1: {
                    return "always";
                }
                case 2: {
                    return "whenNotActive";
                }
                case 3: {
                    return "never";
                }
            }
            throw new IllegalStateException();
        }
        if ("repeatCount" == name) {
            if (Float.isNaN(this.timedElementSupport.repeatCount)) {
                return null;
            }
            if (this.timedElementSupport.repeatCount == Float.MAX_VALUE) {
                return "indefinite";
            }
            return Float.toString(this.timedElementSupport.repeatCount);
        }
        if ("repeatDur" == name) {
            return Time.toStringTrait(this.timedElementSupport.repeatDur);
        }
        if ("fill" == name) {
            switch (this.timedElementSupport.fillBehavior) {
                case 1: {
                    return "remove";
                }
                case 2: {
                    return "freeze";
                }
            }
            throw new IllegalStateException();
        }
        return super.getTraitImpl(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTraitImpl(String name, String value) throws DOMException {
        if ("begin" == name) {
            this.checkWriteLoading(name);
            this.timedElementSupport.beginConditions.removeAllElements();
            this.parseTimeConditionsTrait(name, value, true);
            return;
        } else if ("end" == name) {
            this.checkWriteLoading(name);
            this.timedElementSupport.endConditions.removeAllElements();
            this.parseTimeConditionsTrait(name, value, false);
            return;
        } else if ("dur" == name) {
            this.checkWriteLoading(name);
            if ("media".equals(value)) {
                return;
            }
            this.timedElementSupport.setDur(this.parseClockTrait(name, value));
            return;
        } else if ("min" == name) {
            this.checkWriteLoading(name);
            if ("media".equals(value)) {
                return;
            }
            this.timedElementSupport.setMin(this.parseMinMaxClock(name, value, true));
            return;
        } else if ("max" == name) {
            this.checkWriteLoading(name);
            if ("media".equals(value)) {
                return;
            }
            this.timedElementSupport.setMax(this.parseMinMaxClock(name, value, false));
            return;
        } else if ("restart" == name) {
            this.checkWriteLoading(name);
            if ("always".equals(value)) {
                this.timedElementSupport.restart = 1;
                return;
            } else if ("whenNotActive".equals(value)) {
                this.timedElementSupport.restart = 2;
                return;
            } else {
                if (!"never".equals(value)) throw this.illegalTraitValue(name, value);
                this.timedElementSupport.restart = 3;
            }
            return;
        } else if ("repeatCount" == name) {
            this.checkWriteLoading(name);
            this.timedElementSupport.repeatCount = "indefinite".equals(value) ? Float.MAX_VALUE : this.parseFloatTrait(name, value);
            return;
        } else if ("repeatDur" == name) {
            this.checkWriteLoading(name);
            if ("indefinite".equals(value)) {
                this.timedElementSupport.repeatDur = Time.INDEFINITE;
                return;
            } else {
                this.timedElementSupport.setRepeatDur(this.parseClockTrait(name, value));
            }
            return;
        } else if ("fill" == name) {
            this.checkWriteLoading(name);
            if ("remove".equals(value)) {
                this.timedElementSupport.fillBehavior = 1;
                return;
            } else {
                if (!"freeze".equals(value)) throw this.illegalTraitValue(name, value);
                this.timedElementSupport.fillBehavior = 2;
            }
            return;
        } else {
            super.setTraitImpl(name, value);
        }
    }

    final void nodeHookedInDocumentTree() {
        super.nodeHookedInDocumentTree();
        if (this.ownerDocument.loaded) {
            this.validate();
        }
    }
}

