/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor;

import java.util.Collections;
import java.util.List;
import org.netbeans.editor.ext.html.parser.api.SyntaxAnalyzerResult;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.ErrorFilter;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.html.editor.HtmlPreferences;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.web.common.api.WebPageMetadata;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class HtmlErrorFilter
implements ErrorFilter {
    public static final String DISABLE_ERROR_CHECKS_KEY = "disable_error_checking";
    private static final ErrorFilter INSTANCE = new HtmlErrorFilter();

    public List<? extends Error> filter(ParserResult parserResult) {
        if (!(parserResult instanceof HtmlParserResult)) {
            return null;
        }
        HtmlParserResult htmlParserResult = (HtmlParserResult)parserResult;
        return HtmlErrorFilter.isErrorCheckingEnabled(htmlParserResult.getSyntaxAnalyzerResult()) ? parserResult.getDiagnostics() : Collections.emptyList();
    }

    public static boolean isErrorCheckingEnabled(SyntaxAnalyzerResult result) {
        return !HtmlErrorFilter.isErrorCheckingDisabledForFile(result) && HtmlErrorFilter.isErrorCheckingEnabledForMimetype(result);
    }

    public static boolean isErrorCheckingDisabledForFile(SyntaxAnalyzerResult result) {
        FileObject fo = result.getSource().getSourceFileObject();
        return fo != null && fo.getAttribute(DISABLE_ERROR_CHECKS_KEY) != null;
    }

    public static boolean isErrorCheckingEnabledForMimetype(SyntaxAnalyzerResult result) {
        return HtmlPreferences.isHtmlErrorCheckingEnabledForMimetype(HtmlErrorFilter.getWebPageMimeType(result));
    }

    public static String getWebPageMimeType(SyntaxAnalyzerResult result) {
        String mimeType;
        InstanceContent ic = new InstanceContent();
        ic.add((Object)result);
        WebPageMetadata wpmeta = WebPageMetadata.getMetadata((Lookup)new AbstractLookup((AbstractLookup.Content)ic));
        if (wpmeta != null && (mimeType = (String)wpmeta.value("mimeType")) != null) {
            return mimeType;
        }
        FileObject fo = result.getSource().getSourceFileObject();
        if (fo != null) {
            return fo.getMIMEType();
        }
        return result.getSource().getSnapshot().getMimeType();
    }

    public static class Factory
    implements ErrorFilter.Factory {
        public ErrorFilter createErrorFilter(String featureName) {
            return "tasklist".equals(featureName) ? INSTANCE : null;
        }
    }
}

