/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.html.editor.gsf;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.ext.html.parser.api.AstNode;
import org.netbeans.editor.ext.html.parser.api.AstNodeUtils;
import org.netbeans.modules.csl.api.KeystrokeHandler;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.css.formatting.api.LexUtilities;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.modules.html.editor.HtmlAutoCompletion;
import org.netbeans.modules.html.editor.api.Utils;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;

public class HtmlKeystrokeHandler
implements KeystrokeHandler {
    public boolean beforeCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return HtmlAutoCompletion.beforeCharInserted((BaseDocument)doc, caretOffset, target.getCaret(), ch);
    }

    public boolean afterCharInserted(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        HtmlAutoCompletion.charInserted((BaseDocument)doc, caretOffset, target.getCaret(), ch);
        return false;
    }

    public boolean charBackspaced(Document doc, int caretOffset, JTextComponent target, char ch) throws BadLocationException {
        return false;
    }

    public int beforeBreak(Document doc, int caretOffset, JTextComponent target) throws BadLocationException {
        TokenSequence ts = LexUtilities.getTokenSequence((BaseDocument)((BaseDocument)doc), (int)caretOffset, (Language)HTMLTokenId.language());
        if (ts == null) {
            return -1;
        }
        ts.move(caretOffset);
        String closingTagName = null;
        int end = -1;
        if (ts.moveNext() && ts.token().id() == HTMLTokenId.TAG_OPEN_SYMBOL && ((Object)ts.token().text()).toString().equals("</") && ts.moveNext() && ts.token().id() == HTMLTokenId.TAG_CLOSE) {
            closingTagName = ((Object)ts.token().text()).toString();
            end = ts.offset() + ts.token().text().length();
            ts.movePrevious();
            ts.movePrevious();
        }
        if (closingTagName == null) {
            return -1;
        }
        boolean foundOpening = false;
        if (ts.token().id() == HTMLTokenId.TAG_CLOSE_SYMBOL && ((Object)ts.token().text()).toString().equals(">")) {
            while (ts.movePrevious()) {
                if (ts.token().id() != HTMLTokenId.TAG_OPEN) continue;
                if (!((Object)ts.token().text()).toString().equals(closingTagName)) break;
                foundOpening = true;
                break;
            }
        }
        if (foundOpening) {
            Indent indent = Indent.get((Document)doc);
            doc.insertString(caretOffset, "\n", null);
            target.getCaret().setDot(caretOffset);
            indent.reindent(caretOffset + 1, end);
        }
        return -1;
    }

    public OffsetRange findMatching(Document doc, int caretOffset) {
        return OffsetRange.NONE;
    }

    public List<OffsetRange> findLogicalRanges(ParserResult info, int caretOffset) {
        AstNode node;
        CharSequence text;
        Token token;
        HtmlParserResult result = (HtmlParserResult)info;
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>(2);
        Document doc = info.getSnapshot().getSource().getDocument(true);
        TokenHierarchy hierarchy = TokenHierarchy.get((Document)doc);
        TokenSequence<HTMLTokenId> ts = Utils.getJoinedHtmlSequence(doc, caretOffset);
        if (ts == null) {
            return Collections.emptyList();
        }
        ts.move(caretOffset);
        if ((ts.moveNext() || ts.movePrevious()) && (token = ts.token()).id() == HTMLTokenId.TEXT && ((Object)(text = token.text())).toString().trim().length() > 0) {
            int from = ts.offset();
            int to = from + token.text().length();
            List tokenParts = token.joinedParts();
            if (tokenParts != null) {
                Token last = (Token)tokenParts.get(tokenParts.size() - 1);
                to = last.offset(hierarchy) + last.length();
            }
            int trimmed_from = from;
            for (int i = 0; i < text.length(); ++i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                trimmed_from += i;
                break;
            }
            int trimmed_to = to;
            for (int i = text.length() - 1; i >= 0; --i) {
                char ch = text.charAt(i);
                if (Character.isWhitespace(ch)) continue;
                trimmed_to = to - (text.length() - 1 - i);
                break;
            }
            if (trimmed_from != from || trimmed_to != to) {
                ranges.add(new OffsetRange(trimmed_from, trimmed_to));
            }
            ranges.add(new OffsetRange(from, to));
        }
        AstNode root = result.root();
        Snapshot snapshot = result.getSnapshot();
        if (root != null && (node = AstNodeUtils.findNode((AstNode)root, (int)snapshot.getEmbeddedOffset(caretOffset), (boolean)false, (boolean)false)) != null) {
            do {
                OffsetRange last;
                int[] logicalRange = node.getLogicalRange();
                int from = snapshot.getOriginalOffset(logicalRange[0]);
                int to = snapshot.getOriginalOffset(logicalRange[1]);
                if (from == -1 || to == -1 || from == to) continue;
                OffsetRange offsetRange = last = ranges.isEmpty() ? null : ranges.get(ranges.size() - 1);
                if (last != null && last.getStart() == from && last.getEnd() == to) continue;
                ranges.add(new OffsetRange(from, to));
            } while ((node = node.parent()) != null);
        }
        return ranges;
    }

    public int getNextWordOffset(Document doc, int caretOffset, boolean reverse) {
        return -1;
    }
}

