/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.Pair;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.openide.filesystems.FileEvent;

class FileEventLog
implements Runnable {
    private static final Logger LOG = Logger.getLogger(FileEventLog.class.getName());
    private final ThreadLocal<Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>>> changes = new ThreadLocal();

    public void record(FileOp operation, URL root, String relativePath, FileEvent event, RepositoryUpdater.Work work) {
        Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> myChanges;
        Map<String, Pair<FileOp, RepositoryUpdater.Work>> rootSlot;
        assert (operation != null);
        assert (root != null);
        if (relativePath == null) {
            relativePath = "";
        }
        if ((rootSlot = (myChanges = this.getChanges(true)).get(root)) == null) {
            rootSlot = new HashMap<String, Pair<FileOp, RepositoryUpdater.Work>>();
            myChanges.put(root, rootSlot);
        }
        rootSlot.put(relativePath, Pair.of(operation, work));
        event.runWhenDeliveryOver((Runnable)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.commit();
        }
        finally {
            this.cleanUp();
        }
    }

    private Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> getChanges(boolean create) {
        Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> res = this.changes.get();
        if (res == null && create) {
            res = new HashMap<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>>();
            this.changes.set(res);
        }
        return res;
    }

    private void commit() {
        LinkedList first = new LinkedList();
        LinkedList rest = new LinkedList();
        IdentityHashMap seenDelete = new IdentityHashMap();
        Map<URL, Map<String, Pair<FileOp, RepositoryUpdater.Work>>> myChanges = this.getChanges(false);
        if (myChanges != null) {
            for (Map<String, Pair<FileOp, RepositoryUpdater.Work>> changesInRoot : myChanges.values()) {
                for (Pair<FileOp, RepositoryUpdater.Work> desc : changesInRoot.values()) {
                    if (desc.first == FileOp.DELETE) {
                        if (seenDelete.containsKey(desc.second)) continue;
                        first.add(desc.second);
                        seenDelete.put(desc.second, desc.second);
                        continue;
                    }
                    rest.add(desc.second);
                }
            }
        }
        RepositoryUpdater ru = RepositoryUpdater.getDefault();
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("SCHEDULING: " + first);
        }
        ru.scheduleWork(first);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("SCHEDULING: " + rest);
        }
        ru.scheduleWork(rest);
    }

    private void cleanUp() {
        this.changes.remove();
    }

    public static enum FileOp {
        DELETE,
        CREATE;

    }
}

