/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.File;
import java.util.Collection;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.FileType;
import org.netbeans.modules.remote.impl.fs.RemoteDirectory;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteLink;
import org.netbeans.modules.remote.impl.fs.RemotePlainFile;
import org.netbeans.modules.remote.impl.fs.WeakCache;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RemoteFileObjectFactory {
    private final ExecutionEnvironment env;
    private final RemoteFileSystem fileSystem;
    private final WeakCache<String, RemoteFileObjectBase> fileObjectsCache = new WeakCache();
    private final RequestProcessor.Task cleaningTask;
    private static RequestProcessor RP = new RequestProcessor("File objects cache dead entries cleanup", 1);
    private static final int CLEAN_INTERVAL = Integer.getInteger("rfs.cache.cleanup.interval", 10000);
    private int cacheRequests = 0;
    private int cacheHits = 0;

    public RemoteFileObjectFactory(RemoteFileSystem fileSystem) {
        this.fileSystem = fileSystem;
        this.env = fileSystem.getExecutionEnvironment();
        this.cleaningTask = RP.create(new Runnable(){

            public void run() {
                RemoteFileObjectFactory.this.cleanDeadEntries();
            }
        });
        this.scheduleCleanDeadEntries();
    }

    Collection<RemoteFileObjectBase> getCachedFileObjects() {
        return this.fileObjectsCache.values();
    }

    public RemoteFileObjectBase getCachedFileObject(String path) {
        return this.fileObjectsCache.get(path);
    }

    private void scheduleCleanDeadEntries() {
        this.cleaningTask.schedule(CLEAN_INTERVAL);
    }

    private void cleanDeadEntries() {
        int size;
        boolean trace = RemoteLogger.getInstance().isLoggable(Level.FINEST);
        if (trace) {
            size = this.fileObjectsCache.size();
            if (RemoteLogger.getInstance().isLoggable(Level.FINEST)) {
                RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries and {2}% ({3} of {4}) hits so far", new Object[]{this.env, size, this.cacheRequests == 0 ? 0 : this.cacheHits * 100 / this.cacheRequests, this.cacheHits, this.cacheRequests});
            }
        }
        this.fileObjectsCache.cleanDeadEntries();
        if (trace) {
            size = this.fileObjectsCache.size();
            RemoteLogger.getInstance().log(Level.FINEST, "Cleaning file objects dead entries for {0} ... {1} entries left", new Object[]{this.env, size});
        }
        if (this.fileObjectsCache.size() > 0) {
            this.scheduleCleanDeadEntries();
        }
    }

    public RemoteDirectory createRemoteDirectory(RemoteFileObjectBase parent, String remotePath, File cacheFile) {
        RemoteFileObjectBase result;
        RemoteFileObjectBase fo;
        ++this.cacheRequests;
        if (this.fileObjectsCache.size() == 0) {
            this.scheduleCleanDeadEntries();
        }
        if ((fo = this.fileObjectsCache.get(remotePath)) instanceof RemoteDirectory && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemoteDirectory)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(remotePath, fo);
        }
        if ((fo = new RemoteDirectory(this.fileSystem, this.env, parent, remotePath, cacheFile)).isValid() && (result = this.fileObjectsCache.putIfAbsent(remotePath, fo)) instanceof RemoteDirectory && result.getParent() == parent) {
            return (RemoteDirectory)result;
        }
        return (RemoteDirectory)fo;
    }

    public RemotePlainFile createRemotePlainFile(RemoteDirectory parent, String remotePath, File cacheFile, FileType fileType) {
        RemoteFileObjectBase result;
        RemoteFileObjectBase fo;
        ++this.cacheRequests;
        if (this.fileObjectsCache.size() == 0) {
            this.scheduleCleanDeadEntries();
        }
        if ((fo = this.fileObjectsCache.get(remotePath)) instanceof RemotePlainFile && fo.isValid() && fo.getCache().equals(cacheFile)) {
            if (fo.getParent() == parent) {
                ++this.cacheHits;
                return (RemotePlainFile)fo;
            }
            fo = null;
        }
        if (fo != null && parent.isValid()) {
            fo.invalidate();
            this.fileObjectsCache.remove(remotePath, fo);
        }
        if ((fo = new RemotePlainFile(this.fileSystem, this.env, parent, remotePath, cacheFile, fileType)).isValid() && (result = this.fileObjectsCache.putIfAbsent(remotePath, fo)) instanceof RemotePlainFile && result.getParent() == parent) {
            return (RemotePlainFile)result;
        }
        return (RemotePlainFile)fo;
    }

    public RemoteLink createRemoteLink(RemoteFileObjectBase parent, String remotePath, String link) {
        RemoteLink fo = new RemoteLink(this.fileSystem, this.env, parent, remotePath, link);
        return (RemoteLink)this.fileObjectsCache.putIfAbsent(remotePath, fo);
    }

    public RemoteFileObjectBase invalidate(String remotePath) {
        RemoteFileObjectBase fo = this.fileObjectsCache.remove(remotePath);
        if (fo != null) {
            fo.invalidate();
        }
        return fo;
    }

    public void rename(String path2Rename, String newPath, RemoteFileObjectBase fo2Rename) {
        this.fileObjectsCache.remove(path2Rename, fo2Rename);
        fo2Rename.renamePath(newPath);
        this.fileObjectsCache.putIfAbsent(newPath, fo2Rename);
    }

    public void setLink(RemoteDirectory parent, String linkRemotePath, String linkTarget) {
        RemoteFileObjectBase fo = this.fileObjectsCache.get(linkRemotePath);
        if (fo != null) {
            if (fo instanceof RemoteLink) {
                ((RemoteLink)fo).setLink(linkTarget, parent);
            } else {
                RemoteLogger.getInstance().log(Level.FINE, "Called setLink on {0} - invalidating", fo.getClass().getSimpleName());
                fo.invalidate();
            }
        }
    }
}

