/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.api.ui.ConnectionNotifier;
import org.netbeans.modules.remote.impl.fs.RemoteFileObjectBase;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.netbeans.modules.remote.support.RemoteLogger;
import org.openide.util.NbBundle;

public class RemoteFileSupport
extends ConnectionNotifier.NamedRunnable {
    private final ExecutionEnvironment execEnv;

    public RemoteFileSupport(ExecutionEnvironment execEnv) {
        super(NbBundle.getMessage(RemoteFileSupport.class, (String)"RemoteDownloadTask.TITLE", (Object)RemoteFileSupport.getDisplayName(execEnv)));
        this.execEnv = execEnv;
    }

    protected void runImpl() {
        try {
            this.onConnect();
        }
        catch (ConnectException ex) {
            RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (ConnectionNotifier.NamedRunnable)this);
        }
        catch (InterruptedException ex) {
            RemoteLogger.finest(ex);
        }
        catch (InterruptedIOException ex) {
            RemoteLogger.finest(ex);
        }
        catch (IOException ex) {
            RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (ConnectionNotifier.NamedRunnable)this);
        }
        catch (ExecutionException ex) {
            RemoteLogger.getInstance().log(Level.INFO, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"RemoteFileSystemNotifier.ERROR", (Object)this.execEnv), ex);
            ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (ConnectionNotifier.NamedRunnable)this);
        }
    }

    private static String getDisplayName(ExecutionEnvironment env) {
        return env.getDisplayName();
    }

    private void onConnect() throws InterruptedException, ConnectException, InterruptedIOException, IOException, ExecutionException {
        RemoteFileSystemManager.getInstance().fireDownloadListeners(this.execEnv);
    }

    public void addPendingFile(RemoteFileObjectBase fo) {
        RemoteLogger.getInstance().log(Level.FINEST, "Adding notification for {0}:{1}", new Object[]{this.execEnv, fo.getPath()});
        ConnectionNotifier.addTask((ExecutionEnvironment)this.execEnv, (ConnectionNotifier.NamedRunnable)this);
    }
}

