/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.util.Exceptions;

public class RemoteFileSystemManager {
    private static RemoteFileSystemManager INSTANCE = new RemoteFileSystemManager();
    private Map<ExecutionEnvironment, SoftReference<RemoteFileSystem>> fileSystems = new HashMap<ExecutionEnvironment, SoftReference<RemoteFileSystem>>();
    private final List<FileSystemProvider.DownloadListener> downloadListeners = new ArrayList<FileSystemProvider.DownloadListener>();

    public static RemoteFileSystemManager getInstance() {
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resetFileSystem(ExecutionEnvironment execEnv) {
        RemoteFileSystemManager remoteFileSystemManager = this;
        synchronized (remoteFileSystemManager) {
            this.fileSystems.remove(execEnv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RemoteFileSystem getFileSystem(ExecutionEnvironment execEnv) {
        RemoteFileSystemManager remoteFileSystemManager = this;
        synchronized (remoteFileSystemManager) {
            RemoteFileSystem result;
            SoftReference<RemoteFileSystem> ref = this.fileSystems.get(execEnv);
            RemoteFileSystem remoteFileSystem = result = ref == null ? null : ref.get();
            if (result == null) {
                try {
                    result = new RemoteFileSystem(execEnv);
                    this.fileSystems.put(execEnv, new SoftReference<RemoteFileSystem>(result));
                }
                catch (IOException ioe) {
                    Exceptions.printStackTrace((Throwable)ioe);
                }
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDownloadListener(FileSystemProvider.DownloadListener listener) {
        List<FileSystemProvider.DownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.downloadListeners.remove(listener);
            this.downloadListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDownloadListener(FileSystemProvider.DownloadListener listener) {
        List<FileSystemProvider.DownloadListener> list = this.downloadListeners;
        synchronized (list) {
            this.downloadListeners.remove(listener);
            this.downloadListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDownloadListeners(ExecutionEnvironment env) {
        ArrayList<FileSystemProvider.DownloadListener> listenersCopy;
        List<FileSystemProvider.DownloadListener> list = this.downloadListeners;
        synchronized (list) {
            listenersCopy = new ArrayList<FileSystemProvider.DownloadListener>(this.downloadListeners);
        }
        for (FileSystemProvider.DownloadListener l : listenersCopy) {
            l.postConnectDownloadFinished(env);
        }
    }
}

