/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.remote.impl.fs;

import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.Permission;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystem;
import org.netbeans.modules.remote.impl.fs.RemoteFileSystemManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class RemoteFileURLConnection
extends URLConnection {
    private final ExecutionEnvironment execEnv;
    private final String path;
    private FileObject fileObject;
    private InputStream iStream = null;
    private OutputStream oStream = null;

    public RemoteFileURLConnection(URL url) throws IOException {
        super(url);
        if (!"rfs".equals(url.getProtocol())) {
            throw new IllegalArgumentException("Illegal url protocol: " + url.getProtocol());
        }
        this.execEnv = ExecutionEnvironmentFactory.createNew((String)url.getUserInfo(), (String)url.getHost(), (int)url.getPort());
        this.path = url.getFile();
    }

    public void connect() throws IOException {
        RemoteFileSystem fs = RemoteFileSystemManager.getInstance().getFileSystem(this.execEnv);
        this.fileObject = fs.findResource(this.path);
        if (this.fileObject == null || !this.fileObject.isValid()) {
            throw this.newFileNotFoundException();
        }
    }

    private FileNotFoundException newFileNotFoundException() {
        return new FileNotFoundException(this.execEnv.getDisplayName() + ':' + this.path);
    }

    public InputStream getInputStream() throws IOException {
        if (this.fileObject == null) {
            this.newFileNotFoundException();
        }
        if (this.iStream == null) {
            this.iStream = this.fileObject.getInputStream();
        }
        return this.iStream;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.fileObject == null) {
            this.newFileNotFoundException();
        }
        if (this.oStream == null) {
            FileLock flock = this.fileObject.lock();
            this.oStream = new LockOS(this.fileObject.getOutputStream(flock), flock);
        }
        return this.oStream;
    }

    public int getContentLength() {
        try {
            this.connect();
        }
        catch (IOException ex) {
            return 0;
        }
        return (int)this.fileObject.getSize();
    }

    public Permission getPermission() throws IOException {
        this.connect();
        StringBuilder actions = new StringBuilder();
        if (this.fileObject != null && this.fileObject.isValid()) {
            if (this.fileObject.canRead()) {
                actions.append("read").append(' ');
            }
            if (this.fileObject.canWrite()) {
                actions.append("write").append(' ');
            }
        }
        return new FilePermission(this.path, actions.toString());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ' ' + this.url;
    }

    private static class LockOS
    extends BufferedOutputStream {
        private final FileLock flock;

        public LockOS(OutputStream os, FileLock lock) throws IOException {
            super(os);
            this.flock = lock;
        }

        public void close() throws IOException {
            this.flock.releaseLock();
            super.close();
        }
    }
}

