/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.encoding;

import com.sun.xml.rpc.encoding.ExtendedTypeMapping;
import com.sun.xml.rpc.encoding.TypeMappingDescriptor;
import com.sun.xml.rpc.encoding.TypeMappingException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;

public class TypeMappingImpl
implements ExtendedTypeMapping {
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected static final boolean UNIQUE_IS_REQUIRED = true;
    protected static final boolean UNIQUE_IS_OPTIONAL = false;
    protected static final Row NULL_ROW = new Row();
    protected static final Entry NULL_ENTRY;
    private Entry[] table;
    private int count;
    private int threshold;
    private float loadFactor;
    protected ExtendedTypeMapping parent = null;
    protected String[] encodingURIs = EMPTY_STRING_ARRAY;
    protected List tuples = new ArrayList();

    private int hashToIndex(int hash) {
        return (hash & Integer.MAX_VALUE) % this.table.length;
    }

    private Entry getHashBucket(int hash) {
        return this.table[this.hashToIndex(hash)];
    }

    private void put(int hash, Row row) {
        if (this.count >= this.threshold) {
            this.rehash();
        }
        int index = this.hashToIndex(hash);
        this.table[index] = new Entry(this.table[index], hash, row);
        ++this.count;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Object[] newMap = new Entry[newCapacity];
        Arrays.fill(newMap, NULL_ENTRY);
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            Entry old = oldMap[i];
            while (old != NULL_ENTRY) {
                Entry e = old;
                old = old.next;
                int index = this.hashToIndex(e.hash);
                e.next = this.table[index];
                this.table[index] = e;
            }
        }
    }

    public TypeMappingImpl() {
        this.init();
    }

    private void init() {
        this.loadFactor = 0.75f;
        this.parent = null;
        this.encodingURIs = EMPTY_STRING_ARRAY;
        this.tuples = new ArrayList();
        int initialCapacity = 57;
        this.table = new Entry[initialCapacity];
        Arrays.fill(this.table, NULL_ENTRY);
        this.count = 0;
        this.threshold = (int)((float)initialCapacity * this.loadFactor);
    }

    public TypeMappingImpl(ExtendedTypeMapping parent) {
        this();
        this.parent = parent;
    }

    public String[] getSupportedEncodings() {
        return this.encodingURIs;
    }

    public void setSupportedEncodings(String[] encodingURIs) {
        this.encodingURIs = encodingURIs != null ? encodingURIs : EMPTY_STRING_ARRAY;
    }

    public boolean isRegistered(Class javaType, QName xmlType) {
        boolean isRegistered;
        int xTypeHash;
        if (xmlType == null) {
            throw new IllegalArgumentException("XML type may not be null");
        }
        if (javaType == null) {
            throw new IllegalArgumentException("Java type may not be null");
        }
        int jTypeHash = javaType.hashCode();
        int combinedHash = jTypeHash ^ (xTypeHash = xmlType.hashCode());
        Entry existingEntry = this.getHashBucket(combinedHash).getEntryMatching(javaType, xmlType);
        boolean bl = isRegistered = existingEntry != NULL_ENTRY;
        if (!isRegistered && this.parent != null) {
            isRegistered = this.parent.isRegistered(javaType, xmlType);
        }
        return isRegistered;
    }

    public void register(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory dsf) {
        if (xmlType == null) {
            throw new IllegalArgumentException("XML type may not be null");
        }
        if (javaType == null) {
            throw new IllegalArgumentException("Java type may not be null");
        }
        try {
            int jTypeHash = javaType.hashCode();
            int xTypeHash = xmlType.hashCode();
            int combinedHash = jTypeHash ^ xTypeHash;
            Row existingRow = this.getHashBucket((int)combinedHash).getEntryMatching((Class)javaType, (QName)xmlType).row;
            if (existingRow != NULL_ROW) {
                existingRow.serializerFactory = sf;
                existingRow.deserializerFactory = dsf;
            } else {
                Row newRow = new Row(javaType, xmlType, sf, dsf);
                this.put(jTypeHash, newRow);
                this.put(xTypeHash, newRow);
                this.put(combinedHash, newRow);
                this.tuples.add(newRow);
            }
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.registration.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    protected Entry getEntryMatching(Class javaType) {
        return this.getHashBucket(javaType.hashCode()).getEntryMatching(javaType);
    }

    protected Entry getEntryMatching(QName xmlType) {
        return this.getHashBucket(xmlType.hashCode()).getEntryMatching(xmlType);
    }

    protected Entry getNonPrimitiveEntryMatching(QName xmlType) {
        return this.getHashBucket(xmlType.hashCode()).getNonPrimitiveEntryMatching(xmlType);
    }

    protected Entry getEntryMatching(Class javaType, QName xmlType) {
        return this.getHashBucket(javaType.hashCode() ^ xmlType.hashCode()).getEntryMatching(javaType, xmlType);
    }

    protected Entry getEntryClosestTo(Class javaType, QName xmlType) {
        Entry entry = this.getEntryMatching(javaType, xmlType);
        if (entry == NULL_ENTRY) {
            entry = this.getEntryMatching(xmlType).getEntryMatchingSuperclassOf(javaType, xmlType);
        }
        return entry;
    }

    protected Entry getEntryCloesestTo(Class javaType) {
        Entry matchingEntry = this.getEntryMatching(javaType);
        if (matchingEntry != NULL_ENTRY) {
            return matchingEntry;
        }
        ArrayList superTypes = new ArrayList();
        Class superClass = javaType.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            superTypes.add(superClass);
        }
        superTypes.addAll(Arrays.asList(javaType.getInterfaces()));
        for (int i = 0; i < superTypes.size(); ++i) {
            Class currentType = (Class)superTypes.get(i);
            if (currentType == null) continue;
            matchingEntry = this.getEntryMatching(currentType);
            if (matchingEntry != NULL_ENTRY) break;
            superClass = currentType.getSuperclass();
            if (superClass == null || superClass.equals(Object.class)) continue;
            superTypes.add(superClass);
        }
        return matchingEntry;
    }

    protected SerializerFactory getSerializer(Class javaType, boolean uniqueRequired) {
        try {
            Entry matchingRowEntry = this.getEntryCloesestTo(javaType);
            SerializerFactory factory = matchingRowEntry.row.serializerFactory;
            return factory;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    protected SerializerFactory getSerializer(QName xmlType, boolean uniqueRequired) {
        try {
            Entry matchingRowEntry = this.getNonPrimitiveEntryMatching(xmlType);
            SerializerFactory factory = matchingRowEntry.row.serializerFactory;
            if (uniqueRequired && matchingRowEntry.next.getNonPrimitiveEntryMatching(xmlType) != NULL_ENTRY) {
                return null;
            }
            return factory;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    protected DeserializerFactory getDeserializer(Class javaType, boolean uniqueRequired) {
        try {
            Entry matchingRowEntry = this.getEntryMatching(javaType);
            DeserializerFactory factory = matchingRowEntry.row.deserializerFactory;
            if (uniqueRequired && matchingRowEntry.next.getEntryMatching(javaType) != NULL_ENTRY) {
                return null;
            }
            return factory;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    protected DeserializerFactory getDeserializer(QName xmlType, boolean uniqueRequired) {
        try {
            Entry matchingRowEntry = this.getNonPrimitiveEntryMatching(xmlType);
            DeserializerFactory factory = matchingRowEntry.row.deserializerFactory;
            if (uniqueRequired && matchingRowEntry.next.getNonPrimitiveEntryMatching(xmlType) != NULL_ENTRY) {
                return null;
            }
            return factory;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    protected Class getJavaType(QName xmlType, boolean uniqueRequired) {
        try {
            Entry matchingRowEntry = this.getNonPrimitiveEntryMatching(xmlType);
            Class javaType = matchingRowEntry.row.javaType;
            if (uniqueRequired && matchingRowEntry.next.getNonPrimitiveEntryMatching(xmlType) != NULL_ENTRY) {
                return null;
            }
            return javaType;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    protected QName getXmlType(Class javaType, boolean uniqueRequired) {
        try {
            Entry matchingRowEntry = this.getEntryMatching(javaType);
            QName xmlType = matchingRowEntry.row.xmlType;
            if (uniqueRequired && matchingRowEntry.next.getEntryMatching(javaType) != NULL_ENTRY) {
                return null;
            }
            return xmlType;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    public SerializerFactory getSerializer(Class javaType, QName xmlType) {
        SerializerFactory factory;
        if (javaType == null) {
            if (xmlType == null) {
                throw new IllegalArgumentException("getSerializer requires a Java type and/or an XML type");
            }
            factory = this.getSerializer(xmlType, false);
        } else if (xmlType == null) {
            factory = this.getSerializer(javaType, false);
        } else {
            try {
                factory = this.getEntryClosestTo((Class)javaType, (QName)xmlType).row.serializerFactory;
            }
            catch (Exception e) {
                throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
            }
        }
        if (factory == null && this.parent != null) {
            factory = this.parent.getSerializer(javaType, xmlType);
        }
        return factory;
    }

    public DeserializerFactory getDeserializer(Class javaType, QName xmlType) {
        DeserializerFactory factory = null;
        if (javaType == null) {
            if (xmlType == null) {
                throw new IllegalArgumentException("getDeserializer requires a Java type and/or an XML type");
            }
            factory = this.getDeserializer(xmlType, false);
        } else if (xmlType == null) {
            factory = this.getDeserializer(javaType, false);
        } else {
            try {
                factory = this.getEntryClosestTo((Class)javaType, (QName)xmlType).row.deserializerFactory;
            }
            catch (Exception e) {
                throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
            }
        }
        if (factory == null && this.parent != null) {
            factory = this.parent.getDeserializer(javaType, xmlType);
        }
        return factory;
    }

    public void removeSerializer(Class javaType, QName xmlType) {
        if (javaType == null || xmlType == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.getEntryMatching((Class)javaType, (QName)xmlType).row.serializerFactory = null;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    public void removeDeserializer(Class javaType, QName xmlType) {
        if (javaType == null || xmlType == null) {
            throw new IllegalArgumentException();
        }
        try {
            this.getEntryMatching((Class)javaType, (QName)xmlType).row.deserializerFactory = null;
        }
        catch (Exception e) {
            throw new TypeMappingException("typemapping.retrieval.failed.nested.exception", new LocalizableExceptionAdapter(e));
        }
    }

    public Class getJavaType(QName xmlType) {
        if (xmlType == null) {
            throw new IllegalArgumentException("non null xmlType required");
        }
        Class javaType = this.getJavaType(xmlType, false);
        if (javaType == null && this.parent != null) {
            javaType = this.parent.getJavaType(xmlType);
        }
        return javaType;
    }

    public QName getXmlType(Class javaType) {
        if (javaType == null) {
            throw new IllegalArgumentException("non null xmjavaType required");
        }
        QName xmlType = this.getXmlType(javaType, false);
        if (xmlType == null && this.parent != null) {
            xmlType = this.parent.getXmlType(javaType);
        }
        return xmlType;
    }

    static {
        TypeMappingImpl.NULL_ENTRY.next = NULL_ENTRY = new Entry(null, 0, NULL_ROW);
    }

    protected static class Entry {
        Entry next;
        int hash;
        Row row;

        Entry(Entry next, int hash, Row row) {
            if (row == null) {
                throw new IllegalArgumentException("row may not be null");
            }
            this.next = next;
            this.hash = hash;
            this.row = row;
        }

        Entry getEntryMatching(Class javaType) {
            Entry candidate = this;
            while (candidate != NULL_ENTRY && !candidate.row.javaType.equals(javaType)) {
                candidate = candidate.next;
            }
            return candidate;
        }

        Entry getEntryMatchingSuperclassOf(Class javaType) {
            Entry bestCandidate = NULL_ENTRY;
            Entry currentCandidate = this;
            while (currentCandidate != NULL_ENTRY) {
                if (currentCandidate.matchesSuperclassOf(javaType) && (bestCandidate == NULL_ENTRY || currentCandidate.matchesSubclassOf(bestCandidate.row.javaType))) {
                    bestCandidate = currentCandidate;
                }
                currentCandidate = currentCandidate.next;
            }
            return bestCandidate;
        }

        boolean matchesSubclassOf(Class javaType) {
            Class currentJavaType = this.row.javaType;
            return javaType.equals(currentJavaType) || javaType.isAssignableFrom(currentJavaType) && javaType != Object.class;
        }

        boolean matchesSuperclassOf(Class javaType) {
            Class currentJavaType = this.row.javaType;
            return currentJavaType.equals(javaType) || currentJavaType.isAssignableFrom(javaType) && currentJavaType != Object.class;
        }

        Entry getEntryMatching(QName xmlType) {
            Entry candidate = this;
            while (candidate != NULL_ENTRY && !candidate.row.xmlType.equals(xmlType)) {
                candidate = candidate.next;
            }
            return candidate;
        }

        Entry getNonPrimitiveEntryMatching(QName xmlType) {
            Entry candidate = this;
            while (candidate != NULL_ENTRY && (!candidate.row.xmlType.equals(xmlType) || candidate.row.javaType.isPrimitive())) {
                candidate = candidate.next;
            }
            return candidate;
        }

        Entry getEntryMatching(Class javaType, QName xmlType) {
            Entry candidate = this;
            while (!(candidate == NULL_ENTRY || candidate.row.javaType.equals(javaType) && candidate.row.xmlType.equals(xmlType))) {
                candidate = candidate.next;
            }
            return candidate;
        }

        Entry getEntryMatchingSuperclassOf(Class javaType, QName xmlType) {
            Entry bestCandidate = NULL_ENTRY;
            Entry currentCandidate = this;
            while (currentCandidate != NULL_ENTRY) {
                if (currentCandidate.matchesSuperclassOf(javaType) && currentCandidate.row.xmlType.equals(xmlType) && (bestCandidate == NULL_ENTRY || currentCandidate.matchesSubclassOf(bestCandidate.row.javaType))) {
                    bestCandidate = currentCandidate;
                }
                currentCandidate = currentCandidate.next;
            }
            return bestCandidate;
        }
    }

    public static class Row
    implements TypeMappingDescriptor {
        Class javaType;
        QName xmlType;
        SerializerFactory serializerFactory;
        DeserializerFactory deserializerFactory;

        Row(Class javaType, QName xmlType, SerializerFactory sf, DeserializerFactory dsf) {
            if (javaType == null) {
                throw new IllegalArgumentException("javaType may not be null");
            }
            if (xmlType == null) {
                throw new IllegalArgumentException("xmlType may not be null");
            }
            if (sf == null) {
                throw new IllegalArgumentException("serializerFactory may not be null");
            }
            if (dsf == null) {
                throw new IllegalArgumentException("deserializerFactory may not be null");
            }
            this.javaType = javaType;
            this.xmlType = xmlType;
            this.serializerFactory = sf;
            this.deserializerFactory = dsf;
        }

        Row() {
            this.javaType = null;
            this.xmlType = null;
            this.serializerFactory = null;
            this.deserializerFactory = null;
        }

        public Class getJavaType() {
            return this.javaType;
        }

        public QName getXMLType() {
            return this.xmlType;
        }

        public SerializerFactory getSerializer() {
            return this.serializerFactory;
        }

        public DeserializerFactory getDeserializer() {
            return this.deserializerFactory;
        }
    }
}

