/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.opt.impl.message;

import com.sun.xml.ws.api.SOAPVersion;
import com.sun.xml.ws.api.message.Attachment;
import com.sun.xml.ws.api.message.AttachmentSet;
import com.sun.xml.ws.api.message.Header;
import com.sun.xml.ws.api.message.HeaderList;
import com.sun.xml.ws.api.message.Message;
import com.sun.xml.ws.security.opt.api.SecurityElement;
import com.sun.xml.ws.security.opt.api.SecurityElementWriter;
import com.sun.xml.ws.security.opt.impl.attachment.AttachmentSetImpl;
import com.sun.xml.ws.security.opt.impl.message.SOAPBody;
import com.sun.xml.ws.security.opt.impl.outgoing.SecurityHeader;
import com.sun.xml.wss.XWSSecurityException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jvnet.staxex.NamespaceContextEx;

public class SecuredMessage {
    ArrayList headers;
    Message msg;
    SOAPBody body = null;
    boolean isOneWay = false;
    SecurityElement securedBody = null;
    AttachmentSet attachments = null;
    private NamespaceContextEx context = null;
    SOAPVersion soapVersion = SOAPVersion.SOAP_11;
    private SecurityHeader sh = null;

    public SecuredMessage(Message msg, SecurityHeader sh, SOAPVersion soapVersion) {
        this(msg, sh);
        this.body = new SOAPBody(msg, soapVersion);
        this.soapVersion = soapVersion;
        boolean isSOAP12 = soapVersion == SOAPVersion.SOAP_12;
    }

    public SecuredMessage(Message msg, SecurityHeader sh) {
        HeaderList hl = msg.getHeaders();
        this.headers = new ArrayList<Header>(hl);
        this.msg = msg;
        this.body = new SOAPBody(msg);
        this.attachments = msg.getAttachments();
        this.sh = sh;
    }

    public ArrayList getHeaders() {
        return this.headers;
    }

    public void setRootElements(NamespaceContextEx ne) {
        this.context = ne;
    }

    public boolean isOneWay() {
        return this.isOneWay;
    }

    public Iterator getHeaders(final String localName, final String uri) {
        return new Iterator(){
            int idx = 0;
            Object next;

            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                Object r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                while (this.idx < SecuredMessage.this.headers.size()) {
                    Object obj;
                    if ((obj = SecuredMessage.this.headers.get(this.idx++)) instanceof Header) {
                        Header hd = (Header)obj;
                        if ((uri != null || !localName.equals(hd.getLocalPart())) && (!localName.equals(hd.getLocalPart()) || !uri.equals(hd.getNamespaceURI()))) continue;
                        this.next = hd;
                        break;
                    }
                    if (!(obj instanceof SecurityElement)) continue;
                    SecurityElement she = (SecurityElement)obj;
                    if ((uri != null || !localName.equals(she.getLocalPart())) && (!localName.equals(she.getLocalPart()) || !uri.equals(she.getNamespaceURI()))) continue;
                    this.next = she;
                    break;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator getHeaders(final String uri) {
        return new Iterator(){
            int idx = 0;
            Object next;

            public boolean hasNext() {
                if (this.next == null) {
                    this.fetch();
                }
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    this.fetch();
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                }
                Object r = this.next;
                this.next = null;
                return r;
            }

            private void fetch() {
                while (this.idx < SecuredMessage.this.headers.size()) {
                    SecurityElement she;
                    Object obj;
                    if ((obj = SecuredMessage.this.headers.get(this.idx++)) instanceof Header) {
                        Header hd = (Header)obj;
                        if (!uri.equals(hd.getNamespaceURI())) continue;
                        this.next = hd;
                        break;
                    }
                    if (!(obj instanceof SecurityElement) || !uri.equals((she = (SecurityElement)obj).getNamespaceURI())) continue;
                    this.next = she;
                    break;
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public boolean replaceHeader(Object header1, Object header2) {
        boolean replaced = false;
        for (int i = 0; i < this.headers.size(); ++i) {
            Object obj = this.headers.get(i);
            if (obj != header1 || !obj.equals(header1)) continue;
            this.headers.set(i, header2);
            replaced = true;
            break;
        }
        return replaced;
    }

    public Object getHeader(String id) {
        Object hdr2 = null;
        for (int i = 0; i < this.headers.size(); ++i) {
            SecurityElement she;
            Object obj = this.headers.get(i);
            if (obj instanceof Header) {
                Header hd = (Header)obj;
                String wsuId = hd.getAttribute("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Id");
                if (!id.equals(wsuId)) continue;
                hdr2 = hd;
                break;
            }
            if (!(obj instanceof SecurityElement) || !id.equals((she = (SecurityElement)obj).getId())) continue;
            hdr2 = she;
            break;
        }
        return hdr2;
    }

    public String getPayloadNamespaceURI() {
        if (this.body != null) {
            return this.body.getPayloadNamespaceURI();
        }
        if (this.securedBody != null) {
            return this.securedBody.getNamespaceURI();
        }
        return null;
    }

    public String getPayloadLocalPart() {
        if (this.body != null) {
            return this.body.getPayloadLocalPart();
        }
        if (this.securedBody != null) {
            return this.securedBody.getLocalPart();
        }
        return null;
    }

    public XMLStreamReader readPayload() throws XMLStreamException {
        if (this.body != null) {
            return this.body.read();
        }
        if (this.securedBody != null) {
            return this.securedBody.readHeader();
        }
        throw new XMLStreamException("No Payload found");
    }

    public void writePayloadTo(XMLStreamWriter sw) throws XMLStreamException {
        if (this.body != null) {
            this.body.writeTo(sw);
        } else if (this.securedBody != null) {
            ((SecurityElementWriter)((Object)this.securedBody)).writeTo(sw);
        } else {
            throw new XMLStreamException("No Payload found");
        }
    }

    public Object getBody() throws XWSSecurityException {
        if (this.body != null) {
            return this.body;
        }
        if (this.securedBody != null) {
            return this.securedBody;
        }
        throw new XWSSecurityException("No body present in message");
    }

    public void replaceBody(SecurityElement she) {
        this.msg = null;
        this.securedBody = she;
        this.body = null;
    }

    public void replaceBody(SOAPBody sb) {
        this.msg = null;
        this.body = sb;
        this.securedBody = null;
    }

    public AttachmentSet getAttachments() {
        if (this.attachments == null) {
            this.attachments = new AttachmentSetImpl();
        }
        return this.attachments;
    }

    public void setAttachments(AttachmentSet as) {
        this.attachments = as;
    }

    public Attachment getAttachment(String uri) {
        Attachment attachment = null;
        if (this.attachments != null && uri.startsWith("cid:")) {
            uri = uri.substring("cid:".length());
            attachment = this.attachments.get(uri);
        }
        return attachment;
    }

    public void writeTo(XMLStreamWriter sw) throws XMLStreamException {
        sw.writeStartDocument();
        sw.writeStartElement("S", "Envelope", this.soapVersion.nsUri);
        for (NamespaceContextEx.Binding binding : this.context) {
            sw.writeNamespace(binding.getPrefix(), binding.getNamespaceURI());
        }
        sw.writeStartElement("S", "Header", this.soapVersion.nsUri);
        for (int i = 0; i < this.headers.size(); ++i) {
            Object hdr2 = this.headers.get(i);
            if (hdr2 instanceof Header) {
                ((Header)hdr2).writeTo(sw);
                continue;
            }
            ((SecurityElementWriter)hdr2).writeTo(sw);
        }
        this.sh.writeTo(sw);
        sw.writeEndElement();
        if (this.securedBody != null) {
            ((SecurityElementWriter)((Object)this.securedBody)).writeTo(sw);
        } else if (this.body != null) {
            this.body.writeTo(sw);
        }
        sw.writeEndDocument();
    }
}

