/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.antlr.preprocessor;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Enumeration;
import java.util.Hashtable;
import org.netbeans.modules.cnd.antlr.ANTLRException;
import org.netbeans.modules.cnd.antlr.TokenStreamException;
import org.netbeans.modules.cnd.antlr.Tool;
import org.netbeans.modules.cnd.antlr.collections.impl.IndexedVector;
import org.netbeans.modules.cnd.antlr.preprocessor.Grammar;
import org.netbeans.modules.cnd.antlr.preprocessor.GrammarFile;
import org.netbeans.modules.cnd.antlr.preprocessor.Option;
import org.netbeans.modules.cnd.antlr.preprocessor.Preprocessor;
import org.netbeans.modules.cnd.antlr.preprocessor.PreprocessorLexer;

public class Hierarchy {
    protected Grammar LexerRoot = null;
    protected Grammar ParserRoot = null;
    protected Grammar TreeParserRoot = null;
    protected Hashtable symbols;
    protected Hashtable files;
    protected Tool antlrTool;

    public Hierarchy(Tool tool) {
        this.antlrTool = tool;
        this.LexerRoot = new Grammar(tool, "Lexer", null, null);
        this.ParserRoot = new Grammar(tool, "Parser", null, null);
        this.TreeParserRoot = new Grammar(tool, "TreeParser", null, null);
        this.symbols = new Hashtable(10);
        this.files = new Hashtable(10);
        this.LexerRoot.setPredefined(true);
        this.ParserRoot.setPredefined(true);
        this.TreeParserRoot.setPredefined(true);
        this.symbols.put(this.LexerRoot.getName(), this.LexerRoot);
        this.symbols.put(this.ParserRoot.getName(), this.ParserRoot);
        this.symbols.put(this.TreeParserRoot.getName(), this.TreeParserRoot);
    }

    public void addGrammar(Grammar gr) {
        gr.setHierarchy(this);
        this.symbols.put(gr.getName(), gr);
        GrammarFile f = this.getFile(gr.getFileName());
        f.addGrammar(gr);
    }

    public void addGrammarFile(GrammarFile gf) {
        this.files.put(gf.getName(), gf);
    }

    public void expandGrammarsInFile(String fileName) {
        GrammarFile f = this.getFile(fileName);
        Enumeration e = f.getGrammars().elements();
        while (e.hasMoreElements()) {
            Grammar g = (Grammar)e.nextElement();
            g.expandInPlace();
        }
    }

    public Grammar findRoot(Grammar g) {
        if (g.getSuperGrammarName() == null) {
            return g;
        }
        Grammar sg = g.getSuperGrammar();
        if (sg == null) {
            return g;
        }
        return this.findRoot(sg);
    }

    public GrammarFile getFile(String fileName) {
        return (GrammarFile)this.files.get(fileName);
    }

    public Grammar getGrammar(String gr) {
        return (Grammar)this.symbols.get(gr);
    }

    public static String optionsToString(IndexedVector options) {
        String s = "options {" + System.getProperty("line.separator");
        Enumeration e = options.elements();
        while (e.hasMoreElements()) {
            s = s + (Option)e.nextElement() + System.getProperty("line.separator");
        }
        s = s + "}" + System.getProperty("line.separator") + System.getProperty("line.separator");
        return s;
    }

    public void readGrammarFile(String file) throws FileNotFoundException {
        BufferedReader grStream = new BufferedReader(new FileReader(file));
        this.addGrammarFile(new GrammarFile(this.antlrTool, file));
        PreprocessorLexer ppLexer = new PreprocessorLexer(grStream);
        ppLexer.setFilename(file);
        Preprocessor pp = new Preprocessor(ppLexer);
        pp.setTool(this.antlrTool);
        pp.setFilename(file);
        try {
            pp.grammarFile(this, file);
        }
        catch (TokenStreamException io) {
            this.antlrTool.toolError("Token stream error reading grammar(s):\n" + io);
        }
        catch (ANTLRException se) {
            this.antlrTool.toolError("error reading grammar(s):\n" + se);
        }
    }

    public boolean verifyThatHierarchyIsComplete() {
        Grammar c;
        boolean complete = true;
        Enumeration e = this.symbols.elements();
        while (e.hasMoreElements()) {
            Grammar superG;
            c = (Grammar)e.nextElement();
            if (c.getSuperGrammarName() == null || (superG = c.getSuperGrammar()) != null) continue;
            this.antlrTool.toolError("grammar " + c.getSuperGrammarName() + " not defined");
            complete = false;
            this.symbols.remove(c.getName());
        }
        if (!complete) {
            return false;
        }
        e = this.symbols.elements();
        while (e.hasMoreElements()) {
            c = (Grammar)e.nextElement();
            if (c.getSuperGrammarName() == null) continue;
            c.setType(this.findRoot(c).getName());
        }
        return true;
    }

    public Tool getTool() {
        return this.antlrTool;
    }

    public void setTool(Tool antlrTool) {
        this.antlrTool = antlrTool;
    }
}

